########################################################################
#
# File Name: 	        Literal.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Literal.py.html
#
"""
Implements the Literal meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Operand
from Ft.Ods.MetaData import MetaKind
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions
import cPickle

from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods.Exception import FtodsUnknownError

import cPickle
import types
try:
    g_stringTypes = [types.StringType, types.UnicodeType]
except:
    g_stringTypes = [types.StringType]


class Literal(Operand.Operand):
    def __init__(self,db,data):
        Operand.Operand.__init__(self,db,data,MetaKind.mk_literal)
        if data is None:
            self.__dict__['_literal_value'] = cPickle.dumps('')
            

    def value(self):
        return cPickle.loads(self._literal_value)


    def __setattr__(self,name,value):
        if name == 'literal_value':
            self.__dict__['_literal_value'] = cPickle.dumps(value)
        else:
            return Operand.Operand.__setattr__(self,name,value)

    def __getattr__(self,name):
        if name == 'literal_value':
            return cPickle.loads(self.__dict__['_literal_value'])
        else:
            return Operand.Operand.__getattr__(self,name)


    def _4ods_getOdl(self,indent):
        lv = self.literal_value
        if type(lv) == type(1):
            return indent + str(lv)
        elif type(lv) == type(1.2):
            return indent + str(lv)
        elif type(lv) in g_stringTypes:
            if len(lv) == 1:
                return "'" + lv + "'"
            return indent + '"' + lv + '"'
        else:
            raise FtodsUnknownError(msg="Need more input to generate ODL")


    _tupleNames =  (('_literal_value',),)

    _tupleDefinitions = {'_literal_value':{td.TYPE:Constants.Types.STRING,
                                           }
                         }
    _localExtents = ()
