from Xslt import test_harness
import os, tempfile

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ft="http://xmlns.4suite.org/ext"
  extension-element-prefixes="ft"
  version="1.0"
  >

  <xsl:output method="text"/>
  <xsl:param name='name'/>

  <xsl:template match="/">
    <xsl:text>
    Printed before the ft:write-file
    </xsl:text>
    <ft:write-file name='{$name}' overwrite='yes'>
      <ft:output method="text"/>
      <xsl:text>
      Here is sample output
      From ft:write-file
      </xsl:text>
    </ft:write-file>
    <xsl:text>
    Printed after the ft:write-file
    </xsl:text>
  </xsl:template>

</xsl:stylesheet>
"""

source_1 = """<dummy/>"""

expected_1 = """
    Printed before the ft:write-file
    
    Printed after the ft:write-file
    """

file_expected_1 = """
      Here is sample output
      From ft:write-file
      """

def Test(tester):

    fileName = tempfile.mktemp()

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    topLevelParams={('','name') : fileName},
                                    compareFunc=cmp
                                    )

    xtest.test(tester)
    tester.startTest("Testing extension element result") 
    tester.compare(1, os.path.exists(fileName))
    fileData = open(fileName,'r').read()
    tester.compare(file_expected_1, fileData)
    tester.testDone()

    if os.path.exists(fileName):
        os.unlink(fileName)

    return
