import xml.dom.ext

source_1 = """<?xml version="1.0"?>
<definitions name="EndorsementSearch"
  targetNamespace="http://namespaces.snowboard-info.com"
  xmlns:es="http://www.snowboard-info.com/EndorsementSearch.wsdl"
  xmlns:esxsd="http://schemas.snowboard-info.com/EndorsementSearch.xsd"
  xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
  xmlns:w="http://schemas.xmlsoap.org/wsdl/"
  xmlns="http://schemas.xmlsoap.org/wsdl/"
>
  <types>
    <schema targetNamespace="http://namespaces.snowboard-info.com"
            xmlns="http://www.w3.org/1999/XMLSchema">
      <element name="GetEndorsingBoarder">
        <complexType>
          <sequence>
            <element name="manufacturer" type="string"/>
            <element name="model" type="string"/>
          </sequence>
        </complexType>
      </element>
      <element name="GetEndorsingBoarderResponse">
        <complexType>
          <all>
            <element name="endorsingBoarder" type="string"/>
          </all>
        </complexType>
      </element>
      <element name="GetEndorsingBoarderFault">
        <complexType>
          <all>
            <element name="errorMessage" type="string"/>
          </all>
        </complexType>
      </element>
    </schema>
  </types>

  <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
    <message w:name="GetEndorsingBoarderRequest"
             rdf:ID="GetEndorsingBoarderRequest">
      <part w:name="body" w:element="esxsd:GetEndorsingBoarder"/>
    </message>

    <message name="GetEndorsingBoarderResponse"
             rdf:ID="GetEndorsingBoarderResponse">
      <part w:name="body" w:element="esxsd:GetEndorsingBoarderResponse"/>
    </message>

    <portType w:name="GetEndorsingBoarderPortType"
              rdf:ID="GetEndorsingBoarderPortType">
      <operation w:name="GetEndorsingBoarder">
        <input rdf:resource="GetEndorsingBoarderRequest"/>
        <output rdf:resource="GetEndorsingBoarderResponse"/>
        <fault rdf:resource="GetEndorsingBoarderFault"/>
      </operation>
    </portType>
    
    <binding w:name="EndorsementSearchSoapBinding"
             w:type="es:GetEndorsingBoarderPortType"
             rdf:ID="EndorsementSearchSoapBinding">
      <soap:binding soap:style="document"
                    soap:transport="http://schemas.xmlsoap.org/soap/http"/>
      <operation rdf:about="GetEndorsingBoarder">
        <soap:operation
          soap:soapAction="http://www.snowboard-info.com/EndorsementSearch"/>
        <input>
          <soap:body soap:use="literal"
            soap:namespace="http://schemas.snowboard-info.com/EndorsementSearch.xsd"/>
        </input>
        <output>
          <soap:body soap:use="literal"
            soap:namespace="http://schemas.snowboard-info.com/EndorsementSearch.xsd"/>
        </output>
        <fault>
          <soap:body soap:use="literal"
            soap:namespace="http://schemas.snowboard-info.com/EndorsementSearch.xsd"/>
        </fault>
      </operation>
    </binding>
    
    <service w:name="EndorsementSearchService"
             rdf:ID="EndorsementSearchService">
      <documentation>snowboarding-info.com Endorsement Service</documentation> 
      <port rdf:about="GetEndorsingBoarderPort">
        <binding rdf:resource="EndorsementSearchSoapBinding"/>
        <soap:address soap:location="http://www.snowboard-info.com/EndorsementSearch"/>
      </port>
    </service>
  </rdf:RDF>

</definitions>
"""

def Test():
    from Ft.Rdf.Drivers import Memory
    db = Memory.CreateDb('mydemo')

    from Ft.Rdf import Model
    m = Model.Model('http://article20001111.uche.ogbuji.net', db)

    from xml.dom.ext.reader import PyExpat
    reader = PyExpat.Reader()
    doc = reader.fromString(source_1)

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    serializer.deserialize(m, doc, 'http://article20001111.uche.ogbuji.net')

    print m.complete(None, None, None)

    outdoc = serializer.serialize(m)
    xml.dom.ext.PrettyPrint(outdoc)
    reader.releaseNode(doc)
    reader.releaseNode(outdoc)
    return


if __name__ == '__main__':
    Test()

