
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Enumeration
from Ft.Ods.MetaData import Constant
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_scopedtype
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    
    try:
        test_scopedtype.Test(tester,db,Enumeration.Enumeration,Constant.Constant)


        tester.startGroup("Enumeration Interface %s Driver"%tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,Enumeration.Enumeration,'elements',Constant.Constant,nSided=1)
        tester.groupDone()
    finally:
        db.close()


