import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity1.odl or varsity2.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python basic_test1.py
#



odl_string = '''
class BigBlob {
  attribute blob data;
};
'''


DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

import sys, test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('BigBlob'):
            from distutils import dir_util
            dir_util.remove_tree('BigBlob')


def _Test(tester):

    tester.startGroup("Blob Attributes %s Driver" % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        import BigBlob
        reload(BigBlob)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()


    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()

    tester.startTest("Create and Commit")

    b = BigBlob.new(db)
    tx.commit()

    id = b._4ods_getOid()

    tester.testDone()

    
    tx = db.new()
    tx.begin()

    tester.startTest("Access empty")

    b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)

    tester.testResults("",b.data,done=0,msg="Invalid Empty blob attribute")
    tx.commit()
    tester.testDone()
    
    tx = db.new()
    tx.begin()

    tester.startTest("Set and access")
    b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
    b.data = "*"*10000
    tester.testResults(10000,len(b.data),done=0,msg="Invalid blob attribute")
    tester.testResults("*"*10000,b.data,done=0,msg="Invalid blob attribute")
    tx.commit()

    tester.testDone()

    tx = db.new()
    tx.begin()

    tester.startTest("Load and access")
    b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
    tester.testResults(10000,len(b.data),done=0,msg="Invalid blob attribute")
    tester.testResults("*"*10000,b.data,done=0,msg="Invalid blob attribute")

    b.data = "1"

    tx.commit()

    tester.testDone()

    tx = db.new()
    tx.begin()

    tester.startTest("Load and Modify")
    b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)

    tester.testResults("1",b.data,done=0,msg="Invalid blob attribute")

    b.data = "="*10000
    tx.commit()


    tester.startTest("Load and Delete")
    tx = db.new()
    tx.begin()
    b = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
    tester.testResults(10000,len(b.data),done=0,msg="Invalid blob attribute")
    tester.testResults("="*10000,b.data,done=0,msg="Invalid blob attribute")

    b.delete()

    tx.commit()

    tester.testDone()
    tester.groupDone()

    db.close()
    return

if __name__ == '__main__':


    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

