########################################################################
#
# File Name: 	       ScopedType.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/ScopedType.py.html
#
"""
Implements the ScopedType meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import string

from Ft.Ods.MetaData import Type
from Ft.Ods.MetaData import Scope
from Ft.Ods.Exception import FtodsUnknownError

class ScopedType(Type.Type):
    def __init__(self,db,data,meta_kind):
        Type.Type.__init__(self,db,data,meta_kind)

    #Override the Scope interface
    def bind(self,name,obj):
        for d in self._4ods_getBoundChildren():
            if d.name == name:
                raise Scope.Scope.DuplicateNames(name=name)
        obj.name = name
        self._4ods_boundChild(obj)

    def resolve(self,name):
        if name[0] == ':':
            from Ft.Ods import Database
            return self._db.schema().resolve(name[2:])
        path = string.split(name,'::')
        for d in self._4ods_getBoundChildren():
            if d.name == path[0]:
                break
        else:
            raise Scope.Scope.NameNotFound(reason="No attribute %s" % path[0])
        if len(path) == 1:
            return d
        return d.resolve(string.join(path[1:],'::'))

    def unbind(self,name):
        path = string.split(name,'::')
        for d in self._4ods_getBoundChildren():
            if d.name == path[0]:
                break
        else:
            raise Scope.Scope.NameNotFound(reason="No attribute %s" % path[0])
        if len(path) == 1:
            self._4ods_unboundChild(d)
            return
        return d.unbind(string.join(path[1:],'::'))


    def _4ods_getBoundChildren(self):
        raise FtodsUnknownError(msg="Must override in %s" % str(self))

    def _4ods_boundChild(self,obj):
        raise FtodsUnknownError(msg="Must override in %s" % str(self))

    def _4ods_unboundChild(self,obj):
        raise FtodsUnknownError(msg="Must override in %s" % str(self))


    _tupleNames = ()
    _tupleDefinitions = {}
    _localExtents = ()
