"""
Run all test cases.
"""

import sys
import os
import unittest

from numarray import *
from numarray import strings



verbose = 0
heavy = 0  # Default is not doing heavy testing
if 'verbose' in sys.argv:
    verbose = 1
    sys.argv.remove('verbose')

if 'silent' in sys.argv:  # take care of old flag, just in case
    verbose = 0
    sys.argv.remove('silent')

if '--heavy' in sys.argv:
    heavy = 1
    sys.argv.remove('--heavy')


# This little hack is for when this module is run as main and all the
# other modules import it so they will still be able to get the right
# verbose and heavy settings.  It's confusing but it works.
import test_all
test_all.verbose = verbose
test_all.heavy = heavy

def cleanup(klass):
    #klass.__dict__.clear()     # This is too hard. Don't do that
#    print "Class attributes deleted"
    for key in klass.__dict__.keys():
	if not klass.__dict__[key].__class__.__name__ in ('instancemethod'):
	    klass.__dict__[key] = None

def allequal(a,b, flavor="numarray"):
    """Checks if two numarrays are equal"""

    #print "a-->", repr(a)
    #print "b-->", repr(b)
    if not hasattr(b, "shape"):
        # Scalar case
        return a == b

    if flavor == "Numeric":
        # Convert the parameters to numarray objects
        if a.typecode() == "c":
	    a = strings.array(a.tostring(), itemsize=1, shape=a.shape)
	    b = strings.array(b.tostring(), itemsize=1, shape=b.shape)
        else:
            # if using:
            #a = array(buffer(a),type=typeDict[a.typecode()],shape=a.shape)
            # the next error is issued for non-contiguous arrays (at
            # least from numarray 1.2.3 and Numeric 23.8 on):
            # """ TypeError: single-segment buffer object expected"""
            try:
                a = array(a,type=typeDict[a.typecode()],shape=a.shape)
            except ValueError:
                # This line is able to import Numeric objects like:
                # zeros((0,), 'l')
                # while the previous one don't
                a = array(buffer(a),type=typeDict[a.typecode()],shape=a.shape)
            try:
                b = array(b,type=typeDict[b.typecode()],shape=b.shape)
            except ValueError:
                # This line is able to import Numeric objects like:
                # zeros((0,), 'l')
                # while the previous one don't
                b = array(buffer(b),type=typeDict[b.typecode()],shape=b.shape)


    if a.shape <> b.shape:
        if verbose:
            print "Shape is not equal:", a.shape, "<>", b.shape
        return 0

    #if hasattr(a, "type") and hasattr(b, "type") and a.type() <> b.type():
    if hasattr(b, "type") and a.type() <> b.type():
        if verbose:
            print "Type is not equal:", a.type(), "<>", b.type()
        return 0

    # Rank-0 case
    if len(a.shape) == 0:
        if a[()] == b[()]:
            return 1
        else:
            if verbose:
                print "Shape is not equal:", a.shape, "<>", b.shape
            return 0

    # Null arrays
    if len(a._data) == 0:  # len(a) is not correct for generic shapes
        if len(b._data) == 0:
            return 1
        else:
            if verbose:
                print "length is not equal"
                print "len(a._data) ==>", len(a._data)
                print "len(b._data) ==>", len(b._data)
            return 0

    # Multidimensional case
    result = (a == b)
    for i in range(len(a.shape)):
        #print "nonzero(a <> b)", nonzero(a<>b)
        result = logical_and.reduce(result)
    if not result and verbose:
        print "Some of the elements in arrays are not equal"

    return result


def suite():
    test_modules = ['test_attributes',
                    'test_basics',
                    'test_create',
                    'test_backcompat',
                    'test_types',
                    'test_numarray',
                    'test_lists',
                    'test_tables',
                    'test_tablesMD',
                    'test_indexes',
                    'test_indexvalues',
                    'test_vlarray',
                    'test_earray',
                    'test_carray',
		    'test_tree',
		    'test_timetype',
                    'test_do_undo',
                    'test_enum',
                    'test_nestedrecords',
                    'test_nestedtypes',
                    # Sub-packages
                    'test_filenode',
	    ]

    # Add test_Numeric only if Numeric is installed
    try:
        import Numeric
        print "Numeric (version %s) is present. Adding the Numeric test suite." % \
              (Numeric.__version__)
        print '-=' * 38
        test_modules.append("test_Numeric")
    except:
        print "Skipping Numeric test suite"
        print '-=' * 38

    alltests = unittest.TestSuite()
    for name in test_modules:
        module = __import__(name)
        alltests.addTest(module.suite())
    return alltests


if __name__ == '__main__':
    import numarray
    import tables

    print '-=' * 38
    print "PyTables version:  %s" % tables.__version__
    print "Extension version: %s" % tables.extVersion
    print "HDF5 version:      %s" % tables.whichLibVersion("hdf5")[1]
    #print "HDF5 version:      %s" % tables.hdf5Version
    print "numarray version:  %s" % numarray.__version__
    #print "Zlib version:      %s" % tables.whichLibVersion("zlib")[1]
    tinfo = tables.whichLibVersion("zlib")
    if tinfo is not None:
        print "Zlib version:      %s" % (tinfo[1])
    tinfo = tables.whichLibVersion("lzo")
    if tinfo is not None:
        print "LZO version:       %s (%s)" % (tinfo[1], tinfo[2])
    tinfo = tables.whichLibVersion("ucl")
    if tinfo is not None:
        print "UCL version:       %s (%s)" % (tinfo[1], tinfo[2])
    tinfo = tables.whichLibVersion("bzip2")
    if tinfo is not None:
        print "BZIP2 version:     %s (%s)" % (tinfo[1], tinfo[2])
    print 'Python version:    %s' % sys.version
    if os.name == 'posix':
        (sysname, nodename, release, version, machine) = os.uname()
        print 'Platform:          %s-%s' % (sys.platform, machine)
    print 'Byte-ordering:     %s' % sys.byteorder
    print '-=' * 38

    # Handle --show-versions-only
    only_versions = 0
    args = sys.argv[:]
    for arg in args:
        if arg == '--show-versions-only':
            only_versions = 1
            sys.argv.remove(arg)
        elif arg == '--show-versions':
            only_versions = 1
            sys.argv.remove(arg)

    if not only_versions:
        if heavy:
            print \
"""Performing the complete test suite!"""
        else:
            print \
"""Performing only a light (yet comprehensive) subset of the test
suite.  If you have a big system and lots of CPU to waste and want to
do a more complete test, try passing the --heavy flag to this script.
The whole suite will take more than 10 minutes to complete on a
relatively modern CPU and around 100 MB of main memory."""
        print '-=' * 38

        unittest.main( defaultTest='suite' )

