#!/usr/bin/env python
#----------------------------------------------------------------------
# Setup script for the tables package

import sys, os, string
from os.path import exists

# Check for python
if not (sys.version_info[0] >= 2 and sys.version_info[1] >= 3):
    print "#################################################################"
    print "You need Python 2.3 or greater to install PyTables!. Exiting..."
    print "#################################################################"
    sys.exit(1)

# Check for numarray
try:
    import numarray
except:
    print """\
Can't find a local numarray Python installation.
Please, read carefully the README and remember
that PyTables needs the numarray package to
compile and run."""
    sys.exit(1)
else:
    if numarray.__version__ >= "1.3":
        print "Found numarray %s package installed" % numarray.__version__
    else:
        print "###############################################################"
        print "You need numarray 1.3 or greater to run PyTables!. Exiting..."
        print "###############################################################"
        sys.exit(1)


from distutils.core     import setup, Extension
from distutils.dep_util import newer
# Check if Pyrex is installed or not
try:
    from Pyrex.Distutils import build_ext
    pyrex = 1
    cmdclass = {'build_ext': build_ext}
except:
    pyrex = 0
    cmdclass = {}

VERSION = open('VERSION').read().strip()

#----------------------------------------------------------------------

debug = '--debug' in sys.argv

# Global variables
lflags_arg = []
lib_dirs = []
inc_dirs = []

# Some useful functions
def check_lib_unix(where, libname, headername, compulsory, warn=1):
    "Check if the library and headers are to be found on a Unix system"
    global LIBS, lib_dirs, inc_dirs, def_macros

    incdir = libdir = None
    if where:
        lookup_directories = (where,)
    else:
        lookup_directories = ('/usr/local/', '/usr/')
    for instdir in lookup_directories:
        # ".dylib" is the extension for dynamic library for MacOSX
        for ext in ('.a', '.so', '.dylib'):
            libfile = os.path.join(instdir, "lib/lib"+libname+ext)
            if os.path.isfile(libfile):
                libdir = os.path.dirname(libfile)
                if warn:
                    print "Found "+libname.upper()+" library at " + libdir
                # If library is in /usr
                # they should be already available on search paths
                if libdir not in ('/usr/lib',):
                    lib_dirs.append(libdir)
                break

        headerfile = os.path.join(instdir, "include/"+headername)
        if os.path.isfile(headerfile):
            incdir = os.path.dirname(headerfile)
            if warn:
                print "Found "+libname.upper()+" header files at " + incdir
            # If headers are in /usr 
            # they should be already available on search paths
            if incdir not in ('/usr/include',):
                inc_dirs.append(incdir)
            break

    if compulsory:
        if not incdir or not libdir:
            print """\
Can't find a local %s installation.
Please, read carefully the README and if your
%s library is not in a standard place
set the %s_DIR environment variable or
use the flag --%s to give a hint of
where they can be found.""" % (libname, libname,
                               libname.upper(), libname)

            sys.exit(1)
    else:
        if not incdir or not libdir:
            if warn:
                print "Optional %s library or include files not found. Disabling support for it." % (libname,)
            return False, instdir
        else:
            # Necessary to include code for optional libs
            def_macros.append(("HAVE_"+libname.upper()+"_LIB", 1))

    if (not '-l'+libname in LIBS):
        libnames.append(libname)

    return True, instdir

def check_lib_win(libname, maindir, dll_lib,
                  dirstub, libstub,
                  dirheader, headerfile,
                  warn = 1):
    "Check if the library and headers are to be found on a Windows system"

    # Look for stub library
    libdir = os.path.join(maindir, dirstub)
    libfile = os.path.join(libdir, libstub)
    if os.path.isfile(libfile):
        if warn:
            print "Found", libname, "stub library at", libdir
        fdirstub = libdir
    else:
        if warn:
            print libname, "stub library *not found* at", libdir
        fdirstub = None

    # Look for headers
    headerdir = os.path.join(maindir, dirheader)
    headerfile = os.path.join(headerdir, headerfile)
    if os.path.isfile(headerfile):
        if warn:
            print "Found", libname, "header files at", headerdir
        fdirheader = headerdir
    else:
        if warn:
            print libname, "header files *not found* at", headerdir
        fdirheader = None

    # Look for DLL library in all the paths in the PATH environment variable
    # The user will have to have added the path to it manually
    for instdir in os.environ['PATH'].split(';'):
        pathdll_lib = os.path.join(instdir, dll_lib)
        if os.path.isfile(pathdll_lib):
            print "Found", dll_lib, "library at", instdir
            break
    else:
        if warn:
            print "Warning!:", dll_lib, "library *not found* in PATH."
            print "  Remember to install it after the compilation phase."


    # Return the dirs for stub libs and headers (if found)
    return (fdirstub, fdirheader)

#-----------------------------------------------------------------

if os.name == 'posix':
    # Define macros for UNIX platform
    def_macros = [('NDEBUG', 1)]
    #def_macros = [('DEBUG', 1)]  # For debugging (mainly compression filters)

    # Allow setting the HDF5 dir and additional link flags either in
    # the environment or on the command line.
    # First check the environment...
    HDF5_DIR = os.environ.get('HDF5_DIR', '')
    # We want top get rid of zlib dependency here
    #ZLIB_DIR = os.environ.get('ZLIB_DIR', '')
    LZO_DIR = os.environ.get('LZO_DIR', '')
    UCL_DIR = os.environ.get('UCL_DIR', '')
    BZIP2_DIR = os.environ.get('BZIP2_DIR', '')
    LFLAGS = os.environ.get('LFLAGS', [])
    if LFLAGS:
        LFLAGS = string.split(LFLAGS)
    LIBS = os.environ.get('LIBS', [])
    if LIBS:
        LIBS = string.split(LIBS)

    force_ucl = 0
    # ...then the command line.
    # Handle --hdf5=[PATH] --lzo=[PATH] --ucl=[PATH] --bzip2=[PATH] --lflags=[FLAGS] and debug
    args = sys.argv[:]
    for arg in args:
        if string.find(arg, '--hdf5=') == 0:
            HDF5_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
#         elif string.find(arg, '--zlib=') == 0:
#             ZLIB_DIR = string.split(arg, '=')[1]
#             sys.argv.remove(arg)
        elif string.find(arg, '--lzo=') == 0:
            LZO_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
        elif string.find(arg, '--ucl=') == 0:
            UCL_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
        elif string.find(arg, '--force-ucl') == 0:
	    # To for using ucl in darwin platforms
            force_ucl = 1
            sys.argv.remove(arg)
        elif string.find(arg, '--bzip2=') == 0:
            BZIP2_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
        elif string.find(arg, '--lflags=') == 0:
            LFLAGS = string.split(string.split(arg, '=')[1])
            sys.argv.remove(arg)
        elif string.find(arg, '--debug') == 0:
            # For debugging (mainly compression filters)
            def_macros = [('DEBUG', 1)]
            # Don't delete this argument. It maybe useful for distutils
            # when adding more flags later on
            #sys.argv.remove(arg)

    libnames = LIBS
    if LFLAGS:
        lflags_arg = LFLAGS

    # Look for library. After this, inc_dirs, lib_dirs and libnames are updated
    # Look for HDF5, compulsory
    check_lib_unix(HDF5_DIR, "hdf5", "H5public.h", compulsory=1)
    # Look for ZLIB, compulsory
    # commented out because if HDF5 is there, then so should be ZLIB
    #check_lib_unix(ZLIB_DIR, "z", "zlib.h", compulsory=1)
    # Check for LZO2 or LZO1
    lzo1 = False
    # Look for LZO2, not compulsory
    (lzo2, instdir) = check_lib_unix(LZO_DIR, "lzo2", "lzo/lzo1x.h",
                                     compulsory=0, warn=0)
    if not lzo2:
        # Look for LZO1, not compulsory
        (lzo1, instdir) = check_lib_unix(LZO_DIR, "lzo", "lzo1x.h",
                                         compulsory=0, warn=0)
    if not lzo1 and not lzo2:
        print "Optional LZO (v1 or v2) library or include files not found. Disabling support for it."
    else:
        if lzo2:
            print "Found LZO2 library at", instdir+'lib' 
            print "Found LZO2 header files at", instdir+'include/lzo'
        else:
            print "Found LZO1 library at", instdir+'lib' 
            print "Found LZO1 header files at", instdir+'include'
            
    # Look for UCL, not compulsory
    (ucl, instdir) = check_lib_unix(UCL_DIR, "ucl", "ucl/ucl.h", compulsory=0)
    # Disable UCL support on MacOSX platforms
    if ucl and sys.platform == "darwin" and not force_ucl:
	print \
"""UCL seems installed, but there are some problems using it on MacOSX.
Use --force-ucl if you are sure that you want support for it."""
        #print lib_dirs.pop()  # There is no guarantee that ucl is in a different directory
	inc_dirs.pop()
	libnames.pop()
	def_macros.pop()
    # Look for BZIP2, not compulsory
    check_lib_unix(BZIP2_DIR, "bz2", "bzlib.h", compulsory=0)

    # Set the runtime library search path
    # The use of rlib_dirs should be avoided, because debian lintian says that
    # this is not a good practice, although I should further investigate this.
    # 2003/09/30
    #rlib_dirs = lib_dirs
    rlib_dirs = []

    # Set the appropriate flavor hdf5Extension.c source file:
    if pyrex:
        hdf5Extension = "src/hdf5Extension.pyx"
        utilsExtension = "src/utilsExtension.pyx"
    else:
        hdf5Extension = "src/hdf5Extension.c"
        utilsExtension = "src/utilsExtension.c"

    #print "lib_dirs-->", lib_dirs
    #print "inc_dirs-->", inc_dirs

#-----------------------------------------------------

elif os.name == 'nt':
    # Define macros for Windows platform
    def_macros = [('WIN32', 1), ('NDEBUG', 1), ('_HDF5USEDLL_', 1)]

    # Init variables
    lib_dirs = []  # All the libraries has to be on the PATH
    inc_dirs = []
    # Set the runtime library search path
    rlib_dirs = []  # Windows doesn't support that, but it does not complain
                    # with an empty list
    # Allow setting the HDF5 dir either in
    # the environment or on the command line.
    # First check the environment...
    HDF5_DIR = os.environ.get('HDF5_DIR', '')
    # We want to get rid of the zlib dependency
    #ZLIB_DIR = os.environ.get('ZLIB_DIR', '')
    LZO_DIR = os.environ.get('LZO_DIR', '')
    UCL_DIR = os.environ.get('UCL_DIR', '')
    BZIP2_DIR = os.environ.get('BZIP2_DIR', '')
    LFLAGS = os.environ.get('LFLAGS', [])
    if LFLAGS:
        LFLAGS = string.split(LFLAGS)
    LIBS = os.environ.get('LIBS', [])
    if LIBS:
        LIBS = string.split(LIBS)

    # ...then the command line.
    # Handle --hdf5=[PATH] --lzo=[PATH] --ucl=[PATH] --bzip2=[PATH] --lflags=[FLAGS] and
    # --debug
    args = sys.argv[:]
    for arg in args:
        if string.find(arg, '--hdf5=') == 0:
            HDF5_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
#         elif string.find(arg, '--zlib=') == 0:
#             ZLIB_DIR = string.split(arg, '=')[1]
#             sys.argv.remove(arg)
        elif string.find(arg, '--lzo=') == 0:
            LZO_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
        elif string.find(arg, '--ucl=') == 0:
            UCL_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
        elif string.find(arg, '--bzip2=') == 0:
            BZIP2_DIR = string.split(arg, '=')[1]
            sys.argv.remove(arg)
        elif string.find(arg, '--lflags=') == 0:
            LFLAGS = string.split(string.split(arg, '=')[1])
            sys.argv.remove(arg)
        elif string.find(arg, '--debug') == 0:
            # For debugging (mainly compression filters)
            def_macros = [('DEBUG', 1)]
            # Don't delete this argument. It maybe useful for distutils
            # when adding more flags later on
            #sys.argv.remove(arg)

    libnames = LIBS
    if LFLAGS:
        lflags_arg = LFLAGS

    # HDF5 library (mandatory)
    (dirstub, dirheader) = (None, None)
    if HDF5_DIR:
        (dirstub, dirheader) = check_lib_win("HDF5", HDF5_DIR, "hdf5dll.dll",
                                             "dll", "hdf5dll.lib",  # Stubs
                                             "include", "H5public.h") # Headers
    if dirstub and dirheader:
        lib_dirs.append(dirstub)
        inc_dirs.append(dirheader)
        libnames.append("hdf5dll")
    else:
        print "Unable to locate all the required HDF5 files"
        print """
 Please, read carefully the README and make sure
 that you have correctly specified the
 HDF5_DIR environment variable or use the flag
 --hdf5 to give a hint of where the stubs and
 headers can be found."""

        sys.exit(1)

#     # ZLIB library (mandatory)
#     dirstub, dirheader = None, None
#     if ZLIB_DIR:
#         (dirstub, dirheader) = check_lib_win("ZLIB", ZLIB_DIR, "zlib.dll",
#                                          #"lib", "zdll.lib",  # Stubs (1.2.1)
#                                          "lib", "zlib.lib",  # Stubs
#                                          "include", "zlib.h") # Headers
#     if dirstub and dirheader:
#         lib_dirs.append(dirstub)
#         inc_dirs.append(dirheader)
#         #libnames.append('zdll') # (1.2.1)
#         libnames.append('zlib')
#         def_macros.append(("HAVE_ZLIB_LIB", 1))
#     else:
#         print "Unable to locate all the required ZLIB files"
#         print """
#  Please, read carefully the README and make sure
#  that you have correctly specified the
#  ZLIB_DIR environment variable or use the flag
#  --zlib to give a hint of where the stubs and
#  headers can be found."""

#         sys.exit(1)

    # LZO library (optional)
    if LZO_DIR:
        # Check for LZO2
        (dirstub, dirheader) = check_lib_win("LZO", LZO_DIR, "lzo2.dll",
                                             "lib", "liblzo2.lib",  # Stubs
                                             "include", "lzo/lzo1x.h", #Headers
                                             warn = 0)
        if dirstub and dirheader:
            print "Found LZO2 stub library at", dirstub
            print "Found LZO2 header files at", dirhearder
            lib_dirs.append(dirstub)
            inc_dirs.append(dirheader)
            libnames.append('liblzo')
            def_macros.append(("HAVE_LZO2_LIB", 1))
        else:
            # Check for LZO1
            (dirstub, dirheader) = check_lib_win("LZO", LZO_DIR, "lzo1.dll",
                                                 "lib", "liblzo.lib",  # Stubs
                                                 "include", "lzo1x.h", #Headers
                                                 warn = 0)
            if dirstub and dirheader:
                print "Found LZO1 stub library at", dirstub
                print "Found LZO1 header files at", dirheader
                lib_dirs.append(dirstub)
                inc_dirs.append(dirheader)
                libnames.append('liblzo')
                def_macros.append(("HAVE_LZO_LIB", 1))
            else:
                print "Optional LZO (v1 or v2) library or include files not found. Disabling support for it."

    # UCL library (optional)
    if UCL_DIR:
        (dirstub, dirheader) = check_lib_win("UCL", UCL_DIR, "ucl1.dll",
                                             "lib", "libucl.lib",  # Stubs
                                             "include", "ucl/ucl.h") # Headers
        if dirstub and dirheader:
            lib_dirs.append(dirstub)
            inc_dirs.append(dirheader)
            inc_dirs.append(dirheader+"\ucl")
            libnames.append('libucl')
            def_macros.append(("HAVE_UCL_LIB", 1))
        else:
            print """Optional UCL libraries or include files not found. \
Disabling support for them."""

    # BZIP2 library (optional)
    if BZIP2_DIR:
        (dirstub, dirheader) = check_lib_win("bzip2", BZIP2_DIR, "bzip2.dll",
                                             "lib", "bzip2.lib",  # Stubs
                                             "include", "bzlib.h") # Headers
        if dirstub and dirheader:
            lib_dirs.append(dirstub)
            inc_dirs.append(dirheader)
            libnames.append('bzip2')
            def_macros.append(("HAVE_BZ2_LIB", 1))
        else:
            print """Optional bzip2 libraries or include files not found. \
Disabling support for them."""


#------------------------------------------------------------------------------

# Set the appropriate flavor hdf5Extension.c source file:
if pyrex:
    hdf5Extension = "src/hdf5Extension.pyx"
    TableExtension = "src/TableExtension.pyx"
    utilsExtension = "src/utilsExtension.pyx"
else:
    hdf5Extension = "src/hdf5Extension.c"
    TableExtension = "src/TableExtension.c"
    utilsExtension = "src/utilsExtension.c"

# Update the version.h file if this file is newer
if newer('setup.py', 'src/version.h'):
    open('src/version.h', 'w').write('#define PYTABLES_VERSION "%s"\n' % VERSION)

#--------------------------------------------------------------------

#Having the Python version included in the package name makes managing a
#system with multiple versions of Python much easier.

def find_name(base = 'tables'):
    '''If "--name-with-python-version" is on the command line then
    append "-pyX.Y" to the base name'''
    name = base
    if '--name-with-python-version' in sys.argv:
        name += '-py%i.%i'%(sys.version_info[0],sys.version_info[0])
        sys.argv.remove('--name-with-python-version')
    return name


name = find_name()

classifiers = """\
Development Status :: 5 - Production/Stable
Intended Audience :: Developers
Intended Audience :: Information Technology
Intended Audience :: Science/Research
License :: OSI Approved :: BSD License
Programming Language :: Python
Topic :: Database
Topic :: Software Development :: Libraries :: Python Modules
Operating System :: Microsoft :: Windows
Operating System :: Unix
"""
setup(name = name,
      version = VERSION,
      description = 'Hierarchical datasets for Python',
      long_description = """\

PyTables is a package for managing hierarchical datasets and
designed to efficently cope with extremely large amounts of
data. PyTables is built on top of the HDF5 library and the
numarray package and features an object-oriented interface
that, combined with C-code generated from Pyrex sources,
makes of it a fast, yet extremely easy to use tool for
interactively save and retrieve large amounts of data.

""",
      classifiers = filter(None, classifiers.split("\n")),
      author = 'Francesc Altet, Ivan Vilata',
      author_email = 'faltet@carabos.com, ivilata@carabos.com',
      maintainer = 'Francesc Altet, Ivan Vilata',
      maintainer_email = 'faltet@carabos.com, ivilata@carabos.com',
      url = 'http://www.pytables.org/',
      license = 'http://www.opensource.org/licenses/bsd-license.php',
      platforms = ['any'],
      packages = ['tables', 'tables.nodes'],
      ext_modules = [ Extension("tables.hdf5Extension",
                                include_dirs = inc_dirs,
                                define_macros = def_macros,
                                sources = [hdf5Extension,
                                           "src/arraytypes.c",
                                           "src/utils.c",
                                           "src/H5ARRAY.c",
                                           "src/H5ARRAY-opt.c",
                                           "src/H5VLARRAY.c",
                                           "src/H5LT.c",
                                           ],
                                library_dirs = lib_dirs,
                                libraries = libnames,
                                extra_link_args = lflags_arg,
                                runtime_library_dirs = rlib_dirs,
                                ),
                       Extension("tables.TableExtension",
                                include_dirs = inc_dirs,
                                define_macros = def_macros,
                                sources = [TableExtension,
                                           "src/H5LT.c",
                                           "src/H5TB.c",
                                           "src/H5TB-opt.c",
                                           ],
                                library_dirs = lib_dirs,
                                libraries = libnames,
                                extra_link_args = lflags_arg,
                                runtime_library_dirs = rlib_dirs,
                                ),
                       Extension("tables.utilsExtension",
                                include_dirs = inc_dirs,
                                define_macros = def_macros,
                                sources = [utilsExtension,
                                           "src/utils.c",
                                           "src/arraytypes.c",
                                           "src/typeconv.c",
                                           "src/H5ARRAY.c",
                                           "src/H5LT.c",
                                           "src/H5Zlzo.c",
                                           "src/H5Zucl.c",
                                           "src/H5Zbzip2.c",
                                           ],
                                library_dirs = lib_dirs,
                                libraries = libnames,
                                extra_link_args = lflags_arg,
                                runtime_library_dirs = rlib_dirs,
                                ),
                      ],
      cmdclass = cmdclass,
      scripts = ['utils/ptdump', 'utils/ptrepack', 'utils/nctoh5'],
)
