cdef extern from "cspi/spi.h":
	ctypedef struct Accessible
	ctypedef Accessible AccessibleApplication
	ctypedef Accessible AccessibleAction
	ctypedef Accessible AccessibleText
	ctypedef Accessible AccessibleEditableText
	ctypedef Accessible AccessibleHypertext
	ctypedef Accessible AccessibleHyperlink
	ctypedef Accessible AccessibleImage
	ctypedef Accessible AccessibleTable
	ctypedef Accessible AccessibleComponent

	ctypedef struct AccessibleTextRange
	ctypedef struct AccessibleKeySet
	ctypedef enum SPIBoolean:
		FALSE = 0,
		TRUE

	ctypedef struct AccessibleEvent:
		char  *type
		Accessible  *source
		long         detail1
		long         detail2

	ctypedef void AccessibleEventListener
	ctypedef void AccessibleKeystrokeListener
	ctypedef void AccessibleDeviceListener
	ctypedef void (*AccessibleEventListenerCB) ( AccessibleEvent *event, void *user_data )

	ctypedef enum AccessibleCoordType:
		SPI_COORD_TYPE_SCREEN = 0,
		SPI_COORD_TYPE_WINDOW

	ctypedef enum AccessibleRole:
		SPI_ROLE_INVALID = 0,
		SPI_ROLE_ACCEL_LABEL,
		SPI_ROLE_ALERT,
		SPI_ROLE_ANIMATION,
		SPI_ROLE_ARROW,
		SPI_ROLE_CALENDAR,
		SPI_ROLE_CANVAS,
		SPI_ROLE_CHECK_BOX,
		SPI_ROLE_CHECK_MENU_ITEM,
		SPI_ROLE_COLOR_CHOOSER,
		SPI_ROLE_COLUMN_HEADER,
		SPI_ROLE_COMBO_BOX,
		SPI_ROLE_DATE_EDITOR,
		SPI_ROLE_DESKTOP_ICON,
		SPI_ROLE_DESKTOP_FRAME,
		SPI_ROLE_DIAL,
		SPI_ROLE_DIALOG,
		SPI_ROLE_DIRECTORY_PANE,
		SPI_ROLE_DRAWING_AREA,
		SPI_ROLE_FILE_CHOOSER,
		SPI_ROLE_FILLER,
		SPI_ROLE_FONT_CHOOSER,
		SPI_ROLE_FRAME,
		SPI_ROLE_GLASS_PANE,
		SPI_ROLE_HTML_CONTAINER,
		SPI_ROLE_ICON,
		SPI_ROLE_IMAGE,
		SPI_ROLE_INTERNAL_FRAME,
		SPI_ROLE_LABEL,
		SPI_ROLE_LAYERED_PANE,
		SPI_ROLE_LIST,
		SPI_ROLE_LIST_ITEM,
		SPI_ROLE_MENU,
		SPI_ROLE_MENU_BAR,
		SPI_ROLE_MENU_ITEM,
		SPI_ROLE_OPTION_PANE,
		SPI_ROLE_PAGE_TAB,
		SPI_ROLE_PAGE_TAB_LIST,
		SPI_ROLE_PANEL,
		SPI_ROLE_PASSWORD_TEXT,
		SPI_ROLE_POPUP_MENU,
		SPI_ROLE_PROGRESS_BAR,
		SPI_ROLE_PUSH_BUTTON,
		SPI_ROLE_RADIO_BUTTON,
		SPI_ROLE_RADIO_MENU_ITEM,
		SPI_ROLE_ROOT_PANE,
		SPI_ROLE_ROW_HEADER,
		SPI_ROLE_SCROLL_BAR,
		SPI_ROLE_SCROLL_PANE,
		SPI_ROLE_SEPARATOR,
		SPI_ROLE_SLIDER,
		SPI_ROLE_SPIN_BUTTON,
		SPI_ROLE_SPLIT_PANE,
		SPI_ROLE_STATUS_BAR,
		SPI_ROLE_TABLE,
		SPI_ROLE_TABLE_CELL,
		SPI_ROLE_TABLE_COLUMN_HEADER,
		SPI_ROLE_TABLE_ROW_HEADER,
		SPI_ROLE_TEAROFF_MENU_ITEM,
		SPI_ROLE_TERMINAL,
		SPI_ROLE_TEXT,
		SPI_ROLE_TOGGLE_BUTTON,
		SPI_ROLE_TOOL_BAR,
		SPI_ROLE_TOOL_TIP,
		SPI_ROLE_TREE,
		SPI_ROLE_TREE_TABLE,
		SPI_ROLE_UNKNOWN,
		SPI_ROLE_VIEWPORT,
		SPI_ROLE_WINDOW,
		SPI_ROLE_EXTENDED,
		SPI_ROLE_HEADER,
		SPI_ROLE_FOOTER,
		SPI_ROLE_PARAGRAPH,
		SPI_ROLE_RULER,
		SPI_ROLE_APPLICATION,
		SPI_ROLE_AUTOCOMPLETE,
		SPI_ROLE_EDITBAR,
		SPI_ROLE_EMBEDDED,
		SPI_ROLE_LAST_DEFINED

	ctypedef enum AccessibleState:
		SPI_STATE_INVALID = 0,
		SPI_STATE_ACTIVE,
		SPI_STATE_ARMED,
		SPI_STATE_BUSY,
		SPI_STATE_CHECKED,
		SPI_STATE_COLLAPSED,
		SPI_STATE_DEFUNCT,
		SPI_STATE_EDITABLE,
		SPI_STATE_ENABLED,
		SPI_STATE_EXPANDABLE,
		SPI_STATE_EXPANDED,
		SPI_STATE_FOCUSABLE,
		SPI_STATE_FOCUSED,
		SPI_STATE_HORIZONTAL,
		SPI_STATE_ICONIFIED,
		SPI_STATE_MODAL,
		SPI_STATE_MULTI_LINE,
		SPI_STATE_MULTISELECTABLE,
		SPI_STATE_OPAQUE,
		SPI_STATE_PRESSED,
		SPI_STATE_RESIZABLE,
		SPI_STATE_SELECTABLE,
		SPI_STATE_SELECTED,
		SPI_STATE_SENSITIVE,
		SPI_STATE_SHOWING,
		SPI_STATE_SINGLE_LINE,
		SPI_STATE_STALE,
		SPI_STATE_TRANSIENT,
		SPI_STATE_VERTICAL,
		SPI_STATE_VISIBLE,
		SPI_STATE_MANAGES_DESCENDANTS, 
		SPI_STATE_INDETERMINATE
 
	ctypedef enum AccessibleRelationType:
		SPI_RELATION_NULL,
		SPI_RELATION_LABEL_FOR,
		SPI_RELATION_LABELED_BY,
		SPI_RELATION_CONTROLLER_FOR,
		SPI_RELATION_CONTROLLED_BY,
		SPI_RELATION_MEMBER_OF,
		SPI_RELATION_NODE_CHILD_OF,
		SPI_RELATION_EXTENDED,
		SPI_RELATION_FLOWS_TO,
		SPI_RELATION_FLOWS_FROM,
		SPI_RELATION_SUBWINDOW_OF,
		SPI_RELATION_EMBEDS,
		SPI_RELATION_EMBEDDED_BY,
		SPI_RELATION_POPUP_FOR,
		SPI_RELATION_LAST_DEFINED

	ctypedef enum AccessibleKeySynthType:
		SPI_KEY_PRESS,
		SPI_KEY_RELEASE, 
		SPI_KEY_PRESSRELEASE,
		SPI_KEY_SYM,
		SPI_KEY_STRING

	ctypedef struct GArray:
		char *data
		unsigned int len

	ctypedef struct AccessibleStateSet:
		unsigned int ref_count,
		GArray *states

	ctypedef struct AccessibleRelation

	ctypedef struct SPIException

	ctypedef enum SPIExceptionCode:
		SPI_EXCEPTION_UNSPECIFIED,
		SPI_EXCEPTION_DISCONNECT,
		SPI_EXCEPTION_NO_IMPL,
		SPI_EXCEPTION_IO,
		SPI_EXCEPTION_BAD_DATA

	ctypedef enum SPIExceptionType:
		SPI_EXCEPTION_SOURCE_UNSPECIFIED,
		SPI_EXCEPTION_SOURCE_ACCESSIBLE,
		SPI_EXCEPTION_SOURCE_REGISTRY,
		SPI_EXCEPTION_SOURCE_DEVICE

	ctypedef enum AccessibleComponentLayer:
		SPI_LAYER_INVALID,
		SPI_LAYER_BACKGROUND,
		SPI_LAYER_CANVAS,
		SPI_LAYER_WIDGET,
		SPI_LAYER_MDI,
		SPI_LAYER_POPUP,
		SPI_LAYER_OVERLAY,
		SPI_LAYER_WINDOW,
		SPI_LAYER_LAST_DEFINED	

	# More information on AT-SPI C Bindings Reference Manual can be found at:
	# http://developer.gnome.org/doc/API/2.0/at-spi/index.html
 
	ctypedef SPIBoolean (* SPIExceptionHandler) (SPIException *err, SPIBoolean is_fatal)

	# SPI main loop and initialization
	int SPI_init ()
	int SPI_exit ()
	void SPI_event_main ()
	void SPI_event_quit ()
	void SPI_freeString                     (char *s)
	SPIBoolean SPI_exceptionHandlerPush (SPIExceptionHandler *handler)
	SPIExceptionType SPIException_getSourceType (SPIException *err)
	SPIExceptionCode SPIException_getExceptionCode (SPIException *err)
	Accessible* SPIAccessibleException_getSource (SPIException *err)
	char* SPIException_getDescription (SPIException *err)

	#AccessibleRelation
	void        AccessibleRelation_ref          (AccessibleRelation *obj)
	void        AccessibleRelation_unref        (AccessibleRelation *obj)
	int         AccessibleRelation_getNTargets  (AccessibleRelation *obj)
	Accessible *AccessibleRelation_getTarget    (AccessibleRelation *obj,
        	                                     int i)
	AccessibleRelationType AccessibleRelation_getRelationType (AccessibleRelation *obj)

	# Kindof wrong to add these here:
	void free (void *data)
	int strlen (char *string)

	# Accessible Objects
	void Accessible_ref                     (Accessible *obj)
	void Accessible_unref                   (Accessible *obj)
	char *Accessible_getName                (Accessible *obj)
	char *Accessible_getDescription         (Accessible *obj)
	Accessible *Accessible_getParent        (Accessible *obj)
	long Accessible_getChildCount           (Accessible *obj)
	Accessible *Accessible_getChildAtIndex  (Accessible *obj, long int i)
	long Accessible_getIndexInParent        (Accessible *obj)
	AccessibleRelation **Accessible_getRelationSet (Accessible *obj)

	# Accessible Objects
	SPIBoolean Accessible_isAction          (Accessible *obj)
	AccessibleAction *Accessible_getAction  (Accessible *obj)
	# Subinterface Methods - AccessibleAction Interface
	void AccessibleAction_ref               (AccessibleAction *obj)
	void AccessibleAction_unref             (AccessibleAction *obj)
	long AccessibleAction_getNActions       (AccessibleAction *obj)
	SPIBoolean AccessibleAction_doAction    (AccessibleAction *obj, long int i)
	char *AccessibleAction_getKeyBinding    (AccessibleAction *obj, long int i)
	char *AccessibleAction_getName          (AccessibleAction *obj, long int i)
	char *AccessibleAction_getDescription   (AccessibleAction *obj, long int i)

	AccessibleStateSet *Accessible_getStateSet     (Accessible *obj)
	void AccessibleStateSet_ref                    (AccessibleStateSet *obj)
	void AccessibleStateSet_unref                  (AccessibleStateSet *obj)
	void AccessibleStateSet_add                    (AccessibleStateSet *obj,
	                                                AccessibleState state)
	AccessibleStateSet *AccessibleStateSet_compare (AccessibleStateSet *obj,
	                                                AccessibleStateSet *obj2)
	SPIBoolean AccessibleStateSet_contains         (AccessibleStateSet *obj,
	                                                AccessibleState state)
	SPIBoolean AccessibleStateSet_equals           (AccessibleStateSet *obj,
	                                                AccessibleStateSet *obj2)
	SPIBoolean AccessibleStateSet_isEmpty          (AccessibleStateSet *obj)
	void AccessibleStateSet_remove                 (AccessibleStateSet *obj,
	                                                AccessibleState state)

	# Accessible Objects
	SPIBoolean Accessible_isText            (Accessible *obj)
	AccessibleText *Accessible_getText      (Accessible *obj)
	# Subinterface Methods - AccessibleText Interface
	void AccessibleText_ref                 (AccessibleText *obj)
	void AccessibleText_unref               (AccessibleText *obj)
	SPIBoolean  AccessibleText_addSelection     (AccessibleText *obj,
												long int startOffset,
												long int endOffset)
	char*       AccessibleText_getAttributes    (AccessibleText *obj,
												long int offset,
												long int *startOffset,
												long int *endOffset)
## pyrex doesn't like this for some reason :(
#	AccessibleTextRange** AccessibleText_getBoundedRanges
#												(AccessibleText *obj,
# 												long int x,
# 												long int y,
# 												long int width,
# 												long int height,
# 												AccessibleCoordType type,
# 												AccessibleTextClipType clipTypeX,
# 												AccessibleTextClipType clipTypeY)
	long        AccessibleText_getCaretOffset   (AccessibleText *obj)
	long AccessibleText_getCharacterCount (AccessibleText *obj)
## pyrex doesn't like this for some reason :(
#	void        AccessibleText_getCharacterExtents
#												(AccessibleText *obj,
# 												long int offset,
#												long int *x,
#												long int *y,
#												long int *width,
#												long int *height,
#												AccessibleCoordType type)
	long        AccessibleText_getNSelections   (AccessibleText *obj)
## pyrex doesn't like these for some reason :(
#	long        AccessibleText_getOffsetAtPoint (AccessibleText *obj,
# 												long int x,
# 												long int y,
# 												AccessibleCoordType type)
#	void        AccessibleText_getRangeExtents  (AccessibleText *obj,
# 												long int startOffset,
# 												long int endOffset,
# 												long int *x,
# 												long int *y,
# 												long int *width,
# 												long int *height,
# 												AccessibleCoordType type)
	void        AccessibleText_getSelection     (AccessibleText *obj,
												long int selectionNum,
												long int *startOffset,
												long int *endOffset)
	char *AccessibleText_getText (AccessibleText *obj, long int o, long int e)
## pyrex doesn't like these for some reason :(
#	char* AccessibleText_getTextBeforeOffset	(AccessibleText *obj,
#												long int offset,
#												AccessibleTextBoundaryType type,
#												long int *startOffset,
#												long int *endOffset)
#	char*       AccessibleText_getTextAfterOffset
#												(AccessibleText *obj,
#												long int offset,
#												AccessibleTextBoundaryType type,
#												long int *startOffset,
#												long int *endOffset)
#	char*       AccessibleText_getTextAtOffset  (AccessibleText *obj,
#												long int offset,
#												AccessibleTextBoundaryType type,
#												long int *startOffset,
#												long int *endOffset)
	SPIBoolean AccessibleText_removeSelection  (AccessibleText *obj,
												long int selectionNum)
	SPIBoolean AccessibleText_setCaretOffset   (AccessibleText *obj,
												long int newOffset)
	SPIBoolean AccessibleText_setSelection     (AccessibleText *obj,
												long int selectionNum,
												long int startOffset,
												long int endOffset)
	void        AccessibleTextRange_freeRanges  (AccessibleTextRange **ranges)

	# Accessible Objects
	SPIBoolean Accessible_isEditableText               (Accessible *obj)
	AccessibleEditableText *Accessible_getEditableText (Accessible *obj)
	# Subinterface Methods - AccessibleEditableText Interface
	void AccessibleEditableText_ref             (AccessibleEditableText *obj)
	void AccessibleEditableText_unref           (AccessibleEditableText *obj)
	SPIBoolean AccessibleEditableText_copyText (AccessibleText *obj,
												long int startPos,
												long int endPos)
	SPIBoolean AccessibleEditableText_deleteText (AccessibleEditableText *obj,
												   long int startPos,
												   long int endPos)

	SPIBoolean  AccessibleEditableText_insertText (AccessibleEditableText *obj,
						       long int position,
						       char *text,
						       long int length)
	
	SPIBoolean AccessibleEditableText_cutText  (AccessibleEditableText *obj,
 												long int startPos,
 												long int endPos)
	SPIBoolean AccessibleEditableText_pasteText  (AccessibleEditableText *obj,
												  long int position)
## pyrex doesn't like these for some reason :(
	SPIBoolean AccessibleEditableText_setTextContents (AccessibleEditableText *obj, char *newContents)
	SPIBoolean AccessibleEditableText_setAttributes (AccessibleEditableText *obj, char *attributes, long int startOffset, long int endOffset)

	# Accessible Objects
	SPIBoolean Accessible_isHypertext               (Accessible *obj)
	AccessibleHypertext* Accessible_getHypertext    (Accessible *obj)
	# Subinterface Methods - AccessibleHypertext Interface
	void AccessibleHypertext_ref             (AccessibleHypertext *obj)
	void AccessibleHypertext_unref           (AccessibleHypertext *obj)
	long AccessibleHypertext_getNLinks (AccessibleHypertext *obj)
	AccessibleHyperlink* AccessibleHypertext_getLink (AccessibleHypertext *obj,
												long int linkIndex)
	long AccessibleHypertext_getLinkIndex (AccessibleHypertext *obj,
												long int characterOffset)

	# Accessible Objects
	SPIBoolean Accessible_isHyperlink               (Accessible *obj)
	# Subinterface Methods - AccessibleHyperlink Interface
	void AccessibleHyperlink_ref             (AccessibleHyperlink *obj)
	void AccessibleHyperlink_unref           (AccessibleHyperlink *obj)
	long AccessibleHyperlink_getNAnchors (AccessibleHyperlink *obj)
	void AccessibleHyperlink_getIndexRange (AccessibleHyperlink *obj,
												long int *startIndex, 
												long int *endIndex)
	Accessible *AccessibleHyperlink_getObject (AccessibleHyperlink *obj,
												long int i)
	char* AccessibleHyperlink_getURI (AccessibleHyperlink *obj,
												long int i)
	SPIBoolean AccessibleHyperlink_isValid (AccessibleHyperlink *obj)

	# Accessible Objects
	SPIBoolean Accessible_isImage            (Accessible *obj)
	AccessibleImage *Accessible_getImage     (Accessible *obj)
	# Subinterface Methods - AccessibleImage Interface
	void AccessibleImage_ref                 (AccessibleImage *obj)
	void AccessibleImage_unref               (AccessibleImage *obj)
	char*       AccessibleImage_getImageDescription (AccessibleImage *obj)
	void        AccessibleImage_getImageSize   (AccessibleImage *obj,
 												long int *width,
												long int *height)
	void        AccessibleImage_getImagePosition (AccessibleImage *obj,
 												  long int *x,
 												  long int *y,
 												  AccessibleCoordType ctype)
	void        AccessibleImage_getImageExtents (AccessibleImage *obj,
												 long int *x,
												 long int *y,
												 long int *width,
												 long int *height,
												 AccessibleCoordType ctype)

	# Accessible Objects
	SPIBoolean Accessible_isTable            (Accessible *obj)
	AccessibleTable *Accesssible_getTable    (Accessible *obj)
	# Subinterface Methods - AccessibleTable Interface
	void AccessibleTable_ref                 (AccessibleTable *obj)
	void AccessibleTable_unref               (AccessibleTable *obj)
	Accessible* AccessibleTable_getAccessibleAt (AccessibleTable *obj,
 												long int row,
 												long int column)
	Accessible* AccessibleTable_getCaption      (AccessibleTable *obj)
	long        AccessibleTable_getColumnAtIndex (AccessibleTable *obj,
 												  long int index)
	char*       AccessibleTable_getColumnDescription (AccessibleTable *obj,
													  long int column)
	long        AccessibleTable_getColumnExtentAt (AccessibleTable *obj,
												   long int row,
 												   long int column)
	Accessible* AccessibleTable_getColumnHeader (AccessibleTable *obj,
 												long int column)
	long        AccessibleTable_getIndexAt      (AccessibleTable *obj,
 												long int row,
 												long int column)
	long AccessibleTable_getNColumns         (AccessibleTable *obj)
	long AccessibleTable_getNRows            (AccessibleTable *obj)
	long AccessibleTable_getNSelectedColumns (AccessibleTable *obj)
	long AccessibleTable_getNSelectedRows    (AccessibleTable *obj)
	long        AccessibleTable_getRowAtIndex   (AccessibleTable *obj,
 												long int index)
	char*       AccessibleTable_getRowDescription (AccessibleTable *obj,
												   long int row)
	long        AccessibleTable_getRowExtentAt  (AccessibleTable *obj,
 												 long int row,
 												 long int column)
	Accessible* AccessibleTable_getRowHeader    (AccessibleTable *obj,
 												 long int row)
	long AccessibleTable_getSelectedRows		(AccessibleTable *obj,
												 long int **selectedRows)
	long AccessibleTable_getSelectedColumns		(AccessibleTable *obj,
												 long int **selectedColumns)
	Accessible* AccessibleTable_getSummary      (AccessibleTable *obj)
	SPIBoolean  AccessibleTable_isColumnSelected (AccessibleTable *obj,
 												  long int column)
	SPIBoolean  AccessibleTable_isRowSelected   (AccessibleTable *obj,
 												 long int row)
	SPIBoolean  AccessibleTable_isSelected      (AccessibleTable *obj,
 												 long int row,
 												 long int column)

	# AccessibleApplication Methods - AccessibleApplication API
	void AccessibleApplication_ref               (AccessibleApplication *obj)
	void AccessibleApplication_unref             (AccessibleApplication *obj)
	char *AccessibleApplication_getToolkitName (AccessibleApplication *obj)
	char*      AccessibleApplication_getVersion (AccessibleApplication *obj)
	long       AccessibleApplication_getID      (AccessibleApplication *obj)
	SPIBoolean AccessibleApplication_pause      (AccessibleApplication *obj)
	SPIBoolean AccessibleApplication_resume     (AccessibleApplication *obj)

	# Accessible Objects
	SPIBoolean Accessible_isComponent (Accessible *obj)
	AccessibleComponent *Accessible_getComponent (Accessible *obj)
	Accessible *AccessibleComponent_getAccessibleAtPoint (
			AccessibleComponent *obj,
			long int             x,
			long int             y,
			AccessibleCoordType  ctype)
	void        AccessibleComponent_getExtents  (AccessibleComponent *obj,
			long int            *x,
			long int            *y,
			long int            *width,
			long int            *height,
			AccessibleCoordType  ctype)
	void        AccessibleComponent_getPosition (AccessibleComponent *obj,
			long int            *x,
			long int            *y,
			AccessibleCoordType  ctype)
	void        AccessibleComponent_getSize     (AccessibleComponent *obj,
			long int            *width,
			long int            *height)
	AccessibleComponentLayer	AccessibleComponent_getLayer	(AccessibleComponent *obj)
	SPIBoolean  AccessibleComponent_grabFocus   (AccessibleComponent *obj)
	short       AccessibleComponent_getMDIZOrder(AccessibleComponent *obj)

	# Accessible Objects
	SPIBoolean Accessible_isApplication (Accessible *obj)
	AccessibleApplication *Accessible_getApplication (Accessible *obj)
	AccessibleRole Accessible_getRole       (Accessible *obj)
	char* Accessible_getRoleName			(Accessible *obj)
	char *AccessibleRole_getName            (AccessibleRole role)

	# Registry queries
	int SPI_getDesktopCount                 ()
	Accessible *SPI_getDesktop              (int i)
	int SPI_getDesktopList                  (Accessible ***desktop_list)

	# Synthesizing events:
	SPIBoolean SPI_generateMouseEvent (long x, long y, char *name)
	SPIBoolean SPI_generateKeyboardEvent (long int keyval,
	                                      char *keystring,
                                              AccessibleKeySynthType synth_type)

	# Registry Queries for Event Listener
	SPIBoolean SPI_registerGlobalEventListener (AccessibleEventListener *listener, char *eventType)
	SPIBoolean SPI_deregisterGlobalEventListener (AccessibleEventListener *listener, char *eventType)

	# Event Listener Support
	SPIBoolean AccessibleEvent_ref (AccessibleEvent *event)
	void AccessibleEvent_unref (AccessibleEvent *event)
	AccessibleEventListener* SPI_createAccessibleEventListener (AccessibleEventListenerCB callback, void *user_data)
	void AccessibleEventListener_unref (AccessibleEventListener *listener)
	SPIBoolean AccessibleEventListener_addCallback (AccessibleEventListener *listener, AccessibleEventListenerCB callback, void *user_data)
	SPIBoolean AccessibleEventListener_removeCallback (AccessibleEventListener *listener, AccessibleEventListenerCB callback)
	Accessible* AccessibleActiveDescendantChangedEvent_getActiveDescendant (AccessibleEvent *event)
	Accessible* AccessibleChildChangedEvent_getChildAccessible (AccessibleEvent *event)
	char* AccessibleDescriptionChangedEvent_getDescriptionString (AccessibleEvent *event)
	char* AccessibleNameChangedEvent_getNameString (AccessibleEvent *event)
	Accessible* AccessibleParentChangedEvent_getParentAccessible (AccessibleEvent *event)
	char* AccessibleTableCaptionChangedEvent_getCaptionString (AccessibleEvent *event)
	char* AccessibleTableColumnDescriptionChangedEvent_getDescriptionString (AccessibleEvent *event)
	Accessible* AccessibleTableHeaderChangedEvent_getHeaderAccessible (AccessibleEvent *event)
	char* AccessibleTableRowDescriptionChangedEvent_getDescriptionString (AccessibleEvent *event)
	Accessible* AccessibleTableSummaryChangedEvent_getSummaryAccessible (AccessibleEvent *event)
	char* AccessibleTextChangedEvent_getChangeString (AccessibleEvent *event)
	char* AccessibleTextSelectionChangedEvent_getSelectionString (AccessibleEvent *event)
	char* AccessibleWindowEvent_getTitleString (AccessibleEvent *event)


# vim: sw=4 ts=4 sts=4 noet ai
