"""locators Unittest."""
from ..polygonQuadTreeStructure import QuadTreeStructureSingleRing
from ..shapes import Ring
import unittest

class TestQuadTreeStructureSingleRing(unittest.TestCase):
    def test_QuadTreeStructureSingleRing(self):
        """
        Tests if the class could successfully determine if a point is inside of a polygon
        """
        ring_texas = Ring([
            (-105.99835968, 31.3938179016), (-106.212753296, 31.4781284332), (-106.383041382, 31.7337627411),
            (-106.538970947, 31.7861976624), (-106.614440918, 31.8177280426), (-106.615577698, 31.8446350098),
            (-106.643531799, 31.8951015472), (-106.633201599, 31.9139976501), (-106.63205719, 31.9721183777),
            (-106.649513245, 31.9802284241), (-106.623077393, 32.0009880066), (-106.377845764, 32.0006446838),
            (-106.002708435, 32.0015525818), (-104.921798706, 32.0042686462), (-104.850563049, 32.0031509399),
            (-104.018814087, 32.0072784424), (-103.980895996, 32.0058898926), (-103.728973389, 32.0061035156),
            (-103.332092285, 32.0041542053), (-103.05796814, 32.0018997192), (-103.05519104, 32.0849952698),
            (-103.059547424, 32.5154304504), (-103.048835754, 32.9535331726), (-103.042602539, 33.3777275085),
            (-103.038238525, 33.5657424927), (-103.03276062, 33.8260879517), (-103.029144287, 34.3077430725),
            (-103.022155762, 34.7452659607), (-103.024749756, 34.964717865), (-103.025650024, 35.1772079468),
            (-103.02179718, 35.6236038208), (-103.022117615, 35.7422866821), (-103.02355957, 36.0560264587),
            (-103.026802063, 36.4915657043), (-102.996917725, 36.4923439026), (-102.165222168, 36.4902076721),
            (-102.034210205, 36.4929542542), (-101.620315552, 36.4920043945), (-101.089668274, 36.4880218506),
            (-100.95690918, 36.4896087646), (-100.549415588, 36.4894485474), (-100.006866455, 36.4938774109),
            (-100.001144409, 36.4925193787), (-99.9971542358, 36.0575485229), (-99.9977264404, 35.8837928772),
            (-100.0, 35.6188087463), (-99.994354248, 35.424571991), (-99.9971847534, 35.182182312),
            (-99.9960708618, 35.03099823), (-99.998878479, 34.7471847534), (-99.99609375, 34.5623207092),
            (-99.9720993042, 34.5618629456), (-99.9447402954, 34.5795707703), (-99.9319076538, 34.5791091919),
            (-99.8805999756, 34.5481758118), (-99.8605728149, 34.5186271667), (-99.8299331665, 34.5017776489),
            (-99.7776870728, 34.4439926147), (-99.6849060059, 34.3774452209), (-99.6014480591, 34.3685569763),
            (-99.5852203369, 34.3848571777), (-99.5778503418, 34.4089126587), (-99.5538635254, 34.4151802063),
            (-99.5021362305, 34.4040679932), (-99.4794387817, 34.3835220337), (-99.4383773804, 34.3647041321),
            (-99.4099578857, 34.3691062927), (-99.3941574097, 34.3967437744), (-99.392791748, 34.4289932251),
            (-99.3642044067, 34.4501953125), (-99.3232955933, 34.4127082825), (-99.2671737671, 34.3982849121),
            (-99.2541046143, 34.3682136536), (-99.2054901123, 34.331993103), (-99.1963043213, 34.3051223755),
            (-99.2045974731, 34.255645752), (-99.1904830933, 34.2237358093), (-99.1761550903, 34.2127304077),
            (-99.1279449463, 34.2014694214), (-99.0784301758, 34.2083587646), (-99.0352172852, 34.1989212036),
            (-98.9961929321, 34.2094955444), (-98.952507019, 34.1945648193), (-98.8913421631, 34.1608200073),
            (-98.8110656738, 34.1459350586), (-98.7785339355, 34.1319618225), (-98.705291748, 34.1307144165),
            (-98.6822128296, 34.1499977112), (-98.6617202759, 34.1470375061), (-98.6259918213, 34.1584358215),
            (-98.6072463989, 34.1513977051), (-98.5763320923, 34.1419296265), (-98.5575790405, 34.1053352356),
            (-98.4995193481, 34.0664138794), (-98.4481887817, 34.0543746948), (-98.4213409424, 34.0658302307),
            (-98.4071350098, 34.0824546814), (-98.390953064, 34.0872306824), (-98.3842544556, 34.1157798767),
            (-98.350402832, 34.1421203613), (-98.3204879761, 34.1394195557), (-98.2770004272, 34.1228713989),
            (-98.1728439331, 34.1153678894), (-98.1368637085, 34.1384315491), (-98.1148681641, 34.1489868164),
            (-98.0941238403, 34.1345558167), (-98.1106872559, 34.0698204041), (-98.0862045288, 34.0053138733),
            (-98.055557251, 33.9897994995), (-98.0234909058, 33.9869842529), (-97.9826812744, 34.001285553),
            (-97.9502258301, 33.9711608887), (-97.9477539062, 33.9597511292), (-97.9629974365, 33.9486503601),
            (-97.9506835938, 33.9325180054), (-97.9761276245, 33.9120521545), (-97.9763793945, 33.9025039673),
            (-97.9547348022, 33.883480072), (-97.9090652466, 33.8740234375), (-97.8697509766, 33.8551139832),
            (-97.8525466919, 33.8570709229), (-97.7902069092, 33.8904571533), (-97.756362915, 33.9320983887),
            (-97.729019165, 33.9392929077), (-97.7042617798, 33.9715461731), (-97.6710662842, 33.9886131287),
            (-97.6001815796, 33.9694366455), (-97.5923538208, 33.9178848267), (-97.575668335, 33.9025306702),
            (-97.5545883179, 33.9039039612), (-97.5182037354, 33.9167709351), (-97.4775314331, 33.9077072144),
            (-97.4627609253, 33.902381897), (-97.4570617676, 33.8904304504), (-97.4527359009, 33.8362121582),
            (-97.410118103, 33.8207092285), (-97.363319397, 33.8310241699), (-97.3418045044, 33.8619155884),
            (-97.314956665, 33.8703918457), (-97.3140869141, 33.8958396912), (-97.272277832, 33.8725738525),
            (-97.2639083862, 33.8587303162), (-97.2506866455, 33.8729705811), (-97.2460632324, 33.8942375183),
            (-97.2113342285, 33.9056892395), (-97.1877670288, 33.8992042542), (-97.1641693115, 33.8631477356),
            (-97.1685943604, 33.8477935791), (-97.1950149536, 33.8361587524), (-97.2083206177, 33.8196487427),
            (-97.189163208, 33.7527694702), (-97.1524734497, 33.7286682129), (-97.115562439, 33.725933075),
            (-97.0904998779, 33.7316703796), (-97.0834655762, 33.7424125671), (-97.0876693726, 33.8075714111),
            (-97.0500259399, 33.8234481812), (-97.0782470703, 33.8378105164), (-97.0821762085, 33.8511009216),
            (-97.0708999634, 33.8567276001), (-97.0255966187, 33.8405609131), (-97.0058517456, 33.8505134583),
            (-96.9877090454, 33.8764228821), (-96.9878616333, 33.9442024231), (-96.9681854248, 33.9373207092),
            (-96.9362030029, 33.9478492737), (-96.9295654297, 33.9617729187), (-96.8984527588, 33.9500274658),
            (-96.882850647, 33.9245910645), (-96.8789367676, 33.8840026855), (-96.8610153198, 33.8616790771),
            (-96.8440093994, 33.8580322266), (-96.8141174316, 33.8717689514), (-96.7975921631, 33.8699493408),
            (-96.7488250732, 33.8317375183), (-96.7116775513, 33.8338699341), (-96.6933822632, 33.8479042053),
            (-96.6777038574, 33.9043235779), (-96.6662368774, 33.9135437012), (-96.584487915, 33.8961448669),
            (-96.6141662598, 33.8628997803), (-96.6011962891, 33.842956543), (-96.5621337891, 33.8254203796),
            (-96.5105743408, 33.8156852722), (-96.5007476807, 33.7880897522), (-96.4873733521, 33.7781295776),
            (-96.4194641113, 33.7883262634), (-96.3708190918, 33.7403945923), (-96.3475875854, 33.7055282593),
            (-96.3162765503, 33.7018013), (-96.3007888794, 33.714050293), (-96.289680481, 33.761932373),
            (-96.2780761719, 33.7733879089), (-96.2125473022, 33.756690979), (-96.1870269775, 33.7585830688),
            (-96.1688156128, 33.7693557739), (-96.161315918, 33.7982292175), (-96.141418457, 33.8203201294),
            (-96.1545181274, 33.8239440918), (-96.1807250977, 33.8084335327), (-96.1831283569, 33.8157920837),
            (-96.1692047119, 33.8289833069), (-96.1489639282, 33.8355903625), (-96.1094436646, 33.8292579651),
            (-96.0915222168, 33.8445777893), (-96.0479736328, 33.8412780762), (-96.0267486572, 33.8560218811),
            (-96.0140686035, 33.8442077637), (-96.0017929077, 33.8569793701), (-96.0026168823, 33.8733901978),
            (-95.9942092896, 33.875377655), (-95.977394104, 33.8579521179), (-95.9587631226, 33.8650398254),
            (-95.943069458, 33.8899726868), (-95.9330749512, 33.8905296326), (-95.8465576172, 33.8410377502),
            (-95.8259735107, 33.8430252075), (-95.7954788208, 33.8646736145), (-95.7685165405, 33.8514022827),
            (-95.764251709, 33.8790054321), (-95.7606964111, 33.8934402466), (-95.7468643188, 33.9033966064),
            (-95.6997070312, 33.8948249817), (-95.6334915161, 33.9201049805), (-95.6129837036, 33.9202384949),
            (-95.6148300171, 33.9366912842), (-95.6060714722, 33.9445533752), (-95.5627746582, 33.9360733032),
            (-95.5463180542, 33.9040336609), (-95.5195770264, 33.9066429138), (-95.5267333984, 33.8978157043),
            (-95.547492981, 33.893157959), (-95.5440368652, 33.8857421875), (-95.5128860474, 33.8977355957),
            (-95.4988555908, 33.8817176819), (-95.4681243896, 33.8864326477), (-95.4516067505, 33.8657531738),
            (-95.330039978, 33.8709182739), (-95.336227417, 33.8971138), (-95.3019561768, 33.8866233826),
            (-95.2864303589, 33.8869018555), (-95.2773513794, 33.9179382324), (-95.2636184692, 33.8978004456),
            (-95.2509918213, 33.9050216675), (-95.2512893677, 33.9364433289), (-95.2340393066, 33.9648628235),
            (-95.1483154297, 33.9435462952), (-95.1279678345, 33.9408683777), (-95.1266784668, 33.9171447754),
            (-95.1192245483, 33.9122810364), (-95.0953598022, 33.9217376709), (-95.0822677612, 33.9184532166),
            (-95.0897140503, 33.8969154358), (-95.0836029053, 33.8884620667), (-95.0634765625, 33.9176483154),
            (-95.0631408691, 33.8966941833), (-95.0428619385, 33.8844451904), (-95.037361145, 33.8664512634),
            (-95.0127716064, 33.8699455261), (-94.9892807007, 33.8561820984), (-94.9687042236, 33.8662147522),
            (-94.9599075317, 33.8480758667), (-94.9398880005, 33.8408241272), (-94.9403991699, 33.8158073425),
            (-94.9182357788, 33.8161964417), (-94.9085464478, 33.803478241), (-94.9138793945, 33.7895965576),
            (-94.8816375732, 33.7749633789), (-94.8578796387, 33.7493209839), (-94.8191604614, 33.7494049072),
            (-94.8032226562, 33.7395820618), (-94.7835083008, 33.7532615662), (-94.764175415, 33.7528419495),
            (-94.7820281982, 33.7422676086), (-94.7831573486, 33.7336654663), (-94.7497711182, 33.73670578),
            (-94.7627182007, 33.716796875), (-94.7421112061, 33.7190475464), (-94.7544784546, 33.7077713013),
            (-94.7416534424, 33.7012672424), (-94.6909866333, 33.6902885437), (-94.6684570312, 33.6965370178),
            (-94.6554794312, 33.6922912598), (-94.6443252563, 33.6776504517), (-94.6679534912, 33.671459198),
            (-94.6694259644, 33.6660614014), (-94.6585388184, 33.6637382507), (-94.6387634277, 33.6701049805),
            (-94.6317367554, 33.6838989258), (-94.600944519, 33.6656074524), (-94.585105896, 33.678981781),
            (-94.5785064697, 33.6704711914), (-94.5607223511, 33.671913147), (-94.5652084351, 33.6630134583),
            (-94.5851593018, 33.6621322632), (-94.5883865356, 33.6554489136), (-94.576461792, 33.6521568298),
            (-94.5454177856, 33.6616210938), (-94.5419311523, 33.6482467651), (-94.5621948242, 33.642829895),
            (-94.5621490479, 33.6355361938), (-94.5501937866, 33.6326942444), (-94.5179901123, 33.6430091858),
            (-94.5250549316, 33.6210212708), (-94.510559082, 33.6308097839), (-94.5006103516, 33.623046875),
            (-94.4764862061, 33.6319656372), (-94.4359130859, 33.6364440918), (-94.4363327026, 33.6168441772),
            (-94.4515533447, 33.604347229), (-94.4433288574, 33.5965042114), (-94.4284667969, 33.5971412659),
            (-94.4065704346, 33.5734863281), (-94.3934173584, 33.5749588013), (-94.3791122437, 33.5933265686),
            (-94.3706283569, 33.5900421143), (-94.3723068237, 33.5726623535), (-94.3952636719, 33.5603027344),
            (-94.3707580566, 33.5476837158), (-94.3287506104, 33.573135376), (-94.3023834229, 33.5569343567),
            (-94.2988204956, 33.5798530579), (-94.2789840698, 33.5893325806), (-94.2720794678, 33.5846061707),
            (-94.2745437622, 33.5617370605), (-94.2372360229, 33.5924224854), (-94.2230377197, 33.5857200623),
            (-94.2353668213, 33.5615348816), (-94.2108840942, 33.5579872131), (-94.2053451538, 33.5850791931),
            (-94.1595153809, 33.5937728882), (-94.155166626, 33.5670852661), (-94.0987014771, 33.5729980469),
            (-94.0866546631, 33.5839538574), (-94.0614318848, 33.5772132874), (-94.0359268188, 33.5559120178),
            (-94.0365066528, 33.270324707), (-94.0387496948, 33.0232887268), (-94.0416030884, 32.8823471069),
            (-94.0401992798, 32.6948127747), (-94.0352325439, 32.3892250061), (-94.0347671509, 32.1994476318),
            (-94.0350646973, 31.994512558), (-94.0098876953, 31.9891338348), (-94.0043945312, 31.9779415131),
            (-93.9772109985, 31.9461593628), (-93.9699859619, 31.9231643677), (-93.9357299805, 31.9094562531),
            (-93.9179229736, 31.909702301), (-93.9234619141, 31.8925933838), (-93.8992614746, 31.8944549561),
            (-93.8925247192, 31.8700656891), (-93.8812637329, 31.8714199066), (-93.8774032593, 31.850112915),
            (-93.8648223877, 31.8172721863), (-93.8343276978, 31.8020172119), (-93.8220672607, 31.7746372223),
            (-93.831161499, 31.7532806396), (-93.8099899292, 31.7303524017), (-93.8149490356, 31.7123508453),
            (-93.8087692261, 31.7075653076), (-93.7922668457, 31.7113952637), (-93.8118438721, 31.6745662689),
            (-93.806427002, 31.6537666321), (-93.8147277832, 31.6479663849), (-93.8195877075, 31.6180915833),
            (-93.8355789185, 31.6151885986), (-93.8326187134, 31.5901832581), (-93.8163223267, 31.5771102905),
            (-93.8105163574, 31.5590629578), (-93.780128479, 31.5337352753), (-93.7633056641, 31.5307235718),
            (-93.747543335, 31.5377178192), (-93.7316589355, 31.5218772888), (-93.7057952881, 31.5205688477),
            (-93.7189941406, 31.4954032898), (-93.7504348755, 31.4905567169), (-93.7512435913, 31.4855003357),
            (-93.7267837524, 31.4594745636), (-93.6984176636, 31.4614582062), (-93.7019271851, 31.4462509155),
            (-93.6870040894, 31.4381313324), (-93.6961288452, 31.4277362823), (-93.694442749, 31.4159221649),
            (-93.6874923706, 31.406129837), (-93.6640167236, 31.3983287811), (-93.6610717773, 31.3723945618),
            (-93.6348571777, 31.3738269806), (-93.6770401001, 31.3283863068), (-93.6815872192, 31.3126792908),
            (-93.6561279297, 31.2866706848), (-93.6455917358, 31.2902622223), (-93.6308288574, 31.2739028931),
            (-93.6164550781, 31.2758045197), (-93.6118774414, 31.2700328827), (-93.611000061, 31.2421875),
            (-93.5905456543, 31.2296867371), (-93.6029205322, 31.1990661621), (-93.5939407349, 31.1801986694),
            (-93.5769424438, 31.1721401215), (-93.5505905151, 31.1909294128), (-93.5289230347, 31.1857738495),
            (-93.5269317627, 31.1780757904), (-93.5370178223, 31.1763401031), (-93.5283279419, 31.1629428864),
            (-93.5441894531, 31.1591663361), (-93.5375061035, 31.132440567), (-93.5280914307, 31.1259250641),
            (-93.5350875854, 31.116071701), (-93.556678772, 31.1093425751), (-93.5599822998, 31.1005363464),
            (-93.5431213379, 31.094751358), (-93.5441055298, 31.0823726654), (-93.516998291, 31.0746707916),
            (-93.5257415771, 31.0569801331), (-93.5072174072, 31.0389080048), (-93.5471191406, 31.0141410828),
            (-93.5649414062, 31.0180625916), (-93.5678939819, 31.0129241943), (-93.5708465576, 30.9972705841),
            (-93.5609512329, 30.991689682), (-93.5724563599, 30.9761772156), (-93.5486755371, 30.9701900482),
            (-93.5373382568, 30.9568843842), (-93.5321884155, 30.9607315063), (-93.5256195068, 30.9358196259),
            (-93.5299835205, 30.9269714355), (-93.549621582, 30.9248847961), (-93.5465164185, 30.9053344727),
            (-93.5644760132, 30.9019317627), (-93.5684967041, 30.8862342834), (-93.5608444214, 30.8718795776),
            (-93.5528030396, 30.8602828979), (-93.566444397, 30.8451480865), (-93.5556411743, 30.8423423767),
            (-93.5506820679, 30.8283443451), (-93.5818710327, 30.8020401001), (-93.5851745605, 30.7721843719),
            (-93.6184539795, 30.7457885742), (-93.6076507568, 30.7320098877), (-93.6177902222, 30.73254776),
            (-93.612411499, 30.7103290558), (-93.6176071167, 30.6868019104), (-93.6599884033, 30.6728591919),
            (-93.6779708862, 30.6396923065), (-93.6928787231, 30.6400413513), (-93.6845855713, 30.62342453),
            (-93.6926956177, 30.6157951355), (-93.671585083, 30.5978317261), (-93.6934204102, 30.5988349915),
            (-93.7178115845, 30.5873794556), (-93.717880249, 30.5681533813), (-93.7353057861, 30.5455169678),
            (-93.7054595947, 30.522857666), (-93.7146377563, 30.5051136017), (-93.7072753906, 30.4962406158),
            (-93.7148513794, 30.4886283875), (-93.6979751587, 30.4700469971), (-93.7034225464, 30.46251297),
            (-93.6965713501, 30.4426326752), (-93.721534729, 30.4329795837), (-93.7425613403, 30.4088230133),
            (-93.7549438477, 30.3817882538), (-93.747833252, 30.3674106598), (-93.7593383789, 30.35414505),
            (-93.7591781616, 30.3408718109), (-93.7297744751, 30.3049163818), (-93.6992111206, 30.2973880768),
            (-93.707359314, 30.2393722534), (-93.71484375, 30.2203063965), (-93.7043609619, 30.1808605194),
            (-93.6961669922, 30.1756763458), (-93.6996612549, 30.1508083344), (-93.6831436157, 30.1482315063),
            (-93.6859588623, 30.1412525177), (-93.698638916, 30.1412258148), (-93.6969223022, 30.1179294586),
            (-93.7083816528, 30.1147403717), (-93.7158584595, 30.0956687927), (-93.7124786377, 30.0605201721),
            (-93.7602005005, 30.0059642792), (-93.8572769165, 29.9906539917), (-93.8563308716, 29.9646015167),
            (-93.9517669678, 29.8183631897), (-93.8349609375, 29.6745700836), (-94.0654067993, 29.6740760803),
            (-94.3569946289, 29.5599002838), (-94.3770065308, 29.5519695282), (-94.6825180054, 29.4329051971),
            (-94.7665481567, 29.363992691), (-94.7852478027, 29.3832607269), (-94.6819152832, 29.4751110077),
            (-94.5726928711, 29.5330524445), (-94.5012817383, 29.5175228119), (-94.4697952271, 29.5567798615),
            (-94.5108108521, 29.5451469421), (-94.5336990356, 29.5539836884), (-94.5644378662, 29.5789985657),
            (-94.7880859375, 29.5385570526), (-94.7064208984, 29.6585159302), (-94.7002792358, 29.7545681),
            (-94.7357254028, 29.7929859161), (-94.8294143677, 29.7598571777), (-94.8871612549, 29.6685390472),
            (-94.9325866699, 29.6822090149), (-95.0882644653, 29.8039798737), (-95.040397644, 29.7115783691),
            (-94.9893341064, 29.6797008514), (-95.0141220093, 29.5592651367), (-94.9111557007, 29.500333786),
            (-94.9828109741, 29.46052742), (-94.9437561035, 29.4646816254), (-94.952507019, 29.4242343903),
            (-94.913444519, 29.4201126099), (-94.9169921875, 29.4478225708), (-94.8911361694, 29.3993244171),
            (-94.8153533936, 29.3709316254), (-94.8914718628, 29.3938312531), (-94.8987884521, 29.3087749481),
            (-94.951133728, 29.3259220123), (-95.066368103, 29.1958770752), (-95.1605224609, 29.2000312805),
            (-95.1647796631, 29.1175479889), (-95.1973419189, 29.105222702), (-95.2484054565, 28.9783916473),
            (-95.5265808105, 28.8032417297), (-95.6830291748, 28.7269535065), (-95.6713180542, 28.7526817322),
            (-95.7863540649, 28.7388706207), (-95.9373092651, 28.690454483), (-95.9561462402, 28.6226730347),
            (-95.7021484375, 28.7189865112), (-96.2065811157, 28.4883861542), (-95.991645813, 28.5964241028),
            (-95.9837493896, 28.6531333923), (-96.2375869751, 28.5713214874), (-96.2390289307, 28.5971164703),
            (-96.1574707031, 28.6112308502), (-96.2404556274, 28.6348590851), (-96.1510620117, 28.7626724243),
            (-96.2121734619, 28.6867198944), (-96.2859725952, 28.6617240906), (-96.2703781128, 28.7089805603),
            (-96.3261566162, 28.6340885162), (-96.3641586304, 28.617980957), (-96.3917770386, 28.6702518463),
            (-96.3927307129, 28.7260284424), (-96.4270858765, 28.7120132446), (-96.4496765137, 28.7550354004),
            (-96.432258606, 28.6972484589), (-96.4033966064, 28.719493866), (-96.4187850952, 28.6386642456),
            (-96.3753967285, 28.6100883484), (-96.4912033081, 28.5569438934), (-96.4371566772, 28.5969905853),
            (-96.4543838501, 28.6559333801), (-96.4832687378, 28.5980548859), (-96.5118942261, 28.6081809998),
            (-96.5117340088, 28.6495418549), (-96.5703964233, 28.6362667084), (-96.5705566406, 28.6918411255),
            (-96.5722122192, 28.8081741333), (-96.5764846802, 28.6906890869), (-96.5914993286, 28.7173595428),
            (-96.6465148926, 28.7141418457), (-96.6600112915, 28.6790752411), (-96.6067047119, 28.6236343384),
            (-96.6103439331, 28.5589408875), (-96.5667037964, 28.574098587), (-96.486579895, 28.5062217712),
            (-96.5631942749, 28.4696273804), (-96.5185012817, 28.4608268738), (-96.4765014648, 28.4994544983),
            (-96.3907241821, 28.4340591431), (-96.6613082886, 28.30626297), (-96.7023620605, 28.3401966095),
            (-96.7038116455, 28.3958854675), (-96.7407684326, 28.4034576416), (-96.7870941162, 28.4775066376),
            (-96.8238754272, 28.449640274), (-96.7883377075, 28.4462547302), (-96.7591018677, 28.4109115601),
            (-96.7753601074, 28.3916301727), (-96.8534927368, 28.4049968719), (-96.788230896, 28.3524703979),
            (-96.7862701416, 28.3128585815), (-96.7933349609, 28.2713718414), (-96.7779312134, 28.2293491364),
            (-96.8036880493, 28.2114467621), (-96.9509048462, 28.1143550873), (-96.9127197266, 28.2567977905),
            (-96.9753036499, 28.2107505798), (-96.9410705566, 28.1867713928), (-96.9751052856, 28.1150455475),
            (-97.0336151123, 28.1373977661), (-97.0235671997, 28.1997966766), (-97.1318359375, 28.1304264069),
            (-97.1354141235, 28.1618099213), (-97.1679916382, 28.1594600677), (-97.1570587158, 28.1163806915),
            (-97.2602844238, 28.0647239685), (-97.2412338257, 28.0486526489), (-97.2702941895, 28.025932312),
            (-97.2362136841, 28.0405197144), (-97.1230773926, 28.054265976), (-97.0264053345, 28.107749939),
            (-97.0238037109, 28.020236969), (-97.1146240234, 27.9153862), (-97.1954650879, 27.8122196198),
            (-97.2470245361, 27.8223190308), (-97.2133407593, 27.8311100006), (-97.2834854126, 27.8711452484),
            (-97.3610458374, 27.8399543762), (-97.3456192017, 27.8731784821), (-97.4793548584, 27.8529624939),
            (-97.4966812134, 27.8754692078), (-97.521697998, 27.8636264801), (-97.4995346069, 27.8432426453),
            (-97.4798126221, 27.8202819824), (-97.3885421753, 27.8314266205), (-97.3965606689, 27.7708396912),
            (-97.3177947998, 27.7122249603), (-97.3495101929, 27.7153282166), (-97.3200149536, 27.6906337738),
            (-97.3533630371, 27.6408004761), (-97.3992156982, 27.6331863403), (-97.3475036621, 27.631439209),
            (-97.309211731, 27.707862854), (-97.2497940063, 27.6888313293), (-97.3314590454, 27.5623207092),
            (-97.4122619629, 27.321023941), (-97.5004348755, 27.3196678162), (-97.5075378418, 27.4392147064),
            (-97.5283813477, 27.3441009521), (-97.600112915, 27.3001346588), (-97.7500762939, 27.4196662903),
            (-97.6800079346, 27.2943725586), (-97.7847442627, 27.2877197266), (-97.5481567383, 27.2302074432),
            (-97.4272155762, 27.2651329041), (-97.5035018921, 27.0815410614), (-97.4789962769, 26.9965076447),
            (-97.5685653687, 26.9778575897), (-97.558052063, 26.8460521698), (-97.4955749512, 26.7937812805),
            (-97.4516983032, 26.6009845734), (-97.4258575439, 26.5182247162), (-97.4747085571, 26.4768047333),
            (-97.4211883545, 26.3850593567), (-97.3686981201, 26.3590602875), (-97.3533630371, 26.1824493408),
            (-97.2531204224, 26.068315506), (-97.2763214111, 26.0022754669), (-97.2130966187, 26.0090675354),
            (-97.1722259521, 25.9545688629), (-97.307144165, 25.9651241302), (-97.30443573, 25.9386634827),
            (-97.3809890747, 25.9170207977), (-97.3856430054, 25.8453617096), (-97.4343490601, 25.8451976776),
            (-97.5900878906, 25.9332313538), (-97.5749359131, 25.9541721344), (-97.6129226685, 25.9620018005),
            (-97.6479721069, 26.0234451294), (-97.8674316406, 26.0601406097), (-98.0400695801, 26.0593948364),
            (-98.0763473511, 26.0346260071), (-98.0832138062, 26.0657577515), (-98.2006912231, 26.0553760529),
            (-98.2919464111, 26.0981044769), (-98.2713546753, 26.1208953857), (-98.2922744751, 26.1328086853),
            (-98.3279342651, 26.1116466522), (-98.3471908569, 26.1586799622), (-98.3845214844, 26.1560306549),
            (-98.4533920288, 26.220911026), (-98.4885177612, 26.201543808), (-98.5999679565, 26.2604541779),
            (-98.6779174805, 26.2420558929), (-98.8198318481, 26.3750705719), (-98.9088973999, 26.3603286743),
            (-98.9392700195, 26.3953094482), (-99.1067276001, 26.4195308685), (-99.1014709473, 26.4883403778),
            (-99.1686782837, 26.5457286835), (-99.1658172607, 26.5798892975), (-99.2855224609, 26.8573608398),
            (-99.3905181885, 26.9466304779), (-99.3927154541, 26.9955501556), (-99.4550628662, 27.0286483765),
            (-99.4371566772, 27.1991977692), (-99.4652709961, 27.2698841095), (-99.543586731, 27.3186531067),
            (-99.4904937744, 27.4907550812), (-99.5267410278, 27.504283905), (-99.5491867065, 27.6126270294),
            (-99.7144927979, 27.6615581512), (-99.8157272339, 27.7801074982), (-99.8747329712, 27.7976856232),
            (-99.9418563843, 27.9868812561), (-99.993309021, 28.0034599304), (-100.096923828, 28.1542816162),
            (-100.214073181, 28.2019348145), (-100.223464966, 28.2414569855), (-100.297920227, 28.2803535461),
            (-100.292892456, 28.3203601837), (-100.351570129, 28.3941822052), (-100.37677002, 28.4786510468),
            (-100.345802307, 28.5008106232), (-100.419532776, 28.5441913605), (-100.403175354, 28.5897331238),
            (-100.497909546, 28.660987854), (-100.589790344, 28.8942222595), (-100.647224426, 28.9223499298),
            (-100.668769836, 29.080072403), (-100.768608093, 29.1665706635), (-100.796989441, 29.2425022125),
            (-101.009056091, 29.373254776), (-101.067359924, 29.4735527039), (-101.261428833, 29.526473999),
            (-101.254585266, 29.6287498474), (-101.308929443, 29.580909729), (-101.305862427, 29.652431488),
            (-101.368400574, 29.6571617126), (-101.416099548, 29.7454338074), (-101.401275635, 29.7699050903),
            (-101.448425293, 29.7605857849), (-101.470466614, 29.788690567), (-101.538345337, 29.7630176544),
            (-101.543952942, 29.8101196289), (-101.581489563, 29.7651500702), (-101.639671326, 29.7569599152),
            (-101.759094238, 29.7871665955), (-101.805206299, 29.7799987793), (-101.819099426, 29.814125061),
            (-101.924224854, 29.7885017395), (-101.973320007, 29.8187732697), (-102.063995361, 29.784570694),
            (-102.324333191, 29.880115509), (-102.36756134, 29.8452892303), (-102.384796143, 29.7679462433),
            (-102.503097534, 29.7854557037), (-102.551948547, 29.7495002747), (-102.576499939, 29.7782478333),
            (-102.637611389, 29.7323379517), (-102.676361084, 29.7442245483), (-102.804725647, 29.5301456451),
            (-102.82220459, 29.4118442535), (-102.883010864, 29.3533706665), (-102.908325195, 29.269203186),
            (-102.866172791, 29.2290363312), (-102.988098145, 29.1908626556), (-103.153465271, 28.9786815643),
            (-103.266586304, 29.0074539185), (-103.280349731, 28.9863739014), (-103.335517883, 29.0503387451),
            (-103.375450134, 29.0321083069), (-103.474075317, 29.0721340179), (-103.526237488, 29.1466464996),
            (-103.720314026, 29.1906318665), (-103.739852905, 29.230348587), (-103.782157898, 29.2297954559),
            (-103.76776123, 29.2812404633), (-103.786994934, 29.2672595978), (-104.045631409, 29.328119278),
            (-104.164382935, 29.4007148743), (-104.204734802, 29.484041214), (-104.377593994, 29.550611496),
            (-104.535247803, 29.6794662476), (-104.577560425, 29.8079357147), (-104.674369812, 29.9092826843),
            (-104.696495056, 30.057302475), (-104.674758911, 30.1489639282), (-104.702613831, 30.238489151),
            (-104.813957214, 30.3504695892), (-104.806472778, 30.3764476776), (-104.852996826, 30.3922634125),
            (-104.890678406, 30.5705566406), (-104.986930847, 30.6413249969), (-104.997543335, 30.6843338013),
            (-105.060562134, 30.6878700256), (-105.21434021, 30.8120861053), (-105.25818634, 30.7976531982),
            (-105.287597656, 30.831949234), (-105.313781738, 30.8165073395), (-105.390312195, 30.8530807495),
            (-105.409065247, 30.9025096893), (-105.554382324, 30.9982852936), (-105.603218079, 31.0864276886),
            (-105.769729614, 31.1707801819), (-105.99835968, 31.3938179016)
        ])
        qtssr_texas = QuadTreeStructureSingleRing(ring_texas)
        points = [
            [-96.83201838665211, 30.43633054583931, True], [-94.97179271816618, 30.46609834459278, True],
            [-96.87911915799319, 29.002783392404453, True], [-104.03817768478906, 26.080885130466065, False],
            [-101.05107033713017, 26.110092672074, False], [-101.90984946051287, 30.2673660562615, True],
            [-104.2666097673043, 26.638892954348243, False], [-99.00209313228278, 29.312408039204637, True],
            [-96.76821760997925, 26.53415999513266, False], [-103.60734801725461, 25.989562175464958, False],
            [-105.52663947372852, 35.59616356954213, False], [-99.73190928401823, 36.34065757158246, False],
            [-94.28455658519579, 30.510396248421543, True], [-98.287902523108, 32.42446924695663, True],
            [-98.36319041112684, 26.836620743656326, True], [-100.58823300352246, 28.287422480123738, False],
            [-106.09575378559609, 29.647073739534953, False], [-96.03197805726944, 34.67673925196511, False],
            [-106.13189503506499, 28.293328347459486, False], [-105.6163099497765, 34.642876249285806, False],
            [-102.1699840394609, 32.64792829807019, True], [-102.19213396201079, 31.137813785847744, True],
            [-96.8832056156457, 33.584067733298724, True], [-105.47157574361026, 33.89108923934286, False],
            [-101.53889206881809, 27.73095057942401, False], [-95.0730796759137, 26.09464277833887, False],
            [-96.45795032815394, 30.22238046821291, True], [-99.47479689046119, 27.519862201810025, True],
            [-104.95530088407097, 34.46894379454478, False], [-99.64935392553515, 27.166719715093752, False],
            [-101.8740013838435, 35.11537675606412, True], [-99.07039344683601, 33.64951303142618, True],
            [-106.60595918307385, 29.64471250102584, False], [-97.20030616424087, 32.31820772186446, True],
            [-96.23784236099425, 27.638993220475054, False], [-105.93765675735541, 35.89412147712274, False],
            [-97.17726496423283, 28.55515333886519, True], [-101.41972932590615, 26.609185193916016, False],
            [-101.84272804452128, 31.047193869577697, True], [-95.92485433657428, 33.9254034938182, False],
            [-98.09279175575493, 31.486295362051568, True], [-100.77512720701931, 34.5423023937584, True],
            [-105.99024440024378, 32.444411669816, False], [-101.4742991680627, 36.37442042029491, True],
            [-99.91406680649878, 30.44981434916269, True], [-106.59351726840352, 27.830675040946844, False],
            [-100.50108029331473, 28.08692086210316, False], [-106.22266727042927, 28.257938478160245, False],
            [-99.16766510789698, 34.05594801235725, True], [-98.81327349833023, 34.53578673189781, False],
            [-95.75835434832825, 35.97127466623442, False], [-95.87872844572516, 34.1792497663974, False],
            [-97.67138045660111, 28.85228239075667, True], [-103.7493116963675, 29.910102031100415, True],
            [-97.9552991722866, 35.50168101442732, False], [-101.99173352350167, 33.16196427356835, True],
            [-99.69108575797604, 26.58570279334035, False], [-96.1383698450465, 30.01380467777652, True],
            [-96.65345956191142, 28.13722809686032, False], [-102.19812919352621, 27.653939350819577, False],
            [-106.17852559635664, 34.30676459237532, False], [-97.12171059588019, 32.98547742358788, True],
            [-97.63495481018265, 31.052912731492313, True], [-103.04179423578454, 32.565022698580854, True],
            [-99.7663361476778, 33.93929224333747, True], [-93.96695034930963, 33.64792052285788, False],
            [-106.43489898416725, 27.00081934085768, False], [-98.61144241454609, 26.091546414019007, False],
            [-97.62297026159148, 29.91547499019296, True], [-102.81093959843548, 31.775967846663903, True],
            [-98.92280973197468, 34.706031694183864, False], [-105.82454817097681, 33.60768142292876, False],
            [-104.1703913008495, 26.30423978112628, False], [-97.03821689475404, 25.891523519897085, False],
            [-95.96948383690238, 28.06242640122303, False], [-96.20743197977514, 32.96986917934692, True],
            [-101.84781525566628, 30.91982689926289, True], [-96.31807840035235, 31.527410535260906, True],
            [-100.8781500555231, 34.8227970125657, True], [-94.26355042343864, 30.94843753499924, True],
            [-97.3429146102502, 34.73686841121185, False], [-98.07753472284375, 29.552925455931927, True],
            [-105.04690710593536, 27.132667240961553, False], [-99.87850355720977, 32.06195375035851, True],
            [-96.53670297300587, 26.908808751199025, False], [-101.25665086243849, 34.48897040535931, True],
            [-97.62841641211763, 34.510828859444, False], [-98.26146628715239, 29.30444627019776, True],
            [-94.0424931438063, 34.024181902771446, False], [-95.32764174246178, 29.026516144561093, True],
            [-94.79487469005772, 34.064778827088944, False], [-96.8217807635728, 32.9449205143214, True],
            [-102.65783000325504, 31.187142262599163, True], [-102.73499640672506, 28.241956569934032, False],
            [-106.57423647984751, 26.21365468361891, False], [-101.18188053173569, 35.856064735642605, True],
            [-103.87152954646331, 26.239969281258677, False], [-105.21761650869897, 27.276124133480618, False],
            [-96.58824456554876, 36.01267677418892, False], [-99.10920560787146, 32.43164577872433, True],
            [-101.93795697189412, 31.620064217834788, True], [-105.78051688469152, 34.39769579781999, False],
            [-98.13520908953838, 28.15597786510518, True], [-103.44661785399717, 34.94625679402945, False],
            [-93.5839550242031, 27.799377395246868, False], [-103.09029902940127, 33.20610297263985, False],
            [-97.23285674761303, 28.03274042046823, True], [-95.34132538021933, 25.846590059853146, False],
            [-101.75354725398458, 29.976564072236787, True], [-102.8028884021146, 36.14653256975264, True],
            [-105.23453544451979, 35.083822581361105, False], [-95.02779486726217, 28.039905574389728, False],
            [-105.19965155638648, 29.896855738726387, False], [-105.04729708179732, 34.59962724881616, False],
            [-93.62110240741019, 32.29972687153207, False], [-101.91706806513982, 32.22042821274782, True],
            [-98.7507642387652, 28.373512157202324, True], [-98.67837171745543, 29.31049604748274, True],
            [-101.4835726546693, 35.24105797268996, True], [-99.61534262189332, 34.664146656697135, False],
            [-102.77162178290662, 31.477015077025758, True], [-98.14965646419336, 35.506326174334816, False],
            [-100.35687795352196, 36.428658182990375, True], [-93.75583478299006, 33.78374602526648, False],
            [-97.35272483145133, 36.14322026779398, False], [-104.13566843512568, 32.58780129504587, False],
            [-105.80951615950367, 30.548722565553994, False], [-106.36813961730384, 35.58713162312485, False],
            [-97.66809642868546, 34.13059807529114, False], [-97.61612010157164, 26.31880576825889, True],
            [-105.10689839575184, 27.13050661175676, False], [-94.42639614961973, 28.61525052001613, False],
            [-101.0258419742403, 29.912378788493154, True], [-100.85598848851129, 27.83703095635782, False],
            [-94.6443199603266, 29.977477497837175, True], [-101.16783935327581, 32.03976620169659, True],
            [-95.78686711235261, 34.37099939418539, False], [-100.59275869451973, 34.36381573902874, True],
            [-104.2707359051878, 33.43707298914277, False], [-102.69754715561436, 30.324718877958027, True],
            [-100.31772708579322, 36.03146883077079, True], [-93.84018528740714, 36.306249385961586, False],
            [-97.81378337323478, 25.848331371979896, False], [-104.37867619764027, 31.688609367477817, True],
            [-100.28100102840853, 36.18155424506788, True], [-106.48975872243628, 34.10471027956753, False],
            [-101.4453862294541, 28.535362387187064, False], [-100.05248503701085, 35.161646972337195, True],
            [-101.37197503092796, 27.85006417239032, False], [-95.00012601768513, 36.45104201985982, False],
            [-94.1618133883979, 34.189947778971074, False], [-100.9407537928131, 27.309175834366915, False],
            [-104.72991115996922, 27.3139116441178, False], [-98.59532436543168, 26.287325902961726, True],
            [-94.46884442680549, 35.68627263027676, False], [-105.31712494151611, 35.84472703216106, False],
            [-104.64932323670762, 28.699942778858926, False], [-100.34867007633471, 29.705706918470952, True],
            [-93.69561095836606, 32.456548936430266, False], [-98.12884276179193, 28.360889737226003, True],
            [-96.77862792020258, 28.586529000239178, True], [-106.1873382768634, 29.404306118606442, False],
            [-105.67789642420705, 31.716310454187514, True], [-96.00775542585319, 28.568996970414524, False],
            [-98.0904391114445, 33.41233020042991, True], [-93.82743788526335, 27.5659388943208, False],
            [-98.96755649758798, 31.32502880958104, True], [-96.55622361353764, 35.016203517682726, False],
            [-99.90454174449499, 34.88971778656889, False], [-93.92308221299953, 26.93602671682176, False],
            [-103.02775965216946, 27.526954568149137, False], [-101.70211609579965, 33.221705586015986, True],
            [-94.65140320779773, 30.12411725325112, True], [-105.48158850264392, 25.966083503119812, False],
            [-95.86092717890419, 30.257238607458746, True], [-94.78025397771191, 26.33573351642334, False],
            [-102.42306855603515, 31.528148123221925, True], [-101.11557151275859, 28.23290994001276, False],
            [-99.23764635246289, 34.03712892161272, True], [-97.18358117231713, 30.819652476530774, True],
            [-95.52114900196523, 33.71837984822948, True], [-94.80576475349369, 32.52595208303153, True],
            [-105.53353349524157, 33.10076381764996, False], [-104.45067861203503, 29.792014903132056, True],
            [-100.81552999585323, 31.13371713587459, True], [-98.10244603287715, 27.062939382372114, True],
            [-102.8183262272355, 31.63644201139868, True], [-105.48022791238954, 33.47054002907317, False],
            [-94.54700162806725, 33.3634517345777, True], [-103.52394717869927, 29.289585818953316, True],
            [-100.88024068589486, 28.00254322622369, False], [-105.13298501311634, 33.585842169513036, False],
            [-95.47745420853485, 34.33206192097545, False], [-93.75279262948008, 31.85387584406531, False],
            [-105.6408652118954, 33.38704981277846, False], [-102.68527628279271, 26.856854067490247, False],
            [-105.22798572254378, 34.52742324390015, False], [-94.25227485978478, 36.11993169557898, False],
            [-95.31071217313071, 30.450554401067357, True], [-104.32309381721137, 33.941981631972624, False],
            [-93.68344966428387, 28.25720980205315, False], [-103.11762381325748, 33.05126426779246, False],
            [-95.17637994183367, 36.37368703601287, False], [-101.09466869744112, 29.378868777118257, False],
            [-102.3244768566622, 29.25373813014635, False], [-105.6081974667763, 35.02231128438977, False],
            [-101.45129562213593, 27.250895271383474, False], [-97.77527080825567, 29.233601979476123, True],
            [-101.2708728240608, 30.929678610371226, True], [-101.17628088744974, 30.807932586287112, True],
            [-98.94314936681077, 28.962959058638244, True], [-97.5297094048325, 27.24629690610976, False],
            [-105.24649559460273, 31.68285402434288, True], [-95.38165074760121, 30.678277565962645, True],
            [-101.5405440205774, 35.75938014879534, True], [-106.30162345059492, 32.35717712927482, False],
            [-95.82698786035043, 31.471380696415473, True], [-97.58132229591222, 26.76823235412943, True],
            [-96.24754364311642, 29.148074667141763, True], [-101.60752835018079, 28.02378609076799, False],
            [-93.66280978876574, 34.36888263435238, False], [-97.04083533693894, 32.07693083540003, True],
            [-94.41534967058817, 34.30307828414252, False], [-94.51223027590078, 26.101565901379825, False],
            [-95.37877455769014, 32.91182889409107, True], [-97.02169748832533, 34.77231790184875, False],
            [-99.56938377454452, 27.98323188041011, True], [-104.71416427480177, 31.671590498127077, True],
            [-104.48037657157643, 28.020929009314624, False], [-101.46582277815409, 29.245030464171972, False],
            [-94.33289936897319, 29.433780707715577, False], [-102.65873114765344, 32.579375713461324, True],
            [-94.71197474752655, 29.919750259392565, True], [-100.56224887904757, 30.870441757396232, True],
            [-95.7680416447194, 33.381874464032556, True], [-101.30709319439809, 31.415698736346386, True],
            [-94.17706664281508, 30.20919168191223, True], [-105.1986310512293, 32.2767819705482, False],
            [-96.64520698321878, 32.53545316641808, True], [-101.27894696079863, 27.434282641130807, False],
            [-103.96823391756168, 36.206818702766164, False], [-102.61287825142863, 31.52883149992497, True],
            [-97.43688838995867, 35.35809331749178, False], [-106.3345282700814, 26.77898252396381, False],
            [-97.84563076948461, 28.326830633856254, True], [-97.10812201190659, 27.354066620755486, False],
            [-102.06625125192836, 31.959360067966703, True], [-94.77064907103171, 32.49772073548828, True],
            [-103.7070672713304, 26.993474458082765, False], [-104.63528508881744, 31.77175026283308, True],
            [-106.20330061641941, 28.71581603545491, False], [-102.93466353815762, 36.42712467119802, True],
            [-97.02548398973192, 26.47462461285108, False], [-97.92517027601997, 33.53006657932378, True],
            [-104.89676410831059, 32.03756980285575, False], [-95.02216317823846, 28.250092458391666, False],
            [-102.63731145928554, 30.78785522057966, True], [-101.9626891052094, 28.607495532359852, False],
            [-103.43019339494695, 33.757210152142996, False], [-95.52042729675107, 34.824713652167745, False],
            [-105.6806104213336, 28.64547500599634, False], [-105.01509606690256, 26.998326186544013, False],
            [-104.83729623744878, 28.111330049442206, False], [-99.30736722245813, 27.44271254179918, True],
            [-96.19450914007797, 26.5070841846474, False], [-96.93250711894682, 27.465441701127965, False],
            [-98.05769301004028, 33.34316222525198, True], [-101.70993094422322, 35.378824775340604, True],
            [-97.78065357281011, 30.791192214255453, True], [-103.85602296523946, 33.58813675270333, False],
            [-96.16754367241163, 27.82134326033623, False], [-93.84173858221502, 28.644678311847933, False],
            [-95.66361201153609, 33.1782437005781, True], [-96.18610593628335, 35.66871035791395, False],
            [-100.05778168598985, 34.34775700022905, True], [-105.3070646714683, 26.129506259811194, False],
            [-101.60474509803998, 28.301826427498735, False], [-94.05455083451157, 35.62737695624984, False],
            [-93.77022392951797, 33.35636018468855, False], [-99.9983492940202, 28.616796438006656, True],
            [-103.65327712041633, 35.68635542708576, False], [-94.18836108420525, 33.519234035329205, True],
            [-101.16524711825508, 35.21736886367663, True], [-106.63756507835402, 31.512711118486916, False],
            [-94.64418283641962, 32.24310968022579, True], [-98.48901518901792, 26.92275583383609, True],
            [-105.71495874564097, 30.37875836321371, False], [-103.59489508163908, 34.07565890645147, False],
            [-104.58617756264167, 34.7175307481461, False], [-94.94979738923941, 33.53027390298981, True],
            [-104.79237901545315, 33.643949242871386, False], [-103.6261849261433, 26.37203494674699, False],
            [-104.12072798260623, 34.037343854052246, False], [-99.3137876161763, 28.786746195806515, True],
            [-96.90701800480272, 26.83567175899895, False], [-105.91609848895729, 27.17006217234686, False],
            [-94.88867966602324, 29.0650764347025, False], [-99.09445254927051, 29.165294618392306, True],
            [-99.59646096585762, 31.547978010714818, True], [-100.35308616902222, 27.998071701955347, False],
            [-103.65741111414567, 29.929101550941933, True], [-95.56003645452608, 33.73354146467783, True],
            [-101.98380104745135, 27.741893994563817, False], [-100.28801029632858, 26.08376297941383, False],
            [-100.82876490121433, 27.203171781033483, False], [-99.00038368647441, 30.227734562748875, True],
            [-93.99273175213636, 33.172989756016705, False], [-103.28907886290975, 30.68354258877181, True],
            [-101.58265515547387, 34.05717966984305, True], [-93.61002560748278, 33.95079910028842, False],
            [-104.1322621794693, 31.037441969505064, True], [-94.90790561010023, 33.6667146192015, True],
            [-99.72772840949955, 28.57426803892259, True], [-96.76750823367423, 34.238866572662864, False],
            [-99.11285733031394, 29.297129143702183, True], [-95.34529541329582, 34.50122580606273, False],
            [-106.2015311076861, 33.04546069130247, False], [-106.6471763299225, 35.60222852490276, False],
            [-101.63138803719991, 27.93647861077147, False], [-99.67286004973847, 29.000600155646495, True],
            [-102.69661571801251, 30.438208192282016, True], [-96.47920563132686, 28.187453937378827, False],
            [-99.15701789001724, 28.754330049547363, True], [-103.63208677741055, 31.506299316322448, True],
            [-104.6247250325306, 34.777168030468545, False], [-94.50362320672285, 28.725533817363363, False],
            [-98.8088667387509, 29.719091220812984, True], [-104.66480293721597, 31.36766582422802, True],
            [-100.80243453385943, 29.56664951795082, True], [-104.3184052935018, 28.368505467940153, False],
            [-94.99687127078006, 29.056199158312214, False], [-99.18151980311957, 31.331306403933503, True],
            [-106.58306812961843, 33.83560030586354, False], [-102.34808248763466, 30.93213593104124, True],
            [-96.87905436496129, 31.63403473842953, True], [-101.88482545812973, 31.346536386676735, True],
            [-102.08612983365585, 33.94091937937585, True], [-97.59374438050571, 30.710749425390954, True],
            [-98.468759043241, 34.887864549188656, False], [-104.5600126294423, 30.769523820716284, True],
            [-105.63321064215583, 31.706723345643436, True], [-103.39803684928096, 31.205852663870417, True],
            [-103.74991694223343, 34.47243593420573, False], [-103.55735795090966, 29.368257266446264, True],
            [-100.53250901956653, 34.61994711930259, True], [-106.42290807028131, 29.47435749957574, False],
            [-100.61630496584333, 28.492897242114427, False], [-95.45897223676457, 34.99538998873486, False],
            [-100.80796423924814, 27.597779160448237, False], [-95.59903305812487, 33.53765968472729, True],
            [-102.71817656483864, 33.67774382239573, True], [-100.0519819831278, 31.720152603322795, True],
            [-101.86801670742807, 29.37988286278217, False], [-93.7251604108502, 33.63648932111699, False],
            [-93.50731366944763, 31.66131539976032, False], [-93.91408986252142, 31.91658143504109, False],
            [-99.1976965958281, 31.846542049263352, True], [-96.70181855090833, 27.823299476943752, False],
            [-99.05025751191671, 30.14722485144382, True], [-101.91786175888922, 33.662393020783334, True],
            [-97.18908214543966, 26.584467319788136, False], [-102.09768463635325, 27.745869776526586, False],
            [-105.03784779065376, 33.35089012727154, False], [-99.75443466868418, 32.340335779846406, True],
            [-102.53950776524619, 32.48219468369184, True], [-97.38249374177907, 31.70583501812896, True],
            [-100.23917371385507, 34.15552160975429, True], [-100.64584910978431, 33.08767497994276, True],
            [-95.54547414843782, 28.573393441826422, False], [-98.4400667166874, 29.169883280280335, True],
            [-101.85722555245049, 29.99952272227504, True], [-103.40127887731586, 35.954389606004995, False],
            [-106.49277204369605, 26.3739019521645, False], [-96.42482710450412, 25.935501811569573, False],
            [-96.49468755444158, 26.21429802291354, False], [-103.26280296149277, 36.42505933494076, False],
            [-103.23186132072851, 26.981602236536546, False], [-95.43868017247715, 26.795551518098133, False],
            [-104.95759598697946, 29.274620743768665, False], [-97.4627043038694, 31.264418590173566, True],
            [-99.40922174677335, 30.859355223178202, True], [-97.62450333069754, 31.860943195654983, True],
            [-103.28423668185653, 31.64625933078107, True], [-97.34347509751296, 32.39948448790623, True],
            [-104.78394662628456, 32.19069943780818, False], [-94.27543944274844, 28.45111869438522, False],
            [-105.41902431151755, 34.098705479256964, False], [-105.84856227788723, 34.401910854922086, False],
            [-105.76944559045042, 27.541157331410925, False], [-105.96625908843005, 34.60984823477864, False],
            [-100.45522585613661, 35.82958048104291, True], [-95.8227101752813, 26.40044772412707, False],
            [-98.14190854947867, 28.173726785556475, True], [-103.41079917326785, 33.17358912330205, False],
            [-106.21380947469507, 30.673049362200253, False], [-98.6181240681384, 31.57826052940466, True],
            [-105.52347449914703, 28.45331024338554, False], [-105.87199783454764, 29.269133017660426, False],
            [-95.72117392272776, 32.84521613150032, True], [-103.98103037156038, 29.39830154631861, True],
            [-98.84272856308685, 27.010603508995832, True], [-103.48528511610583, 32.292795962096, False],
            [-101.10764837358862, 34.44067771878632, True], [-99.90899218640438, 33.864602563342665, True],
            [-99.99425094006477, 29.632299612876448, True], [-104.19954114103936, 29.481293826903272, True],
            [-99.1617923467798, 27.24969812956527, True], [-93.94985771467012, 33.20509824852493, False],
            [-98.74589172711391, 26.59828162369087, True], [-100.74104498226976, 28.090884473461635, False],
            [-102.0941642949128, 29.40228872741179, False], [-103.71745434686355, 36.07717165565938, False],
            [-103.85504023598908, 35.797619278303934, False], [-98.3178181998277, 31.80247171895742, True],
            [-100.46831716774525, 26.395663970107364, False], [-96.6262432609301, 33.43258969257319, True],
            [-102.12872561318167, 30.9414684197057, True], [-96.10044267209415, 31.617205739677686, True],
            [-102.76040876099727, 30.02029055974793, True], [-100.28567173102832, 33.71564104661008, True],
            [-101.87455244042499, 35.45783748840937, True], [-103.80647075850555, 33.75958813400894, False],
            [-104.07465598182498, 29.829473718048853, True], [-96.80679641483542, 34.068109206459674, False],
            [-100.21922411687524, 35.55827610846517, True], [-102.18536576459445, 35.60838848797885, True],
            [-100.74818339320018, 32.46468922651053, True], [-98.89381745119253, 29.84927086885224, True],
            [-95.57772284816139, 34.03118772897132, False], [-102.19208387081574, 35.47422893590955, True],
            [-99.31176771742929, 28.159649775138398, True], [-95.08438010592444, 30.864384073337725, True],
            [-105.62858370011037, 36.04041710371988, False], [-99.50704661690466, 26.530069415053166, False],
            [-102.21328017280045, 28.123746616410187, False], [-93.82909083931759, 31.8346812474552, False],
            [-99.68311577900606, 33.37514101639904, True], [-93.88914553766337, 34.40543275268286, False],
            [-95.49031947037534, 36.15787562082431, False], [-94.04958126924683, 25.895718131012476, False],
            [-102.31183630727872, 26.195612345971853, False], [-99.74217764726765, 34.4866834996357, False],
            [-101.2273998455989, 31.012399597950438, True], [-93.7170401640232, 26.52296130239048, False],
            [-106.31856530763194, 30.254195818383003, False], [-93.54539750125572, 31.968279205890525, False],
            [-102.06176434040876, 35.96267638467066, True], [-102.21150807644786, 31.276020170678756, True],
            [-97.59134352614593, 27.758428418449625, True], [-105.6285777230377, 36.20035827010385, False],
            [-99.56855691529327, 27.565199944571845, False], [-93.95512959128524, 35.50257083074824, False],
            [-104.2068757288861, 25.983428900973824, False], [-104.1534590142076, 29.90389615149271, True],
            [-104.75891565225955, 26.17708478969608, False], [-96.34136547606607, 26.58259616840622, False],
            [-94.35505605596222, 31.363945882683545, True], [-100.75357998539742, 27.70797766258346, False],
            [-96.34206621365894, 29.195743358202087, True], [-96.44632535331706, 33.578167176287465, True],
            [-100.52062683482386, 28.935836235311534, True], [-103.59488192282778, 31.145329272683313, True],
            [-96.21513910038252, 26.71734433601959, False], [-97.74524155506616, 35.72544238150706, False],
            [-98.15072688652688, 29.65447185320712, True], [-102.94259657821668, 28.995860793431966, False],
            [-98.37049290964605, 28.992239589640803, True], [-101.9333665893231, 32.042668019418784, True],
            [-100.31205895270178, 28.542423199402116, True], [-102.7842119789965, 31.351234994650703, True],
            [-102.82118189131612, 25.936779514285522, False], [-105.06566909806352, 34.429600751175066, False],
            [-103.95414080936615, 30.5173184712075, True], [-96.41063716230997, 35.68425390782344, False],
            [-94.82668338005425, 34.10595925830741, False], [-105.42861829324059, 26.89985572905742, False],
            [-94.86003017402527, 32.72190652290611, True], [-96.69442705925057, 29.12593879172168, True],
            [-100.57898366779487, 35.697109012290476, True], [-105.77290660716999, 34.23468690232633, False],
            [-104.3849259560512, 31.337110429238777, True], [-95.21459964105358, 33.00732978946704, True],
            [-95.7332150421658, 27.704415504038284, False], [-104.50875122680036, 34.91526292458323, False],
            [-102.80833873160228, 31.875937580897503, True], [-104.53224880900562, 25.940603993388773, False],
            [-99.6884270626213, 31.04708806366109, True], [-95.76317485487704, 35.45517519387816, False],
            [-101.84342021439619, 35.834756908559946, True], [-104.04702349088515, 26.09752753366655, False],
            [-103.48123590122003, 34.55695985365465, False], [-101.90736610359222, 26.198871101374856, False],
            [-95.80852972334627, 26.4884711642595, False], [-106.49602165329638, 31.587480730479957, False],
            [-99.11540612418378, 28.76377389466793, True], [-98.81124442220992, 27.408954979897345, True],
            [-103.54081324519612, 28.238918914656047, False], [-102.8589030540497, 33.69752159861657, True],
            [-100.38962812985066, 36.259455441754405, True], [-100.60205967959344, 27.45237069505359, False],
            [-104.82116135978534, 33.90726029831255, False], [-95.25951953419671, 36.427532407586796, False],
            [-93.75127522006922, 31.774003703956872, False], [-106.50710079332187, 32.31418914724039, False],
            [-95.38754195058371, 27.686986329488576, False], [-103.48158704856718, 28.05982044881246, False],
            [-94.40123367677305, 32.13802908979801, True], [-98.37091796124368, 31.394805069115378, True],
            [-99.35199253682242, 29.364231843209286, True], [-100.6371809469257, 29.485414607179138, True],
            [-101.65847488152119, 33.055932161413, True], [-104.75073650330286, 35.477180164221664, False],
            [-100.70424003073441, 33.33233065367354, True], [-104.9829081950403, 33.49495185425366, False],
            [-96.28014091653374, 30.765109918972172, True], [-102.51312299795521, 34.973490202758846, True],
            [-106.4316820557197, 28.835022330467574, False], [-98.37035640871174, 29.15982666730043, True],
            [-103.81743393736278, 33.33070497195332, False], [-102.38044273457957, 27.128328755756332, False],
            [-105.83310224715474, 32.69799499508526, False], [-104.47875333696165, 33.08218160363957, False],
            [-105.08315111607386, 27.5499535808647, False], [-102.50315445382816, 32.952707100728176, True],
            [-106.34702977388169, 28.350530651265025, False], [-100.7324706006535, 28.110070428450136, False],
            [-98.89057718530617, 30.501635222091867, True], [-93.7973707158511, 30.332449685439883, True],
            [-100.50817745675471, 35.933620707046416, True], [-93.62331898394628, 28.011415151343442, False],
            [-102.40168198643366, 28.038346452109714, False], [-98.76386270364078, 32.824244011949546, True],
            [-98.63890075873523, 28.426721830307706, True], [-103.06753906192446, 27.182546407018886, False],
            [-103.5149916483893, 32.22702185824897, False], [-96.92704846269056, 33.56573720072518, True],
            [-98.59191146293448, 26.717454841499933, True], [-98.21728189059557, 30.499991381612325, True],
            [-98.96569953382873, 34.09349857812645, True], [-98.81645597171263, 31.538513035336027, True],
            [-103.99810746775411, 34.572232011339544, False], [-97.1971994402299, 33.01231694977086, True],
            [-97.35525400352937, 27.593348250877636, True], [-95.61047936363322, 32.915418129253844, True],
            [-105.77325410471146, 32.220934743164854, False], [-100.31130282858123, 31.053207323928227, True],
            [-94.27435346222804, 29.717111545751255, True], [-99.36518149272568, 29.81842676057489, True],
            [-102.4595465810425, 29.78052913717334, True], [-104.93563833675945, 36.1553390615043, False],
            [-96.67331825738593, 33.795256849340824, True], [-104.13912762449462, 28.90285335911741, False],
            [-99.85650514030851, 27.082576996579743, False], [-95.46433062216431, 26.31189218916502, False],
            [-100.84562917395462, 26.46339943905897, False], [-94.75077980314441, 30.746795428982928, True],
            [-98.38741630868877, 32.8939361913369, True], [-101.50339387491944, 33.409893596597634, True],
            [-102.8838322429055, 33.550509813464714, True], [-94.4241089162888, 29.987534160102904, True],
            [-96.97724045199526, 29.413237018802626, True], [-103.26463086689401, 35.69959960363469, False],
            [-104.22583858596425, 35.32625561149897, False], [-102.28802601849752, 35.31386927276366, True],
            [-101.0349738411682, 25.896953488838804, False], [-103.9839821999459, 33.2679016367904, False],
            [-105.01149642855964, 34.24130005689306, False], [-104.86876474825357, 35.97880497285345, False],
            [-98.95300311760788, 28.23951953232239, True], [-106.44607553528402, 28.99701327445984, False],
            [-97.15665622011281, 33.802655749490576, False], [-104.88728768211863, 26.19423408399297, False],
            [-98.2868092522052, 26.77958013643795, True], [-96.30475465159665, 25.886256031524383, False],
            [-93.96185258306615, 30.262131379160092, True], [-95.98431071502645, 34.074476976239524, False],
            [-99.34592870499611, 31.77796555029789, True], [-101.23448890900838, 35.02325060675137, True],
            [-96.60311950987519, 26.520767851753252, False], [-103.30098695011493, 33.95932432365544, False],
            [-97.20833874248723, 30.443771327358455, True], [-100.49276808544384, 30.563391121718663, True],
            [-106.00844672588474, 27.67304591354748, False], [-94.68045487444002, 28.380941225789602, False],
            [-106.32581808918103, 27.457360510530357, False], [-103.90944733413775, 33.75181119086094, False],
            [-96.62055409685594, 30.911602145241257, True], [-105.08332076154659, 35.84175548182445, False],
            [-106.46727840740928, 30.97311215593337, False], [-98.24608713290009, 26.87548489704331, True],
            [-99.99394976092111, 35.372523026676305, False], [-101.04275569324, 26.378571750355146, False],
            [-99.49808015597847, 29.0197284725707, True], [-100.04278394100143, 31.138487871928806, True],
            [-93.77580092670675, 28.679720562816012, False], [-105.69434962210484, 35.48380415396366, False],
            [-94.76833576200043, 34.77440737306939, False], [-93.55059692835445, 32.93611160385383, False],
            [-96.16637525156335, 35.14861120144762, False], [-102.57674991354982, 33.57167753159161, True],
            [-104.50984249707894, 27.845184825434426, False], [-102.46681259074438, 32.876290517890325, True],
            [-103.79635335230255, 34.68136206176115, False], [-97.37101719424614, 34.331617955613964, False],
            [-93.78338486646257, 29.1736195506313, False], [-98.653709287249, 30.255774672109183, True],
            [-104.78162076886001, 36.14023266162845, False], [-95.30745598333526, 26.15568755210897, False],
            [-96.19795914229807, 29.783289215723965, True], [-93.97200790057319, 30.34872478231179, True],
            [-102.75807129557354, 32.02568271699399, True], [-95.63613363239972, 30.17575679938203, True],
            [-95.74058254060239, 27.830132693387228, False], [-97.28993038017775, 33.34058580949793, True],
            [-94.782421253055, 26.37055251439716, False], [-99.01579664350437, 33.29078588254949, True],
            [-97.2079339911563, 27.123479789817104, False], [-96.66399830213123, 35.57917944458788, False],
            [-104.00378871415248, 33.03909098032557, False], [-98.18333736354995, 33.40304952690905, True],
            [-99.51409889042824, 28.352125049514296, True], [-96.39878389524632, 33.80913094147424, False],
            [-97.95457727578372, 31.304986453423908, True], [-105.41519123044006, 31.17900852073914, True],
            [-102.55823249490591, 28.227952215383333, False], [-105.22740902391834, 28.00912246742774, False],
            [-105.4327613051658, 30.42094293937215, False], [-99.8642636892311, 34.741799628413524, False],
            [-104.07069003771045, 30.561044257056018, True], [-105.71580939231154, 34.73255277750661, False],
            [-98.92331393934845, 34.757305489096225, False], [-95.1451471669803, 35.59262098012566, False],
            [-100.78929431916742, 35.83001258653612, True], [-106.15538551006625, 33.88884085609275, False],
            [-97.78557980515986, 33.9896913074551, False], [-94.43404183378551, 31.976310799398128, True],
            [-102.77500581970122, 30.636815025506447, True], [-105.67967176568628, 33.47402254839546, False],
            [-98.79160014376332, 32.79018812677753, True], [-102.84347322545034, 28.136203054123584, False],
            [-95.24784148052099, 34.22424254638486, False], [-106.31929728808254, 30.9825641984661, False],
            [-102.43296109133702, 32.532070674152855, True], [-105.92145087338875, 30.381356965114943, False],
            [-106.45282535347631, 35.54158851537021, False], [-95.04777932048988, 35.82906359730707, False],
            [-97.42369763037011, 34.37608618524585, False], [-104.57070459903527, 33.70875609054547, False],
            [-97.41632281711793, 32.92982657064401, True], [-94.66570627408036, 27.27007338775074, False],
            [-99.1743643002243, 27.247623481915483, True], [-104.68950862955154, 29.870865904293723, False],
            [-98.10816880312582, 28.162238589797898, True], [-93.64216163895259, 26.298614364258444, False],
            [-95.19102534541413, 33.389356010635154, True], [-96.62070599059086, 30.74805978317854, True],
            [-99.3386516464026, 27.906200841991534, True], [-100.8007152801228, 32.84683422029997, True],
            [-106.20302284683326, 32.380361469176044, False], [-94.23655356205708, 26.324497474351357, False],
            [-99.65954455695915, 35.474000933282724, False], [-94.31553240129878, 35.66875101369414, False],
            [-101.83519143957733, 25.873081120803842, False], [-99.97028199969046, 34.58909164776538, False],
            [-105.71652597027627, 31.489327979058995, True], [-105.79973754647258, 28.65472050301513, False],
            [-104.61884498465494, 31.131621852439807, True], [-102.57111696065307, 30.114279991888235, True],
            [-103.32297212967914, 35.236882653404706, False], [-100.4249645463674, 35.01412558025736, True],
            [-96.2664164425719, 27.27790820412447, False], [-95.49119347312927, 34.04880310368103, False],
            [-94.76867790780145, 30.68409383373247, True], [-97.33084948761977, 35.987707032142886, False],
            [-98.9375962329848, 27.590161796852268, True], [-100.24496746645461, 35.14003067100538, True],
            [-97.82265827697529, 29.12546410605067, True], [-103.60831990499707, 34.420657352069206, False],
            [-96.6211125945082, 33.06459177171514, True], [-99.74211708967393, 29.148959136838407, True],
            [-101.74939764896713, 34.474532089579476, True], [-94.34764438114355, 30.357142981363083, True],
            [-106.52546379307893, 30.041326961454715, False], [-101.2986640335862, 26.37652905898862, False],
            [-106.4580153687541, 29.87759744762145, False], [-100.89335102135293, 35.52499965140305, True],
            [-100.8248639994296, 33.40975770839312, True], [-103.93212196016398, 32.909497641552065, False],
            [-94.67932056126476, 35.15626837470808, False], [-106.02052521025293, 29.597198775376654, False],
            [-98.2893867410877, 29.93112729119841, True], [-99.89450058695091, 27.938220198829537, True],
            [-97.3506130624274, 29.943100560338415, True], [-102.20272670412375, 26.935152987528188, False],
            [-102.76414059461521, 27.054007916590372, False], [-106.0041901594681, 34.50108734620676, False],
            [-99.34960356247895, 30.765691636568544, True], [-93.90991359101918, 29.52415548605938, False],
            [-102.45068333144832, 29.498640082146757, False], [-93.52649708202873, 33.25384150278302, False],
            [-98.11359820029512, 32.661143218490004, True], [-93.64776248509527, 30.4684682460894, False],
            [-99.4498229748733, 27.335197692456124, True], [-106.3098030711422, 28.114811474983753, False],
            [-103.19744279212784, 29.761699794107464, True], [-98.04521749365168, 29.23374276253473, True],
            [-96.02905435107336, 30.127228292010795, True], [-98.51879935475141, 29.632065468973558, True],
            [-97.51304854653931, 31.509276424390762, True], [-103.29390200939619, 27.318075011416106, False],
            [-99.9824973213597, 30.110443559920434, True], [-99.50915156948314, 29.258458344281003, True],
            [-96.41505277249307, 27.81615410871556, False], [-104.15751695040154, 28.634566430199957, False],
            [-99.54546678775662, 30.628758593109584, True], [-94.501671157283, 26.690164729805314, False],
            [-99.5998715300248, 29.29963433926709, True], [-96.19407966991072, 26.583996951962845, False],
            [-94.18130561957514, 34.39183349747304, False], [-99.35457098320595, 29.19418372510661, True],
            [-103.2439668700228, 28.7415827836878, False], [-95.94946899471344, 26.094846437871187, False],
            [-96.29555855830898, 35.61463847091715, False], [-100.90818350967113, 32.81839948197739, True],
            [-103.19547298017221, 33.780381119513564, False], [-103.7311831715452, 34.51901410810771, False],
            [-104.9802204382533, 27.04133234378543, False], [-97.04516124978682, 26.74522583795225, False],
            [-99.54055674299795, 30.957712411033505, True], [-100.75291255499768, 34.98555626576464, True],
            [-103.08923082250261, 33.115219018353876, False], [-94.38102432053655, 33.1179055259896, True],
            [-102.03982643927137, 29.9838170230828, True], [-105.81904014957023, 28.79765172366808, False],
            [-96.65811064697854, 29.033441999230575, True], [-94.79391199397416, 32.26686772352405, True],
            [-94.05970729814709, 27.578098867203245, False], [-101.34732336260434, 31.621990539913554, True],
            [-104.3518957862908, 29.119881150805877, False], [-94.62935978446168, 30.4280012647268, True],
            [-94.4545353979626, 35.54695331314244, False], [-95.54556621919373, 36.13412073236616, False],
            [-95.35828131810126, 29.196029446685102, True], [-94.03367199299583, 29.998249298603696, True],
            [-106.36092437901962, 35.88480338683122, False], [-104.36739535175568, 34.44871919970392, False],
            [-101.23847775114616, 33.38670941589996, True], [-99.14984412490651, 33.42882053133658, True],
            [-103.57375420847947, 36.10822666498764, False], [-105.16720721276594, 35.376479016301516, False],
            [-97.83947903342955, 27.52109204805256, True], [-98.71405542652877, 35.7689674767476, False],
            [-103.06998061485356, 34.82880997682268, False], [-105.28204362921868, 28.400435333576176, False],
            [-94.15911792478674, 26.17595690168265, False], [-96.8089922559183, 28.576299745236, True],
            [-94.55012730211439, 35.965323310709934, False], [-102.35052435497836, 35.54979117991739, True],
            [-104.37005549234762, 27.1898216329847, False], [-95.68880266269171, 28.848538713723595, True],
            [-99.48796021732129, 33.879870610429656, True], [-101.00413095653694, 34.33763822793282, True],
            [-106.07730385091368, 29.134515491377414, False], [-103.45299952582074, 27.571405818685125, False],
            [-102.68769661036903, 35.0508397444369, True], [-102.12226125487027, 31.490531154286373, True],
            [-99.20157845594305, 31.551754104915446, True], [-102.55860273418811, 34.074770794654526, True],
            [-106.13595097934105, 30.66643783693412, False], [-106.62769073938416, 30.65343353159766, False],
            [-106.40940133512453, 29.82237466871204, False], [-102.1529566504516, 35.06622589749327, True],
            [-102.80724491463563, 34.7087445437067, True], [-97.64939497688633, 30.67928132241753, True],
            [-96.36801227272899, 27.90369756441311, False], [-94.09540454906752, 26.5340311979023, False],
            [-100.95868651879503, 29.489244579528528, True], [-99.00791521500773, 33.15713091296997, True],
            [-94.56949551831565, 29.097678237118387, False], [-104.30210679432342, 27.480997154392185, False],
            [-102.89216000521263, 28.618705789328487, False], [-96.97440058322412, 33.50865616454956, True],
            [-98.99276448264528, 33.16482908208919, True], [-104.83376414397748, 30.866597558655094, True],
            [-105.87523535009888, 26.94560046391572, False], [-99.29766049432588, 32.83368387034709, True],
            [-102.51690788569256, 33.11843291048262, True], [-95.8185042576338, 29.933635250495907, True],
            [-95.64639798097132, 29.81408328213472, True], [-95.27363238555648, 26.04686490238641, False],
            [-97.49469880046678, 28.7839351111114, True], [-102.55955572766781, 32.24579142286663, True],
            [-102.3259956134002, 29.68040823171017, False], [-97.73863157435005, 29.996562088019196, True],
            [-104.68631893564948, 32.01946765618769, False], [-95.04016163980175, 33.10637289096444, True],
            [-104.60749147021224, 34.68835575652551, False], [-103.65636297920052, 30.591031777106217, True],
            [-102.77020591146633, 28.84679685398533, False], [-93.68494562344958, 30.545382533660963, False],
            [-105.28442207266875, 35.066432824429576, False], [-96.25390521489425, 26.494829177985668, False],
            [-98.82250217338702, 27.932953025264148, True], [-101.74188578040746, 34.64776869635973, True],
            [-106.04404882060925, 28.594522513035013, False], [-93.67216964673989, 29.251042306696004, False],
            [-99.78759245690895, 33.06425606417031, True], [-98.40506092257863, 30.372595091544586, True],
            [-102.29051625332913, 32.71012257838102, True], [-103.71880332727147, 32.69104459346947, False],
            [-97.0545647773379, 30.76611952136734, True], [-96.38483633115239, 27.604532811233028, False],
            [-106.26518681815887, 30.011599887072457, False], [-96.29869292442771, 28.668280098851437, False],
            [-101.81643591481892, 26.171067127237418, False], [-99.84342847150265, 26.017698064471553, False],
            [-104.11331752582073, 29.654316762816297, True], [-99.97301004853021, 27.730105527140825, False],
            [-106.31647836713242, 32.17703231405249, False], [-105.53511133815337, 26.702440097120153, False],
            [-96.73532103327318, 35.78642691945332, False], [-99.1113903696459, 34.40215160301135, False],
            [-105.57490309093876, 36.00074957169259, False], [-96.91408056656418, 32.50309840505817, True],
            [-97.12004011524724, 26.947775539446376, False], [-104.31177621433217, 28.977811712282257, False],
            [-94.2821165561003, 30.71331882514141, True], [-98.29146997158631, 26.800066299911094, True],
            [-103.116290122766, 31.46742167424961, True], [-98.56811800705276, 29.888220960970425, True],
            [-98.08987891135445, 27.80577602559695, True], [-95.34430060625397, 35.0872381937164, False],
            [-97.29977470332764, 28.838558342329026, True], [-99.29340339460651, 32.1659999533891, True],
            [-98.45946176172794, 35.06767544568288, False], [-97.28077383253662, 30.77329811793486, True],
            [-103.2046478070315, 33.95113909648831, False], [-97.41533999785908, 32.08647437970406, True],
            [-106.24449926545937, 26.923081786350345, False], [-97.29470564456045, 36.18937223503928, False],
            [-97.66122972103732, 34.56870670469234, False], [-102.35020419742744, 27.349690061784784, False],
            [-93.77154189004054, 33.43617694637923, False], [-101.35103101345337, 29.463692272605073, False],
            [-101.62926979404627, 32.803732493055875, True], [-94.90780742661717, 27.023519182303016, False],
            [-106.20392742378257, 32.97382450322062, False], [-100.31113315995306, 29.431049347619815, True],
            [-101.26240055732195, 36.148817757576396, True], [-98.42727511780691, 27.460837740553018, True],
            [-98.57534771820664, 35.599414672044254, False], [-97.62020154014516, 26.369709082738453, True],
            [-103.2986841163323, 32.6157912851791, False], [-93.93578337162835, 34.486048529590185, False],
            [-93.64615854059947, 28.5736836659404, False], [-96.99391123102941, 28.896993703684423, True],
            [-102.45723986918175, 35.7010832684699, True], [-105.25314374574465, 26.38581255615052, False],
            [-100.2188547460063, 28.291673320576088, True], [-100.7877537462725, 34.49341196472571, True],
            [-106.45021897380575, 26.72924721086809, False], [-105.02103129126913, 30.757125052138996, True],
            [-98.53860937298697, 32.45578723025558, True], [-99.57879415297293, 33.96386507864504, True],
            [-93.7378357236408, 27.9626758279968, False], [-100.63489750669079, 35.38304941928768, True],
            [-106.59421404071085, 30.052955341162452, False], [-106.59172119923385, 35.689363691993364, False],
            [-97.34149801358657, 32.67880291850629, True], [-94.73963101360403, 27.850819649646564, False],
            [-100.94403277172583, 33.474538412919046, True], [-99.27226009251935, 27.468315184289615, True],
            [-100.4539129843546, 34.591160165118865, True], [-106.44494557869739, 28.035999053683224, False],
            [-94.23984184184754, 29.557288201626776, False], [-99.03587934877508, 26.59598428059316, True],
            [-99.74353348891233, 32.82386415542986, True], [-101.86634664448142, 35.898545381710065, True],
            [-104.82904170889573, 35.68593461490256, False], [-102.883660082079, 25.927764876566876, False],
            [-95.10167954830852, 29.132555432953012, False], [-104.16716765381528, 32.54432440506069, False],
            [-95.8001698490917, 30.554039020076594, True], [-98.25774265085879, 30.67468293710671, True],
            [-104.14549182637904, 36.13448211420454, False], [-100.79273106998009, 27.687205570475957, False],
            [-97.9031540972447, 34.04156602854073, False], [-99.48655188258273, 36.01928708820145, False],
            [-103.78885086741725, 26.649573815350735, False], [-97.54897028080592, 26.611495630090587, True],
            [-106.18533271033974, 26.521041809084632, False], [-102.04736124316179, 35.80143440960038, True],
            [-103.53014416761859, 35.94251011771925, False], [-106.37072741181773, 33.56020830971726, False],
            [-100.5087744739241, 33.68691572355519, True], [-103.14684873740707, 30.33159482347187, True],
            [-101.04498614381122, 34.01935100090506, True], [-99.23406810345234, 36.47780260248638, False],
            [-96.38309061733807, 28.10204238295031, False], [-106.04814322602003, 30.009165824440764, False],
            [-99.09937261770088, 36.27541704541078, False], [-94.9236280439113, 26.908216725432283, False],
            [-96.03138446605873, 29.48956628516225, True], [-101.79748242792357, 36.2396677016486, True],
            [-96.7954152001291, 28.981691254375008, True], [-95.95383982488345, 33.80047001504878, True],
            [-103.89568070095685, 26.027352965725004, False], [-104.33069038138268, 36.46092136221017, False],
            [-99.40487331382435, 33.362496703874385, True], [-98.0390467871466, 27.286158481267943, True],
            [-103.93051493329094, 36.21025032666974, False], [-100.89036166271175, 29.431712359982495, True],
            [-103.01093811284001, 28.951789475547162, False], [-105.6925789844033, 26.67611273491844, False],
            [-100.63232815476351, 35.18180560295863, True], [-95.84068243438212, 26.566440681951057, False],
            [-101.69166851142406, 27.58570691504354, False], [-96.39192036000713, 30.76580153991847, True],
            [-99.60575587904657, 32.844854917935244, True], [-99.88359268023875, 26.427305650516256, False],
            [-102.49870407406512, 35.670387195714135, True], [-99.02838249064023, 34.35433748751913, False],
            [-93.69511330973809, 28.964334494491123, False], [-102.77438414412866, 34.77587690396507, True],
            [-97.20637129262126, 28.62351031644859, True], [-97.20760493091282, 29.66509727888832, True],
            [-97.78279263302204, 28.650053248724216, True], [-105.10373645902229, 30.10605688088612, False],
            [-102.29320671455936, 34.913227698065626, True], [-102.08456452797166, 35.04888378920539, True],
            [-97.684013792577, 35.91610190976283, False], [-94.66766997135741, 28.388037123223707, False],
            [-93.51699445904997, 30.745955788402362, False], [-100.56415276925733, 27.122598143422042, False],
            [-105.51909002313077, 30.081775705006855, False], [-95.57290373716107, 26.724672719886662, False],
            [-103.50352867348445, 32.004206585428776, True], [-102.8747549124684, 32.8979077719816, True],
            [-94.54178731632837, 28.121556170094824, False], [-105.1852492618114, 34.57852818651511, False],
            [-101.56833897599279, 32.394936636984475, True], [-102.06612007055514, 30.0654558718264, True],
            [-104.27037065814437, 26.539037110206124, False], [-96.84449118726283, 34.303252013399494, False],
            [-100.21448448808589, 31.640102623719255, True], [-105.11541407363484, 32.59032999242083, False],
            [-102.47865996013053, 36.106193753181586, True], [-102.1982854302976, 30.87389402879236, True],
            [-103.75935920410515, 34.164405398206384, False], [-100.26058874460439, 29.97152621245525, True],
            [-99.98584687760041, 29.138422331875738, True], [-98.8136163575852, 31.471193466135066, True],
            [-98.2634703260477, 34.441857423457066, False], [-101.31389165577758, 26.67722696068761, False],
            [-105.25939274478021, 33.42397682936403, False], [-95.42401575533701, 36.38213160460099, False],
            [-93.7911156924766, 26.16919479726154, False], [-106.0793837632488, 32.0426040667038, False],
            [-101.67576371230456, 26.55813999428948, False], [-105.29328020590933, 33.317961711071874, False],
            [-106.6282733323151, 26.640651252579072, False], [-100.97693002993205, 29.778473204159543, True],
            [-99.81270323613123, 28.521657399940562, True], [-106.35993676923691, 32.47765856951956, False],
            [-98.6318807925877, 27.313103487591995, True], [-105.60269402006043, 33.9266565877851, False],
            [-96.50522425362368, 33.17862810486471, True], [-99.36585657273703, 27.918462376378407, True],
            [-102.71165541572611, 27.26977019467567, False], [-105.26203795210641, 33.50921690053216, False],
            [-105.45340320249285, 28.841949098625847, False], [-97.67986158008269, 31.45298937828147, True],
            [-95.42927279657806, 30.012853799790946, True], [-94.61186352922475, 30.990817003676423, True],
            [-98.75882027588506, 33.21933322666259, True], [-104.55525321655045, 36.35184775125859, False],
            [-97.39087680042095, 29.262712771446328, True], [-95.32479451597851, 32.558534263953774, True],
            [-96.17652314621081, 34.39156129414083, False], [-99.95318514227759, 29.206707699022903, True],
            [-105.32756527254323, 29.177591819396113, False], [-104.63110828519505, 35.14036164405956, False],
            [-101.75109732251778, 30.720543376919306, True], [-98.43013838260205, 28.14394272715192, True],
            [-97.0734335255207, 28.750007474412804, True], [-103.21154248047685, 32.22703974346086, False],
            [-102.39810543632244, 32.819942719538474, True], [-103.36259451330584, 27.176657526494928, False],
            [-103.66650593230085, 36.025520559005244, False], [-101.63539174258722, 27.803279475131447, False],
            [-96.34811589893562, 31.14578417358513, True], [-98.94976448687677, 31.767797366700666, True],
            [-97.38029827656692, 36.27728736453143, False], [-95.93103949592769, 28.74450380455483, True],
            [-98.8151117128684, 34.70259233670797, False], [-96.14623746963383, 30.48841309287015, True],
            [-101.46340647601903, 30.19511307273737, True], [-100.63602533061145, 31.749219881531914, True],
            [-101.63505098125265, 33.69021849156649, True], [-94.71406829659445, 31.90061330594235, True]
        ]
        for p in points:
            assert p[2] == qtssr_texas.contains_point((p[0], p[1]))
