'''OpenGL extension VERSION.GL_2_0

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_2_0 to provide a more 
Python-friendly API
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.VERSION.GL_2_0 import *
### END AUTOGENERATED SECTION
import OpenGL
from OpenGL.raw.GL.ARB.shader_objects import GL_OBJECT_COMPILE_STATUS_ARB as GL_OBJECT_COMPILE_STATUS
from OpenGL.raw.GL.ARB.shader_objects import GL_OBJECT_LINK_STATUS_ARB as GL_OBJECT_LINK_STATUS
from OpenGL.GL.ARB.shader_objects import glGetInfoLogARB as glGetInfoLog

from OpenGL import converters, error
GL_INFO_LOG_LENGTH = constant.Constant( 'GL_INFO_LOG_LENGTH', 0x8B84 )

glShaderSource = platform.createBaseFunction( 
	'glShaderSource', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLhandle, constants.GLsizei, ctypes.POINTER(ctypes.c_char_p), arrays.GLintArray,),
	doc = 'glShaderSource( GLhandle(shaderObj), str( string) ) -> None',
	argNames = ('shaderObj', 'count', 'string', 'length',),
)
conv = converters.StringLengths( name='string' )
glShaderSource = wrapper.wrapper(
	glShaderSource
).setPyConverter(
	'count' # number of strings
).setPyConverter( 
	'length' # lengths of strings
).setPyConverter(
	'string', conv.stringArray
).setCResolver(
	'string', conv.stringArrayForC,
).setCConverter(
	'length', conv,
).setCConverter(
	'count', conv.totalCount,
)
del conv

for size in (1,2,3,4):
	for format,arrayType in (
		('f',arrays.GLfloatArray),
		('i',arrays.GLintArray),
	):
		name = 'glUniform%(size)s%(format)sv'%globals()
		globals()[name] = arrays.setInputArraySizeType(
			globals()[name],
			size,
			arrayType, 
			'value',
		)
		del format, arrayType
	del size

def _afterCheck( key ):
	"""Generate an error-checking function for compilation operations"""
	if key == GL_OBJECT_COMPILE_STATUS:
		getter = glGetShaderiv
	else:
		getter = glGetProgramiv
	def GLSLCheckError( 
		result,
		baseOperation=None,
		cArguments=None,
		*args
	):
		result = error.glCheckError( result, baseOperation, cArguments, *args )
		status = ctypes.c_int()
		getter( cArguments[0], key, ctypes.byref(status))
		status = status.value


		if not status:
			raise error.GLError( 
				result = result,
				baseOperation = baseOperation,
				cArguments = cArguments,
				description= glGetInfoLog( cArguments[0] )
			)
		return result
	return GLSLCheckError

if OpenGL.ERROR_CHECKING:
	glCompileShader.errcheck = _afterCheck( GL_OBJECT_COMPILE_STATUS )
if OpenGL.ERROR_CHECKING:
	glLinkProgram.errcheck = _afterCheck( GL_OBJECT_LINK_STATUS )
## Not sure why, but these give invalid operation :(
##if glValidateProgram and OpenGL.ERROR_CHECKING:
##	glValidateProgram.errcheck = _afterCheck( GL_OBJECT_VALIDATE_STATUS )

base_glGetShaderSource = glGetShaderSource
def glGetShaderSource( obj ):
	"""Retrieve the program/shader's source code as a Python string
	
	returns string which is '' if no source code
	"""
	length = int(glGetObjectParameteriv(obj, GL_OBJECT_SHADER_SOURCE_LENGTH))
	if length > 0:
		source = ctypes.create_string_buffer(length)
		base_glGetShaderSource(obj, length, None, source)
		return source.value.strip('\000') # null-termination
	return ''
glGetShaderSource.wrappedOperation = base_glGetShaderSource

base_glGetActiveUniform = glGetActiveUniform
def glGetActiveUniform(program, index):
	"""Retrieve the name, size and type of the uniform of the index in the program"""
	max_index = int(glGetObjectParameteriv( program, GL_OBJECT_ACTIVE_UNIFORMS ))
	length = int(glGetObjectParameteriv( program, GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH))
	if index < max_index and index >= 0 and length > 0:
		name = ctypes.create_string_buffer(length)
		size = arrays.GLintArray.zeros( (1,))
		gl_type = arrays.GLuintArray.zeros( (1,))
		base_glGetActiveUniform(program, index, length, None, size, gl_type, name)
		return name.value, size[0], gl_type[0]
	raise IndexError, 'Index %s out of range 0 to %i' % (index, max_index - 1, )
glGetActiveUniform.wrappedOperation = base_glGetActiveUniform
