# A plugin to add a stop button to the player window.
# This one is for you, lorijho.
import gtk, gtk.glade
import pygtk

__name = 'Stop Button'
__version = '0.01'
__author = "Natan 'whatah' Zohar"
__blurb = 'Stop Button does exactly what it sounds like - it adds a stop button to the players interface.'
def stop_mpd(obj, mpd):
    mpd.stop()

class Stopbutton:
    # called when we load the plugin.
    def _init(self, data):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, parser = data
        self.parent = self.xml.get_widget("hbox6")
        self.stopbutton = gtk.Button()
        self.stopbutton.set_label('')
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_MEDIA_STOP, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.stopbutton.set_image(image)
        self.stopbutton.connect('clicked', stop_mpd, self.pympd)
        self.stopbutton.show_all()
        self.parent.add(self.stopbutton)

    # plugin configure dialog.
    def _conf(self, hasDialog=None):
        return False
    
    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        pass

    # called on plugin unloaded
    def _unload(self):
        self.parent.remove(self.stopbutton)
        return

