# 7.0 Migration Notes {: #\7.0}

## Tabbed Extension

A new extension called Tabbed has been added. With the arrival of this general purpose tabbed content extension, it has
made the old SuperFences tabbed content feature redundant. By default, SuperFences will now change the classes it uses
for it's tabbed feature to match those of the new Tabbed extension. CSS should be updated accordingly.

The classes that have changed are `superfences-tabs` and `superfences-content`, which have changed to `tabbed-set` and
`tabbed-content` respectively. Example CSS is updated in SuperFences for
[reference](../../extensions/superfences.md).

To help with the transition though, you can quickly switch back to the old style classes by simply enabling the
SuperFences' global option `legacy_tab_classes`:

```py3
extension_configs = {
    "pymdownx.superfences": {
        "legacy_tab_classes": True
    }
}
```

To learn more about migrating to the Tabbed extension, checkout the [Tabbed documentation](../../extensions/tabbed.md).

SuperFences' tab content feature will be removed in 8.0. There is no formal date for when this will occur, but it is
recommended to begin migrating as soon as possible, but `legacy_tab_classes` can be used as a stop gap for the short
term.

## Option Deprecation in SuperFences

SuperFences has deprecated `highlight_code`. This option now does nothing and will be removed in some future release.
If this option was used, you will have to use [custom fences](../../extensions/superfences.md#custom-fences) to
implement this behavior with your own custom formatter.

## SuperFences Configurable Classes and IDs

Additional classes and IDs can now be injected into fenced code blocks with the format ` ```{.lang .more-class} `.

The attribute list feature also impacts the the custom formatter. While the default formatters will still inject
classes and IDs to the top level element to preserve backwards compatibility, the formatter now must accept the new
keyword parameters `classes` and `id_value`. If you have a custom formatter that does not adhere to this new
requirement, you will see a user warning.

The new format is:

```py3
def custom_formatter(source, language, css_class, options, md, classes=None, id_value='', **kwargs):
    return string
```

While it is recommended for a user to update their custom formatters to receive the new parameters, at the very
least, users should add `**kwargs` to future proof their formatters.

## CodeHilite Separation

SuperFences and InlineHilite no longer sync settings from CodeHilite. To configure either of the extensions, Pymdown
Extension's Highlight extension must be used. CodeHilite can be run along side Highlight if desired, but CodeHilite
cannot be used to augment SuperFences or InlineHilite's behavior.

## Keys Alias Changes

Previously `alt`, `left-alt`, and `right-alt` had aliases `menu`, `left-menu`, `right-menu`, `lmenu`, and `rmenu`. These
aliases have been removed. `menu` will now be an alias for `context-menu`.

It is known that *Alt* has been referred to as *Menu* in the real world, but so is the actual *Menu*/*Apps* key. This
will hopefully create less confusion in the long term, even if there is a little in the short term.
