from __future__ import generators
import py
datadir  = py.magic.autopath().dirpath('data')

tmpdir = py.test.ensuretemp('test_collect') 

def test_failing_import_execfile():
    fn = datadir / 'failingimport.py'
    dest = tmpdir.join('failing_import.py')
    fn.copy(dest)
    col = py.test.collect.Module(dest) 
    py.test.raises(ImportError, col.run)
    py.test.raises(ImportError, col.run)

def XXXtest_finds_root(): 
    fn = datadir / 'filetest.py'
    col = py.test.collect.Module(fn) 
    root, namelist = col.fromroot() 
    assert isinstance(root, py.test.collect.Directory) 
    cur = root
    for x in namelist: 
        cur = cur.join(x) 
    assert cur.name == col.name 
    assert cur.parent == col.parent  
    assert cur.fspath == cur.fspath 

def test_finds_tests(): 
    fn = datadir / 'filetest.py'
    col = py.test.collect.Module(fn) 
    l = col.run() 
    assert len(l) == 2 
    assert l[0] == 'test_one' 
    assert l[1] == 'TestClass' 

def test_ignored_certain_directories(): 
    tmp = py.test.ensuretemp("ignore_certain_directories")
    tmp.ensure("_darcs", 'test_notfound.py')
    tmp.ensure("CVS", 'test_notfound.py')
    tmp.ensure("{arch}", 'test_notfound.py')
    tmp.ensure(".whatever", 'test_notfound.py')
    tmp.ensure("normal", 'test_found.py')
    tmp.ensure('test_found.py')

    colitem = py.test.collect.Directory(tmp) 
    items = list(colitem.tryiter(py.test.collect.Module))
    assert len(items) == 2
    for item in items: 
        assert item.name == 'test_found.py' 

def test_failing_import_directory():
    class MyDirectory(py.test.collect.Directory):
        def filefilter(self, p):
            return p.check(fnmatch='testspecial*.py')
    mydir = MyDirectory(datadir)
    l = mydir.run() 
    assert len(l) == 1
    item = mydir.join(l[0])
    assert isinstance(item, py.test.collect.Module)
    py.test.raises(ImportError, item.run)

def test_module_file_not_found():
    fn = datadir.join('nada','no')
    col = py.test.collect.Module(fn) 
    py.test.raises(py.error.ENOENT, col.run) 

def test_syntax_error_in_module():
    modpath = datadir.join('syntax_error.py') 
    col = py.test.collect.Module(modpath) 
    py.test.raises(SyntaxError, col.run) 

def test_disabled_class():
    col = py.test.collect.Module(datadir.join('disabled.py'))
    l = col.run() 
    assert len(l) == 1
    colitem = col.join(l[0])
    assert isinstance(colitem, py.test.collect.Class)
    assert not colitem.run() 

class Testsomeclass:
    disabled = True
    def test_something():
        raise ValueError


#class TestWithCustomItem:
#    class Item(py.test.Item):
#        flag = []
#        def execute(self, target, *args):
#            self.flag.append(42)
#            target(*args)
#
#    def test_hello(self):
#        assert self.Item.flag == [42]
#

def test_generative_simple(): 
    o = tmpdir.ensure('generativetest', dir=1)
    tfile = o.join('test_generative.py')
    tfile.write(py.code.Source("""
        from __future__ import generators # python2.2!
        def func1(arg, arg2): 
            assert arg == arg2 

        def test_gen(): 
            yield func1, 17, 3*5
            yield func1, 42, 6*7

        class TestGenMethods: 
            def test_gen(self): 
                yield func1, 17, 3*5
                yield func1, 42, 6*7
    """))
    col = py.test.collect.Module(tfile) 
    l = col.run() 
    assert len(l) == 2 
    l = col.multijoin(l) 

    generator = l[0]
    assert isinstance(generator, py.test.collect.Generator)
    l2 = generator.run() 
    assert len(l2) == 2 
    l2 = generator.multijoin(l2) 
    assert isinstance(l2[0], py.test.Function)
    assert isinstance(l2[1], py.test.Function)
    assert l2[0].name == '[0]'
    assert l2[1].name == '[1]'

    assert l2[0].obj.func_name == 'func1' 
 
    classlist = l[1].run() 
    assert len(classlist) == 1
    classlist = l[1].multijoin(classlist) 
    cls = classlist[0]
    generator = cls.join(cls.run()[0])
    assert isinstance(generator, py.test.collect.Generator)
    l2 = generator.run() 
    assert len(l2) == 2 
    l2 = generator.multijoin(l2) 
    assert isinstance(l2[0], py.test.Function)
    assert isinstance(l2[1], py.test.Function)
    assert l2[0].name == '[0]'
    assert l2[1].name == '[1]'
   
def test_custom_collection_from_conftest():
    o = tmpdir.ensure('customconfigtest', dir=1)
    o.ensure('conftest.py').write("""if 1:
        import py
        class MyFunction(py.test.Function):
            pass
        class Directory(py.test.collect.Directory):
            def filefilter(self, fspath):
                return fspath.check(basestarts='check_', ext='.py')
        class myfuncmixin: 
            Function = MyFunction
            def funcnamefilter(self, name): 
                return name.startswith('check_') 

        class Module(myfuncmixin, py.test.collect.Module):
            def classnamefilter(self, name): 
                return name.startswith('CustomTestClass') 
        class Instance(myfuncmixin, py.test.collect.Instance):
            pass 
        """)
    checkfile = o.ensure('somedir', 'check_something.py')
    checkfile.write("""if 1:
        def check_func():
            assert 42 == 42
        class CustomTestClass:
            def check_method(self):
                assert 23 == 23
        """)

    from py.__.test.collect import getfscollector
    for x in (o, checkfile, checkfile.dirpath()): 
        #print "checking that %s returns custom items" % (x,) 
        col = getfscollector(x)
        assert len(list(col.tryiter(py.test.Item))) == 2 
        #assert items[1].__class__.__name__ == 'MyFunction'

    # test that running a session works from the directories
    old = o.chdir() 
    try: 
        config, args = py.test.Config.parse([]) 
        out = py.std.cStringIO.StringIO()
        session = config.getsessionclass()(config, out) 
        session.main(args) 
        l = session.getitemoutcomepairs(py.test.Item.Passed) 
        assert len(l) == 2
    finally: 
        old.chdir() 


def test_order_of_execution_generator_same_codeline():
    test_list = []
    expected_list = range(6)

    def list_append(item):
        test_list.append(item)
        
    def assert_order_of_execution():
        print 'expected order', expected_list
        print 'but got       ', test_list
        assert test_list == expected_list
    
    for i in expected_list:
        yield list_append, i
    yield assert_order_of_execution


    
def test_order_of_execution_generator_different_codeline():
    test_list = []
    expected_list = range(3)

    def list_append_2():
        test_list.append(2)

    def list_append_1():
        test_list.append(1)

    def list_append_0():
        test_list.append(0)

    def assert_order_of_execution():
        print 'expected order', expected_list
        print 'but got       ', test_list
        assert test_list == expected_list
        
    yield list_append_0
    yield list_append_1
    yield list_append_2
    yield assert_order_of_execution   

