#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#
# simple.py - non threaded use of pyinotify
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
# usage: ./simple.py [path-to-watch]

from process import PExample
# please read src/examples/README
try:
    # import local build
    import autopath
    from src.pyinotify.pyinotify import WatchManager, Notifier, \
         EventsCodes
except ImportError:
    # import global (installed) pyinotify
    from pyinotify import WatchManager, Notifier, EventsCodes


if __name__ == '__main__':
    #
    # - watch for selected events and do processing with PExample()
    # - The watched path is '/tmp' (by default) or the first
    #   command line argument if given.
    # - type c^c to stop.
    # - You can read the threaded version of this example in threaded.py
    #
    import sys

    path = '/tmp'  # default watched path
    if sys.argv[1:]:
        path = sys.argv[1]

    # only watch these events
    mask = EventsCodes.IN_MODIFY | EventsCodes.IN_DELETE | \
           EventsCodes.IN_OPEN | EventsCodes.IN_ATTRIB | \
           EventsCodes.IN_CREATE

    # watch manager instance
    wm = WatchManager()
    # notifier instance and init, process all events with
    # an instance of PExample
    notifier = Notifier(wm, PExample())

    print 'start monitoring %s with mask 0x%08x' % (path, mask)

    added_flag = False
    # read and process events
    while True:
        try:
            if not added_flag:
                # on first iteration, add a watch on path:
                # watch path for events handled by mask                # instance of PExample as processing function.
                wm.add_watch(path, mask)
                added_flag = True
            notifier.process_events()
            if notifier.check_events():
                notifier.read_events()
        except KeyboardInterrupt:
            # ...until c^c signal
            print 'stop monitoring...'
            # stop monitoring
            notifier.stop()
            break
        except Exception, err:
            # otherwise keep on watching
            print err

