/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.colorspace;

import java.io.IOException;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.colorspace.boxes.ChannelDefinitionBox;
import ucar.jpeg.colorspace.boxes.ColorSpecificationBox;
import ucar.jpeg.colorspace.boxes.ComponentMappingBox;
import ucar.jpeg.colorspace.boxes.ImageHeaderBox;
import ucar.jpeg.colorspace.boxes.PaletteBox;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.jj2000.j2k.codestream.reader.HeaderDecoder;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;
import ucar.jpeg.jj2000.j2k.util.ParameterList;

public class ColorSpace {
    public static final String eol = System.getProperty("line.separator");
    static final int GRAY = 0;
    static final int RED = 1;
    static final int GREEN = 2;
    static final int BLUE = 3;
    public ParameterList pl;
    public HeaderDecoder hd;
    private PaletteBox pbox = null;
    private ComponentMappingBox cmbox = null;
    private ColorSpecificationBox csbox = null;
    private ChannelDefinitionBox cdbox = null;
    private ImageHeaderBox ihbox = null;
    private RandomAccessIO in = null;
    public static final MethodEnum ICC_PROFILED = new MethodEnum("profiled");
    public static final MethodEnum ENUMERATED = new MethodEnum("enumerated");
    public static final CSEnum sRGB = new CSEnum("sRGB");
    public static final CSEnum GreyScale = new CSEnum("GreyScale");
    public static final CSEnum sYCC = new CSEnum("sYCC");
    public static final CSEnum Illegal = new CSEnum("Illegal");
    public static final CSEnum Unknown = new CSEnum("Unknown");

    public byte[] getICCProfile() {
        return this.csbox.getICCProfile();
    }

    public static String indent(String ident, StringBuffer instr) {
        return ColorSpace.indent(ident, instr.toString());
    }

    public static String indent(String ident, String instr) {
        StringBuffer tgt = new StringBuffer(instr);
        char eolChar = eol.charAt(0);
        int i = tgt.length();
        while (--i > 0) {
            if (tgt.charAt(i) != eolChar) continue;
            tgt.insert(i + 1, ident);
        }
        return ident + tgt.toString();
    }

    public ColorSpace(RandomAccessIO in, HeaderDecoder hd, ParameterList pl) throws IOException, ColorSpaceException {
        this.pl = pl;
        this.in = in;
        this.hd = hd;
        this.getBoxes();
    }

    protected final void getBoxes() throws ColorSpaceException, IOException {
        int type;
        long len = 0L;
        int boxStart = 0;
        byte[] boxHeader = new byte[16];
        int i = 0;
        while (true) {
            this.in.seek(boxStart);
            this.in.readFully(boxHeader, 0, 16);
            len = ICCProfile.getInt(boxHeader, 0);
            if (len == 1L) {
                len = ICCProfile.getLong(boxHeader, 8);
            }
            type = ICCProfile.getInt(boxHeader, 4);
            if (i == 0 && type != 1783636000) {
                throw new ColorSpaceException("first box in image not signature");
            }
            if (i == 1 && type != 1718909296) {
                throw new ColorSpaceException("second box in image not file");
            }
            if (type == 1785737827) {
                throw new ColorSpaceException("header box not found in image");
            }
            if (type == 1785737832) break;
            ++i;
            boxStart = (int)((long)boxStart + len);
        }
        long headerBoxEnd = (long)boxStart + len;
        if (len == 1L) {
            boxStart += 8;
        }
        boxStart += 8;
        while ((long)boxStart < headerBoxEnd) {
            this.in.seek(boxStart);
            this.in.readFully(boxHeader, 0, 16);
            len = ICCProfile.getInt(boxHeader, 0);
            if (len == 1L) {
                throw new ColorSpaceException("Extended length boxes not supported");
            }
            type = ICCProfile.getInt(boxHeader, 4);
            switch (type) {
                case 1768449138: {
                    this.ihbox = new ImageHeaderBox(this.in, boxStart);
                    break;
                }
                case 1668246642: {
                    this.csbox = new ColorSpecificationBox(this.in, boxStart);
                    break;
                }
                case 1667523942: {
                    this.cdbox = new ChannelDefinitionBox(this.in, boxStart);
                    break;
                }
                case 1668112752: {
                    this.cmbox = new ComponentMappingBox(this.in, boxStart);
                    break;
                }
                case 1885564018: {
                    this.pbox = new PaletteBox(this.in, boxStart);
                    break;
                }
            }
            boxStart = (int)((long)boxStart + len);
        }
        if (this.ihbox == null) {
            throw new ColorSpaceException("image header box not found");
        }
        if (this.pbox == null && this.cmbox != null || this.pbox != null && this.cmbox == null) {
            throw new ColorSpaceException("palette box and component mapping box inconsistency");
        }
    }

    public int getChannelDefinition(int c) {
        if (this.cdbox == null) {
            return c;
        }
        return this.cdbox.getCn(c + 1);
    }

    public MethodEnum getMethod() {
        return this.csbox.getMethod();
    }

    public CSEnum getColorSpace() {
        return this.csbox.getColorSpace();
    }

    public PaletteBox getPaletteBox() {
        return this.pbox;
    }

    public int getPaletteChannels() {
        return this.pbox == null ? 0 : this.pbox.getNumColumns();
    }

    public int getPaletteChannelBits(int c) {
        return this.pbox == null ? 0 : (int)this.pbox.getBitDepth(c);
    }

    public int getPalettizedSample(int channel, int index) {
        return this.pbox == null ? 0 : this.pbox.getEntry(channel, index);
    }

    public boolean isPalettized() {
        return this.pbox != null;
    }

    public boolean isOutputSigned(int channel) {
        return this.pbox != null ? this.pbox.isSigned(channel) : this.hd.isOriginalSigned(channel);
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ColorSpace is ").append(this.csbox.getMethodString()).append(this.isPalettized() ? "  and palettized " : " ").append(this.getMethod() == ENUMERATED ? this.csbox.getColorSpaceString() : "");
        if (this.ihbox != null) {
            rep.append(eol).append(ColorSpace.indent("    ", this.ihbox.toString()));
        }
        if (this.cdbox != null) {
            rep.append(eol).append(ColorSpace.indent("    ", this.cdbox.toString()));
        }
        if (this.csbox != null) {
            rep.append(eol).append(ColorSpace.indent("    ", this.csbox.toString()));
        }
        if (this.pbox != null) {
            rep.append(eol).append(ColorSpace.indent("    ", this.pbox.toString()));
        }
        if (this.cmbox != null) {
            rep.append(eol).append(ColorSpace.indent("    ", this.cmbox.toString()));
        }
        return rep.append("]").toString();
    }

    public boolean debugging() {
        return this.pl.getProperty("colorspace_debug") != null && this.pl.getProperty("colorspace_debug").equalsIgnoreCase("on");
    }

    public static class CSEnum
    extends Enumeration {
        public CSEnum(String value) {
            super(value);
        }
    }

    public static class MethodEnum
    extends Enumeration {
        public MethodEnum(String value) {
            super(value);
        }
    }

    public static class Enumeration {
        public final String value;

        public Enumeration(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

