# arch-tag: david@allouche.net - 2003-11-17 15:23:30 335369000
# Copyright (C) 2003 John Goerzen, David Allouche
# <jgoerzen@complete.org> <david@allouche.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Obsolete utility module
"""

import os
import re


# For compatibility
from errors import ExecProblem
from pathname import PathName, DirName, FileName
from backends.logger import Logger
from backends.forkexec import exec_safe
from backends.forkexec import exec_safe_status_stdout
from backends.forkexec import exec_safe_iter_stdout
from backends.forkexec import ChildProcess
from backends.forkexec import getnull
from backends.forkexec import StringOutput


def exec_safe_stdout(program, args=[], expected=0, chdir=None, logger=None):
    status, output = exec_safe_status_stdout(program, args, expected,
                                             chdir, logger)
    return output


def exec_safe_silent(program, args = [], expected = 0, chdir = None):
    """Silently runs the specified program."""
    null = getnull()
    proc = ChildProcess(program, args, expected, chdir)
    proc.spawn(null, null, null)
    proc.wait()
    return proc.status


def new_numbered_name(dir, prefix):
    def int_tail(name):
        if not name.startswith(prefix):
            return 0
        else:
            tail = name[len(prefix):]
            try: return int(tail)
            except ValueError: return 0

    N = max(map(None, map(int_tail, os.listdir(dir))))
    return dir/(prefix + str(N+1))


def maketree(path, addpath = DirName(), ignore = [], res = None):
    """Sorted recursive listing of the directory at @path.

    @ignore is a list of regular expression strings. Files and
    directories which match any of these are skipped.

    The listing is actually a list of DirName and FileName objects.
    They are storted directories first, then files.
    """
    retval = []
    others = []
    if res == None:
        res = [re.compile(x) for x in ignore]
    for item in os.listdir(path):
        skip = 0
        for retest in res:
            if retest.search(item):
                skip = 1
                break
        if skip:
            continue

        dirname = os.path.join(path, item)
        if os.path.isdir(dirname):
            item, dirname = DirName(item), DirName(dirname)
            retval.append(addpath/item)
            others.extend(maketree(dirname, addpath/item, res = res))
        else:
            item = FileName(item)
            retval.append(addpath/item)
    return sorttree(retval + others)


def sorttree(srctree):
    dirs = [x for x in srctree if isinstance(x, DirName)]
    files = [x for x in srctree if isinstance(x, FileName)]
    dirs.sort()
    files.sort()
    return dirs + files


def copyfrom(srcdir, destdir, verbose=False):
    """Copy the contents of @srcdir into @destdir using a tar pipe.

    All files in @srcdir will be copied into @destdir and files which
    are unique to @destdir will be preserved. Sparse files and
    permissions from @srcdir will be preserved.

    The sparse file preservation feature causes a dependence on GNU tar.
    """
    read_end, write_end = os.pipe()
    verbargs = []
    if verbose:
        verbargs.append('-v')
    reader = ChildProcess("tar", ["-cSpf", "-", "."], chdir=srcdir)
    reader.spawn(stdout = write_end, closefds = [read_end])
    writer = ChildProcess("tar", ["-xSpf", "-"] + verbargs, chdir=destdir)
    writer.spawn(stdin = read_end, closefds = [write_end])
    os.close(read_end)
    os.close(write_end)
    reader.wait()
    writer.wait()
