# arch-tag: c97e5e20-4852-44eb-b896-7442a39023fc
# Copyright (C) 2003 David Allouche <david@allouche.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Internal module providing my-id getting and setting.

This module implements some of public interface for the
pybaz_ package. But for convenience reasons the author prefers
to store this code in a file separate from ``__init__.py``.

.. _pybaz: pybaz-module.html

This module is strictly internal and should never be used.
"""

__all__ = ['my_id', 'set_my_id']


def _backend():
    import pybaz
    return pybaz.backend


def my_id():
    """The current registered user id

    :return: the user id, for example 'John Doe <jdoe@example.org>'.
    :rtype: str
    """
    status, output = _backend().status_one_cmd(('my-id',), (0,2))
    # status is 2 if the user id is not set.
    # maybe an exception should be thrown instead of returning None.
    if status != 0: return None
    return output

def set_my_id(new_id):
    """Set the current registered user id

    :param new_id: new value of the user id.
    :type new_id: str
    """
    _backend().null_cmd(('my-id', new_id))


