#----------------------------------------------------------------------
#      ___       ___ ___   P X E S   Universal  Linux  Thin  Client
#     /__/\\_// /__ /__    Copyright(C) 2003 by Diego Torres Milano
#    /    // \\/__  __/    All rights reserved.  http://pxes.sf.net
#
# Author: Diego Torres Milano <diego@in3.com.ar>
# $Id: pxesconfig.spec,v 1.18 2003/11/12 02:57:12 diego Exp $
#----------------------------------------------------------------------
%define ver     0.7
%define rel     1
%define name    pxesconfig
%define rlname  %{name}
%define source0 http://prdownloads.sourceforge.net/pxes/%{name}-%{ver}-%{rel}.tar.gz
%define url     http://pxes.sourceforge.net
%define group   Applications/System
%define copy    GPL
%define filelst %{name}-%{ver}-files
%define prefix  /usr
%define arch    noarch
%define dtm 	 Diego Torres Milano <diego@pxes.com.ar>
%define mandir  /usr/share/man
%define confdir %{prefix}/share/%{name}
%define icon    pxes-tiny-48x48.xpm

Summary: PXES configuration tool

Name: %name
Version: %ver
Release: %rel
Copyright: %{copy}
Distribution: Red Hat Linux
Vendor: %{dtm}
Packager: %{dtm}
Source: %{source0}
URL: %{url}
Group: %{group}
BuildArch: %{arch}
AutoReq: no
AutoProv: no
Requires: pxes-base, perl >= 5.6.0, Glade-Perl >= 0.60, Gtk-Perl >= 0.7008, sh-utils >= 2.0.11, mount >= 2.11g, gzip >= 1.3, fileutils >= 4.1, bash >= 2.05, findutils >= 4.1.7, textutils >= 2.0.14, e2fsprogs >= 1.23, mknbi >= 1.2, binutils >= 2.11.90.0.8, mkisofs >= 1.10, hwdata >= 0.47, samba >= 2.2.5
Prefix: %{prefix}
BuildRoot: /var/tmp/%{name}-%{ver}
Icon: %{icon}

%description
This is the PXES configuration.
Following the steps in a druid (wizard) you will obtain a running
configuration of PXES.

%prep
%setup -n %{rlname}-%{ver}

%build
if [ $(perl -e 'print index($INC[0],"%{prefix}/lib/perl");') -eq 0 ];then
    # package is to be installed in perl root
    inst_method="makemaker-root"
    CFLAGS=$RPM_OPT_FLAGS perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/%{prefix} INSTALLMAN1DIR=%{mandir}/man1
else
    # package must go somewhere else (eg. /opt), so leave off the perl
    # versioning to ease integration with automatic profile generation scripts
    # if this is really a perl-version dependant package you should not omiss
    # the version info...
    inst_method="makemaker-site"
    CFLAGS=$RPM_OPT_FLAGS perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/%{prefix}/ INSTALLMAN1DIR=$RPM_BUILD_ROOT/%{mandir}/man1
fi

echo $inst_method > inst_method

# get number of processors for parallel builds on SMP systems
numprocs=`cat /proc/cpuinfo | grep processor | wc | cut -c7`
if [ "x$numprocs" = "x" -o "x$numprocs" = "x0" ]; then
  numprocs=1
fi

make "MAKE=make -j$numprocs"

%install
rm -rf $RPM_BUILD_ROOT

if [ "$(cat inst_method)" = "makemaker-root" ];then
   make UNINST=1 PREFIX=$RPM_BUILD_ROOT%{prefix} install
elif [ "$(cat inst_method)" = "makemaker-site" ];then
   make UNINST=1 PREFIX=$RPM_BUILD_ROOT%{prefix} INSTALLMAN1DIR=$RPM_BUILD_ROOT%{mandir}/man1 install
fi

# back compatibility
if [ ! -d $RPM_BUILD_ROOT/opt/bin ];then
	mkdir -p $RPM_BUILD_ROOT/opt/bin
fi
ln -s %{prefix}/bin/pxesconfig $RPM_BUILD_ROOT/opt/bin/pxesconfig
ls -l $RPM_BUILD_ROOT/opt/bin/pxesconfig

%__os_install_post
find $RPM_BUILD_ROOT ! -type d -print|sed -e "s@^$RPM_BUILD_ROOT@@g" > %{filelst}

%files -f %{filelst}
%defattr(-, root, root)
%{prefix}/share/pixmaps/%{name}
%doc Documentation/*
%config %{confdir}/*

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Tue Nov 11 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.7-1
	  rdp_dont_request_license disabled
	  Added archdir
	  Added monitors db
	  Added keyboard_model
	  Added local_esd_enabled
	  Default frequencies changed to Generic SVGA

* Mon Nov 10 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-14
	  Corrected vnc_compress_level
	  Added vnc_is_viewonly

* Wed Nov  3 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-13
	  rdesktop 1.3.0 support

* Wed Oct 23 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-12
	  Added window_manager variable default value /usr/bin/oroborus

* Wed Oct 22 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-11
	  Added window_manager variable

* Wed Oct 15 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-10
	  Added prompt_before_x
	  Changed telnetd action

* Thu Oct  9 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-9
	  Added smbpasswd.ro
	  Added support for RH 7.x and AS 2.x
	  Added include, install, isoinclude and isoinstall options
	  Telnet session support completed
	  Modified inittab parsing to exclude startx if no X sessions
	  were selected
	  Added Monitor DB support
	  ESD support now controlled by variable
	  Added local inetd
	  Added Custom session
	  Completed syslog support
	  Support for system wide configuration in
	  /etc/pxes/pxesconfig.conf
	  Suppoprt for user configuration in ~/.pxesconfig.conf
	  Removed path from most command so pxesconfig is more distribution
	  independent
	  Added ica optional files section
	  Created smbpasswd and copied to ro
	  Changed error message in find cpio
	  Changed BIOS boot failure number

* Wed Sep 25 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-8
	  ICAClient directory renamed to ICAClient.ro

* Wed Sep 24 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-7
	  Added custom session
	  Added telnet session
	  Support for text only sessions
	  Samba password set and floppy access set to public = no
	  Added include and isoinclude options
	  Read /etc/pxes/pxesconfig.conf and ~/.pxesconfig.conf files

* Mon Aug 28 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-6
	  Added MonitorsDB and hwdata dependency

* Mon Aug 18 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-5
	  Default kernel version changed

* Mon Aug 18 2003 - Diego Torres Milano <diego@pxes.com.ar>
	- pxesconfig-0.6-4
	  Kernel changed to 2.4.20-6pxes
	  Release component added to source file

* Wed Aug 13 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.6-3
	  Added rdesktop version selection
	  Default prefix changed to /usr
	  Datadir changed to /usr/share/pxesconfig
	  Back compatibility with /opt

* Thu Jul 25 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.6-2
	  Rdesktop variable added

* Thu Jul 19 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.6-1
	  Version changed

* Thu Jul 19 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-50
	  Added LTSP session
	  Session management changed (XA, XI, TA, TI)
	  Devfs support
	  Added PRPM (stage 1)

* Thu Jul 14 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-49
	  No info

* Thu Jul  7 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-48
	  Added x_extra_options.
	  Added default variables for monitor.

* Thu Jun 20 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-46
	  No info

* Thu Jun 19 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-45
	  Added LINRDP support
	  Added WINCONNECT support
	  Changes in extra_templates
	  Debug tools added
	  Kernel finding changed (newer-higher)

* Thu Jun  5 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-44
	  Added local HTTP support
	  Added ASK support to all sessions
	  RDP default port changed to 3389
	  Added volumen name to ISO image
	  Mkiso options changed
	  Added local configuration directory
	  Serial printer added to printer options

* Thu Jun  2 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-43
	  No Hw Cursor X option enabled

* Thu May 15 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-42
	  No info

* Thu May 15 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-41
	  No Hw Cursor X option disabled

* Thu May 13 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-40
	  Added partial LinRDP support
	  Added parial No Hw Cursor X option support
	  Added LinRDP variables

* Thu May 12 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-39
	  Ask support completed

* Thu May  9 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-38
	  Inittab parsing modified to include tty number (keyboard "locked"
	  problem solved)

* Thu May  8 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-37
	  Added login and telnet support
	  Root password managemente

* Mon Apr 21 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-36
	  NX image support
	  Mouse acceleration added.
	  ISO image creation.

* Mon Mar 28 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-35
	  Changes in arch dependent files check

* Mon Mar 27 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-34
	  X3 and X4 selectable
	  Dump configuration bug fixed

* Mon Mar 20 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-33
	  Multiple sessions (extra files)
	  Default kernel changed to 2.4.20-4pxes

* Mon Mar 10 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-32
	  Multiple sessions
	  New icons added

* Mon Feb 27 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-31
	  
* Mon Feb 20 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-30
	  Changes in spec
	  Default kernel changed to 2.4.20-2pxes

* Mon Feb 17 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-29
	  Local samba added
	  Supermount supported
	  Kernel module options added

* Thu Jan 30 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-28
	  ICA server list bug fixed

* Thu Jan 28 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-27
	  no relevant changes

* Thu Jan 27 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-26
	  local session
	  mouse acceleration
	  1600x1200 resolution added

* Thu Jan 22 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-25
	  Minor corrections

* Thu Jan 20 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-24
	  Modules configuration written to modules.conf.ro.

* Thu Jan 17 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-23
	  Boot messages as numeric value

* Thu Jan 10 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-22
	  Added boot messages check button

* Thu Jan  9 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-21

* Thu Jan  3 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-20
	  Added x_numlock

* Thu Jan  2 2003 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-19
	  Kernel architecture support fully added.

* Thu Dec 30 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-18
	  VIA C3 added to arch

* Thu Dec 28 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-17
	  X options noaccel added

* Thu Dec 26 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-16
	  ICA defaults changed
	  Arch directory added

* Tue Dec 24 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-16
	  Extra files for ICA client included
	  Modules directory extracted from dist
	  ICA version test in druid

* Thu Dec 12 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-13
	  Local configuration small fixes

* Thu Dec  5 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-13
	  RedHat 8.0 and Glade-Perl-0.60-1 problem fixed
	  Local configuration added
	  Support for autogeneration of initrd and nbi added

* Mon Dec  2 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-12
	  ICA fixes

* Tue Nov 26 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-11
	  ICA session finished

* Thu Nov 21 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-10
	  VNC session finished
	  ICA session (incomplete)

*Mon Nov 18 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5.1-9
	  vnc session added
	  text messages
	  no druid option in pxesconfig

*Sun Oct 20 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-1-5
	  added mouse autodetect via lsmouse

*Thu Sep 26 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-pl1
	  added local devices (fd, cd, hd).
	  ICA support page started.
	  RDP server version selection.

*Tue Aug 27 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC10
	  added check to control login shell
	  added check to control "press key" message
	  check for pending changes before exit

*Tue Aug  6 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC8
	  added mouse wheel support
	  keyboard layout bug '-' corrected
	  destroy handler
	  changed druid watermark

*Thu Aug  1 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC7
	  added horizontal sync and vertical refresh

*Tue Jul 30 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC6
	  dynamic content of combo boxes (keyboar, nic, sound)

*Thu Jul 25 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC5
	  added mknbi options (append)
	  added watermark

*Tue Jul 23 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC4
	  added test for RDP geometry when full screen not set
	  modified copyright message
	  kernel copied to tftpboot
	  icon added to spec
	  corrections in mouse protocols
	  corrections in keyboard layout names

*Mon Jul 15 2002 - Diego Torres Milano <diego@in3.com.ar>
	- pxesconfig-0.5-RC3
	  added NBI support
	  added XDM port support

*Tue Jun 11 2002 - Diego Torres Milano <diego@in3.com.ar>
    - version 0.01 - This file was created by Glade::PerlSource
