#----------------------------------------------------------------------
#      ___       ___ ___   P X E S   Universal  Linux  Thin  Client
#     /__/\\_// /__ /__    Copyright(C) 2003 by Diego Torres Milano
#    /    // \\/__  __/    All rights reserved.  http://pxes.sf.net
#
# Author: Diego Torres Milano <diego@in3.com.ar>
# $Id: PxesconfigGUI.pm,v 1.13 2003/11/12 04:17:02 diego Exp $
#----------------------------------------------------------------------
package PxesconfigGUI;
require 5.000; use strict 'vars', 'refs', 'subs';
# UI class 'PxesconfigGUI' (version 0.5)
# 
# Copyright (c) Date Fri May 24 01:45:10 ART 2002
# Author Diego Torres Milano <diego@in3.com.ar>
#
# Unspecified copying policy, please contact the author
# Diego Torres Milano <diego@in3.com.ar>
#
#=======================================================================
# This perl source file was automatically generated by 
# Glade::PerlGenerate version 0.60 - Fri May  3 03:56:25 BST 2002
# Copyright (c) Author Dermot Musgrove <dermot.musgrove@virgin.net>
#
# from Glade file PxesconfigGUI.glade
# Fri May 24 01:45:10 ART 2002
#=======================================================================

BEGIN {
	use constant TRUE => 1;
	use constant FALSE => 0;
	use constant DRUID_CHANGE_PAGE => 0;
	use constant DRUID_DONT_CHANGE_PAGE => 1;

	use constant TA => 1;
	use constant XA => 2;
	use constant TI => -1;
	use constant XI => -2;

	use English;
	use Gtk;
   use Gnome;
   use Pxesconfig::PxesconfigGUIUI;
	use Pxesconfig::PxesconfigDruidPage;

	use vars qw($DEBUG);
	use vars qw($active_dialog $finished);
	use vars qw($druid_session_pages);

	our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

	#@ISA = qw();

	# set the version for version checking
   $VERSION = do { my @r = (q$Revision: 1.13 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; # must be all one line, for MakeMaker

	# FIXME
	# /usr prefix
   $Glade::PerlRun::pixmaps_directory = "/usr/share/pixmaps/pxesconfig";
	#warn "pixmaps: $Glade::PerlRun::pixmaps_directory";
} # End of sub BEGIN

$DEBUG = 0;
$active_dialog = undef;
$finished = FALSE;
$druid_session_pages = undef;

sub app_run {
    my ($class, %params) = @_;
    #$class->load_translations('PxesconfigGUI');
    $class->load_translations('pxesconfig');
    # You can use the line below to load a test .mo file before it is installed in 
    # the normal place (eg /usr/local/share/locale/en_US/LC_MESSAGES/PxesconfigGUI.mo)
#    $class->load_translations('PxesconfigGUI', 'test', undef, '/home/diego/src/perl/Gtk/Pxesconfig-0.5/ppo/PxesconfigGUI.mo');

	 #..................................................................
	 # by DTM
	 # moved to pxesconfig script
    #Gnome->init("$PACKAGE", "$VERSION");
	 #..................................................................
	 
    my $window = $class->new;
    $window->TOPLEVEL->show;

    # Put any extra UI initialisation (eg signal_connect) calls here
	 initialize($window);

    # Now let Gtk handle signals
    Gtk->main;

    $window->TOPLEVEL->destroy;

    return $window;

} # End of sub app_run

sub initialize($) {
	my ($window) = @_;
	my $model = $Pxesconfig::MODEL;

	initialize_druidpagestart1(
		$window->lookup_widget('druidpagestart1'));

	#initialize_treeModules($window->lookup_widget('treeModules'));

	initialize_spinbuttonXFontServerPort(
		$window->lookup_widget('spinbuttonXFontServerPort'));
	initialize_spinbuttonXDMServerPort(
		$window->lookup_widget('spinbuttonXDMServerPort'));
	initialize_spinbuttonOLDPrinterPort(
		$window->lookup_widget('spinbuttonOLDPrinterPort'));
	initialize_comboLocalDevicesKeyboardLayout(
		$window->lookup_widget('comboLocalDevicesKeyboardLayout'));
	initialize_comboXVideoDriver(
		$window->lookup_widget('comboXVideoDriver'));
	initialize_hscaleLocalDevicesMouseAcceleration(
		$window->lookup_widget('hscaleLocalDevicesMouseAcceleration'));
	initialize_hscaleLocalDevicesMouseThreshold(
		$window->lookup_widget('hscaleLocalDevicesMouseThreshold'));
	initialize_hscaleVNCCompression(
		$window->lookup_widget('hscaleVNCCompression'));
	initialize_hscaleVNCQuality(
		$window->lookup_widget('hscaleVNCQuality'));
	initialize_hscaleGeneralBootMessagesLevel(
		$window->lookup_widget('hscaleGeneralBootMessagesLevel'));

	my $s = new PxesconfigDruidPage('druidpagestandardSession', undef,
		undef);
	$s->active(TRUE);
	$s->selected(TRUE);
	my $w = new PxesconfigDruidPage('druidpagestandardXWindows', $s,
		undef);
	$w->active(TRUE);
	$w->selected(TRUE);
	$s->next($w);

	my $l = new PxesconfigDruidPage('druidpagestandardLOCAL', $w, undef);
	$l->active($model->sessions()->{local} > 0);
	$w->next($l);
	$window->lookup_widget('checkbuttonSessionLOCAL')->set_sensitive(
		$model->sessions()->{local} > 0);
	$window->lookup_widget('pixmapSessionLOCAL')->set_sensitive(
		$model->sessions()->{local} > 0);
	$window->lookup_widget('labelSessionLOCAL')->set_sensitive(
		$model->sessions()->{local} > 0);

	my $x = new PxesconfigDruidPage('druidpagestandardXDM', $l, undef);
	$x->active($model->sessions()->{xdm} > 0);
	$l->next($x);
	my $r = new PxesconfigDruidPage('druidpagestandardRDP', $x, undef);
	$r->active($model->sessions()->{rdp} > 0);
	$x->next($r);
	my $v = new PxesconfigDruidPage('druidpagestandardVNC', $r, undef);
	$v->active($model->sessions()->{vnc} > 0);
	$r->next($v);
	my $i = new PxesconfigDruidPage('druidpagestandardICA', $v, undef);
	$i->active($model->sessions()->{ica} > 0);
	$v->next($i);

	my $t = new PxesconfigDruidPage('druidpagestandardTELNET', $i,
		undef);
	$t->active($model->sessions()->{telnet} > 0);
	$i->next($t);

	my $lr = new PxesconfigDruidPage('druidpagestandardLINRDP', $t,
		undef);
	$lr->active($model->sessions()->{linrdp} > 0);
	$t->next($lr);
	
	$window->lookup_widget('checkbuttonSessionTELNET')->set_sensitive(
		$model->sessions()->{telnet} > 0);
	$window->lookup_widget('radiobuttonSessionTELNET')->set_sensitive(
		$model->sessions()->{telnet} > 0);
	$window->lookup_widget('pixmapSessionTELNET')->set_sensitive(
		$model->sessions()->{telnet} > 0);
	$window->lookup_widget('labelSessionTELNET')->set_sensitive(
		$model->sessions()->{telnet} > 0);

	my $h = new PxesconfigDruidPage('druidpagestandardSSH', $lr, undef);
	$h->active($model->sessions()->{ssh} > 0);
	$lr->next($h);

	$window->lookup_widget('checkbuttonSessionSSH')->set_sensitive(
		$model->sessions()->{ssh} > 0);
	$window->lookup_widget('radiobuttonSessionSSH')->set_sensitive(
		$model->sessions()->{ssh} > 0);
	$window->lookup_widget('pixmapSessionSSH')->set_sensitive(
		$model->sessions()->{ssh} > 0);
	$window->lookup_widget('labelSessionSSH')->set_sensitive(
		$model->sessions()->{ssh} > 0);

	my $p = new PxesconfigDruidPage('druidpagestandardLTSP', $h, undef);
	$p->active($model->sessions()->{ltsp} > 0);
	$h->next($p);

	$window->lookup_widget('checkbuttonSessionLTSP')->set_sensitive(
		$model->sessions()->{ltsp} > 0);
	$window->lookup_widget('radiobuttonSessionLTSP')->set_sensitive(
		$model->sessions()->{ltsp} > 0);
	$window->lookup_widget('pixmapSessionLTSP')->set_sensitive(
		$model->sessions()->{ltsp} > 0);
	$window->lookup_widget('labelSessionLTSP')->set_sensitive(
		$model->sessions()->{ltsp} > 0);

	$window->lookup_widget('checkbuttonSessionLINRDP')->set_sensitive(
		$model->sessions()->{linrdp} > 0);
	$window->lookup_widget('radiobuttonSessionLINRDP')->set_sensitive(
		$model->sessions()->{linrdp} > 0);
	$window->lookup_widget('pixmapSessionLINRDP')->set_sensitive(
		$model->sessions()->{linrdp} > 0);
	$window->lookup_widget('labelSessionLINRDP')->set_sensitive(
		$model->sessions()->{linrdp} > 0);

	$window->lookup_widget('checkbuttonSessionWINCONNECT')->set_sensitive(
		$model->sessions()->{winconnect} > 0);
	$window->lookup_widget('radiobuttonSessionWINCONNECT')->set_sensitive(
		$model->sessions()->{winconnect} > 0);
	$window->lookup_widget('pixmapSessionWINCONNECT')->set_sensitive(
		$model->sessions()->{winconnect} > 0);
	$window->lookup_widget('labelSessionWINCONNECT')->set_sensitive(
		$model->sessions()->{winconnect} > 0);

	my $g = new PxesconfigDruidPage('druidpagestandardGeneral', $p,
		undef);
	$g->active(TRUE);
	$g->selected(TRUE);
	$p->next($g);
	$druid_session_pages = $s;

	# There're more initializations but they depend on values not
	# yet set.
}

#======================================================================
#=== Initialization routines
#======================================================================
sub initialize_druidpagestart1($) {
	my ($druidpage) = @_;

	$druidpage->set_text(_("
Pxesconfig $::PXES_VERSION
by Diego Torres Milano <diego\@pxes.com.ar>
Copyright(C) 2001-2003. All rights reserved.
This software is free software under the GNU General Public License.
Pxesconfig comes with ABSOLUTELY NO WARRANTY;
for details type \'pxesconfig -V\'.



This is the PXES Configuration Utility.
In the following screens you will be able to choose de desired
configuration for your thin clients.

You configuration will not be saved until you press the \"Finish\" button.
"));

}

sub initialize_treeModules($) {
	my ($tree) = @_;

	my $root = new_with_label Gtk::TreeItem("modules");
	$tree->append($root);

	my $subtree = new Gtk::Tree();
	$root->set_subtree($subtree);

	my @modules = ( "3c5x9", "sb", "soundconfig", "lp", "parport" );
	foreach my $m (@modules) {
		my $item = new_with_label Gtk::TreeItem($m);
		$subtree->append($item);
		$item->show();
	}

	foreach my $i ('normal', 'half', 'none') {
		my $cb = new Gtk::CheckButton("check button test $i");
		$cb->set_relief($i);
		my $item = new Gtk::TreeItem();
		$item->add($cb);
		$cb->show();
		$item->show();

		$subtree->append($item);
		$item->show();

		my $b = new Gtk::Button("button test $i");
		$b->set_relief($i);
		$item = new Gtk::TreeItem();
		$item->add($b);
		$b->show();
		$item->show();

		$subtree->append($item);
		$item->show();
	}

	$subtree->show();
	$root->show();
	$root->expand();
}

sub initialize_spinbuttonXFontServerPort($) {
	my ($spin) = @_;

	my $a = new Gtk::Adjustment(7001, 1024, 65535, 1, 100, 10 );
	$spin->set_adjustment($a);
	$spin->set_value(7001);
}

sub initialize_spinbuttonXDMServerPort($) {
	my ($spin) = @_;

	my $a = new Gtk::Adjustment(177, 1, 65535, 1, 100, 10 );
	$spin->set_adjustment($a);
	$spin->set_value(177);
}

sub initialize_spinbuttonOLDPrinterPort($) {
	my ($spin) = @_;

	my $a = new Gtk::Adjustment(9100, 1024, 65535, 1, 100, 10 );
	$spin->set_adjustment($a);
	$spin->set_value(9100);
}

sub initialize_comboLocalDevicesKeyboardLayout($) {
	my ($combo) = @_;
	my $model = $Pxesconfig::MODEL;

	$combo->set_popdown_strings($model->keyboard_layouts());
}

sub initialize_comboLocalDevicesNetworkCard($) {
	my ($combo) = @_;
	my $model = $Pxesconfig::MODEL;

	$combo->set_popdown_strings($model->network_cards());
}

sub initialize_comboOLDSoundCard($) {
	my ($combo) = @_;
	my $model = $Pxesconfig::MODEL;

	$combo->set_popdown_strings($model->sound_cards());
}

sub initialize_comboXVideoDriver($) {
	my ($combo) = @_;
	my $model = $Pxesconfig::MODEL;

	$combo->set_popdown_strings($model->video_drivers());
}

sub initialize_hscaleLocalDevicesMouseAcceleration($) {
	my ($hscale) = @_;

	my $a = new Gtk::Adjustment(5, 0, 11, 1, 1, 1);
	$hscale->set_adjustment($a);
}

sub initialize_hscaleLocalDevicesMouseThreshold($) {
	my ($hscale) = @_;

	my $a = new Gtk::Adjustment(2, 0, 11, 1, 1, 1);
	$hscale->set_adjustment($a);
}

sub initialize_hscaleVNCCompression($) {
	my ($hscale) = @_;

	my $a = new Gtk::Adjustment(9, 0, 10, 1, 1, 1);
	$hscale->set_adjustment($a);
}

sub initialize_hscaleVNCQuality($) {
	my ($hscale) = @_;

	my $a = new Gtk::Adjustment(5, 0, 10, 1, 1, 1);
	$hscale->set_adjustment($a);
}

sub initialize_hscaleGeneralBootMessagesLevel($) {
	my ($hscale) = @_;

	my $a = new Gtk::Adjustment(0, 0, 5, 1, 1, 1);
	$hscale->set_adjustment($a);
}



#=======================================================================
#=== Below are the default signal handlers for 'PxesconfigGUI' class
#=======================================================================
sub about_Form {
    my ($class) = @_;
    my $gtkversion = 
        Gtk->major_version.".".
        Gtk->minor_version.".".
        Gtk->micro_version;
    my $name = $0;
    #
    # Create a Gnome::About '$ab'
    my $ab = new Gnome::About(
        $PACKAGE, 
        $VERSION, 
        _("Copyright")." $DATE", 
        $AUTHOR, 
        _('No description')."\n".
        "Gtk ".     _("version").": $gtkversion\n".
        "Gtk-Perl "._("version").": $Gtk::VERSION\n".
        `gnome-config --version`."\n".
        _("run from file").": $name\n \n".
        '# Unspecified copying policy, please contact the author
#', 
        "$Glade::PerlRun::pixmaps_directory/Logo.xpm", 
    );
    $ab->set_title(_("About")." PxesconfigGUI" );
    $ab->position('mouse' );
    $ab->set_policy(1, 1, 0 );
    $ab->set_modal(1 );
    $ab->show;
} # End of sub about_Form

sub destroy_Form {
    my ($class, $data, $object, $instance) = @_;
    Gtk->main_quit; 
} # End of sub destroy_Form

sub toplevel_hide    { shift->get_toplevel->hide    }
sub toplevel_close   { shift->get_toplevel->close   }
sub toplevel_destroy { shift->get_toplevel->destroy }

#======================================================================
#=== Below are the signal handlers for 'PxesconfigGUI' class 
#======================================================================

sub on_pxesconfig_gui_destroy {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_pxesconfig_gui_destroy";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

	print STDERR "Check if there were changes\n";
} # End of sub on_pxesconfig_gui_destroy

#
# druid
#

sub on_druidpagefinish_finish {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagefinish_finish";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$active_dialog = new DialogFinishing();
	my $steps = $model->steps_to_finish();
	my $adj = new Gtk::Adjustment(0, 0, $steps, 0, 0, 0);
	$active_dialog->FORM->{progressbarStatus}->set_adjustment($adj);

	$active_dialog->TOPLEVEL->show();
	# Run the main loop as long as events are pending
	Gtk->main_iteration while ( Gtk->events_pending );
	
	my $exitval = 0;
	my $retval = $model->finish();
	$finished = TRUE;


	if ( $retval < 0 ) {
		$active_dialog->TOPLEVEL->destroy();
		my_message_box('error',
			"There was problems saving configuration.\n\n" .
			$model->error_message()
			);
		$exitval = 1;
	}

	my_message_box('info',
		"Remember to set the kernel parameter\n" .
		"ramdisk_size=" . $model->initrd_fssize() . "\n" .
		"or greater in the boot loader configuration file."
		);

	warn "entering Gtk->main" if $DEBUG;
	Gtk->main;
	exit($exitval);
} # End of sub on_druidpagefinish_finish

sub on_druid_cancel {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druid_cancel";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( $model->changed() ) {
		if ( ! my_message_box('question',
				"Your changes won't be saved.\n" .
				"Are you sure you want to quit ?") ) {
			return TRUE;
		}
	}

	$model->clean_up();
	exit(0);
} # End of sub on_druid_cancel


#
# Kernel and Initrd
#
sub on_druidpagestandardKernelAndInitrd_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardKernelAndInitrd_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{fileentryKISplashScreen}->gtk_entry()->set_text(
		$model->splash_screen());

	$form->{fileentryKIKernel}->gtk_entry()->set_text(
		$model->kernel());
	my $ka = $model->kernel_arch();
	$form->{"radiobuttonKIArch_$ka"}->set_active(TRUE);

	$form->{fileentryKIInitrd}->gtk_entry()->set_text(
		$model->initrd());

	$form->{checkbuttonKINBI}->set_active(
		$model->mknbi());
	$form->{fileentryKINBI}->gtk_entry()->set_text(
		$model->nbi());

	$form->{checkbuttonKIISO}->set_active(
		$model->mkiso());
	$form->{fileentryKIISO}->gtk_entry()->set_text(
		$model->iso());

	$form->{checkbuttonKIInitialize}->set_active(
		$model->initialize());
	$form->{checkbuttonKIReadConfiguration}->set_active(
		$model->read_configuration());
} # End of sub on_druidpagestandardKernelAndInitrd_prepare

sub on_druidpagestandardKernelAndInitrd_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardKernelAndInitrd_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# TEST 1.0
	my $splash_screen =
		$form->{fileentryKISplashScreen}->gtk_entry()->get_text();
	if ( ! -f $splash_screen ) {
		$error_found = TRUE;
		$error_msg .= "Can't read splash screen $splash_screen.\n";
	}

	# TEST 1.1
	my $kernel = $form->{fileentryKIKernel}->gtk_entry()->get_text();
	if ( ! -f $kernel ) {
		$error_found = TRUE;
		$error_msg .= "Can't read kernel $kernel.\n";
	}
	if ( ! $model->check_kernel($kernel) ) {
		$error_found = TRUE;
		$error_msg .= "$kernel is not a valid kernel.\n";
	}

	my $initialize =
		$form->{checkbuttonKIInitialize}->get_active() ? TRUE : FALSE;
	my $mknbi =
		$form->{checkbuttonKINBI}->get_active() ? TRUE : FALSE;
	my $mkiso =
		$form->{checkbuttonKIISO}->get_active() ? TRUE : FALSE;
	my $read_configuration =
		$form->{checkbuttonKIReadConfiguration}->get_active() ? TRUE :
			FALSE;

	# TEST 1.2 and 1.4
	my $initrd = $form->{fileentryKIInitrd}->gtk_entry()->get_text();
	if ( ! -f $initrd ) {
		if ( ! $initialize ) {
			$error_found = TRUE;
			$error_msg .= "Can't read $initrd and initialize not set.\n"
		}
		else {
			if ( -d $initrd ) {
				$error_found = TRUE;
				$error_msg .= 
					"$initrd is a directory and you must specify a " .
					"filename.\n";
			}
		}

		if ( $read_configuration ) {
			$error_found = TRUE;
			$error_msg .=
				"Can't read configuration from an inexistent file.\n";
		}
	}

	# TEST 1.5
	my $nbi = $form->{entryKINBI}->get_text();
	if ( $mknbi ) {
		if ( ! $nbi ) {
			$error_found = TRUE;
			$error_msg .= 
				"Network boot image selected so you must specify an " .
				"image filename.\n";
		}
	}
			
	# TEST 1.5.1
	my $iso = $form->{entryKIISO}->get_text();
	if ( $mkiso ) {
		if ( ! $iso ) {
			$error_found = TRUE;
			$error_msg .= 
				"ISO boot image selected so you must specify an " .
				"image filename.\n";
		}
	}
			
	# TEST 1.6
	my $ka;
	$ka = 'i386' if $form->{radiobuttonKIArch_i386}->get_active();
	$ka = 'i486' if $form->{radiobuttonKIArch_i486}->get_active();
	$ka = 'i586' if $form->{radiobuttonKIArch_i586}->get_active();
	$ka = 'i686' if $form->{radiobuttonKIArch_i686}->get_active();
	$ka = 'viac3' if $form->{radiobuttonKIArch_viac3}->get_active();
	if ( $model->check_arch_dependencies($ka) < 0 ) {
		$error_found = TRUE;
		$error_msg .= 
			"Architecture dependent files missing:\n" .
			$model->error_message() .
			".\n" .
			"Perhaps you forgot to install the architecture dependent " .
			"package for " . $ka;
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->splash_screen($splash_screen);

	$model->kernel($kernel);
	$model->kernel_arch($ka);

	$model->initrd($initrd);
	$model->mknbi($mknbi);
	$model->nbi($nbi);
	$model->mkiso($mkiso);
	$model->iso($iso);
	$model->initialize($initialize);
	$model->read_configuration($read_configuration);
	#$model->notify();
	if ( $model->initial() < 0 ) {
		my_message_box('error', "Problems in initial configuration");
		return DRUID_DONT_CHANGE_PAGE;
	}
		
	# These initializations depends on kernel version
	initialize_comboLocalDevicesNetworkCard(
		$form->{'comboLocalDevicesNetworkCard'});
	initialize_comboOLDSoundCard(
		$form->{'comboOLDSoundCard'});

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardKernelAndInitrd_next

#
# Local Devices
#
sub on_druidpagestandardLocalDevices_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLocalDevices_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{comboLocalDevicesKeyboardLayout}->entry()->set_text(
		$model->keyboard_layout());

	$form->{comboLocalDevicesMouseDevice}->entry()->set_text(
		$model->mouse_device());
	$form->{comboLocalDevicesMouseProtocol}->entry()->set_text(
		$model->mouse_protocol());
	$form->{checkbuttonLocalDevicesEnableMouseWheel}->set_active(
		$model->mouse_wheel_enabled());
	$form->{hscaleLocalDevicesMouseAcceleration}->get_adjustment()->set_value($model->mouse_accel_mult() || 0);
	$form->{hscaleLocalDevicesMouseThreshold}->get_adjustment()->set_value($model->mouse_accel_thr() || 0);

	$form->{comboLocalDevicesNetworkCard}->entry()->set_text(
		$model->network_card());
	$form->{entryLocalDevicesNetworkCardOptions}->set_text(
		$model->network_card_options() || "");

} # End of sub on_druidpagestandardLocalDevices_prepare

sub on_druidpagestandardLocalDevices_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLocalDevices_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( $model->initrd_already_mounted() ) {
		my_message_box('info', "Already mounted");
	}

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardLocalDevices_back

sub on_druidpagestandardLocalDevices_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLocalDevices_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;


	$model->keyboard_layout(
		$form->{comboLocalDevicesKeyboardLayout}->entry()->get_text());

	$model->mouse_device(
		$form->{comboLocalDevicesMouseDevice}->entry()->get_text());
	$model->mouse_protocol(
		$form->{comboLocalDevicesMouseProtocol}->entry()->get_text());
	$model->mouse_wheel_enabled(
		$form->{checkbuttonLocalDevicesEnableMouseWheel}->get_active() ?
			TRUE : FALSE);
	$model->mouse_accel_mult(
		$form->{hscaleLocalDevicesMouseAcceleration}->get_adjustment()->get_value());
	$model->mouse_accel_thr(
		$form->{hscaleLocalDevicesMouseThreshold}->get_adjustment()->get_value());
		
	$model->network_card(
		$form->{comboLocalDevicesNetworkCard}->entry()->get_text());
	$model->network_card_options(
		$form->{entryLocalDevicesNetworkCardOptions}->get_text());

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardLocalDevices_next

#
# Optional Local devices
#
sub on_druidpagestandardOptionalLocalDevices_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardOptionalLocalDevices_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $es = $model->local_sound_enabled();
	my $sc = $model->local_sound_card();
	my $sco = $model->local_sound_card_options();
	my $esd = $model->local_esd_enabled();

	my $ep = $model->local_printer_enabled();
	my $pd = $model->local_printer_device();
	my $pp = $model->local_printer_port();

	my $fd = $model->local_floppy_enabled();
	my $cd = $model->local_dvdcdrom_enabled();
	my $hd = $model->local_harddisk_enabled();

	my $samba = $model->local_samba_enabled();

	$form->{checkbuttonOLDEnableFloppy}->set_active($fd);
	$form->{checkbuttonOLDEnableDVDCDROM}->set_active($cd);
	$form->{checkbuttonOLDEnableHardDisk}->set_active($hd);

	$form->{checkbuttonOLDEnableSound}->set_active($es);
	$form->{comboOLDSoundCard}->entry()->set_text($sc)
		if defined($sc);
	$form->{entryOLDSoundCardOptions}->set_text($sco)
		if defined($sco);
	$form->{checkbuttonOLDEnableESD}->set_active($esd);

	$form->{checkbuttonOLDEnablePrinter}->set_active($ep);
	$form->{comboOLDPrinterDevice}->entry()->set_text($pd)
		if defined($pd);
	$form->{spinbuttonOLDPrinterPort}->set_value($pp);

	$form->{checkbuttonOLDEnableSamba}->set_active($samba);
} # End of sub on_druidpagestandardOptionalDevices_prepare

sub on_druidpagestandardOptionalLocalDevices_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardOptionalLocalDevices_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	my $fd = $form->{checkbuttonOLDEnableFloppy}->get_active() ? TRUE :
		FALSE;
	my $cd = $form->{checkbuttonOLDEnableDVDCDROM}->get_active() ? TRUE :
		FALSE;
	my $hd = $form->{checkbuttonOLDEnableHardDisk}->get_active() ? TRUE :
		FALSE;


	my $es = $form->{checkbuttonOLDEnableSound}->get_active() ? TRUE :
		FALSE;
	my $sc = $form->{comboOLDSoundCard}->entry()->get_text();
	my $sco = $form->{entryOLDSoundCardOptions}->get_text();
	my $esd = $form->{checkbuttonOLDEnableESD}->get_active() ? TRUE :
		FALSE;

	# TEST 2.2.1
	if ( $es && ! $sc ) {
		$error_found = TRUE;
		$error_msg .= "You must specify a sound card when local sound " .
			"is enabled.\n";
	}

	my $ep = $form->{checkbuttonOLDEnablePrinter}->get_active() ? TRUE
		: FALSE;
	my $pd = $form->{comboOLDPrinterDevice}->entry()->get_text();
	my $pp = $form->{spinbuttonOLDPrinterPort}->get_value_as_int();

	# TEST 2.2.2
	if ( $ep && ! $pd ) {
		$error_found = TRUE;
		$error_msg .= "You must specify a printer device when local " .
			"printer is enabled.\n";
	}

	# TEST 2.2.3
	if ( $ep && ! ( $pp > 0 && $pp < 65535 ) ) {
		$error_found = TRUE;
		$error_msg .= "You must specify a printer port > 0 and < " .
			"65535.\n";
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->local_floppy_enabled($fd);
	$model->local_dvdcdrom_enabled($cd);
	$model->local_harddisk_enabled($hd);

	$model->local_sound_enabled($es);
	$model->local_sound_card($sc);
	$model->local_sound_card_options($sco);
	$model->local_esd_enabled($esd);

	$model->local_printer_enabled($ep);
	$model->local_printer_device($pd);
	$model->local_printer_port($pp);

	$model->local_samba_enabled($form->{checkbuttonOLDEnableSamba}->get_active() ? TRUE : FALSE);

	$model->supermount_enabled(TRUE) if ( $fd || $cd );

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardOptionalDevices_next



#
# Modules
#
sub on_druidpagestandardModules_prepare {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_druidpagestandardModules_prepare";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

} # End of sub on_druidpagestandardModules_prepare

sub on_druidpagestandardModules_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardModules_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $ucs = uc($model->x_session_type());

	$form->{druid}->set_page($form->{"druidpagestandard${ucs}"});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardModules_back


sub on_druidpagestandardModules_next {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_druidpagestandardModules_next";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardModules_next


#
# XDM
#
sub on_druidpagestandardXDM_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardXDM_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{checkbuttonXDMAskEnabled}->set_active(
		$model->xdm_ask_enabled());

	my $xm = ucfirst($model->xdm_method());
	$form->{"radiobuttonXDM$xm"}->set_active(TRUE);
	my $xs = $model->xdm_server_name();
	$form->{entryXDMServerName}->set_text($xs)
		if defined($xs);
	$form->{spinbuttonXDMServerPort}->set_value($model->xdm_server_port());
} # End of sub on_druidpagestandardXDM_prepare


sub on_druidpagestandardXDM_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardXDM_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';


	# TEST 4.1
	die "Internal error"
		unless $model->x_session_xdm();

	# TEST 4.2
	my $xd = $form->{radiobuttonXDMDirect}->get_active() ? TRUE : FALSE;
	my $xi = $form->{radiobuttonXDMIndirect}->get_active() ? TRUE
		: FALSE;
	my $xb = $form->{radiobuttonXDMBroadcast}->get_active() ? TRUE
		: FALSE;
	my $xs = $form->{entryXDMServerName}->get_text();
	if ( $xd || $xi ) {
		if ( ! $xs || $xs eq '' ) {
			$error_found = TRUE;
			$error_msg .= "The selected XDM method requireis a server.\n";
		}
		# TEST 4.3
		elsif ( ! seems_host_or_ip($xs) ) {
			$error_found = TRUE;
			$error_msg .= "The server '$xs' does not appear to be a" .
				"a valid hostname or IP address, sorry.\n";
		}
	}

	# TEST 4.4
	my $xp = $form->{spinbuttonXDMServerPort}->get_value_as_int();
	if ( $xp == 0 || $xp > 65535 ) {
		$error_found = TRUE;
		$error_msg .= "The port '$xp' is invalid.\n";
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->xdm_ask_enabled(
		$form->{checkbuttonXDMAskEnabled}->get_active() ? TRUE : FALSE);

	my $xm = ($xd)?"direct":($xi)?"indirect":"broadcast";
	$model->xdm_method($xm);
	$model->xdm_server_name($xs);
	$model->xdm_server_port($xp);

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardXDM_next

sub on_druidpagestandardXDM_back {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_druidpagestandardXDM_back";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardXDM_back


#
# RPD
#
sub on_druidpagestandardRDP_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardRDP_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $v = $model->rdp_version();
	$form->{"radiobuttonRDPVersion" . $v}->set_active(TRUE);

	$form->{checkbuttonRDPAskEnabled}->set_active(
		$model->rdp_ask_enabled());
	$form->{entryRDPServerName}->set_text(
		$model->rdp_server_name() || "");
	$form->{entryRDPDomain}->set_text(
		$model->rdp_domain() || "");
	$form->{entryRDPUser}->set_text(
		$model->rdp_user() || "");
	$form->{entryRDPPassword}->set_text(
		$model->rdp_password() || "");

	$form->{checkbuttonRDPFullScreen}->set_active(
		$model->rdp_is_full_screen());
	$form->{comboRDPGeometry}->entry()->set_text(
		$model->rdp_geometry() || "");

	$form->{"radiobuttonRDPColorDepth" .
		$model->rdp_color_depth()}->set_active(TRUE);

	$form->{checkbuttonRDPRedirectSoundEnabled}->set_active(
		$model->rdp_sound_enabled());
	$form->{checkbuttonRDPForceBitmapUpdates}->set_active(
		$model->rdp_force_bitmap_updates());
	$form->{checkbuttonRDPDontSendMotionEvents}->set_active(
		$model->rdp_dont_send_motion_events());

	# Don't request license not available
	$form->{checkbuttonRDPDontRequestLicense}->set_sensitive(FALSE);
	$form->{checkbuttonRDPDontRequestLicense}->set_active(
		$model->rdp_dont_request_license() || FALSE);

} # End of sub on_druidpagestandardRDP_prepare

sub on_druidpagestandardRDP_back {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_druidpagestandardRDP_back";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardRDP_back

sub on_druidpagestandardRDP_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardRDP_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# TEST 5.1
	die "Internal error"
		unless $model->x_session_rdp();

	# TEST 5.2
	my $a = $form->{checkbuttonRDPAskEnabled}->get_active() ? TRUE :
		FALSE;
	my $server = $form->{entryRDPServerName}->get_text();
	if ( ! $a ) {
		if ( ! $server || $server eq '' ) {
			$error_found = TRUE;
			$error_msg .= "Server cannot be null.\n";
		}
		else {
			# TEST 5.2.1
			if ( ! seems_host_or_ip($server) ) {
				$error_found = TRUE;
				$error_msg .= "The server '$server' does not appear to " .
					"be a valid hostname or IP address.\n";
			}
		}
	}

	# TEST 5.3
	# implicit by signals

	# TEST 5.4
	my $f = $form->{checkbuttonRDPFullScreen}->get_active() ? TRUE :
		FALSE;
	my $g = $form->{comboRDPGeometry}->entry()->get_text();
	if ( ! $f && ! $g ) {
		$error_found = TRUE;
		$error_msg .= "Geometry cannot be null or you must select " .
			"full screen.\n";
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	# TEST 5.5
	my $se =
		$form->{checkbuttonRDPRedirectSoundEnabled}->get_active() ? TRUE :
			FALSE;

	if ( $se ) {
		if ( $model->local_sound_enabled() &&
				$model->local_esd_enabled() ) {
			my_message_box('warning', 'Local sound and ESD are enabled.' .
				"\n" .
				'ESD may conflict with rdesktop sound.');
		}
	}

	my $v = $form->{radiobuttonRDPVersion5}->get_active() ? 5 : 4;
	$model->rdp_version($v);

	$model->rdp_ask_enabled($a);
	$model->rdp_server_name($form->{entryRDPServerName}->get_text());
	$model->rdp_domain($form->{entryRDPDomain}->get_text());
	$model->rdp_user($form->{entryRDPUser}->get_text());
	$model->rdp_password($form->{entryRDPPassword}->get_text());

	$model->rdp_is_full_screen($f);
	$model->rdp_geometry($g);

	my $c = 8;
	foreach my $cd (24, 16, 15, 8) {
		if ( $form->{"radiobuttonRDPColorDepth" . $cd}->get_active() ) {
			$c = $cd;
			last;
		}
	}
	$model->rdp_color_depth($c);

	$model->rdp_sound_enabled($se);
	$model->rdp_force_bitmap_updates(
		$form->{checkbuttonRDPForceBitmapUpdates}->get_active() ? TRUE
			: FALSE);
	$model->rdp_dont_send_motion_events(
		$form->{checkbuttonRDPDontSendMotionEvents}->get_active() ? TRUE
			: FALSE);
	$model->rdp_dont_request_license(
		$form->{checkbuttonRDPDontRequestLicense}->get_active() ? TRUE
			: FALSE);

	$form->{checkbuttonRDPRedirectSoundEnabled}->set_active(
		$model->rdp_sound_enabled());

	$form->{checkbuttonRDPStartProgramEnabled}->set_active(
		$model->rdp_start_program_enabled());
	$form->{entryRDPStartProgram}->set_text(
		$model->rdp_start_program() || "");
	$form->{entryRDPStartProgramFolder}->set_text(
		$model->rdp_start_program_folder() || "");

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardRDP_next


#
# ICA
#
sub on_druidpagestandardICA_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardICA_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{entryICAInstallationDirectory}->set_text(
		$model->local_ica_installation_directory() || "");
	$form->{entryICAConfigurationManager}->set_text(
		$model->local_ica_configuration_manager() || "");
	$form->{entryICAApplicationServers}->set_text(
		$model->local_ica_application_servers_ini() || "");
	$form->{entryICAClientConfiguration}->set_text(
		$model->local_ica_client_configuration_ini() || "");

	my @servers;
	if ( $model->ica_server_list() ) {
		@servers = @{$model->ica_server_list()};
		# FIXME: realy, not a good place for this
		foreach my $s (@servers) {
			$s =~ s/"//g;
		}
	}

	$form->{comboICAServerName}->set_popdown_strings(@servers || "");

	$form->{checkbuttonICAAskEnabled}->set_active(
		$model->ica_ask_enabled());
	$form->{entryICAServerName}->set_text(
		$model->ica_server_name() || "");
} # End of sub on_druidpagestandardICA_prepare

sub on_druidpagestandardICA_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardICA_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardICA_back

sub on_druidpagestandardICA_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardICA_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# TEST 9.1
	die "Internal error"
		unless $model->x_session_ica();

	# TEST 9.2
	my $server = $form->{entryICAServerName}->get_text();
	if ( ! $server || $server eq '' ) {
		$error_found = TRUE;
		$error_msg .= "Server cannot be null.\n";
	}

	# TEST 9.3
	my $d = $form->{entryICAInstallationDirectory}->get_text();
	if ( $model->initialize() ) {
		if ( ! -d $d ) {
			$error_found = TRUE;
			$error_msg .= "Invalid installation directory '$d'.\n";
		}
	}

	# TEST 9.4
	my $a = $form->{entryICAApplicationServers}->get_text();
	if ( ! -r $a ) {
		$error_found = TRUE;
		$error_msg .= "Cannot access file '$a'.\n";
	}

	# TEST 9.5
	my $c = $form->{entryICAClientConfiguration}->get_text();
	if ( ! -r $c ) {
		$error_found = TRUE;
		$error_msg .= "Cannot access file '$c'.\n";
	}

	# TEST 9.6
	$model->local_ica_application_servers_ini($a);
	if ( $server ) {
		if ( ! defined($model->ica_server_list()) ) {
			$error_found = TRUE;
			$error_msg .= "Not defined ICA server list.\n";
		}
		else {
			my @servers = @{$model->ica_server_list()};
			if ( ! @servers || ! grep(/^$server$/, @servers) ) {
				$error_found = TRUE;
				$error_msg .= "'$server' is not on the server list.\n";
			}
		}
	}

	# TEST 9.7
	if ( $model->check_ica_version($d) < 0 ) {
		$error_found = TRUE;
		$error_msg .= $model->error_message() . "\n";
	}
	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	# TEST 9.8
	if ( $model->local_sound_enabled() && $model->local_esd_enabled() ) {
		my_message_box('warning', 'Local sound and ESD are enabled.' .
			"\n" .
			'ESD may conflict with Citrix ICA Client sound.');
	}

	$model->local_ica_installation_directory($d);
	$model->local_ica_configuration_manager(
		$form->{entryICAConfigurationManager}->get_text());
	$model->local_ica_client_configuration_ini($c);

	$model->ica_ask_enabled(
		$form->{checkbuttonICAAskEnabled}->get_active() ? TRUE : FALSE
		);

	$model->ica_server_name($form->{entryICAServerName}->get_text());

#	if ( $model->local_floppy_enabled() || 
#			$model->local_dvdcdrom_enabled() ) {
#		$model->supermount_enabled(TRUE);
#	}

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardICA_next

#
# VNC
#
sub on_druidpagestandardVNC_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardVNC_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{checkbuttonVNCAskEnabled}->set_active(
		$model->vnc_ask_enabled());

	$form->{entryVNCServerName}->set_text(
		$model->vnc_server_name() || "");
	$form->{spinbuttonVNCDisplay}->set_value(
		$model->vnc_display() || 0);
	$form->{fileentryVNCPasswordFile}->gtk_entry()->set_text(
		$model->local_vnc_password_file() || "");

	$form->{checkbuttonVNCFullScreen}->set_active(
		$model->vnc_is_full_screen());
	$form->{comboVNCGeometry}->entry()->set_text(
		$model->vnc_geometry() || "");

	$form->{hscaleVNCCompression}->get_adjustment()->set_value(
		$model->vnc_compress_level() || 0);
	$form->{hscaleVNCQuality}->get_adjustment()->set_value(
		$model->vnc_quality() || 0);

	my $v = $model->vnc_is_shared() ? "Yes" : "No";
	$form->{"radiobuttonVNCShared$v"}->set_active(TRUE);

} # End of sub on_druidpagestandardVNC_prepare

sub on_druidpagestandardVNC_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardVNC_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardVNC_back

sub on_druidpagestandardVNC_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardVNC_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# TEST 8.1
	die "Internal error"
		unless $model->x_session_vnc();

	# TEST 8.2
	my $server = $form->{entryVNCServerName}->get_text();
	if ( ! $server || $server eq '' ) {
		$error_found = TRUE;
		$error_msg .= "Server cannot be null.\n";
	}
	else {
		# TEST 8.2.1
		if ( ! seems_host_or_ip($server) ) {
			$error_found = TRUE;
			$error_msg .= "The server '$server' does not appear to " .
				"be a valid hostname or IP address.\n";
		}
	}

	# TEST 8.3
	my $p = $form->{fileentryVNCPasswordFile}->gtk_entry()->get_text();
	if ( ! -r $p ) {
		$error_found = TRUE;
		$error_msg .= "Password file '$p' cannot be accessded.\n";
	}

	# TEST 8.4
	my $f = $form->{checkbuttonVNCFullScreen}->get_active() ? TRUE :
		FALSE;
	my $g = $form->{comboVNCGeometry}->entry()->get_text();
	if ( ! $f && ! $g ) {
		$error_found = TRUE;
		$error_msg .= "Geometry cannot be null or you must select " .
			"full screen.\n";
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->vnc_ask_enabled(
		$form->{checkbuttonVNCAskEnabled}->get_active() ? TRUE : FALSE
		);

	$model->vnc_server_name($form->{entryVNCServerName}->get_text());
	$model->vnc_display(
		$form->{spinbuttonVNCDisplay}->get_value_as_int());
	$model->local_vnc_password_file($p);

	$model->vnc_is_full_screen($f);
	$model->vnc_geometry($g);

	$model->vnc_compress_level(
		$form->{hscaleVNCCompression}->get_adjustment()->get_value());
	$model->vnc_quality(
		$form->{hscaleVNCQuality}->get_adjustment()->get_value());

	if ( $form->{radiobuttonVNCSharedYes}->get_active() ) {
		$model->vnc_is_shared(TRUE);
	}
	else {
		$model->vnc_is_shared(FALSE);
	}

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardVNC_next

#
# X
#
sub on_druidpagestandardXWindows_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardXWindows_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
}

sub on_druidpagestandardXWindows_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardXWindows_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	# FIXME
	if ( ! $model->x_sessions('selected') ) {
		$form->{druid}->set_page($form->{
			find_selected_druid_page_to_go($me, $object)->name()});
		# we have changed the page already
		return DRUID_DONT_CHANGE_PAGE;
	}

	$form->{"radiobuttonXVersion336"}->set_sensitive(
		$model->initialize());
	$form->{"radiobuttonXVersion430"}->set_sensitive(
		$model->initialize());
		
	my $v = $model->x_version();
	$v =~ s/\.//g;
	$form->{"radiobuttonXVersion" . $v}->set_active(TRUE);

	$form->{checkbuttonXEnableFontServer}->set_active(
		$model->x_font_server_enabled());
	my $fs = $model->x_font_server_name();
	$form->{entryXFontServerName}->set_text($fs)
		if defined($fs);
	$form->{spinbuttonXFontServerPort}->set_value(
		$model->x_font_server_port());

	$form->{entryXVideoDriver}->set_text($model->x_driver());

	my $vm = $model->x_video_modes();
	print STDERR "vm=$vm ", ref($vm), "\n"
		if $DEBUG > 2;
	if ( ref($vm) eq 'ARRAY' ) {
		foreach my $m (@{$vm}) {
			x_video_mode_activate_checkbutton($form, $m);
		}
	}
	else {
		x_video_mode_activate_checkbutton($form, $vm);
	}

	#$form->{checkbuttonXEnableMonitorAutodetect}->set_sensitive(
	#	$model->x_version() ne '3.3.6');
		
	my $cd = $model->x_color_depth();
	$form->{"radiobuttonXColorDepth_$cd"}->set_active(TRUE);

	$form->{checkbuttonXEnableMonitorAutodetect}->set_active(
		$model->x_monitor_autodetect_enabled());
	$form->{comboXHorizontalSync}->entry()->set_text(
		$model->x_horizontal_sync());
	$form->{comboXVerticalRefresh}->entry()->set_text(
		$model->x_vertical_refresh());

	$form->{checkbuttonXOptionNoAccel}->set_active(
		$model->x_option_noaccel());
	$form->{checkbuttonXOptionNoHwCursor}->set_active(
		$model->x_option_no_hw_cursor());
	$form->{checkbuttonXOptionDontZap}->set_active(
		$model->x_option_dont_zap());
	$form->{checkbuttonXScreensaverDisabled}->set_active(
		$model->x_screensaver_disabled());
	$form->{entryXExtraOptions}->set_text($model->x_extra_options());

} # End of sub on_druidpagestandardXWindows_prepare

sub on_druidpagestandardXWindows_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardXWindows_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# FIXME
	# Hardcoded version number
	my $v = $form->{radiobuttonXVersion336}->get_active() ? '3.3.6' :
		'4.3.0';

	my $xfse = $form->{checkbuttonXEnableFontServer}->get_active() ? TRUE
		: FALSE;
	my $xfs = $form->{entryXFontServerName}->get_text();
	my $port = $form->{spinbuttonXFontServerPort}->get_value_as_int();

	# TEST 3.1
	if ( $xfse ) {
		if ( ! $xfs || $xfs eq '' ) {
			$error_found = TRUE;
			$error_msg = "Font server name cannot be null.\n";
		}
		else {
			# TEST 3.1.1
			if ( ! seems_host_or_ip($xfs) ) {
				$error_found = TRUE;
				$error_msg .= "The server '$xfs' does not appear to " .
					"be a valid hostname or IP address.\n";
			}
		}

		# TEST 3.2
		if ( $port == 0 || $port > 65535 ) {
			$error_found = TRUE;
			$error_msg .= "The port '$port' is not between the " .
				"valid range.\n";
		}
	}

	# TEST 3.4
	my %m = (
		"1600" => "1200",
		"1280" => "1024",
		"1024" => "768",
		"800" => "600",
		"640" => "480",
		"Custom" => "Custom",
		);
	my %vm;
	my $count = 0;
	foreach my $v (keys %m) {
		print STDERR "checking ", "checkbuttonXVideoMode_$v", "\n"
			if $DEBUG > 2;
		if ( $form->{"checkbuttonXVideoMode_$v"}->get_active() ) {
			$count++;
			$vm{$v} = 1;
		}
	}

	if ( $count == 0 ) {
		$error_found = TRUE;
		$error_msg .= "At least one video mode should be selected.\n";
	}

	my $c8 = $form->{radiobuttonXColorDepth_8}->get_active();
	my $c16 = $form->{radiobuttonXColorDepth_16}->get_active();
	my $c24 = $form->{radiobuttonXColorDepth_24}->get_active();
	my $c32 = $form->{radiobuttonXColorDepth_32}->get_active();

	if ( $c8 ) {
		$model->x_color_depth(8);
	}
	elsif ( $c16 ) {
		$model->x_color_depth(16);
	}
	elsif ( $c24 ) {
		$model->x_color_depth(24);
	}
	elsif ( $c32 ) {
		$model->x_color_depth(32);
	}
	else {
		$error_found = TRUE;
		$error_msg .= "Invalid color depth.\n";
	}

	my $xmae =
		$form->{checkbuttonXEnableMonitorAutodetect}->get_active() ?
			TRUE : FALSE;
	my $xhs = $form->{comboXHorizontalSync}->entry()->get_text();
	my $xvr = $form->{comboXVerticalRefresh}->entry()->get_text();

	if ( ! $xmae ) {
		# TEST 3.5
		if ( ! $xhs ) {
			$error_found = TRUE;
			$error_msg .= "Invalid horizontal sync.\n";
		}
		
		# TEST 3.6
		if ( ! $xvr ) {
			$error_found = TRUE;
			$error_msg .= "Invalid vertical refresh.\n";
		}
	}
		
	# TEST 3.7
	my $cm = $form->{checkbuttonXVideoMode_Custom}->get_active();
	my $cx;
	my $cy;
	my $ml;
	if ( $cm ) {
		$cx = $form->{entryXVideoModeCustomX}->get_text();
		$cy = $form->{entryXVideoModeCustomY}->get_text();
		$ml = $form->{entryXVideoModeCustomModeline}->get_text();

		if ( ! ($cx && $cy) ) {
			$error_found = TRUE;
			$error_msg .= "You must specify both x and y custom resolution.\n";
		}
	}

	# TEST 3.8
	my $xd = $form->{entryXVideoDriver}->get_text();
	if ( $v gt '4' && ! $xd ) {
			$error_found = TRUE;
			$error_msg .= "You must specify a video driver with X > 4.\n";
		}
		
	# error mgmt
	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->x_version($v);

	$model->x_font_server_enabled($xfse);
	$model->x_font_server_name($xfs);
	$model->x_font_server_port($port);

	$model->x_driver($xd);

	if ( $cm ) {
		$model->x_video_mode_custom(TRUE);
		$model->x_video_mode_custom_x($cx);
		$model->x_video_mode_custom_y($cy);
		$model->x_video_mode_custom_modeline($ml);
	}

	my @vm;
	foreach my $v (sort {
			warn "comparing $a <=> $b" if $DEBUG;
			return -1 if $b eq 'Custom';
			return 1 if $a eq 'Custom';
			$b <=> $a}
			keys %vm) {
		if ( $v ne 'Custom' ) {
			push @vm, "\"${v}x$m{$v}\"";
			warn "pushing \"${v}x$m{$v}\"" if $DEBUG > 2;
		}
		else {
			push @vm, "\"" . $model->x_video_mode_custom_x() . "x" .
				$model->x_video_mode_custom_y() . "\"";
			warn "pushing \"" . $model->x_video_mode_custom_x() . "x" .
				$model->x_video_mode_custom_y() . "\"" if $DEBUG > 2;
		}
	}
	$model->x_video_modes(\@vm);

	$model->x_monitor_autodetect_enabled($xmae);
	$model->x_horizontal_sync($xhs);
	$model->x_vertical_refresh($xvr);
	
	$model->x_option_noaccel(
		$form->{checkbuttonXOptionNoAccel}->get_active()?TRUE:FALSE);
	$model->x_option_no_hw_cursor(
		$form->{checkbuttonXOptionNoHwCursor}->get_active()?TRUE:FALSE);
	$model->x_option_dont_zap(
		$form->{checkbuttonXOptionDontZap}->get_active()?TRUE:FALSE);
	$model->x_screensaver_disabled(
		$form->{checkbuttonXScreensaverDisabled}->get_active()?TRUE:FALSE);
	$model->x_extra_options($form->{entryXExtraOptions}->get_text());

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardXWindows_next

#
# LOCAL
#
sub on_druidpagestandardLOCAL_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLOCAL_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardLOCAL_back

sub on_druidpagestandardLOCAL_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLOCAL_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardLOCAL_next

sub on_druidpagestandardLOCAL_prepare {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_druidpagestandardLOCAL_prepare";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

} # End of sub on_druidpagestandardLOCAL_prepare

#
# LTSP
#
sub on_druidpagestandardLTSP_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLTSP_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	warn "LTSP_back: $me $object" if $DEBUG > 1;
	if ( ! $model->x_sessions('selected') ) {
		$form->{druid}->set_page($form->{'druidpagestandardSession'});
	}
	else {
		$form->{druid}->set_page($form->{
			find_selected_druid_page_to_go($me, $object)->name()});
	}

	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardLTSP_back

sub on_druidpagestandardLTSP_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLTSP_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	my $o;
	if ( $form->{radiobuttonLTSPASKServerAndRoot}->get_active() ) {
		$o = 'ask';
	}
	elsif ( $form->{radiobuttonLTSPDHCPServerAndRoot}->get_active() ) {
		$o = 'dhcp';
	}
	elsif ( $form->{radiobuttonLTSPPXESServerAndRoot}->get_active() ) {
		$o = 'pxes';
	}
		
	if ( ! $o ) {
		$error_found = TRUE;
		$error_msg .= "Internal error.\n";
	}

	my $s = $form->{entryLTSPServerName}->get_text();
	my $d = $form->{entryLTSPRootDirectory}->get_text();

	if ( $o eq 'pxes' ) {
		if ( ! ($s && $d) ) {
			$error_found = TRUE;
			$error_msg .= "Server and directory cannot be null.\n";
		}
	}
			
	# error mgmt
	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->ltsp_server_and_root($o);
	$model->ltsp_server_name($s);
	$model->ltsp_root_directory($d);

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardLTSP_next

sub on_druidpagestandardLTSP_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLTSP_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $o = uc($model->ltsp_server_and_root());
	$form->{'radiobuttonLTSP' . $o . 'ServerAndRoot'}->set_active(TRUE)
		if $o;

	$form->{entryLTSPServerName}->set_text(
		$model->ltsp_server_name() || "");
	$form->{entryLTSPRootDirectory}->set_text(
		$model->ltsp_root_directory() || "");
} # End of sub on_druidpagestandardLTSP_prepare

#
# TELNET
#
sub on_druidpagestandardTELNET_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardTELNET_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{checkbuttonTELNETAskEnabled}->set_active(
		$model->telnet_ask_enabled());
	$form->{entryTELNETServerName}->set_text(
		$model->telnet_server_name() || "");
	$form->{spinbuttonTELNETPort}->set_value(
		$model->telnet_port());

} # End of sub on_druidpagestandardTELNET_prepare

sub on_druidpagestandardTELNET_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardTELNET_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( ! $model->x_sessions('selected') ) {
		$form->{druid}->set_page($form->{'druidpagestandardSession'});
	}
	else {
		$form->{druid}->set_page($form->{
			find_selected_druid_page_to_go($me, $object)->name()});
	}

	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardTELNET_back

sub on_druidpagestandardTELNET_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardTELNET_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# TEST 11.1
	die "Internal error"
		unless $model->session_telnet();

	# TEST 11.2
	my $a = $form->{checkbuttonTELNETAskEnabled}->get_active() ? TRUE :
		FALSE;
	my $server = $form->{entryTELNETServerName}->get_text();
	if ( ! $a ) {
		if ( ! $server || $server eq '' ) {
			$error_found = TRUE;
			$error_msg .= "Server cannot be null.\n";
		}
		else {
			# TEST 11.2.1
			if ( ! seems_host_or_ip($server) ) {
				$error_found = TRUE;
				$error_msg .= "The server '$server' does not appear to " .
					"be a valid hostname or IP address.\n";
			}
		}
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->telnet_ask_enabled($a);
	$model->telnet_server_name($form->{entryTELNETServerName}->get_text());
	$model->telnet_port($form->{spinbuttonTELNETPort}->get_value_as_int());
	
	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardTELNET_next

#
# LINRDP
#
sub on_druidpagestandardLINRDP_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLINRDP_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{checkbuttonLINRDPAskEnabled}->set_active(
		$model->linrdp_ask_enabled());
	$form->{entryLINRDPServerName}->set_text(
		$model->linrdp_server_name() || "");
	$form->{spinbuttonLINRDPPort}->set_value(
		$model->linrdp_port());
	$form->{entryLINRDPDomain}->set_text(
		$model->linrdp_domain() || "");
	$form->{entryLINRDPUser}->set_text(
		$model->linrdp_user() || "");
	$form->{entryLINRDPPassword}->set_text(
		$model->linrdp_password() || "");

	$form->{checkbuttonLINRDPFullScreen}->set_active(
		$model->linrdp_is_full_screen());
	$form->{comboLINRDPGeometry}->entry()->set_text(
		$model->linrdp_geometry() || "");
	$form->{"radiobuttonLINRDPColor" .
		$model->linrdp_depth()}->set_active(TRUE);

	$form->{checkbuttonLINRDPSoundEnabled}->set_active(
		$model->linrdp_sound_enabled());
	$form->{spinbuttonLINRDPSoundQuality}->set_value(
		$model->linrdp_sound_quality());

	$form->{checkbuttonLINRDPStartProgramEnabled}->set_active(
		$model->linrdp_start_program_enabled());
	$form->{entryLINRDPStartProgram}->set_text(
		$model->linrdp_start_program() || "");
	$form->{entryLINRDPStartProgramFolder}->set_text(
		$model->linrdp_start_program_folder() || "");
} # End of sub on_druidpagestandardLINRDP_prepare

sub on_druidpagestandardLINRDP_back {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_druidpagestandardLINRDP_back";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardLINRDP_back

sub on_druidpagestandardLINRDP_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardLINRDP_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	# TEST 10.1
	die "Internal error"
		unless $model->x_session_linrdp();

	# TEST 10.2
	my $a = $form->{checkbuttonLINRDPAskEnabled}->get_active() ? TRUE :
		FALSE;
	my $server = $form->{entryLINRDPServerName}->get_text();
	if ( ! $a ) {
		if ( ! $server || $server eq '' ) {
			$error_found = TRUE;
			$error_msg .= "Server cannot be null.\n";
		}
		else {
			# TEST 10.2.1
			if ( ! seems_host_or_ip($server) ) {
				$error_found = TRUE;
				$error_msg .= "The server '$server' does not appear to " .
					"be a valid hostname or IP address.\n";
			}
		}
	}

	# TEST 10.3
	# implicit by signals

	# TEST 10.4
	my $f = $form->{checkbuttonLINRDPFullScreen}->get_active() ? TRUE :
		FALSE;
	my $g = $form->{comboLINRDPGeometry}->entry()->get_text();
	if ( ! $f && ! $g ) {
		$error_found = TRUE;
		$error_msg .= "Geometry cannot be null or you must select " .
			"full screen.\n";
	}

	# TEST 10.5
	my $spe =
		$form->{checkbuttonLINRDPStartProgramEnabled}->get_active() ?
			TRUE : FALSE;
	my $sp = $form->{entryLINRDPStartProgram}->get_text();
	my $spf = $form->{entryLINRDPStartProgramFolder}->get_text();

	if ( $spe && ! $sp ) {
		$error_found = TRUE;
		$error_msg .= "Start Program cannot be null if you select " .
			"Start Program Enabled.\n";
	}

	# TEST 10.6
	my $sq = $form->{spinbuttonLINRDPSoundQuality}->get_value_as_int();
	if ( $sq <=0 || $sq > 3 ) {
		$error_found = TRUE;
		$error_msg .= "Sound quality should be 0 < q <= 3\n";
	}
		
	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->linrdp_ask_enabled($a);
	$model->linrdp_server_name($form->{entryLINRDPServerName}->get_text());
	$model->linrdp_port($form->{spinbuttonLINRDPPort}->get_value_as_int());
	$model->linrdp_domain($form->{entryLINRDPDomain}->get_text());
	$model->linrdp_user($form->{entryLINRDPUser}->get_text());
	$model->linrdp_password($form->{entryLINRDPPassword}->get_text());

	$model->linrdp_is_full_screen($f);
	$model->linrdp_geometry($g);

	foreach my $c (24, 16, 15, 8) {
		if ( $form->{"radiobuttonLINRDPColor" . $c}->get_active() ) {
			$model->linrdp_depth($c);
			last;
		}
	}

	$model->linrdp_sound_enabled(
		$form->{checkbuttonLINRDPSoundEnabled}->get_active() ? TRUE :
			FALSE);
	$model->linrdp_sound_quality(
		$form->{spinbuttonLINRDPSoundQuality}->get_value_as_int());

	$model->linrdp_start_program_enabled($spe);
	$model->linrdp_start_program($sp);
	$model->linrdp_start_program_folder($spf);
	
	# FIXME
	# Is supermount realy needed by LINRDP
	# and samba ?
	#if ( $model->local_floppy_enabled() || 
	#		$model->local_dvdcdrom_enabled() ||
	#		$model->local_harddisk_enabled() ) {
	#	$model->supermount_enabled(TRUE);
	#}

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardLINRDP_next


#
# General
#
sub on_druidpagestandardGeneral_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardGeneral_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{checkbuttonGeneralDebug}->set_active($model->pxes_debug());
	$form->{checkbuttonGeneralPromptBeforeX}->set_active(
		$model->prompt_before_x());
	$form->{checkbuttonGeneralPromptBeforeClient}->set_active(
		$model->prompt_before_client());
	$form->{checkbuttonGeneralWaitOnError}->set_active(
		$model->wait_on_error());

	$form->{checkbuttonGeneralShell}->set_active(
		($model->inittab_shell_action() ne 'off'));
	$form->{checkbuttonGeneralLoginShell}->set_active(
		($model->inittab_login_action() ne 'off'));
	$form->{checkbuttonGeneralTelnetServer}->set_active(
		$model->local_telnetd_enabled());

	if ( $model->check_privileges() ) {
		# Set root password if privileged
		$form->{checkbuttonGeneralRootPassword}->set_active(
			$model->local_set_root_password());
		$form->{entryGeneralRootPassword}->set_text(
			($model->root_password()));
	}
	else {
		$model->local_set_root_password(FALSE);
		$form->{checkbuttonGeneralRootPassword}->set_active(
			$model->local_set_root_password());
		$form->{checkbuttonGeneralRootPassword}->set_sensitive(FALSE);
	}

	$form->{checkbuttonGeneralHttpServer}->set_active(
		$model->local_httpd_enabled());

	$form->{hscaleGeneralBootMessagesLevel}->get_adjustment()->set_value(
		$model->boot_messages() || 0);

	$form->{checkbuttonGeneralEnableRemoteConfiguration}->set_active(
		$model->remote_configuration_enabled());
	my $cs = $model->configuration_server_name();
	$form->{entryGeneralConfigurationServerName}->set_text($cs)
		if defined($cs);
	my $cd = $model->configuration_directory();
	$form->{entryGeneralConfigurationDirectory}->set_text($cd)
		if defined($cd);

} # End of sub on_druidpagestandardGeneral_prepare

sub on_druidpagestandardGeneral_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardGeneral_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardGeneral_back

sub on_druidpagestandardGeneral_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardGeneral_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;
	my $error_found = FALSE;
	my $error_msg = '';

	my $d = $form->{checkbuttonGeneralDebug}->get_active();
	my $sx = $form->{checkbuttonGeneralPromptBeforeX}->get_active();
	my $bc = $form->{checkbuttonGeneralPromptBeforeClient}->get_active();
	my $we = $form->{checkbuttonGeneralWaitOnError}->get_active();
	my $sa = $form->{checkbuttonGeneralShell}->get_active();
	my $la = $form->{checkbuttonGeneralLoginShell}->get_active();
	my $ta = $form->{checkbuttonGeneralTelnetServer}->get_active();
	my $ha = $form->{checkbuttonGeneralHttpServer}->get_active();

	my $bm =
		$form->{hscaleGeneralBootMessagesLevel}->get_adjustment()->get_value();
	my $rc = $form->{checkbuttonGeneralEnableRemoteConfiguration}->
		get_active();
	my $cs = $form->{entryGeneralConfigurationServerName}->get_text();
	my $cd = $form->{entryGeneralConfigurationDirectory}->get_text();

	if ( $rc ) {
		# TEST 7.1
		if ( ! $cs || $cs eq '' ) {
			$error_found = TRUE;
			$error_msg .= "Server cannot be null.\n";
		}

		# TEST 7.1.1
		if ( ! seems_host_or_ip($cs) ) {
			$error_found = TRUE;
			$error_msg .= "The server '$cs' does not appear to " .
		 		"be a valid hostname or IP address.\n";
		}
	
		# TEST 7.2
		if ( $cd !~ /^[\S]+$/ ) {
			$error_found = TRUE;
			$error_msg .= "The directory '$cd' does not appear to " .
		 		"be a valid directory name.\n";
		}
	}

	if ( $error_found ) {
		my_message_box('error', $error_msg);
		return DRUID_DONT_CHANGE_PAGE;
	}

	$model->pxes_debug($d ? TRUE : FALSE);

	$model->prompt_before_x($sx ? TRUE : FALSE);
	$model->prompt_before_client($bc ? TRUE : FALSE);
	$model->wait_on_error($we ? TRUE : FALSE);

	$model->inittab_shell_action($sa);
	$model->inittab_login_action($la);


	$model->local_set_root_password(
		$form->{checkbuttonGeneralRootPassword}->get_active() ? TRUE :
			FALSE);
	$model->root_password(
		$form->{entryGeneralRootPassword}->get_text());

	$model->local_telnetd_enabled($ta ? TRUE : FALSE);
	$model->local_httpd_enabled($ha ? TRUE : FALSE);

	$model->boot_messages($bm);

	$model->remote_configuration_enabled($rc ? TRUE : FALSE);
	$model->configuration_server_name($cs);
	$model->configuration_directory($cd);

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardGeneral_next

#
# Session
#
sub on_druidpagestandardSession_prepare {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardSession_prepare";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $d = uc($model->session_default());
	warn "setting default session as $d" if $DEBUG > 2;
	$form->{'radiobuttonSession' . $d}->set_active(TRUE);


	foreach my $s (keys %{$model->sessions()}) {
		my $S = uc($s);

		warn "setting session $S as ",
			$model->session_by_name($s) ? "ACTIVE" : "INACTIVE"
			if $DEBUG > 0;

		$form->{'checkbuttonSession' . $S}->set_active(
			$model->session_by_name($s));

		if ( ! $model->initialize() ) {
			if ( ! $model->session_by_name($s) ) {
				$form->{'checkbuttonSession' . $S}->set_sensitive(FALSE);
				$form->{'radiobuttonSession' . $S}->set_sensitive(FALSE);
				$form->{'pixmapSession' . $S}->set_sensitive(FALSE);
				$form->{'labelSession' . $S}->set_sensitive(FALSE);
			}
		}
	}

	return DRUID_CHANGE_PAGE;
} # End of sub on_druidpagestandardSession_prepare

sub on_druidpagestandardSession_back {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardSession_back";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	return DRUID_CHANGE_PAGE;
}

sub on_druidpagestandardSession_next {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_druidpagestandardSession_next";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	foreach my $s (keys %{$model->sessions()}) {
		my $S = uc($s);

		my $a =
			$form->{'checkbuttonSession'.$S}->get_active()?TRUE:FALSE;
		my $d =
			$form->{'radiobuttonSession'.$S}->get_active()?TRUE:FALSE;

		my $x = '';
		my $t = $model->sessions()->{$s};
		$x = 'x_' if ( $t == XA || $t == XI );
		eval '$model->' . $x . "session_$s($a)";
		$model->session_default($s) if $d;
		#
		# FIXME
		# There's no such page yet
		#
		#warn "s=$s";
		if ( $s ne 'nx' && $s ne 'tarantella' && $s ne 'winconnect' &&
				$s ne 'custom' ) {
			find_druid_page_by_name('druidpagestandard'.$S)->selected($a);
		}
	}

	$form->{druid}->set_page($form->{
		find_selected_druid_page_to_go($me, $object)->name()});
	# we have changed the page already
	return DRUID_DONT_CHANGE_PAGE;
} # End of sub on_druidpagestandardSession_next


#======================================================================
# buttons
#======================================================================
sub on_buttonICARunNow_clicked {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_buttonICARunNow_clicked";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $wfcmgr = $form->{entryICAConfigurationManager}->get_text();

	if ( ! $wfcmgr ) {
		my_message_box('error', "wfcmgr not defined");
		return;
	}

	if ( $wfcmgr !~ m@/@ ) {
		$wfcmgr = $form->{entryICAInstallationDirectory}->get_text() .
			'/' . $wfcmgr;
	}

	if ( ! -x $wfcmgr ) {
		my_message_box('error', "Cannot execute $wfcmgr");
		return;
	}

	my $err = `$wfcmgr`;

	if ( $? ) {
		my_message_box('error', $err);
		return;
	}

	return;
} # End of sub on_buttonICARunNow_clicked

sub on_buttonICARefresh_clicked {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_buttonICARefresh_clicked";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $appsrv = $form->{entryICAApplicationServers}->get_text();

	if ( ! $appsrv ) {
		my_message_box('error', "Server configuration not defined");
		return;
	}

	if ( ! -r $appsrv ) {
		my_message_box('error', "Cannot read $appsrv");
		return;
	}

	$model->local_ica_application_servers_ini($appsrv);
	my @servers = @{$model->ica_server_list()};

	if ( ! @servers ) {
		my_message_box('error', "Reading server configuration");
		return;
	}

	$form->{comboICAServerName}->set_popdown_strings(@servers);
} # End of sub on_buttonICARefresh_clicked

sub on_buttonXMonitorDB_clicked {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_buttonXMonitorDB_clicked";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	$active_dialog = new DialogMonitorDB();

	# Initialize list
	my @a = $model->monitors();
	$active_dialog->initialize_list($model->monitors());

	$active_dialog->TOPLEVEL->show();
} # End sub on_buttonXMonitorDB_clicked

#======================================================================
# fileentries
#======================================================================
sub on_fileentryICAConfigurationManager_browse_clicked {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_fileentryICAConfigurationManager_browse_clicked";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	$form->{fileentryICAConfigurationManager}->set_default_path(
		$form->{entryICAInstallationDirectory}->get_text());
} # End of sub on_fileentryICAConfigurationManager_browse_clicked

#======================================================================
# entries
#======================================================================
sub on_entryLocalDevicesMouseDevice_changed {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_entryLocalDevicesMouseDevice_changed";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $t = $form->{$object}->get_text();
	my $s = ( $t ne 'Autodetect' );

	$form->{comboLocalDevicesMouseProtocol}->set_sensitive($s);
	$form->{checkbuttonLocalDevicesEnableMouseWheel}->set_sensitive($s);

	warn "t=$t s=$s" if $DEBUG > 1;
} # End of sub on_entryLocalDevicesMouseDevice_changed

sub on_entryLocalDevicesNetworkCard_changed {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_entryLocalDevicesNetworkCard_changed";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $t = $form->{$object}->get_text();
	my $s = ( $t ne 'Autodetect' );

	$form->{labelLocalDevicesNetworkCardOptions}->set_sensitive($s);
	$form->{entryLocalDevicesNetworkCardOptions}->set_sensitive($s);
} # End of sub on_entryLocalDevicesNetworkCard_changed

sub on_entryOLDSoundCard_changed {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_entryOLDSoundCard_changed";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $t = $form->{$object}->get_text();
	my $s = ( $t ne 'Autodetect' );

	$form->{labelOLDSoundCardOptions}->set_sensitive($s);
	$form->{entryOLDSoundCardOptions}->set_sensitive($s);
} # End of sub on_entryLocalDevicesNetworkCard_changed


#======================================================================
# check buttons
#======================================================================
sub on_checkbuttonKINBI_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonKINBI_toggled";
   # Get ref to hash of all widgets on our form
	my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelKINBI}->set_sensitive($s);
	$form->{fileentryKINBI}->set_sensitive($s);
} # End of sub on_checkbuttonKINBI_toggled

sub on_checkbuttonKIISO_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonKIISO_toggled";
   # Get ref to hash of all widgets on our form
	my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;

	###############
	# FIXME
	if ( $s && ! $DEBUG ) {
		if ( ! $model->check_privileges() ) {
			my_message_box('error', "There are some privileged " .
				"operations in order to build an ISO image.\n" .
				"Please login as root.\n" .
				"FYI: You are loged as '" .
					$model->login() .
					"'.");
			$form->{$object}->set_active(FALSE);
			return;
		}
	}

	$form->{labelKIISO}->set_sensitive($s);
	$form->{fileentryKIISO}->set_sensitive($s);
} # End of sub on_checkbuttonKIISO_toggled

sub on_checkbuttonKIInitialize_toggled {
	my ($class, $data, $object, $instance, $event) = @_;
	my $me = __PACKAGE__."->on_checkbuttonKIInitialize_toggled";
	# Get ref to hash of all widgets on our form
	my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( $form->{'checkbuttonKIInitialize'}->get_active() ) {
		if ( ! $model->check_privileges() ) {
			my_message_box('error', "There are some privileged " .
				"operations in order to build a new filesystem image.\n" .
				"Please login as root.\n" .
				"FYI: You are loged as '" .
				$model->login() .
				"'.");
			$form->{'checkbuttonKIInitialize'}->set_active(FALSE);
			return;
		}
			
		my_message_box('warning', 'The current contents of you initial ' .
			'ram disk will be destroyed.');

		# FIXME
		# impossible to read configuration from a destroyed filesystem
		# maybe you want to read the configuration and then destroy the
		# filesystem ?
		$form->{checkbuttonKIReadConfiguration}->set_active(FALSE);

		$form->{labelKIKernelArch}->set_sensitive(TRUE);
		$form->{radiobuttonKIArch_i386}->set_sensitive(TRUE);
		$form->{radiobuttonKIArch_i486}->set_sensitive(TRUE);
		$form->{radiobuttonKIArch_i586}->set_sensitive(TRUE);
		$form->{radiobuttonKIArch_i686}->set_sensitive(TRUE);
		$form->{radiobuttonKIArch_viac3}->set_sensitive(TRUE);
		$form->{labelKIKernel}->set_sensitive(TRUE);
		$form->{fileentryKIKernel}->set_sensitive(TRUE);
	}
	else {
		# restore the model value before going insensitive
		my $ka = $model->kernel_arch();
		$form->{"radiobuttonKIArch_$ka"}->set_active(TRUE);
		$form->{labelKIKernelArch}->set_sensitive(FALSE);
		$form->{radiobuttonKIArch_i386}->set_sensitive(FALSE);
		$form->{radiobuttonKIArch_i486}->set_sensitive(FALSE);
		$form->{radiobuttonKIArch_i586}->set_sensitive(FALSE);
		$form->{radiobuttonKIArch_i686}->set_sensitive(FALSE);
		$form->{radiobuttonKIArch_viac3}->set_sensitive(FALSE);
		$form->{labelKIKernel}->set_sensitive(FALSE);
		$form->{fileentryKIKernel}->set_sensitive(FALSE);
	}
} # End of sub on_checkbuttonInitialize_toggled

sub on_checkbuttonOLDEnablePrinter_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonOLDEnablePrinter_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	print STDERR "on_checkbuttonOLDEnablePrinter_toggled\n"
		if $DEBUG > 3;
	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelOLDPrinterDevice}->set_sensitive($s);
	$form->{comboOLDPrinterDevice}->set_sensitive($s);
	$form->{labelOLDPrinterPort}->set_sensitive($s);
	$form->{spinbuttonOLDPrinterPort}->set_sensitive($s);
} # End of sub on_checkbuttonOLDEnablePrinter_toggled

sub on_checkbuttonOLDEnableSound_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonOLDEnableSound_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelOLDSoundCard}->set_sensitive($s);
	$form->{comboOLDSoundCard}->set_sensitive($s);
	$form->{checkbuttonOLDEnableESD}->set_sensitive($s);
	my $t = $form->{entryOLDSoundCard}->get_text();
	$s &&= ( $t ne 'Autodetect' );
	$form->{labelOLDSoundCardOptions}->set_sensitive($s);
	$form->{entryOLDSoundCardOptions}->set_sensitive($s);
} # End of sub on_checkbuttonOLDEnableSound_toggled

sub on_checkbuttonXEnableFontServer_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonXEnableFontServer_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelXFontServerName}->set_sensitive($s);
	$form->{entryXFontServerName}->set_sensitive($s);
	$form->{labelXFontServerPort}->set_sensitive($s);
	$form->{spinbuttonXFontServerPort}->set_sensitive($s);
} # End of sub on_checkbuttonXEnableFontServer_toggled

sub on_checkbuttonXEnableMonitorAutodetect_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonXEnableMonitorAutodetect_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelXHorizontalSync}->set_sensitive(! $s);
	$form->{comboXHorizontalSync}->set_sensitive(! $s);
	$form->{labelXHorizontalSyncUnits}->set_sensitive(! $s);
	$form->{labelXVerticalRefresh}->set_sensitive(! $s);
	$form->{comboXVerticalRefresh}->set_sensitive(! $s);
	$form->{labelXVerticalRefreshUnits}->set_sensitive(! $s);
	$form->{buttonXMonitorsDB}->set_sensitive(! $s);

} # End of sub on_checkbuttonXEnableMonitorAutodetect_toggled

sub on_checkbuttonRDPFullScreen_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonRDPFullScreen_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelRDPGeometry}->set_sensitive(!$s);
	$form->{comboRDPGeometry}->set_sensitive(!$s);
} # End of sub on_checkbuttonRDPFullScreen_toggled

sub on_checkbuttonRDPStartProgramEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonRDPStartProgramEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active();
	$form->{labelRDPStartProgram}->set_sensitive($s);
	$form->{entryRDPStartProgram}->set_sensitive($s);
	$form->{labelRDPStartProgramFolder}->set_sensitive($s);
	$form->{entryRDPStartProgramFolder}->set_sensitive($s);

} # End of sub on_checkbuttonRDPStartProgramEnabled_toggled

sub on_checkbuttonVNCFullScreen_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonVNCFullScreen_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelVNCGeometry}->set_sensitive(!$s);
	$form->{comboVNCGeometry}->set_sensitive(!$s);
} # End of sub on_checkbuttonVNCFullScreen_toggled

sub on_checkbuttonGeneralEnableRemoteConfiguration_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonGeneralEnableRemoteConfiguration_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active();
	$form->{labelGeneralConfigurationServerName}->set_sensitive($s);
	$form->{entryGeneralConfigurationServerName}->set_sensitive($s);
	$form->{labelGeneralConfigurationDirectory}->set_sensitive($s);
	$form->{entryGeneralConfigurationDirectory}->set_sensitive($s);
} # End of sub on_checkbuttonGeneralEnableRemoteConfiguration_toggled

sub on_checkbuttonXVideoMode_Custom_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonXVideoMode_Custom_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $s = $form->{$object}->get_active();
	$form->{entryXVideoModeCustomX}->set_sensitive($s);
	$form->{labelXVideoModeX}->set_sensitive($s);
	$form->{entryXVideoModeCustomY}->set_sensitive($s);
	$form->{labelXVideoModeCustomModeline}->set_sensitive($s);
	$form->{entryXVideoModeCustomModeline}->set_sensitive($s);

	if ( $s ) {
		$form->{entryXVideoModeCustomX}->set_text(
			$model->x_video_mode_custom_x());
		$form->{entryXVideoModeCustomY}->set_text(
			$model->x_video_mode_custom_y());
		$form->{entryXVideoModeCustomModeline}->set_text(
			$model->x_video_mode_custom_modeline());
	}
} # End of sub on_checkbuttonXVideoMode_Custom_toggled

sub on_checkbuttonXDMAskEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonXDMAskEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = ! $form->{$object}->get_active();
	$form->{radiobuttonXDMDirect}->set_sensitive($s);
	$form->{radiobuttonXDMIndirect}->set_sensitive($s);
	$form->{radiobuttonXDMBroadcast}->set_sensitive($s);
	$form->{labelXDMServerName}->set_sensitive($s);
	$form->{entryXDMServerName}->set_sensitive($s);
	$form->{labelXDMServerPort}->set_sensitive($s);
	$form->{spinbuttonXDMServerPort}->set_sensitive($s);

	if ( $s ) {
		coordinate_XDM_widgets($form);
	}

} # End of sub on_checkbuttonXDMAskEnabled_toggled

sub on_checkbuttonRDPAskEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonRDPAskEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = ! $form->{$object}->get_active();
	$form->{labelRDPServerName}->set_sensitive($s);
	$form->{entryRDPServerName}->set_sensitive($s);
	$form->{labelRDPDomain}->set_sensitive($s);
	$form->{entryRDPDomain}->set_sensitive($s);
	$form->{labelRDPUser}->set_sensitive($s);
	$form->{entryRDPUser}->set_sensitive($s);
	$form->{labelRDPPassword}->set_sensitive($s);
	$form->{entryRDPPassword}->set_sensitive($s);
} # End of sub on_checkbuttonRDPAskEnabled_toggled

sub on_checkbuttonVNCAskEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonVNCAskEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = ! $form->{$object}->get_active();
	$form->{labelVNCServerName}->set_sensitive($s);
	$form->{entryVNCServerName}->set_sensitive($s);
	$form->{labelVNCDisplay}->set_sensitive($s);
	$form->{spinbuttonVNCDisplay}->set_sensitive($s);
} # End of sub on_checkbuttonVNCAskEnabled_toggled

sub on_checkbuttonICAAskEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonICAAskEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = ! $form->{$object}->get_active();
	$form->{labelICAServerName}->set_sensitive($s);
	$form->{entryICAServerName}->set_sensitive($s);
	$form->{buttonICARefresh}->set_sensitive($s);
} # End of sub on_checkbuttonICAAskEnabled_toggled

sub on_checkbuttonLINRDPAskEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonLINRDPAskEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = ! $form->{$object}->get_active();
	$form->{labelLINRDPServerName}->set_sensitive($s);
	$form->{comboLINRDPServerName}->set_sensitive($s);
	$form->{labelLINRDPPort}->set_sensitive($s);
	$form->{spinbuttonLINRDPPort}->set_sensitive($s);
	$form->{labelLINRDPUser}->set_sensitive($s);
	$form->{entryLINRDPUser}->set_sensitive($s);
	$form->{labelLINRDPPassword}->set_sensitive($s);
	$form->{entryLINRDPPassword}->set_sensitive($s);
	$form->{labelLINRDPDomain}->set_sensitive($s);
	$form->{entryLINRDPDomain}->set_sensitive($s);

} # End of sub on_checkbuttonLINRDPAskEnabled_toggled

sub on_checkbuttonLINRDPFullScreen_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonLINRDPFullScreen_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelLINRDPGeometry}->set_sensitive(!$s);
	$form->{comboLINRDPGeometry}->set_sensitive(!$s);
} # End of sub on_checkbuttonLINRDPFullScreen_toggled

sub on_checkbuttonLINRDPSoundEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonLINRDPSoundEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active() ? TRUE : FALSE;
	$form->{labelLINRDPSoundQuality}->set_sensitive($s);
	$form->{spinbuttonLINRDPSoundQuality}->set_sensitive($s);
} # End of sub on_checkbuttonLINRDPSoundEnabled_toggled


sub on_checkbuttonLINRDPStartProgramEnabled_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonLINRDPStartProgramEnabled_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	my $s = $form->{$object}->get_active();
	$form->{labelLINRDPStartProgram}->set_sensitive($s);
	$form->{entryLINRDPStartProgram}->set_sensitive($s);
	$form->{labelLINRDPStartProgramFolder}->set_sensitive($s);
	$form->{entryLINRDPStartProgramFolder}->set_sensitive($s);

} # End of sub on_checkbuttonLINRDPStartProgramEnabled_toggled

sub on_checkbuttonSession_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonSession_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $rn = $object;
	$rn =~ s/^checkbutton/radiobutton/;

	my $cs = $form->{$object}->get_active();
	my $rs = $form->{$rn}->get_active();

	if ( ! $cs && $rs ) {
		my_message_box('error', "Default session type cannot be " .
			"excluded from final image.\n" .
			"Change the default image first.");
		$form->{$object}->set_active(TRUE);
		return FALSE;
	}

	return TRUE;
} # End of sub on_checkbuttonSession_toggled

sub on_checkbuttonGeneralRootPassword_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_checkbuttonGeneralRootPassword_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $s = $form->{$object}->get_active();
	$form->{labelGeneralRootPassword}->set_sensitive($s);
	$form->{entryGeneralRootPassword}->set_sensitive($s);

	return TRUE;
} # End of sub on_checkbuttonSession_toggled

#======================================================================
# radio buttons
#======================================================================
sub on_radiobuttonKIArch_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonKIArch_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( $form->{$object}->get_active() ) {
		$object =~ /_([^_]+)$/;
		my $ka = $1;
		my $k = $model->find_kernel($ka);
		if ( defined($k) && $k ) {
			$form->{entryKIKernel}->set_text($k);
		}
		else {
			my_message_box('error', $model->error_message());
		}
	}
} # End of sub on_radiobuttonKIArch_toggled

sub on_radiobuttonXDM_toggled {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_radiobuttonXDM_toggled";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

	if ( $form->{$object}->get_active() ) {
		coordinate_XDM_widgets($form);
	}

} # End of sub on_radiobuttonXDM_toggled

sub on_radiobuttonSession_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonSession_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	my $cn = $object;
	$cn =~ s/^radiobutton/checkbutton/;

	$form->{$cn}->set_active(TRUE)
		if $form->{$object}->get_active();

	return TRUE;
} # End of sub on_checkbuttonSession_toggled

sub on_radiobuttonXVersion336_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonXVersion336_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( $form->{$object}->get_active() ) {
		# 3.3.6 selected
		$form->{frameXVideoHardware}->set_sensitive(FALSE);
		$form->{comboXVideoDriver}->set_sensitive(FALSE);
		$form->{labelXVideoDriver}->set_sensitive(FALSE);
		$model->x_monitor_autodetect_enabled(FALSE);
		$form->{checkbuttonXEnableMonitorAutodetect}->set_active(FALSE);
		$form->{checkbuttonXEnableMonitorAutodetect}->set_sensitive(FALSE);
	}
} # End of sub on_radiobuttonXVersion336_toggled

sub on_radiobuttonXVersion430_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonXVersion430_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

	if ( $form->{$object}->get_active() ) {
		# 4.3.0 selected
		$form->{frameXVideoHardware}->set_sensitive(TRUE);
		$form->{comboXVideoDriver}->set_sensitive(TRUE);
		$form->{labelXVideoDriver}->set_sensitive(TRUE);
		$form->{checkbuttonXEnableMonitorAutodetect}->set_sensitive(TRUE);
	}
} # End of sub on_radiobuttonXVersion430_toggled

sub on_radiobuttonRDPRdesktopVersion110_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonRDPRdesktopVersion110_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

} # End of sub on_radiobuttonRDPRdesktopVersion110_toggled

sub on_radiobuttonRDPRdesktopVersion120_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonRDPRdesktopVersion120_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $model = $Pxesconfig::MODEL;

} # End of sub on_radiobuttonRDPRdesktopVersion120_toggled

sub on_radiobuttonLTSPServerAndRoot_toggled {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_radiobuttonLTSPServerAndRoot_toggled";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	if ( $form->{$object}->get_active() ) {
		my $s = ( $object eq 'radiobuttonLTSPPXESServerAndRoot' );
		$form->{labelLTSPServerName}->set_sensitive($s);
		$form->{entryLTSPServerName}->set_sensitive($s);
		$form->{labelLTSPRootDirectory}->set_sensitive($s);
		$form->{entryLTSPRootDirectory}->set_sensitive($s);
	}

} # End of sub on_radiobuttonLTSPServerAndRoot_toggled

#======================================================================
#=== Other methods
#======================================================================

sub coordinate_XDM_widgets($) {
	my $form = shift;

	if ( $form->{'radiobuttonXDMBroadcast'}->get_active() ) {
		$form->{labelXDMServerName}->set_sensitive(FALSE);
		$form->{entryXDMServerName}->set_sensitive(FALSE);
	}
	else {
		$form->{labelXDMServerName}->set_sensitive(TRUE);
		$form->{entryXDMServerName}->set_sensitive(TRUE);
	}
}

sub my_message_box($$) {
	my ($type, $msg) = @_;
	my $model = $Pxesconfig::MODEL;

	if ( $type ne 'warning' && $type ne 'error' &&
			$type ne 'info' && $type ne 'question' ) {
		die "Bad argument '$type'";
	}

	my $nw = $model->no_warnings();
	if ( $type eq 'warning' && $nw ) {
		return;
	}

	my @b = ('Button_Ok');
	my @args = (_($msg), $type);

	if ( $type eq 'question' ) {
		$b[0] = 'Button_No';
		$b[1] = 'Button_Yes';
	}

	foreach my $b (@b) {
		push(@args, $b);
	}
	
	my $mb = new Gnome::MessageBox(@args);

	$mb->set_modal(TRUE);
	$mb->run();
}

sub x_video_mode_activate_checkbutton($$) {
	my ($form, $m) = @_;

	# eat "
	$m =~ s/"//g;
	my ($x, $y) = split(/x/, $m);
	my $cb = 'checkbuttonXVideoMode_' . $x;

	if ( exists($form->{$cb}) ) {
		$form->{$cb}->set_active(TRUE);
	}
	else {
		warn "$cb checkbutton doesn't exist, custom resolution ?"
			if $DEBUG;
		$form->{'checkbuttonXVideoMode_Custom'}->set_active(TRUE);
	}
}

sub set_subject($$) {
	my ($self, $subject) = @_;

	$self->{subject} = $subject;
}

sub update($) {
	my ($self) = shift;
	my ($action) = shift;
	my $model = $Pxesconfig::MODEL;

	if ( $active_dialog ) {
		my $form = $active_dialog->FORM;

		# Run the main loop as long as events are pending
		Gtk->main_iteration while ( Gtk->events_pending );

		if ( $action eq 'info' ) {
			$form->{labelOperation}->set_text("@_");
			$form->{progressbarStatus}->set_value(
				$form->{progressbarStatus}->get_value()+1);
		}

		# Run the main loop as long as events are pending
		Gtk->main_iteration while ( Gtk->events_pending );
		# FIXME
		sleep(1);
	}
}

sub find_druid_page_by_name($) {
	my ($name) = @_;

	my $s = $druid_session_pages;
	while ( $s ) {
		return $s if $s->name() eq $name;
		$s = $s->next();
	}

	return undef;
}

sub find_selected_druid_page_next_to($) {
	my ($name) = @_;

	my $s = find_druid_page_by_name($name)->next();
	while ( $s ) {
		return $s if $s->selected();
		$s = $s->next();
	}

	return undef;
}

sub find_selected_druid_page_prev_to($) {
	my ($name) = @_;

	my $s = find_druid_page_by_name($name)->prev();
	while ( $s ) {
		return $s if $s->selected();
		$s = $s->prev();
	}

	return undef;
}

sub find_selected_druid_page_to_go($$) {
	my ($sub, $name) = @_;

	warn "find_selected_druid_page_to_go($sub,$name)"
		if $DEBUG > 3;

	my $dir = $sub;
	$dir =~ s/.*(.{4}$)/$1/;
	if ( $dir eq 'next' ) {
		warn 'returning ' . find_selected_druid_page_next_to($name)
			if $DEBUG > 3;
		return find_selected_druid_page_next_to($name);
	}
	elsif ( $dir eq 'back' ) {
		return find_selected_druid_page_prev_to($name);
	}
	elsif ( $dir eq 'pare' ) {
		# prepare, assume 'next' because the call is made while
		# skipping pages in the prepare stage
		return find_selected_druid_page_next_to($name);
	}
	else {
		die "Internal error: dir=$dir";
	}
}

sub toString($) {
	my ($self) = @_;

	my $s;

	$s .= "PxesconfigGUI:\n";

	return $s;
}

sub seems_host_or_ip($) {
	# FIXME
	# not a real test
	my ($s) = @_;

	if ( $s =~ /[a-zA-Z\d][a-zA-Z\d\.-]*/ ) {
		return TRUE;
	}

	if ( $s =~ /\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/ ) {
		return TRUE;
	}

	return FALSE;
}

#=======================================================================
#
# 'DialogFinishing' class 
#
#=======================================================================

package DialogFinishing;
require 5.000; use strict 'vars', 'refs', 'subs';

BEGIN {
	use constant TRUE => 1;
	use constant FALSE => 0;

	use Gtk;
   use Gnome;
   use Pxesconfig::PxesconfigGUIUI;

	use vars qw($DEBUG);
} # End of sub BEGIN

$DEBUG = 0;

#=======================================================================
#=== Below are the signal handlers for 'DialogFinishing' class 
#=======================================================================

sub on_DialogFinishing_clicked {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_DialogFinishing_clicked";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	#warn "closing";
	#$PxesconfigGUI::active_dialog->TOPLEVEL->destroy();
	#warn "resetting";
	#$PxesconfigGUI::active_dialog = undef;

	# FIXME
	# we must to be sure that the finishing process has been terminated
	warn "on_clicked" if $DEBUG;
	if ( $PxesconfigGUI::finished ) {
		exit(0);
	}
} # End of sub on_DialogFinishing_clicked

sub on_DialogFinishing_close {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_DialogFinishing_close";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	warn "on_close" if $DEBUG;
	if ( $PxesconfigGUI::finished ) {
		exit(0);
	}
} # End of sub on_DialogFinishing_close



#=======================================================================
#
# 'MonitorDB' class 
#
#=======================================================================

package DialogMonitorDB;
require 5.000; use strict 'vars', 'refs', 'subs';

BEGIN {
	use constant TRUE => 1;
	use constant FALSE => 0;
	use constant OK => 0;
	use constant CANCEL => 1;

	use Gtk;
   use Gnome;
   use Pxesconfig::PxesconfigGUIUI;

	use vars qw($DEBUG);

} # End of sub BEGIN

$DEBUG = 0;

our $selection = undef;

sub initialize_list {
	my ($self) = shift;
	my @monitors = @_;
	my $form = $self->FORM;
	my $clist = $form->{'clistMonitorsDB'};

	my @li;
	foreach my $m (@monitors) {
		next unless $m->[0];
		$clist->append(@{$m});
	}

	$clist->set_column_width( 0, 250 );
	$clist->set_column_width( 1, 100 );
	$clist->set_column_width( 2, 100 );
}

#=======================================================================
#=== Below are the signal handlers for 'DialogMonitorDB' class 
#=======================================================================

sub on_DialogMonitorDB_clicked {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_DialogMonitorDB_clicked";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};
	my $clist = $form->{'clistMonitorsDB'};
	# pxesconfig form
   my $pxesconfig_form = $__PACKAGE__::all_forms->{'PxesconfigGUI-2'};

	my $row = $clist->selection();

	if ( $event == OK ) {
		if ( defined($row) ) {
			my $xhs = $clist->get_text($row, 1);
			my $xvr = $clist->get_text($row, 2);
			my $c = $pxesconfig_form->{'comboXHorizontalSync'};
			$c->entry()->set_text($xhs);
			$c = $pxesconfig_form->{'comboXVerticalRefresh'};
			$c->entry()->set_text($xvr);
		}
		else {
			PxesconfigGUI::my_message_box('error',
				"You must select a monitor or press 'Cancel'.\n\n"
				);
			return;
		}
	}
	$class->close();
} # End of sub on_DialogMonitor_clicked

sub on_DialogMonitorDB_close {
   my ($class, $data, $object, $instance, $event) = @_;
   my $me = __PACKAGE__."->on_DialogMonitorDB_close";
   # Get ref to hash of all widgets on our form
   my $form = $__PACKAGE__::all_forms->{$instance};

	return 0;
} # End of sub on_DialogFinishing_close


1;

__END__

#===============================================================================
#==== Documentation
#===============================================================================
=pod

=head1 NAME

PxesconfigGUI - version 0.01 Fri May 24 01:45:10 ART 2002

No description

=head1 SYNOPSIS

 use PxesconfigGUI;

 To construct the window object and show it call
 
 Gtk->init;
 my $window = PxesconfigGUI->new;
 $window->TOPLEVEL->show;
 Gtk->main;
 
 OR use the shorthand for the above calls
 
 PxesconfigGUI->app_run;

=head1 DESCRIPTION

Unfortunately, the author has not yet written any documentation :-(

=head1 AUTHOR

Diego Torres Milano <diego@in3.com.ar>

=cut
