#
# DO NOT MODIFY!!!!
# This file is automatically generated by racc 1.4.5
# from racc grammer file "grammar.ra".
#

require 'racc/parser'


require 'puppet'
require 'puppet/parsedfile'
require 'puppet/parser/lexer'
require 'puppet/parser/ast'
#require 'puppet/parser/interpreter'

module Puppet
    class ParseError < Puppet::Error; end

    class ImportError < Racc::ParseError; end
end

Puppet[:typecheck] = true
Puppet[:paramcheck] = true


module Puppet

  module Parser

    class Parser < Racc::Parser

module_eval <<'..end grammar.ra modeval..id99c9ad765d', 'grammar.ra', 787
require 'puppet/parser/functions'

attr_reader :file
attr_accessor :files

# Create an AST array out of all of the args
def aryfy(*args)
    if args[0].instance_of?(AST::ASTArray)
        result = args.shift
        args.each { |arg|
            result.push arg
        }
    else
        result = AST::ASTArray.new(
            :children => args
        )
    end

    return result
end

def file=(file)
    unless FileTest.exists?(file)
        unless file =~ /\.pp$/
            file = file + ".pp"
        end
        unless FileTest.exists?(file)
            raise Puppet::Error, "Could not find file %s" % file
        end
    end
    if @files.detect { |f| f.file == file }
        raise Puppet::ImportError.new("Import loop detected")
    else
        @files << Puppet::ParsedFile.new(file)
        @lexer.file = file
    end
end

def initialize
    @lexer = Puppet::Parser::Lexer.new()
    @files = []
    #if Puppet[:debug]
    #    @yydebug = true
    #end
end

def on_error(token,value,stack)
    #on '%s' at '%s' in\n'%s'" % [token,value,stack]
    #error = "line %s: parse error after '%s'" %
    #    [@lexer.line,@lexer.last]
    error = "Syntax error at '%s'" % [value]

    #if Puppet[:debug]
        #puts stack.inspect
        #puts stack.class
    #end
    #if @lexer.file
    #    error += (" in '%s'" % @lexer.file)
    #end

    except = Puppet::ParseError.new(error)
    except.line = @lexer.line
    if @lexer.file
        except.file = @lexer.file
    end

    raise except
end

# how should I do error handling here?
def parse
    begin
        yyparse(@lexer,:scan)
    rescue Racc::ParseError => except
        error = Puppet::ParseError.new(except)
        error.line = @lexer.line
        error.file = @lexer.file
        error.backtrace = except.backtrace
        raise error
    rescue Puppet::ParseError => except
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue Puppet::Error => except
        # and this is a framework error
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        #if Puppet[:debug]
        #    puts except.stack
        #end
        raise except
    rescue Puppet::DevError => except
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        #if Puppet[:debug]
        #    puts except.stack
        #end
        raise except
    rescue => except
        error = Puppet::DevError.new(except.message)
        error.line = @lexer.line
        error.file = @lexer.file
        error.backtrace = except.backtrace
        #if Puppet[:debug]
        #    puts caller
        #end
        raise error
    end
end

def reparse?
    @files.detect { |file|
        file.changed?
    }
end

def string=(string)
    @lexer.string = string
end

# Make emacs happy
# Local Variables:
# mode: ruby
# End:

# $Id: parser.rb 1418 2006-07-21 19:38:29Z luke $

..end grammar.ra modeval..id99c9ad765d

##### racc 1.4.5 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 44, :_reduce_1,
 1, 44, :_reduce_none,
 1, 45, :_reduce_none,
 2, 45, :_reduce_4,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 1, 47, :_reduce_none,
 4, 54, :_reduce_15,
 2, 54, :_reduce_16,
 1, 58, :_reduce_none,
 3, 58, :_reduce_18,
 1, 59, :_reduce_none,
 1, 59, :_reduce_none,
 1, 59, :_reduce_none,
 5, 48, :_reduce_22,
 5, 48, :_reduce_23,
 5, 48, :_reduce_24,
 2, 49, :_reduce_25,
 3, 50, :_reduce_26,
 4, 68, :_reduce_27,
 1, 63, :_reduce_none,
 3, 63, :_reduce_29,
 0, 64, :_reduce_none,
 1, 64, :_reduce_none,
 1, 60, :_reduce_32,
 1, 67, :_reduce_33,
 1, 69, :_reduce_none,
 1, 69, :_reduce_none,
 1, 69, :_reduce_none,
 1, 69, :_reduce_none,
 1, 69, :_reduce_none,
 1, 69, :_reduce_none,
 3, 51, :_reduce_40,
 0, 65, :_reduce_41,
 1, 65, :_reduce_42,
 3, 65, :_reduce_43,
 3, 73, :_reduce_44,
 1, 74, :_reduce_none,
 3, 74, :_reduce_46,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 4, 78, :_reduce_56,
 1, 62, :_reduce_57,
 1, 62, :_reduce_58,
 1, 76, :_reduce_59,
 4, 77, :_reduce_60,
 5, 52, :_reduce_61,
 1, 79, :_reduce_none,
 2, 79, :_reduce_63,
 5, 80, :_reduce_64,
 4, 80, :_reduce_65,
 1, 81, :_reduce_none,
 3, 81, :_reduce_67,
 3, 70, :_reduce_68,
 1, 83, :_reduce_none,
 3, 83, :_reduce_70,
 1, 85, :_reduce_none,
 3, 85, :_reduce_72,
 3, 84, :_reduce_73,
 1, 82, :_reduce_none,
 1, 82, :_reduce_none,
 1, 82, :_reduce_none,
 1, 82, :_reduce_none,
 1, 82, :_reduce_none,
 1, 82, :_reduce_none,
 1, 82, :_reduce_80,
 2, 53, :_reduce_81,
 6, 55, :_reduce_82,
 5, 55, :_reduce_83,
 6, 56, :_reduce_84,
 5, 56, :_reduce_85,
 6, 57, :_reduce_86,
 5, 57, :_reduce_87,
 1, 88, :_reduce_none,
 3, 88, :_reduce_89,
 1, 89, :_reduce_90,
 1, 89, :_reduce_91,
 1, 89, :_reduce_92,
 0, 46, :_reduce_93,
 1, 86, :_reduce_none,
 3, 86, :_reduce_95,
 3, 86, :_reduce_96,
 1, 90, :_reduce_none,
 3, 90, :_reduce_98,
 3, 91, :_reduce_99,
 1, 91, :_reduce_100,
 1, 87, :_reduce_none,
 2, 87, :_reduce_102,
 1, 61, :_reduce_103,
 3, 71, :_reduce_104,
 2, 71, :_reduce_105,
 1, 75, :_reduce_none,
 1, 75, :_reduce_none,
 0, 66, :_reduce_none,
 1, 66, :_reduce_109 ]

racc_reduce_n = 110

racc_shift_n = 181

racc_action_table = [
    47,    34,    37,   153,   149,    18,    47,    34,    37,    59,
   152,   -76,    47,    34,    37,    77,    18,    34,    37,    70,
    34,    37,    18,    35,   -75,    59,    34,    37,    18,    42,
    82,   129,   -74,    48,    49,    42,    30,    54,    30,    48,
    49,    42,    68,    54,    60,    48,    49,   -74,    42,    54,
    47,    34,    37,    35,    42,   -77,    47,    34,    37,    35,
   -76,   130,    47,    34,    37,    75,    18,   108,    29,   158,
    29,    31,    18,    31,    35,    75,   110,   106,    18,    42,
   159,   137,   138,    48,    49,    42,   145,    54,    80,    48,
    87,    42,   -77,    54,    83,    48,    49,    34,    37,    54,
    47,    34,    37,    34,    37,   111,    47,    34,    37,   112,
   114,   142,    47,    34,    37,   168,    18,   112,   114,    72,
    43,   108,    18,   106,   146,    42,    81,   -79,    18,    42,
    35,    42,    80,    48,    49,    42,    35,    54,   -75,    48,
    49,    42,    72,    54,   -78,    48,    49,   156,   157,    54,
    47,    34,    37,    34,    37,   105,   160,   161,    75,    72,
    34,    37,    34,    37,    67,   120,    18,    66,    18,    97,
   170,    65,   108,    35,    68,    18,    62,    18,    99,    42,
    32,    42,    26,    48,    49,    48,    49,    54,    42,    54,
    42,   103,    48,    49,    48,    49,    54,   nil,    54,    34,
    37,    34,    37,   nil,   nil,   151,   nil,   nil,    34,    37,
   nil,   nil,   nil,   nil,    18,   nil,    18,   nil,   nil,   nil,
   nil,   nil,   nil,    18,   nil,   nil,   nil,    42,   163,    42,
   nil,    48,    49,    48,    49,    54,    42,    54,   nil,    18,
    48,    49,   nil,   165,    54,   nil,   nil,   nil,   nil,    15,
    17,   nil,    22,    24,    18,     3,   nil,     9,   180,    12,
   nil,    19,   nil,   nil,    15,    17,   nil,    22,    24,    18,
     3,   nil,     9,   166,    12,   nil,    19,   nil,   nil,    15,
    17,   nil,    22,    24,    18,     3,   nil,     9,   175,    12,
   nil,    19,   nil,   nil,    15,    17,   nil,    22,    24,    18,
     3,   nil,     9,   140,    12,   nil,    19,   nil,   nil,    15,
    17,   nil,    22,    24,    18,     3,   nil,     9,   179,    12,
   nil,    19,   nil,   nil,    15,    17,   nil,    22,    24,    18,
     3,   nil,     9,   176,    12,   nil,    19,   nil,   nil,    15,
    17,   nil,    22,    24,    18,     3,   nil,     9,   nil,    12,
   nil,    19,   nil,   nil,    15,    17,   nil,    22,    24,    18,
     3,   nil,     9,   nil,    12,   nil,    19,   nil,   nil,    15,
    17,   nil,    22,    24,    18,     3,   nil,     9,   nil,    12,
   nil,    19,   nil,   nil,    15,    17,   nil,    22,    24,   nil,
     3,   nil,     9,   nil,    12,   nil,    19 ]

racc_action_check = [
    65,    65,    65,   127,   124,    19,   130,   130,   130,    13,
   127,    57,    47,    47,    47,    47,    65,    15,    15,    27,
    43,    43,   130,    19,    85,    64,    80,    80,    47,    65,
    53,    88,    91,    65,    65,   130,     3,    65,    70,   130,
   130,    47,    27,   130,    13,    47,    47,    53,    43,    47,
   113,   113,   113,    43,    80,    92,    59,    59,    59,    80,
    93,    94,    82,    82,    82,    76,   113,    96,     3,   133,
    70,     3,    59,    70,    99,   115,    76,    87,    82,   113,
   133,   100,   102,   113,   113,    59,   115,   113,    87,    59,
    59,    82,    56,    59,    55,    82,    82,    75,    75,    82,
    12,    12,    12,     9,     9,    79,   146,   146,   146,    79,
    79,   107,   161,   161,   161,   148,    12,   148,   148,   108,
     9,    74,   146,    72,   118,    75,    51,    58,   161,    12,
    75,     9,    49,    12,    12,   146,     9,    12,    46,   146,
   146,   161,   129,   146,    45,   161,   161,   131,   132,   161,
   106,   106,   106,    83,    83,    71,   134,   136,    36,    32,
   153,   153,    81,    81,    26,    81,   106,    24,    83,    60,
   152,    22,   154,   158,    66,   153,    17,    81,    62,   106,
     4,    83,     2,   106,   106,    83,    83,   106,   153,    83,
    81,    68,   153,   153,    81,    81,   153,   nil,    81,   169,
   169,   125,   125,   nil,   nil,   125,   nil,   nil,   120,   120,
   nil,   nil,   nil,   nil,   169,   nil,   125,   nil,   nil,   nil,
   nil,   nil,   nil,   120,   nil,   nil,   nil,   169,   137,   125,
   nil,   169,   169,   125,   125,   169,   120,   125,   nil,   137,
   120,   120,   nil,   138,   120,   nil,   nil,   nil,   nil,   137,
   137,   nil,   137,   137,   138,   137,   nil,   137,   178,   137,
   nil,   137,   nil,   nil,   138,   138,   nil,   138,   138,   178,
   138,   nil,   138,   139,   138,   nil,   138,   nil,   nil,   178,
   178,   nil,   178,   178,   139,   178,   nil,   178,   162,   178,
   nil,   178,   nil,   nil,   139,   139,   nil,   139,   139,   162,
   139,   nil,   139,   105,   139,   nil,   139,   nil,   nil,   162,
   162,   nil,   162,   162,   105,   162,   nil,   162,   170,   162,
   nil,   162,   nil,   nil,   105,   105,   nil,   105,   105,   170,
   105,   nil,   105,   164,   105,   nil,   105,   nil,   nil,   170,
   170,   nil,   170,   170,   164,   170,   nil,   170,   nil,   170,
   nil,   170,   nil,   nil,   164,   164,   nil,   164,   164,     6,
   164,   nil,   164,   nil,   164,   nil,   164,   nil,   nil,     6,
     6,   nil,     6,     6,     0,     6,   nil,     6,   nil,     6,
   nil,     6,   nil,   nil,     0,     0,   nil,     0,     0,   nil,
     0,   nil,     0,   nil,     0,   nil,     0 ]

racc_action_pointer = [
   356,   nil,   182,    32,   174,   nil,   341,   nil,   nil,   100,
   nil,   nil,    98,     3,   nil,    14,   nil,   140,   nil,   -13,
   nil,   nil,   158,   nil,   131,   nil,   164,     9,   nil,   nil,
   nil,   nil,   123,   nil,   nil,   nil,   148,   nil,   nil,   nil,
   nil,   nil,   nil,    17,   nil,   125,   119,    10,   nil,   112,
   nil,   107,   nil,    28,   nil,    88,    73,    -8,   108,    54,
   127,   nil,   158,   nil,    19,    -2,   141,   nil,   155,   nil,
    34,   149,   114,   nil,   111,    94,    55,   nil,   nil,   100,
    23,   159,    60,   150,   nil,     5,   nil,    68,    14,   nil,
   nil,    13,    36,    41,    24,   nil,    57,   nil,   nil,    38,
    75,   nil,    76,   nil,   nil,   296,   148,   104,    83,   nil,
   nil,   nil,   nil,    48,   nil,    65,   nil,   nil,   115,   nil,
   205,   nil,   nil,   nil,    -1,   198,   nil,    -7,   nil,   106,
     4,   140,   141,    59,   135,   nil,   144,   221,   236,   266,
   nil,   nil,   nil,   nil,   nil,   nil,   104,   nil,   108,   nil,
   nil,   nil,   164,   157,   162,   nil,   nil,   nil,   137,   nil,
   nil,   110,   281,   nil,   326,   nil,   nil,   nil,   nil,   196,
   311,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   251,   nil,
   nil ]

racc_action_default = [
   -93,   -12,  -110,  -110,  -110,   -13,    -1,   -14,    -2,   -32,
    -3,    -5,  -110,  -110,    -6,  -110,    -7,  -110,   -33,  -110,
    -8,    -9,  -110,   -10,  -110,   -11,  -110,   -93,   -88,   -90,
   -91,   -92,   -41,    -4,   -57,   -32,   -16,   -58,   -17,   -19,
   -20,   -21,  -103,  -110,   -54,   -55,   -49,  -110,   -59,   -32,
   -51,  -110,   -53,   -48,   -80,  -110,   -52,   -47,   -50,   -41,
  -110,   -81,   -93,   -25,  -110,  -110,   -93,   181,  -110,  -101,
  -110,  -110,  -110,   -42,  -108,  -110,  -110,  -105,   -45,  -110,
  -110,  -110,  -110,  -110,   -78,   -36,   -28,   -32,  -110,   -37,
   -39,   -35,   -38,   -34,   -30,   -79,  -108,   -26,   -94,   -93,
  -110,   -40,  -110,  -102,   -89,  -110,  -110,  -110,  -109,   -18,
   -15,  -104,  -106,  -110,  -107,  -110,   -75,   -74,  -110,   -77,
  -110,   -68,   -76,   -69,  -110,  -110,   -62,  -110,   -66,   -41,
   -31,  -110,  -110,  -110,  -110,   -97,  -100,  -110,  -110,  -110,
   -87,   -44,   -24,   -43,   -46,   -56,  -110,   -71,  -110,   -60,
   -63,   -61,  -110,  -110,  -108,   -29,   -22,   -23,  -110,   -96,
   -95,  -110,  -110,   -83,  -110,   -85,   -86,   -73,   -70,  -110,
  -110,   -67,   -27,   -98,   -99,   -82,   -84,   -72,  -110,   -65,
   -64 ]

racc_goto_table = [
    33,     6,    74,    39,     8,   107,    53,    89,   135,   123,
   126,    86,    36,    64,   109,    40,    71,    90,   125,    79,
    94,   121,   113,   131,   148,    28,   100,   132,   143,    96,
    41,    27,    63,   133,     2,   nil,    61,    39,   nil,   nil,
   118,    53,   128,   nil,   nil,   nil,    76,   nil,   147,    40,
   nil,   nil,   150,    91,   nil,   102,   nil,   nil,   nil,    53,
   nil,   nil,   nil,   nil,    41,    92,    98,   173,   nil,    39,
   nil,   nil,   nil,   nil,    39,   117,    53,   117,    89,   118,
    93,    40,   155,   115,   128,   172,    40,   119,    90,   119,
    55,   169,   104,   136,   nil,    46,    41,   177,   nil,   154,
    53,    41,   122,   134,   122,   nil,   139,    53,   nil,   nil,
   nil,   nil,   171,   nil,   117,   nil,   nil,   nil,   nil,   117,
   nil,   nil,   nil,   nil,    91,    78,   119,   nil,   118,   nil,
    46,   119,   nil,    33,   nil,   nil,    92,   nil,   162,   164,
    53,   122,    85,   101,   nil,   nil,   122,   117,    46,   nil,
   nil,    93,   136,   nil,    84,    53,    33,    95,    33,   119,
   124,   nil,   nil,   117,   116,    46,   116,   nil,   nil,   nil,
   nil,   178,    33,   nil,   122,   119,    84,   nil,    84,    95,
   nil,    95,   nil,   nil,   141,   nil,   nil,   nil,   nil,    46,
   122,   144,   nil,   nil,   nil,   nil,    46,   nil,   nil,   nil,
   nil,   nil,   nil,   116,   nil,   nil,   nil,   nil,   116,   nil,
   nil,   nil,   nil,    85,   nil,    84,   nil,   nil,    95,   nil,
    84,   nil,   nil,    95,   167,    84,   nil,   nil,    95,    46,
   nil,   nil,   nil,   nil,   nil,   nil,   116,   nil,   nil,   174,
   nil,   nil,   nil,   nil,    46,   nil,   nil,   nil,    84,   nil,
   nil,    95,   116,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    84,   nil,   nil,    95 ]

racc_goto_check = [
     4,     2,    22,    17,     3,    23,    17,    27,    48,    41,
    37,    25,    15,    17,    16,    18,    44,    28,    36,    31,
    20,    40,    32,    21,    42,    46,    43,    23,    30,    22,
    19,    45,     5,    47,     1,   nil,    19,    17,   nil,   nil,
    39,    17,    39,   nil,   nil,   nil,    15,   nil,    41,    18,
   nil,   nil,    37,    17,   nil,    44,   nil,   nil,   nil,    17,
   nil,   nil,   nil,   nil,    19,    18,     3,    48,   nil,    17,
   nil,   nil,   nil,   nil,    17,    17,    17,    17,    27,    39,
    19,    18,    25,    15,    39,    23,    18,    18,    28,    18,
    29,    32,    46,    17,   nil,    24,    19,    41,   nil,    22,
    17,    19,    19,     3,    19,   nil,     2,    17,   nil,   nil,
   nil,   nil,    39,   nil,    17,   nil,   nil,   nil,   nil,    17,
   nil,   nil,   nil,   nil,    17,    29,    18,   nil,    39,   nil,
    24,    18,   nil,     4,   nil,   nil,    18,   nil,     2,     2,
    17,    19,    24,    29,   nil,   nil,    19,    17,    24,   nil,
   nil,    19,    17,   nil,    35,    17,     4,    33,     4,    18,
    29,   nil,   nil,    17,    24,    24,    24,   nil,   nil,   nil,
   nil,     2,     4,   nil,    19,    18,    35,   nil,    35,    33,
   nil,    33,   nil,   nil,    29,   nil,   nil,   nil,   nil,    24,
    19,    29,   nil,   nil,   nil,   nil,    24,   nil,   nil,   nil,
   nil,   nil,   nil,    24,   nil,   nil,   nil,   nil,    24,   nil,
   nil,   nil,   nil,    24,   nil,    35,   nil,   nil,    33,   nil,
    35,   nil,   nil,    33,    29,    35,   nil,   nil,    33,    24,
   nil,   nil,   nil,   nil,   nil,   nil,    24,   nil,   nil,    29,
   nil,   nil,   nil,   nil,    24,   nil,   nil,   nil,    35,   nil,
   nil,    33,    24,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    35,   nil,   nil,    33 ]

racc_goto_pointer = [
   nil,    34,     1,     4,    -6,    13,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     3,   -61,    -6,     6,    21,
   -39,   -71,   -30,   -69,    83,   -48,   nil,   -52,   -42,    78,
   -80,   -28,   -57,    98,   nil,    95,   -65,   -73,   nil,   -41,
   -60,   -72,   -96,   -36,   -11,    28,    22,   -66,   -91 ]

racc_goto_default = [
   nil,   nil,   nil,    69,    10,    11,    14,    16,    20,    21,
    23,    25,     1,     5,     7,   nil,    38,    13,    56,    57,
   nil,   nil,   nil,   nil,     4,   nil,    88,    50,    52,   nil,
    73,   nil,   nil,    58,    44,    45,   nil,   nil,   127,    51,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :LBRACK => 2,
 :DQTEXT => 3,
 :SQTEXT => 4,
 :RBRACK => 5,
 :LBRACE => 6,
 :RBRACE => 7,
 :SYMBOL => 8,
 :FARROW => 9,
 :COMMA => 10,
 :TRUE => 11,
 :FALSE => 12,
 :EQUALS => 13,
 :LESSEQUAL => 14,
 :NOTEQUAL => 15,
 :DOT => 16,
 :COLON => 17,
 :TYPE => 18,
 :QMARK => 19,
 :LPAREN => 20,
 :RPAREN => 21,
 :ISEQUAL => 22,
 :GREATEREQUAL => 23,
 :GREATERTHAN => 24,
 :LESSTHAN => 25,
 :IF => 26,
 :ELSE => 27,
 :IMPORT => 28,
 :DEFINE => 29,
 :ELSIF => 30,
 :VARIABLE => 31,
 :CLASS => 32,
 :INHERITS => 33,
 :NODE => 34,
 :BOOLEAN => 35,
 :NAME => 36,
 :SEMIC => 37,
 :CASE => 38,
 :DEFAULT => 39,
 :AT => 40,
 :LCOLLECT => 41,
 :RCOLLECT => 42 }

racc_use_result_var = true

racc_nt_base = 43

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'LBRACK',
'DQTEXT',
'SQTEXT',
'RBRACK',
'LBRACE',
'RBRACE',
'SYMBOL',
'FARROW',
'COMMA',
'TRUE',
'FALSE',
'EQUALS',
'LESSEQUAL',
'NOTEQUAL',
'DOT',
'COLON',
'TYPE',
'QMARK',
'LPAREN',
'RPAREN',
'ISEQUAL',
'GREATEREQUAL',
'GREATERTHAN',
'LESSTHAN',
'IF',
'ELSE',
'IMPORT',
'DEFINE',
'ELSIF',
'VARIABLE',
'CLASS',
'INHERITS',
'NODE',
'BOOLEAN',
'NAME',
'SEMIC',
'CASE',
'DEFAULT',
'AT',
'LCOLLECT',
'RCOLLECT',
'$start',
'program',
'statements',
'nothing',
'statement',
'object',
'collectable',
'collection',
'assignment',
'casestatement',
'import',
'fstatement',
'definition',
'hostclass',
'nodedef',
'classnames',
'classname',
'name',
'variable',
'quotedtext',
'objectinstances',
'endsemi',
'params',
'endcomma',
'type',
'objectinst',
'objectname',
'selector',
'array',
'rvalue',
'param',
'rvalues',
'comma',
'boolean',
'objectref',
'funcrvalue',
'caseopts',
'caseopt',
'casevalues',
'selectlhand',
'svalues',
'selectval',
'sintvalues',
'argumentlist',
'parent',
'hostnames',
'hostname',
'arguments',
'argument']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'grammar.ra', 26
  def _reduce_1( val, _values, result )
    if val[0].is_a?(AST::ASTArray)
        result = val[0]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :children => [val[0]]
        )
    end
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'grammar.ra', 41
  def _reduce_4( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[1])
        result = val[0]
    else
        result = AST::ASTArray.new(
            :file => @lexer.file,
            :line => @lexer.line,
            :children => [val[0],val[1]]
        )
    end
   result
  end
.,.,

 # reduce 5 omitted

 # reduce 6 omitted

 # reduce 7 omitted

 # reduce 8 omitted

 # reduce 9 omitted

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

module_eval <<'.,.,', 'grammar.ra', 64
  def _reduce_15( val, _values, result )
    args = aryfy(val[2])
    result = AST::Function.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :name => val[0],
        :arguments => args,
        :ftype => :statement
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 74
  def _reduce_16( val, _values, result )
    args = aryfy(val[1])
    result = AST::Function.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :name => val[0],
        :arguments => args,
        :ftype => :statement
    )
   result
  end
.,.,

 # reduce 17 omitted

module_eval <<'.,.,', 'grammar.ra', 93
  def _reduce_18( val, _values, result )
    result = aryfy(val[0], val[2])
    result.line = @lexer.line
    result.file = @lexer.file
   result
  end
.,.,

 # reduce 19 omitted

 # reduce 20 omitted

 # reduce 21 omitted

module_eval <<'.,.,', 'grammar.ra', 128
  def _reduce_22( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        raise Puppet::ParseError, "Invalid name"
    end
    array = val[2]
    if array.instance_of?(AST::ObjectInst)
        array = [array]
    end
    result = AST::ASTArray.new(
        :line => @lexer.line,
        :file => @lexer.file
    )
    # this iterates across each specified objectinstance
    array.each { |instance|
        unless instance.instance_of?(AST::ObjectInst)
            raise Puppet::Dev, "Got something that isn't an instance"
        end
        # now, i need to somehow differentiate between those things with
        # arrays in their names, and normal things
        result.push AST::ObjectDef.new(
            :pin => "{}",
            :line => @lexer.line,
            :file => @lexer.file,
            :type => val[0],
            :name => instance[0],
            :params => instance[1]
        )
    }
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 142
  def _reduce_23( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        Puppet.notice "invalid name"
        raise Puppet::ParseError, "Invalid name"
    end
    # an object but without a name
    # this cannot be an instance of a library type
    result = AST::ObjectDef.new(
        :pin => "{}",
        :line => @lexer.line,
        :file => @lexer.file,
        :type => val[0],
        :params => val[2]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 154
  def _reduce_24( val, _values, result )
    # a template setting for a type
    if val[0].instance_of?(AST::ASTArray)
        raise Puppet::ParseError, "Invalid type"
    end
    result = AST::TypeDefaults.new(
        :pin => "{}",
        :line => @lexer.line,
        :file => @lexer.file,
        :type => val[0],
        :params => val[2]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 177
  def _reduce_25( val, _values, result )
    unless Puppet[:storeconfigs]
        raise Puppet::ParseError, "You cannot collect without storeconfigs being set"
    end

    if val[1].is_a? AST::TypeDefaults
        raise Puppet::ParseError, "Defaults are not collectable"
    end

    # Just mark our objects as collectable and pass them through.
    if val[1].instance_of?(AST::ASTArray)
        val[1].each do |obj|
            obj.collectable = true
        end
    else
        val[1].collectable = true
    end

    result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 190
  def _reduce_26( val, _values, result )
    unless Puppet[:storeconfigs]
        raise Puppet::ParseError, "You cannot collect without storeconfigs being set"
    end
    result = AST::Collection.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :type => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 198
  def _reduce_27( val, _values, result )
    result = AST::ObjectInst.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :children => [val[0],val[2]]
    )
   result
  end
.,.,

 # reduce 28 omitted

module_eval <<'.,.,', 'grammar.ra', 212
  def _reduce_29( val, _values, result )
    if val[0].instance_of?(AST::ObjectInst)
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0],val[2]]
        )
    else
        val[0].push val[2]
        result = val[0]
    end
   result
  end
.,.,

 # reduce 30 omitted

 # reduce 31 omitted

module_eval <<'.,.,', 'grammar.ra', 223
  def _reduce_32( val, _values, result )
    result = AST::Name.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 231
  def _reduce_33( val, _values, result )
    result = AST::Type.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

 # reduce 34 omitted

 # reduce 35 omitted

 # reduce 36 omitted

 # reduce 37 omitted

 # reduce 38 omitted

 # reduce 39 omitted

module_eval <<'.,.,', 'grammar.ra', 254
  def _reduce_40( val, _values, result )
    # this is distinct from referencing a variable
    variable = AST::Name.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0].sub(/^\$/,'')
    )
    result = AST::VarDef.new(
        :pin => "=",
        :line => @lexer.line,
        :file => @lexer.file,
        :name => variable,
        :value => val[2]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 263
  def _reduce_41( val, _values, result )
    result = AST::ASTArray.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :children => []
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 263
  def _reduce_42( val, _values, result )
 result = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 276
  def _reduce_43( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0],val[2]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 291
  def _reduce_44( val, _values, result )
    leaf = AST::String.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
    result = AST::ObjectParam.new(
        :pin => "=>",
        :line => @lexer.line,
        :file => @lexer.file,
        :param => leaf,
        :value => val[2]
    )
   result
  end
.,.,

 # reduce 45 omitted

module_eval <<'.,.,', 'grammar.ra', 304
  def _reduce_46( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        result = val[0].push(val[2])
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0],val[2]]
        )
    end
   result
  end
.,.,

 # reduce 47 omitted

 # reduce 48 omitted

 # reduce 49 omitted

 # reduce 50 omitted

 # reduce 51 omitted

 # reduce 52 omitted

 # reduce 53 omitted

 # reduce 54 omitted

 # reduce 55 omitted

module_eval <<'.,.,', 'grammar.ra', 326
  def _reduce_56( val, _values, result )
    args = aryfy(val[2])
    result = AST::Function.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :name => val[0],
        :arguments => args,
        :ftype => :rvalue
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 334
  def _reduce_57( val, _values, result )
    result = AST::String.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 340
  def _reduce_58( val, _values, result )
    result = AST::FlatString.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 348
  def _reduce_59( val, _values, result )
    result = AST::Boolean.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 358
  def _reduce_60( val, _values, result )
    result = AST::ObjectRef.new(
        :pin => '[]',
        :line => @lexer.line,
        :file => @lexer.file,
        :type => val[0],
        :name => val[2]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 375
  def _reduce_61( val, _values, result )
    options = val[3]
    unless options.instance_of?(AST::ASTArray)
        options = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[3]]
        )
    end
    result = AST::CaseStatement.new(
        :test => val[1],
        :options => options,
        :file => @lexer.file,
        :line => @lexer.line
    )
   result
  end
.,.,

 # reduce 62 omitted

module_eval <<'.,.,', 'grammar.ra', 389
  def _reduce_63( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push val[1]
        result = val[0]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0], val[1]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 399
  def _reduce_64( val, _values, result )
    result = AST::CaseOpt.new(
        :pin => ":",
        :value => val[0],
        :file => @lexer.file,
        :line => @lexer.line,
        :statements => val[3]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 411
  def _reduce_65( val, _values, result )
    result = AST::CaseOpt.new(
        :pin => ":",
        :value => val[0],
        :file => @lexer.file,
        :line => @lexer.line,
        :statements => AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => []
        )
    )
   result
  end
.,.,

 # reduce 66 omitted

module_eval <<'.,.,', 'grammar.ra', 425
  def _reduce_67( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0],val[2]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 435
  def _reduce_68( val, _values, result )
    result = AST::Selector.new(
        :pin => "?",
        :line => @lexer.line,
        :file => @lexer.file,
        :param => val[0],
        :values => val[2]
    )
   result
  end
.,.,

 # reduce 69 omitted

module_eval <<'.,.,', 'grammar.ra', 437
  def _reduce_70( val, _values, result )
 result = val[1]
   result
  end
.,.,

 # reduce 71 omitted

module_eval <<'.,.,', 'grammar.ra', 452
  def _reduce_72( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0],val[2]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 462
  def _reduce_73( val, _values, result )
    result = AST::ObjectParam.new(
        :pin => "=>",
        :line => @lexer.line,
        :file => @lexer.file,
        :param => val[0],
        :value => val[2]
    )
   result
  end
.,.,

 # reduce 74 omitted

 # reduce 75 omitted

 # reduce 76 omitted

 # reduce 77 omitted

 # reduce 78 omitted

 # reduce 79 omitted

module_eval <<'.,.,', 'grammar.ra', 476
  def _reduce_80( val, _values, result )
    result = AST::Default.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 535
  def _reduce_81( val, _values, result )
    # importing files
    # yuk, i hate keywords
    # we'll probably have to have some kind of search path eventually
    # but for now, just use a path relative to the file doing the importing
    dir = @lexer.file.sub(%r{[^/]+$},'').sub(/\/$/, '')
    if dir == ""
        dir = "."
    end
    result = AST::ASTArray.new(
        :file => @lexer.file,
        :line => @lexer.line
    )

    Dir.chdir(dir) {
        # We can't interpolate at this point since we don't have any 
        # scopes set up. Warn the user if they use a variable reference
        pat = val[1].value
        if pat.index("$")
             Puppet.warning(
                 "The import of #{pat} contains a variable reference;" +
                 " variables are not interpolated for imports " +
                 "in file #{@lexer.file} at line #{@lexer.line}"
             )
        end
        files = Dir.glob(pat)
        if files.size == 0
            files = Dir.glob(pat + ".pp")
            if files.size == 0
                raise Puppet::ImportError.new("No file(s) found for import " + 
                                              "of '#{pat}'")
            end
        end

        files.each { |file|
            parser = Puppet::Parser::Parser.new()
            parser.files = self.files
            Puppet.debug("importing '%s'" % file)

            unless file =~ /^#{File::SEPARATOR}/
                file = File.join(dir, file)
            end
            begin
                parser.file = file
            rescue Puppet::ImportError
                Puppet.warning(
                    "Importing %s would result in an import loop" %
                        File.join(dir, file)
                )
                next
            end
            # push the results into the main result array
            parser.parse.each do |child|
                result.push child
            end
        }
    }
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 546
  def _reduce_82( val, _values, result )
    result = AST::CompDef.new(
        :type => AST::Name.new(:value => val[1], :line => @lexer.line),
        :args => val[2],
        :file => @lexer.file,
        :line => @lexer.line,
        :keyword => val[0],
        :code => val[4]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 559
  def _reduce_83( val, _values, result )
    result = AST::CompDef.new(
        :type => AST::Name.new(:value => val[1], :line => @lexer.line),
        :args => val[2],
        :file => @lexer.file,
        :line => @lexer.line,
        :keyword => val[0],
        :code => AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => []
        )
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 576
  def _reduce_84( val, _values, result )
        #:args => val[2],
    args = {
        :type => AST::Name.new(:value => val[1], :line => @lexer.line),
        :file => @lexer.file,
        :line => @lexer.line,
        :keyword => val[0],
        :code => val[4]
    }
    # It'll be an ASTArray if we didn't get a parent
    if val[2].instance_of?(AST::Name)
        args[:parentclass] = val[2]
    end
    result = AST::ClassDef.new(args)
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 593
  def _reduce_85( val, _values, result )
    args = {
        :type => AST::Name.new(:value => val[1], :line => @lexer.line),
        :file => @lexer.file,
        :line => @lexer.line,
        :keyword => val[0],
        :code => AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => []
        )
    }
    # It'll be an ASTArray if we didn't get a parent
    if val[2].instance_of?(AST::Name)
        args[:parentclass] = val[2]
    end
    result = AST::ClassDef.new(args)
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 614
  def _reduce_86( val, _values, result )
    unless val[1].instance_of?(AST::ASTArray)
        val[1] = AST::ASTArray.new(
            :line => val[1].line,
            :file => val[1].file,
            :children => [val[1]]
        )
    end
    args = {
        :file => @lexer.file,
        :line => @lexer.line,
        :names => val[1],
        :keyword => val[0],
        :code => val[4]
    }
    if val[2].instance_of?(AST::Name)
        args[:parentclass] = val[2]
    end
    result = AST::NodeDef.new(args)
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 637
  def _reduce_87( val, _values, result )
    unless val[1].instance_of?(AST::ASTArray)
        val[1] = AST::ASTArray.new(
            :line => val[1].line,
            :file => val[1].file,
            :children => [val[1]]
        )
    end
    args = {
        :file => @lexer.file,
        :line => @lexer.line,
        :keyword => val[0],
        :names => val[1],
        :code => AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => []
        )
    }
    if val[2].instance_of?(AST::Name)
        args[:parentclass] = val[2]
    end
    result = AST::NodeDef.new(args)
   result
  end
.,.,

 # reduce 88 omitted

module_eval <<'.,.,', 'grammar.ra', 652
  def _reduce_89( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        result = val[0]
        result.push val[2]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0], val[2]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 660
  def _reduce_90( val, _values, result )
   result = AST::HostName.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 666
  def _reduce_91( val, _values, result )
   result = AST::HostName.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 672
  def _reduce_92( val, _values, result )
    result = AST::Default.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => val[0]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 680
  def _reduce_93( val, _values, result )
    result = AST::ASTArray.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :children => []
    )
   result
  end
.,.,

 # reduce 94 omitted

module_eval <<'.,.,', 'grammar.ra', 685
  def _reduce_95( val, _values, result )
    result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 696
  def _reduce_96( val, _values, result )
    if val[1].instance_of?(AST::ASTArray)
        result = val[1]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[1]]
        )
    end
   result
  end
.,.,

 # reduce 97 omitted

module_eval <<'.,.,', 'grammar.ra', 710
  def _reduce_98( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[0],val[2]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 718
  def _reduce_99( val, _values, result )
    result = AST::CompArgument.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :children => [val[0],val[2]]
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 725
  def _reduce_100( val, _values, result )
    result = AST::CompArgument.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :children => [val[0]]
    )
   result
  end
.,.,

 # reduce 101 omitted

module_eval <<'.,.,', 'grammar.ra', 734
  def _reduce_102( val, _values, result )
    result = AST::Name.new(
        :value => val[1],
        :file => @lexer.file,
        :line => @lexer.line
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 743
  def _reduce_103( val, _values, result )
    name = val[0].sub(/^\$/,'')
    result = AST::Variable.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :value => name
    )
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 755
  def _reduce_104( val, _values, result )
    if val[1].instance_of?(AST::ASTArray)
        result = val[1]
    else
        result = AST::ASTArray.new(
            :line => @lexer.line,
            :file => @lexer.file,
            :children => [val[1]]
        )
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 761
  def _reduce_105( val, _values, result )
    result = AST::ASTArray.new(
        :line => @lexer.line,
        :file => @lexer.file,
        :children => []
    )
   result
  end
.,.,

 # reduce 106 omitted

 # reduce 107 omitted

 # reduce 108 omitted

module_eval <<'.,.,', 'grammar.ra', 766
  def _reduce_109( val, _values, result )
 result = nil
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

    end   # class Parser

  end   # module Parser

end   # module Puppet
