# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.
#
# $Id: perl.mk,v 1.2 2000/12/27 07:57:47 muaddib Exp $
#
# Variables that may be set before this file is included:
#
# ROOT_PERLSRCS = the list of all the .pm files that live in
#                 the $(srcdir), and whose docs should go into
#                 the ROOT_PERLDOCDIR
# SRC_PERLSRCS  = the list of all the .pm files that live in
# 	          the $(srcdir) and whose docs should go into
#	          the PERLDOCDIR
# PERLSRCS      = the .pm files that will somehow get built into
#                 the build dir
#
# ROOT_PERLDOCDIR = the outer level dir that docs should be installed into
# PERLDOCDIR      = the inner level dir that docs should be installed into
#
# ROOT_PERLLIBDIR = the outer level dir that root .pm files should be 
#                   installed into
# PERLLIBDIR      = the inner level directory that the rest of the .pm 
#                   files should be installed into
# TESTLIB         = the inner level directory that tests reside in
# TESTPROGS       = the list of tests in TESTLIB


#------------ Installation Rules -------------------#

# Only install the various sections if the appropriate variables contain
# data, but when building the install target, always copy over the files
# in the target dirs.
install::
ifdef ROOT_PERLLIBDIR 
	${ENSUREDIR} $(ROOT_PERLLIBDIR)
 ifdef ROOT_PERLSRCS
	for i in $(ROOT_PERLSRCS); do  \
	${INSTALL_DATA} $(srcdir)/$$i $(ROOT_PERLLIBDIR)/$$i ; done
 endif
endif
ifdef PERLLIBDIR
	${ENSUREDIR} $(PERLLIBDIR)
 ifdef SRC_PERLSRCS
	for i in $(SRC_PERLSRCS); do  \
	${INSTALL_DATA} $(srcdir)/$$i $(PERLLIBDIR)/$$i ; done
 endif
 ifdef PERLSRCS
	for i in $(PERLSRCS); do  \
	${INSTALL_DATA} $$i $(PERLLIBDIR)/$$i ; done
 endif
endif

# fast-install depends on the root .pm files being installed in the
# ROOT_PERLLIBDIR directory and the other .pm files being installed in
# the PERLLIBDIR directory. Empty ROOT_PERLSRCS, SRC_PERLSRCS and
# PERLSRCS are harmless here, as they simply fail to generate any
# dependencies. Howerver, empty ROOT_PERLLIBDIR and PERLLIBDIR are
# not as harmless, as they could generate a dependency on files in
# the (absolute) root directory. 
fast-install:: \
ifdef ROOT_PERLLIBDIR \
	       $(ROOT_PERLLIBDIR) \
               $(addprefix $(ROOT_PERLLIBDIR)/, $(ROOT_PERLSRCS)) \
endif \
ifdef PERLLIBDIR \
               $(PERLLIBDIR) \
               $(addprefix $(PERLLIBDIR)/, $(SRC_PERLSRCS) $(PERLSRCS)) \
endif 


# Rules to install .pm files into the PERLLIBDIR. They only get
# created if the PERLLIBDIR variable has something in it.
ifdef PERLLIBDIR
$(PERLLIBDIR):
	$(ENSUREDIR) $(PERLLIBDIR)

$(PERLLIBDIR)/%.pm : $(srcdir)/%.pm
	$(INSTALL_DATA) $< $@

$(PERLLIBDIR)/%.pm : %.pm
	$(INSTALL_DATA) $< $@
endif

# Create rules to install .pm files into the ROOT_PERLLIBDIR if
# something has been defined for the ROOT_PERLLIBDIR variable.
ifdef ROOT_PERLLIBDIR
$(ROOT_PERLLIBDIR):
	$(ENSUREDIR) $(ROOT_PERLLIBDIR)

$(ROOT_PERLLIBDIR)/%.pm : $(srcdir)/%.pm
	$(INSTALL_DATA) $< $@
endif

# Check to see if things have been installed into the various
# install directories, but dont barf if some of the variables
# were not set properly
install-check::
ifdef PERLLIBDIR
 ifdef PERLSRCS
	for i in $(PERLSRCS); do \
	${perlcheck} $(PERLLIBDIR)/$$i ; done
 endif
 ifdef SRC_PERLSRCS
	for i in $(SRC_PERLSRCS); do \
	${perlcheck} $(PERLLIBDIR)/$$i ; done
 endif
endif
ifdef ROOT_PERLLIBDIR
 ifdef ROOT_PERLSRCS
	for i in $(ROOT_PERLSRCS); do  \
	${perlcheck} $(ROOT_PERLLIBDIR)/$$i ; done
 endif
endif

#---------- Documentation Rules ------------------#

# Build all of the *.pm.html files in the build directory
# regardless of whether they are root files or not, or whether
# they live in the source dir or the build dir.
doc:: $(addsuffix .html, $(PERLSRCS) $(SRC_PERLSRCS) $(ROOT_PERLSRCS))

# Pattern rule to make .pm.html files out of .pm files that live
# in the build directory.
%.pm.html : %.pm
	pod2html --infile=$< --outfile=$@

# Pattern rule to make .pm.html files out of .pm files that live
# in the source directory
%.pm.html : $(srcdir)/%.pm
	pod2html --infile=$< --outfile=$@

# The install-doc target depends on the existance of the ROOT_PERLDOCDIR
# (assuming it is non-blank), the PERLDOCDIR (assuming it is non blank),
# any root .pm.html files living in the ROOT_PERLDOCDIR directory, and
# and nonroot .pm.html files living in the PERLDOCDIR directory.
install-doc:: $(ROOT_PERLDOCDIR) $(PERLDOCDIR) \
       $(foreach FILE, $(ROOT_PERLSRCS), $(ROOT_PERLDOCDIR)/$(FILE).html )\
       $(foreach FILE, $(PERLSRCS) $(SRC_PERLSRCS), $(PERLDOCDIR)/$(FILE).html )

# If the ROOT_PERLDOCDIR was supplied, make rules for insuring its existance
# and for installing .html files into it from the build dir.
ifdef ROOT_PERLDOCDIR
$(ROOT_PERLDOCDIR):
	$(ENSUREDIR) $(ROOT_PERLDOCDIR)

$(ROOT_PERLDOCDIR)/%.html : %.html
	$(INSTALL_DATA) $< $@
endif

# If the PERLDOCDIR was supplied, make rules for insuring its existance
# and for installing .html files into it from the build dir.
ifdef PERLDOCDIR
$(PERLDOCDIR):
	$(ENSUREDIR) $(PERLDOCDIR)

$(PERLDOCDIR)/%.html : %.html
	$(INSTALL_DATA) $< $@
endif

# Clean up all of the junk left by pod2html
clean::
	rm -f *.html pod2html-*

#------------- Test Rules ---------------------#

# Run tests
install-test::
	cd $(srcdir)/t; \
	for i in *.t; do \
		echo $(srcdir)/t/$$i..; \
		$(perl) -I $(archlibperl) -I $(libperl) $$i; \
	done

