#ifndef INVITEDIALOG_H
#define INVITEDIALOG_H

#include <QCloseEvent>
#include "ui_invitedialog.h"
#include "ui_invitationdialog.h"

class InviteDialog : public QDialog
{
    Q_OBJECT
    public:
         InviteDialog(QStringList resources, QWidget *parent = 0);

    private:
         Ui::InviteDialog ui_;
         QStringList resources_;

    private slots:
         void buttonPressed();

    signals:
         void play(QString, QString);
};

class InvitationDialog : public QDialog
{
    Q_OBJECT
    public:
         InvitationDialog(QString jid, QString color, QWidget *parent = 0);

    private:
         Ui::InvitationDialog ui_;
         bool accepted;

    private slots:
         void buttonPressed();

    signals:
         void accept();
         void reject();

    protected:
         void closeEvent(QCloseEvent *e);
};


#endif // INVITEDIALOG_H
