//internal 
window.psi = function() {
	var chatEl = document.body;
	var trackbar = null;
	var scrollTimer = -1;

	var escapeHTML = function(html) {
		return html.split("&").join("&amp;").split( "<").join("&lt;").split(">").join("&gt;");
	}

	var icon2img = function (obj) {
	   var img = document.createElement('img');
	   img.src = "icon://psi/" + obj.getAttribute("name");
	   img.title = obj.getAttribute("text");
	   var ib = obj.nextSibling
	   while (obj.firstChild) obj.parentNode.insertBefore(obj.firstChild, ib);
	   obj.parentNode.replaceChild(img, obj);
	}


	var replaceIcons = function(el) {
		var icon, icons = [], i, els;
		while (true) {
			els = el.getElementsByTagName("icon");
			if (els.length == 0) break;
			for (i=0; i<els.length; i++) {
				icon2img(els[i]);
			}
		}
	}

	var atBottom = function() {
		return document.height == (window.innerHeight+window.pageYOffset);
	}

	var deferredScroll = function(time) {
		if (scrollTimer>=0) {
			clearTimeout(scrollTimer);
			psi.scrollToBottom();
		}
		scrollTimer = setTimeout(function() {psi.scrollToBottom(); scrollTimer=-1;}, time?time:50);
	}

	setTimeout("psi.scrollToBottom()", 3000); //to fix some resizing lags on start. not the best way though

	return {
		scrollToBottom : function(time) {
			if (time) deferredScroll(time)
			else chatEl.scrollTop = chatEl.scrollHeight
		},
		appendText : function(txt) {
			var needScroll = atBottom();
			el = document.createElement("div");
			el.style.margin="0px 3px 0px 3px"
			el.innerHTML = txt;
			chatEl.appendChild(el);
			try {
				replaceIcons(el);
			} catch(e) {
			  alert(e + e.line)
			}

			if (needScroll) deferredScroll();
		},
		clear : function() {
			chatEl.innerHTML = "";
		},
		doTrackbar : function() {
			var needScroll = atBottom()
			if (!trackbar) {
				trackbar = document.createElement("div");
				trackbar.innerHTML = '<hr style="height:1px; border:1px solid black; border-color:#bbf #66f #66f #bbf" />';
			} else {
				trackbar.parentNode.removeChild(trackbar);
			}
			chatEl.appendChild(trackbar);
			if (needScroll) deferredScroll();
		},
		modifyBaseStyle : function(s) {
			for (i in s) {
				chatEl.style[i] = s[i];
			}
		}
	}
}()
