#!/bin/bash
#######################################################################
#                                                                     #
#       Universal make dist script of Psi+ under Linux                #
#       Универсальный скрипт получения дистрибутива Psi+ под Linux    #
#                                                                     #
#######################################################################

# REQUIREMENTS / ТРЕБОВАНИЯ

# In order to build Psi+ you must have next packages in your system
# Для сборки Psi+ вам понадобятся следующие пакеты
# git - vcs system / система контроля версий
# gcc - compiler / компилятор
# qt4 tools libraries and headers (most probably "dev" packages)
#     qt4 тулзы либы и хидеры (наверное "dev" пакеты)
# qca/QtCrypto - encryption libs / криптовальные либы



# OPTIONS / НАСТРОЙКИ

# build and store directory / каталог для сорсов и сборки
PSI_DIR="${HOME}/psi"

# official repository / репозиторий официальной Psi
GIT_REPO_PSI=git://github.com/psi-im/psi.git

# do git pull on psi git working copy on start
# обновляться с репозитория перед сборкой
FORCE_REPO_UPDATE=1

# log of applying patches / лог применения патчей
PATCH_LOG=/tmp/psipatch.log

# do svn up on patches / обновлять патчи из svn
FORCE_PATCH_UPDATE=1

# skip patches which applies with errors / пропускать глючные патчи
SKIP_INVALID_PATCH=1

# only sources / только архив исходного кода
ONLY_SOURCE=1

PATCHTESTOPT="--dry-run"
[ `uname` = FreeBSD ] && PATCHTESTOPT="$PATCHTESTOPT -C"



# FUNCTIONS /функкции

# Exit with error message
die() { echo; echo " !!!ERROR: ${1}"; exit 1; }

# error status
_epatch_assert() { local _pipestatus=${PIPESTATUS[*]}; [[ ${_pipestatus// /} -eq 0 ]] ; }

#smart patcher
spatch() {
  popts=""
  PATCH_TARGET="${1}"

  if [ ! -f $PATCH_TARGET ]
  then
    echo "patch '${PATCH_TARGET}' doesn't exist"
    exit 1
  fi

  echo -n " * applying ${PATCH_TARGET}..."

  count=0
  while [ "${count}" -lt 2 ]; do
    echo " * trying patch -p${count} ${popts} --dry-run -f" >> $PATCH_LOG
    if (cat ${PATCH_TARGET} | patch -p${count} ${popts} ${PATCHTESTOPT} -f ; _epatch_assert) >> $PATCH_LOG 2>&1
    then
      cat ${PATCH_TARGET} | patch -p${count} ${popts} >> $PATCH_LOG 2>&1
      _epatch_assert
      if [ "$?" -ne 0 ]
      then
        echo "A dry-run of patch command succeeded, but actually"
        echo "applying the patch failed!"
        count=5
      fi
      break;
    fi
    count=$((count + 1))
  done

  if [ $count -ne 5 ]
  then
     echo "done"
     return 0
  else
     echo "failed"
     echo "see log here ${PATCH_LOG}"
     return 1
  fi
}

# Go Go Go!
echo -n "testing environment.."
v=`git --version 2>/dev/null` || die "You should install Git first. / Сначала установите Git"
v=`svn --version 2>/dev/null` || die "You should install subversion first. / Сначала установите subversion"
v=`qconf --version 2>/dev/null` || v=`qt-qconf --version 2>/dev/null` || die "You should install qconf first. / Сначала установите qconf"
echo "OK"

echo -n "init directories.."
if [ ! -d "${PSI_DIR}" ]
then
  mkdir "${PSI_DIR}" || die "can't create work directory ${PSI_DIR}"
fi

cd "${PSI_DIR}"
if [ ! -d psi ]
then
  mkdir psi || die "can't create directory for git sources ${PSI_DIR}/psi"
fi
if [ -d build ]
then
  echo -n "removing old build directory.."
  rm -rf build || die "can't delete old build directory ${PSI_DIR}/build"
fi
mkdir build || die "can't create build directory ${PSI_DIR}/build"
echo "OK"

if [ -d "psi/.git" ]
then
  echo "Starting updating.."
  cd psi
  if [ $FORCE_REPO_UPDATE != 0 ]; then
    git pull || die "git update failed"
    git submodule update || die "git submodule update failed"
  else
    echo "Update disabled in options"
  fi
else
  echo "New fresh repo.."
  git clone "${GIT_REPO_PSI}" || die "git clone failed"
  cd psi
  git submodule init || die "git submodule init failed"
  git submodule update || die "git submodule update failed"
fi

echo "exporting sources"
git archive --format=tar master | ( cd "${PSI_DIR}/build" ; tar xf - )
cd "${PSI_DIR}/psi/iris"
git archive --format=tar master | ( cd "${PSI_DIR}/build/iris" ; tar xf - )
cd "${PSI_DIR}/psi/src/libpsi"
git archive --format=tar master | ( cd "${PSI_DIR}/build/src/libpsi" ; tar xf - )

echo "downloading psi+.."

cd "${PSI_DIR}"
if [ -d psi+ ]
then
  [ $FORCE_PATCH_UPDATE != 0 ] && ( svn up psi+ || die "psi+ update failed" )
else
  svn co http://psi-dev.googlecode.com/svn/trunk/ psi+/ \
  	|| die "psi+ checkout failed"
fi

svn export --force psi+/ build/

rm build/patches/*win32* 2>/dev/null
rm build/patches/380* #проверка на апдейт для виндузятников
rm build/patches/600* #нафиг не нужно - это должно быть в diff.gz
PATCHES=`ls -1 build/patches/*diff 2>/dev/null`

# build and install / собираем и устанавливаем
cd "${PSI_DIR}/build"
for p in $PATCHES; do
   spatch "${PSI_DIR}/${p}"
   if [ "$?" != 0 ]
   then
     [ $SKIP_INVALID_PATCH != 0 ] && echo "skip invalid patch"
     [ $SKIP_INVALID_PATCH == 0 ] && die "can't continue due to patch failed"
   fi
done
rev=`svnversion "../psi+"`
sed "s/.xxx/.${rev}/" -i src/applicationinfo.cpp

sed 's/<!--\(.*plugins.*\)-->/\1/' -i psi.qc
qt-qconf || qconf

find "${PSI_DIR}/build" -name '*.orig' | xargs rm -rf $1

#очищаем виндовый хлам
find "${PSI_DIR}/build" -name 'win32'  | xargs rm -rf $1

#Ну кто так файлы кладет в svn
cp -R "${PSI_DIR}/build/plugins" "${PSI_DIR}/build/src/"
rm -rf "${PSI_DIR}/build/plugins"

#Удаляем копии иконок
rm -rf "${PSI_DIR}/build/iconsets/clients/default"
rm -rf "${PSI_DIR}/build/iconsets/moods/default"

#к сожалению из-за лицензии
#rm -rf "${PSI_DIR}/build/iconsets/clients"

rm -rf "${PSI_DIR}/psi-plus-0.14~svn${rev}"
mv "${PSI_DIR}/build" "${PSI_DIR}/psi-plus-0.14~svn${rev}"
cd ${PSI_DIR}
tar -cjf "psi-plus-0.14~svn${rev}.tar.bz2" "psi-plus-0.14~svn${rev}"
rm -rf "${PSI_DIR}/psi-plus-0.14~svn${rev}"

