/***************************************************************************
                          core.h  -  description
                             -------------------
    begin                : Mon May 13 2002
    copyright          : Proxy Labs (C) 2002 by Net Creature,
    email                : netcreature@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __CORE_HEADER
#define __CORE_HEADER
#define BUFF_SIZE 8*1024  // used to read responses from poxies.
/*error codes*/
typedef enum
{
 SUCCESS=0,
 MEMORY_FAIL,        // malloc failed
 SOCKET_ERROR,  // look errno for more
 CHAIN_DOWN,    // no proxy in chain responds to tcp
 CHAIN_EMPTY,   //  if proxy_count = 0
 BLOCKED  //  target's port blocked on last proxy in the chain
} ERR_CODE;


typedef enum {HTTP_TYPE,SOCKS4_TYPE,SOCKS5_TYPE} proxy_type;
typedef enum {DYNAMIC_TYPE,STRICT_TYPE,RANDOM_TYPE} chain_type;
typedef enum {PLAY_STATE,DOWN_STATE,BLOCKED_STATE} proxy_state;

typedef struct
{
in_addr_t ip;
in_port_t port;
proxy_type pt;
proxy_state ps;
char user[256];
char pass[256];
} proxy_data;

typedef struct
{
	proxy_data *pd;
 	chain_type ct;
  	unsigned int proxy_count;
   	int sock;
    	struct sockaddr addr;
      int flags;
} thread_arg;

int connect_proxy_chain (
                int sock,
                in_addr_t target_ip,
                in_port_t target_port,
                proxy_data * pd,
                unsigned int proxy_count,
                chain_type ct );
//#define threaded_px

#endif
