#include <stdio.h>
#include <stdint.h>

uint32_t *aboutScreenBMP    = NULL, *arrowBMP           = NULL, *clearDialogBMP     = NULL;
uint32_t *diskOpScreenBMP   = NULL, *editOpModeCharsBMP = NULL, *mod2wavBMP         = NULL;
uint32_t *editOpScreen1BMP  = NULL, *editOpScreen2BMP   = NULL, *samplerVolumeBMP   = NULL;
uint32_t *editOpScreen3BMP  = NULL, *editOpScreen4BMP   = NULL, *spectrumVisualsBMP = NULL;
uint32_t *muteButtonsBMP    = NULL, *posEdBMP           = NULL, *monoScopeBMP       = NULL;
uint32_t *samplerFiltersBMP = NULL, *samplerScreenBMP   = NULL, *pat2SmpDialogBMP   = NULL;
uint32_t *termTopBMP        = NULL, *termScrollBarBMP   = NULL;
uint32_t *trackerFrameBMP   = NULL, *yesNoDialogBMP     = NULL;

int8_t pNoteTable[32] = // for drumpad
{
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24
};

const char noteNames1[36][4] =
{
    "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1" ,"G-1", "G#1", "A-1", "A#1", "B-1",
    "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2" ,"G-2", "G#2", "A-2", "A#2", "B-2",
    "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3" ,"G-3", "G#3", "A-3", "A#3", "B-3"
};

const char noteNames2[36][4] =
{
    "C-1", { 'D', 127, '1'}, "D-1", { 'E', 127, '1'}, "E-1", "F-1", { 'G', 127, '1'}, "G-1", { 'A', 127, '1'}, "A-1", { 'B', 127, '1'}, "B-1",
    "C-2", { 'D', 127, '2'}, "D-2", { 'E', 127, '2'}, "E-2", "F-2", { 'G', 127, '2'}, "G-2", { 'A', 127, '2'}, "A-2", { 'B', 127, '2'}, "B-2",
    "C-3", { 'D', 127, '3'}, "D-3", { 'E', 127, '3'}, "E-3", "F-3", { 'G', 127, '3'}, "G-3", { 'A', 127, '3'}, "A-3", { 'B', 127, '3'}, "B-3"
};

const int8_t tuneToneData[32] = // Tuning Tone (Sine Wave)
{
      0,  25,  49,  71,  91, 106, 118, 126,
    127, 126, 118, 106,  91,  71,  49,  25,
      0, -25, -49, -71, -91,-106,-118,-126,
   -127,-126,-118,-106, -91, -71, -49, -25
};

const uint16_t cursorPosTable[24] =
{
     30,  54,  62,  70,  78,  86,
    102, 126, 134, 142, 150, 158,
    174, 198, 206, 214, 222, 230,
    246, 270, 278, 286, 294, 302
};

const int8_t vuMeterHeights[65] =
{
     0,  0,  1,  2,  2,  3,  4,  5,
     5,  6,  7,  8,  8,  9, 10, 11,
    11, 12, 13, 14, 14, 15, 16, 17,
    17, 18, 19, 20, 20, 21, 22, 23,
    23, 24, 25, 26, 26, 27, 28, 29,
    29, 30, 31, 32, 32, 33, 34, 35,
    35, 36, 37, 38, 38, 39, 40, 41,
    41, 42, 43, 44, 44, 45, 46, 47,
    48
};

const uint8_t funkTable[16] = // EFx (FunkRepeat/InvertLoop)
{
    0x00, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0D,
    0x10, 0x13, 0x16, 0x1A, 0x20, 0x2B, 0x40, 0x80
};

const uint8_t vibratoTable[32] =
{
    0x00, 0x18, 0x31, 0x4A, 0x61, 0x78, 0x8D, 0xA1,
    0xB4, 0xC5, 0xD4, 0xE0, 0xEB, 0xF4, 0xFA, 0xFD,
    0xFF, 0xFD, 0xFA, 0xF4, 0xEB, 0xE0, 0xD4, 0xC5,
    0xB4, 0xA1, 0x8D, 0x78, 0x61, 0x4A, 0x31, 0x18
};

uint16_t periodTable[606] =
{
    856,808,762,720,678,640,604,570,538,508,480,453,
    428,404,381,360,339,320,302,285,269,254,240,226,
    214,202,190,180,170,160,151,143,135,127,120,113,0,
    850,802,757,715,674,637,601,567,535,505,477,450,
    425,401,379,357,337,318,300,284,268,253,239,225,
    213,201,189,179,169,159,150,142,134,126,119,113,0,
    844,796,752,709,670,632,597,563,532,502,474,447,
    422,398,376,355,335,316,298,282,266,251,237,224,
    211,199,188,177,167,158,149,141,133,125,118,112,0,
    838,791,746,704,665,628,592,559,528,498,470,444,
    419,395,373,352,332,314,296,280,264,249,235,222,
    209,198,187,176,166,157,148,140,132,125,118,111,0,
    832,785,741,699,660,623,588,555,524,495,467,441,
    416,392,370,350,330,312,294,278,262,247,233,220,
    208,196,185,175,165,156,147,139,131,124,117,110,0,
    826,779,736,694,655,619,584,551,520,491,463,437,
    413,390,368,347,328,309,292,276,260,245,232,219,
    206,195,184,174,164,155,146,138,130,123,116,109,0,
    820,774,730,689,651,614,580,547,516,487,460,434,
    410,387,365,345,325,307,290,274,258,244,230,217,
    205,193,183,172,163,154,145,137,129,122,115,109,0,
    814,768,725,684,646,610,575,543,513,484,457,431,
    407,384,363,342,323,305,288,272,256,242,228,216,
    204,192,181,171,161,152,144,136,128,121,114,108,0,
    907,856,808,762,720,678,640,604,570,538,508,480,
    453,428,404,381,360,339,320,302,285,269,254,240,
    226,214,202,190,180,170,160,151,143,135,127,120,0,
    900,850,802,757,715,675,636,601,567,535,505,477,
    450,425,401,379,357,337,318,300,284,268,253,238,
    225,212,200,189,179,169,159,150,142,134,126,119,0,
    894,844,796,752,709,670,632,597,563,532,502,474,
    447,422,398,376,355,335,316,298,282,266,251,237,
    223,211,199,188,177,167,158,149,141,133,125,118,0,
    887,838,791,746,704,665,628,592,559,528,498,470,
    444,419,395,373,352,332,314,296,280,264,249,235,
    222,209,198,187,176,166,157,148,140,132,125,118,0,
    881,832,785,741,699,660,623,588,555,524,494,467,
    441,416,392,370,350,330,312,294,278,262,247,233,
    220,208,196,185,175,165,156,147,139,131,123,117,0,
    875,826,779,736,694,655,619,584,551,520,491,463,
    437,413,390,368,347,328,309,292,276,260,245,232,
    219,206,195,184,174,164,155,146,138,130,123,116,0,
    868,820,774,730,689,651,614,580,547,516,487,460,
    434,410,387,365,345,325,307,290,274,258,244,230,
    217,205,193,183,172,163,154,145,137,129,122,115,0,
    862,814,768,725,684,646,610,575,543,513,484,457,
    431,407,384,363,342,323,305,288,272,256,242,228,
    216,203,192,181,171,161,152,144,136,128,121,114,0,

    // PT BUGFIX: overflowing arpeggio on -1 finetuned samples, add extra zeroes.
    0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const char hexTable[16] =
{
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};

const uint8_t unshiftedKeymap[64] =
{
    '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '=', '\\', '*', '0', '`',
    'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', '*', '1', '2', '3',
    'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'', '#', '\0', '4', '5', '6',
    '<', 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/', '\0', '.', '7', '8', '9', ' '
};

const int8_t rawKeyScaleTable[41] =
{
    49, 33, 50, 34, 51, 52, 36, 53, 37, 54, 38, 55, 56,
    40, 57, 41, 58, 16,  2, 17,  3, 18, 19,  5, 20,  6,
    21,  7, 22, 23,  9, 24, 70, 25, 26, 12, 27, 70, 70,
    14, 11
};

const int8_t kbdTransTable[2][41] =
{
    // high octave (default)
    {
        12,13,14,15,16,17,18,19,20,21,22,23,24,25,
        26,27,28,24,25,26,27,28,29,30,31,32,33,34,
        35,37,37,37,37,37,37,37,37,37,37,37,37
    },

    // low octave
    {
         0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,
        14,15,16,12,13,14,15,16,17,18,19,20,21,22,
        23,24,25,26,27,28,29,30,31,36,36,27,30
    }
};

// for terminal
const uint8_t topazFontPacked[760] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x00,
    0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x7F, 0x36, 0x7F, 0x36, 0x36, 0x00,
    0x18, 0x7C, 0x06, 0x3C, 0x60, 0x3E, 0x18, 0x00, 0x00, 0x66, 0x35, 0x1B, 0x6C, 0x56, 0x33, 0x00,
    0x1C, 0x36, 0x16, 0x6E, 0x3B, 0x73, 0xDE, 0x00, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00,
    0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x00,
    0x3C, 0x66, 0x76, 0x7E, 0x6E, 0x66, 0x3C, 0x00, 0x18, 0x1C, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x00,
    0x3C, 0x66, 0x60, 0x30, 0x18, 0x0C, 0x7E, 0x00, 0x3C, 0x66, 0x60, 0x38, 0x60, 0x66, 0x3C, 0x00,
    0x38, 0x3C, 0x36, 0x33, 0x7F, 0x30, 0x30, 0x00, 0x7E, 0x06, 0x3E, 0x60, 0x60, 0x66, 0x3C, 0x00,
    0x38, 0x0C, 0x06, 0x3E, 0x66, 0x66, 0x3C, 0x00, 0x7E, 0x60, 0x60, 0x30, 0x18, 0x18, 0x18, 0x00,
    0x3C, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x3C, 0x00, 0x3C, 0x66, 0x66, 0x7C, 0x60, 0x30, 0x1C, 0x00,
    0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x0C,
    0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x7E, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x00, 0x3C, 0x66, 0x60, 0x30, 0x18, 0x00, 0x18, 0x00,
    0x3E, 0x63, 0x7B, 0x6B, 0x7B, 0x03, 0x1E, 0x00, 0x3C, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00,
    0x3E, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x3E, 0x00, 0x78, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x78, 0x00,
    0x1E, 0x36, 0x66, 0x66, 0x66, 0x36, 0x1E, 0x00, 0x7E, 0x06, 0x06, 0x1E, 0x06, 0x06, 0x7E, 0x00,
    0x7E, 0x06, 0x06, 0x1E, 0x06, 0x06, 0x06, 0x00, 0x3C, 0x66, 0x06, 0x76, 0x66, 0x66, 0x7C, 0x00,
    0x66, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x3C, 0x00, 0x63, 0x33, 0x1B, 0x0F, 0x1B, 0x33, 0x63, 0x00,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7E, 0x00, 0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x63, 0x00,
    0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00,
    0x3E, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x06, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x3B, 0x7E, 0x00,
    0x3E, 0x66, 0x66, 0x3E, 0x36, 0x66, 0x66, 0x00, 0x3C, 0x66, 0x0E, 0x3C, 0x70, 0x66, 0x3C, 0x00,
    0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x3C, 0x3C, 0x18, 0x00, 0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00,
    0xC3, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0xC3, 0x00, 0xC3, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x00,
    0x7F, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x7F, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00,
    0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00,
    0x08, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
    0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x60, 0x7C, 0x66, 0x7C, 0x00,
    0x06, 0x06, 0x3E, 0x66, 0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 0x3C, 0x06, 0x06, 0x06, 0x3C, 0x00,
    0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x7E, 0x06, 0x3C, 0x00,
    0x38, 0x0C, 0x3E, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x3C,
    0x06, 0x06, 0x3E, 0x66, 0x66, 0x66, 0x66, 0x00, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00,
    0x30, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1E, 0x06, 0x06, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x37, 0x7F, 0x6B, 0x63, 0x63, 0x00,
    0x00, 0x00, 0x3E, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x00,
    0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60,
    0x00, 0x00, 0x3E, 0x66, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x3C, 0x06, 0x3C, 0x60, 0x3E, 0x00,
    0x0C, 0x0C, 0x3E, 0x0C, 0x0C, 0x0C, 0x38, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7C, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6B, 0x7F, 0x36, 0x00,
    0x00, 0x00, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x0C,
    0x00, 0x00, 0x7E, 0x30, 0x18, 0x0C, 0x7E, 0x00, 0x70, 0x18, 0x18, 0x0E, 0x18, 0x18, 0x70, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x0E, 0x18, 0x18, 0x70, 0x18, 0x18, 0x0E, 0x00,
    0x4E, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
