/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.EventObject;
import weka.core.Instances;

public class TestSetEvent
extends EventObject {
    private static final long serialVersionUID = 8780718708498854231L;
    protected Instances m_testSet;
    private boolean m_structureOnly;
    protected int m_runNumber = 1;
    protected int m_maxRunNumber = 1;
    protected int m_setNumber;
    protected int m_maxSetNumber;

    public TestSetEvent(Object source, Instances testSet) {
        super(source);
        this.m_testSet = testSet;
        if (this.m_testSet != null && this.m_testSet.numInstances() == 0) {
            this.m_structureOnly = true;
        }
    }

    public TestSetEvent(Object source, Instances testSet, int setNum, int maxSetNum) {
        this(source, testSet);
        this.m_setNumber = setNum;
        this.m_maxSetNumber = maxSetNum;
    }

    public TestSetEvent(Object source, Instances testSet, int runNum, int maxRunNum, int setNum, int maxSetNum) {
        this(source, testSet, setNum, maxSetNum);
        this.m_runNumber = runNum;
        this.m_maxRunNumber = maxRunNum;
    }

    public Instances getTestSet() {
        return this.m_testSet;
    }

    public int getRunNumber() {
        return this.m_runNumber;
    }

    public int getMaxRunNumber() {
        return this.m_maxRunNumber;
    }

    public int getSetNumber() {
        return this.m_setNumber;
    }

    public int getMaxSetNumber() {
        return this.m_maxSetNumber;
    }

    public boolean isStructureOnly() {
        return this.m_structureOnly;
    }
}

