/***************************************************************************
                          supermountwatcher.cpp  -  description
                             -------------------
    begin                : Mon Oct 3 2004
    copyright            : (C) 2004 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "supermountwatcher.h"
#include "datadispatcher.h"
#include "gui.h"

#include <qdir.h>
#include <qvaluelist.h>

#define SUBFS "/proc/fs/supermount/subfs"

SupermountWatcher::SupermountWatcher() {
    stopCalled = false;
    paused = false;
}

void SupermountWatcher::addDevice(QString device, QString dir) {
    deviceStates[device] = "unmounted";
    deviceMountpoints[device] = dir;
    bool listed = false;
    QFile f(SUBFS);
    if(f.exists() && f.open(IO_ReadOnly)) {
        QTextStream t(&f);
        QString s;
        while(!t.eof()) {
            s = t.readLine();
            s = s.simplifyWhiteSpace();
            if(!s.isEmpty()) {
                QString devicename = s.left(s.find(' '));
                s = s.remove(0, s.find(' ') + 1);
                QString mounted = s.left(s.find(' '));

                if(devicename == device) {
                    deviceStates[devicename] = mounted;
                    deviceMountpoints[devicename] = dir;
                    listed = true;
                    break;
                }
            }
        }
        f.close();
    }

    if(!listed) {
        QString cmd = "mount " + dir + " &";
        system(cmd.local8Bit().data());
    }
}

void SupermountWatcher::stop() {
    stopCalled = true;
}

void SupermountWatcher::pause() {
    paused = true;
}

void SupermountWatcher::proceed() {
    paused = false;
}

void SupermountWatcher::run() {
    QFile f(SUBFS);

    for(;;) {
        msleep(1000);
        if(stopCalled) {
            exit();
        }
        if(paused || deviceMountpoints.empty()) {
            continue;
        }
        mutex.lock();

        if(!(f.exists() && f.open(IO_ReadOnly))) {
            // TRANSLATORS: %1 = filename
            MessageEvent* e = new MessageEvent(QString(_("Error: Could not read '%1'.\nPlease contact the prokyon3 developers\nbecause it seems that your supermount implementation\nisn't supported by prokyon3 correctly")).arg(QString(SUBFS)));
            QApplication::postEvent( gui, e );
            mutex.unlock();
            exit();
        }

        QTextStream t(&f);
        QString s;
        QMap<QString, bool> supermounts;
        while(!t.eof()) {
            s = t.readLine();
            s = s.simplifyWhiteSpace();
            if(!s.isEmpty()) {
                QString devicename = s.left(s.find(' '));
                s = s.remove(0, s.find(' ') + 1);
                QString mounted = s.left(s.find(' '));
                supermounts[devicename] = true;
                if(deviceStates.contains(devicename) && deviceStates[devicename] != mounted) {
                    deviceStates[devicename] = mounted;
                    app->lock()
                    ;
                    datadispatcher->eventDirHasChanged(deviceMountpoints[devicename]);
                    app->unlock();
                }
            }
        }
        f.close();

        QValueList<QString> list = deviceStates.keys();
        for(QValueList<QString>::Iterator it = list.begin(); it != list.end(); ++it ) {
            if(!supermounts.contains(*it) && deviceStates[*it] != "unmounted") {
                deviceStates[*it] = "unmounted";
                app->lock()
                ;
                datadispatcher->eventDirHasChanged(deviceMountpoints[*it]);
                app->unlock();
            }

            // force update of /proc/fs/supermount/subfs
            QString cmd = "ls " + deviceMountpoints[*it] + "> /dev/null &";
            system(cmd.local8Bit().data());
        }

        mutex.unlock();
    }
}
