/***************************************************************************
                       lvi_playlisttrack.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 
    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_playlisttrack.h"
#include "gui.h"
#include "pixmapcache.h"

LVI_PlaylistTrack::LVI_PlaylistTrack(QListView *parent, PLAYLIST_TRACK *_playlist_track, int _mtype)
: QListViewItem(parent), playlist_track(_playlist_track), mtype(_mtype) {
    setText(0, "");
    setText(1, playlist_track->artist + " - " + playlist_track->title);
    if ( parent->lastItem() )
        moveItem( parent->lastItem() );
}

PLAYLIST_TRACK* LVI_PlaylistTrack::getPlaylistTrack() {
    return playlist_track;
}

int LVI_PlaylistTrack::getID() {
    return playlist_track->id;
}
int LVI_PlaylistTrack::getTrackID() {
    return playlist_track->track_id;
}
int LVI_PlaylistTrack::getMediumID() {
    return playlist_track->medium_id;
}
int LVI_PlaylistTrack::getMediumType() {
    return mtype;
}
int LVI_PlaylistTrack::getPlaylistID() {
    return playlist_track->playlist_id;
}
int LVI_PlaylistTrack::getPlaylistPosition() {
    return playlist_track->position_in_playlist;
}
QString LVI_PlaylistTrack::getArtist() {
    return playlist_track->artist;
}
QString LVI_PlaylistTrack::getTitle() {
    return playlist_track->title;
}
int LVI_PlaylistTrack::getSize() {
    return playlist_track->size;
}
int LVI_PlaylistTrack::getLength() {
    return playlist_track->length;
}
bool LVI_PlaylistTrack::getIsAvailable() {
    return isAvailable;
}

void LVI_PlaylistTrack::setPlaylistPosition(int pos) {
    playlist_track->position_in_playlist = pos;
}

void LVI_PlaylistTrack::setAvailability(bool avail) {
    isAvailable = avail;
    //  setEnabled(isAvailable);
    adjustIcon();
}

void LVI_PlaylistTrack::adjustIcon() {
    switch(mtype) {
    case MEDIUM_HARDDISK:
        setPixmap(1, pixmapcache->get
                  ("lvi_hdd.png"));
        break;
    case MEDIUM_CDROM:
        if(!isAvailable)
            setPixmap(1, pixmapcache->getFaded("lvi_cdrom.png"));
        else
            setPixmap(1, pixmapcache->get
                      ("lvi_cdrom.png"));
        break;
    case MEDIUM_SMB:
        if(!isAvailable)
            setPixmap(1, pixmapcache->getFaded("lvi_smb.png"));
        else
            setPixmap(1, pixmapcache->get
                      ("lvi_smb.png"));
        break;
    case MEDIUM_NFS:
        if(!isAvailable)
            setPixmap(1, pixmapcache->getFaded("lvi_nfs.png"));
        else
            setPixmap(1, pixmapcache->get
                      ("lvi_nfs.png"));
        break;
    }
}

#ifdef HAVE_MIXXX
void LVI_PlaylistTrack::adjustMixxxStatus(int status) {
    switch(status) {
    case 1: // play
        setPixmap(0, pixmapcache->get
                  ("prelisten_play2.png"));
        break;
    case 2: // pause
        setPixmap(0, pixmapcache->get
                  ("prelisten_pause.png"));
        break;
    case 0: // nothing
    default:
        setPixmap(0, 0);
    }
}
#endif /* HAVE_MIXXX */

int LVI_PlaylistTrack::key() const {
    return playlist_track->position_in_playlist;
}

int LVI_PlaylistTrack::compare(QListViewItem *i, int col, bool ascending) const {
    LVI_PlaylistTrack *item = static_cast<LVI_PlaylistTrack*>(i);

    if(key() < item->key())
    return -1;
    else if(key() > item->key())
        return 1;
        else
            return 0;
        }

        LVI_PlaylistTrack::~LVI_PlaylistTrack() {
            delete playlist_track;
        }

