#ifndef LVI_ALBUM_H
#define LVI_ALBUM_H

#include "prokyon.h"

#include <qlistview.h>
#include <qpixmap.h>

class LVI_Album: public QListViewItem {
public:

    LVI_Album(QListViewItem *parent, ARTISTALBUM *album);
    LVI_Album(QListView *parent, ARTISTALBUM *album);
    LVI_Album(QListView *parent, DELTAINFO *delta);
    LVI_Album(QListViewItem *parent, ALBUMINFO delta);

    bool applyDelta(ALBUMINFO delta);
    bool applyDelta(DELTAINFO *delta);

    bool getIsArtist() {
        return isArtist;
    }
    bool getIsArtistFavourite() {
        return isArtistFavourite;
    }
    int getArtistId() {
        return artistId;
    }
    int getLocal() const {
        return local;
    }
    int getTotal() const {
        return total;
    }
    int getMedium() const {
        return medium;
    }
    void setIsArtistFavourite(bool val) {
        isArtistFavourite = val;
        return;
    }
    void setLocal(const int a) {
        local = a;
        return;
    }
    void setTotal(const int b) {
        total = b;
        return;
    }
    void addLocal(const int a) {
        local += a;
        adjustIcon();
        return;
    }
    void addTotal(const int b) {
        total += b;
        adjustIcon();
        return;
    }
    void changeLocal(int delta);
    void adjustIcon(bool);

private:
    void adjustIcon();

    bool isArtist;
    bool isArtistFavourite;
    int total;
    int local;
    int artistId;
    int medium;
};

#endif
