/***************************************************************************
                          gui_datadispatcher.h  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATADISPATCHER_H
#define DATADISPATCHER_H

#include "prokyon.h"

#include "lvi_cddrive.h"
#include "lvi_smbshare.h"
#include "lvi_nfsexport.h"
#include "lvi_medium.h"
#include "lvi_playlist.h"
#include "lvi_playlisttrack.h"

#include <qptrlist.h>
#include <qmap.h>

class DataDispatcher {
public:
    DataDispatcher();

    #ifdef HAVE_MIXXX

    void eventEstablishedMixxxConnection();
    void eventLostMixxxConnection();
    #endif /* HAVE_MIXXX */

    void eventStartedExaminingCDROM(LVI_CDDrive *drive);
    void eventStartedAppendingCDROM(LVI_CDDrive *drive);
    void eventStoppedAppendingCDROM(LVI_CDDrive *drive);
    void eventStartedAppendingSMB(LVI_SMBShare *share);
    void eventStoppedAppendingSMB(LVI_SMBShare *share);
    void eventStartedAppendingNFS(LVI_NFSExport *Export);
    void eventStoppedAppendingNFS(LVI_NFSExport *Export);

    void eventCDROMInserted(LVI_CDDrive *drive);
    void eventSMBMounted(LVI_SMBShare *share);
    void eventNFSMounted(LVI_NFSExport *Export);
    void eventMediumNoMoreAvailable(int id);

    void eventStartedHarddiskSynchronizing();
    void eventStoppedHarddiskSynchronizing();

    void eventStartedCDROMSynchronizing(LVI_CDDrive *drive);
    void eventStoppedCDROMSynchronizing(LVI_CDDrive *drive);

    void eventStartedSMBSynchronizing(LVI_SMBShare *share);
    void eventStoppedSMBSynchronizing(LVI_SMBShare *share);

    void eventStartedNFSSynchronizing(LVI_NFSExport *Export);
    void eventStoppedNFSSynchronizing(LVI_NFSExport *Export);

    void eventFilenameHasChanged(int id, QString filename);

    void eventDirHasChanged(QString dir);

    void eventAddEditLock();
    void eventRemoveEditLock();
    void eventAddReadWriteLock();
    void eventRemoveReadWriteLock();

    void eventSelectArtistAlbum();

    void eventNewAlbumBasis(QList<ARTISTALBUM> *list);
    void eventNewFavouritesBasis(QList<ARTISTALBUM> *list);
    void eventNewArtistAlbumBasis(QList<ARTISTALBUM> *list, bool select);
    void eventNewMediumBasis(QList<MEDIUM> *list);
    void eventNewLocalAlbumDeltaBasis(QMap<int, QMap<QString, int> > *delta);
    void eventNewLocalAlbumDelta(int id, QMap<QString, int> delta);

    void eventNewArtistDelta(QMap<int, QMap<int, DELTAINFO*> > *delta);

    void eventNewTrackListing(QList<TRACK> *list);

    #ifdef HAVE_MEXTRAS

    void eventNewExtraData(EXTRADATA_GUI *data);
    void eventMextrasTrackListing(QList<TRACK> *list);
    #endif /* HAVE_MEXTRAS */

    void eventNewMedium(MEDIUM *medium);
    void eventMediumRemoved(int id);
    void eventMediumRenamed(MEDIUM *medium);

    void eventMediumIsBusy(LVI_Medium *medium);

    void eventNewPlaylistBasis(QList<PLAYLIST> *list);
    void eventNewPlaylistTracksBasis(QList<PLAYLIST_TRACK> *list, int playlistID);
    void eventNewPlaylist(PLAYLIST *playlist, bool isNewCreated=false);
    void eventNewPlaylistTrack(PLAYLIST_TRACK *, int playlistID);
    void eventRemovePlaylist(LVI_Playlist *playlist);
    void eventRenamePlaylist(LVI_Playlist *playlist, QString newname);
    void eventMovePlaylistTrack();
    void eventCloseSelectorTree();

    void eventNewCustomQueries(QMap<QString,QString>);

    ~DataDispatcher();
};

#endif
