/*
    ProjectTypeLoader.m

    Implementation of the ProjectTypeLoader class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ProjectTypeLoader.h"

#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>

#import "ProjectType.h"
#import "BundleExtensionLoader.h"

@implementation ProjectTypeLoader

static ProjectTypeLoader * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- init
{
  if ([super init])
    {
      /* load all project type bundles */

      NSMutableDictionary * projTypes;
      NSArray * bundles;
      NSBundle * bundle;
      NSEnumerator * e;

      bundles = [[BundleExtensionLoader shared]
        extensionsForBundleType: @"projtype"
         principalClassProtocol: @protocol(ProjectType)
             bundleSubdirectory: @"ProjectManager"
                      inDomains: 0
           domainDetectionByKey: @"ProjectTypes"];

      projTypes = [NSMutableDictionary dictionaryWithCapacity:
        [bundles count]];

      e = [bundles objectEnumerator];
      while ((bundle = [e nextObject]) != nil)
        {
          Class principalClass = [bundle principalClass];

          [projTypes setObject: principalClass
                        forKey: [principalClass projectTypeID]];
        }

      ASSIGNCOPY(projectTypes, projTypes);

      return self;
    }
  else
    {
      return nil;
    }
}

- (NSDictionary *) projectTypes
{
  return projectTypes;
}

- (id <ProjectType>) projectTypeForTypeID: (NSString *) projectTypeID
                                  project: (ProjectDocument *) project
                           infoDictionary: (NSDictionary *) infoDict
{
  Class projType;

  projType = [projectTypes objectForKey: projectTypeID];

  return [[[projType alloc]
     initWithOwner: project
    infoDictionary: infoDict]
    autorelease];
}

@end
