/*
    ProjectAttributes.m

    Implementation of the ProjectAttributes class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ProjectAttributes.h"

#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>

#import <AppKit/NSBox.h>
#import <AppKit/NSPopUpButton.h>

#import "ProjectDocument.h"
#import "ProjectType.h"
#import "ProjectNameChecking.h"

@implementation ProjectAttributes

- (void) dealloc
{
  TEST_RELEASE(generalView);
  TEST_RELEASE(additionalAttributeViews);

  [super dealloc];
}

- (void) awakeFromNib
{
  [super awakeFromNib];

  [generalView retain];

  ASSIGN(additionalAttributeViews, [[document projectType]
    projectAttributeViews]);
  [popup addItemsWithTitles: [[additionalAttributeViews allKeys]
    sortedArrayUsingSelector: @selector(caseInsensitiveCompare:)]];
  [projectName setStringValue: [document projectName]];
  [projectType setStringValue: [[[document projectType] class]
    humanReadableProjectTypeName]];
}

- (void) switchView: sender
{
  if ([popup indexOfSelectedItem] == 0)
    {
      [contentView setContentView: generalView];
    }
  else
    {
      [contentView setContentView: [additionalAttributeViews
        objectForKey: [popup titleOfSelectedItem]]];
    }
}

- (void) changeProjectName: sender
{
  NSString * newProjectName = [projectName stringValue];

  if (IsValidProjectName(newProjectName, YES))
    {
      [document setProjectName: newProjectName];
    }
}

@end
