/*
    FileTypeDetermining.m

    Function definitions for file type determination for the ProjectManager
    application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "FileTypeDetermining.h"

#import <Foundation/NSString.h>
#import <Foundation/NSFileHandle.h>
#import <Foundation/NSData.h>

#import <ctype.h>

/**
 * Returns YES if the file identified by `filename' is a text file,
 * otherwise returns NO.
 *
 * The test is one by reading the first 512 bytes of the file
 * and checking whether at least 90% of the data are printable
 * ASCII characters.
 */
BOOL
IsTextFile (NSString * filename)
{
  NSFileHandle * fh;
  NSData * data;
  unsigned int i, n;
  const char * buf;
  unsigned int printable;

  fh = [NSFileHandle fileHandleForReadingAtPath: filename];
  if (fh == nil)
    {
      return NO;
    }

  data = [fh readDataOfLength: 512];
  if ([data length] == 0)
    {
      return YES;
    }

  buf = [data bytes];
  for (i = printable = 0, n = [data length]; i < n; i++)
    {
      if (isprint(buf[i]) || isspace(buf[i]))
        {
          printable++;
        }
    }

  return (((double) printable / n) > 0.9);
}
