/*
    EnvironmentInspector.m

    Implementation of the EnvironmentInspector class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "EnvironmentInspector.h"

#import <AppKit/NSTextField.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSTableView.h>
#import <AppKit/NSTableColumn.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSScrollView.h>
#import <AppKit/NSScroller.h>

#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSProcessInfo.h>

@implementation EnvironmentInspector

static EnvironmentInspector * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- (void) dealloc
{
  TEST_RELEASE(environment);

  [super dealloc];
}

- (void) awakeFromNib
{
  [panel setFrameAutosaveName: @"EnvironmentInspector"];
}

- (void) activateWithProject: (NSString *) aProject
                 environment: (NSMutableDictionary *) env
{
  if (panel == nil)
    {
      [NSBundle loadNibNamed: @"EnvironmentInspector" owner: self];
    }

  [project setStringValue: aProject];
  ASSIGN(environment, env);
  ASSIGN(sortedNames, [[environment allKeys] sortedArrayUsingSelector:
    @selector(caseInsensitiveCompare:)]);
  [table reloadData];

  [panel makeKeyAndOrderFront: nil];
}

- (void) addVariable: (id)sender
{
  NSString * newVariableName;
  int i;

  for (i = 1, newVariableName = _(@"NewVariable");
    [environment objectForKey: newVariableName] != nil;
    newVariableName = [NSString stringWithFormat: _(@"NewVariable%i"), i], i++);

  [environment setObject: @"" forKey: newVariableName];
  ASSIGN(sortedNames, [[environment allKeys] sortedArrayUsingSelector:
    @selector(caseInsensitiveCompare:)]);
  [table reloadData];
}


- (void) removeVariable: (id)sender
{
  int row = [table selectedRow];

  if (row >= 0)
    {
      [environment removeObjectForKey: [sortedNames objectAtIndex: row]];
      ASSIGN(sortedNames, [[environment allKeys] sortedArrayUsingSelector:
        @selector(caseInsensitiveCompare:)]);
      
      [table reloadData];
    }
}

- (void) resetVariables: sender
{
  [environment setDictionary: [[NSProcessInfo processInfo] environment]];
  [table reloadData];
}

- (int) numberOfRowsInTableView: (NSTableView *)aTableView
{
  return [environment count];
}

- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex
{
  if ([[aTableColumn identifier] isEqualToString: @"Name"])
    {
      return [sortedNames objectAtIndex: rowIndex];
    }
  else
    {
      return [environment objectForKey: [sortedNames objectAtIndex: rowIndex]];
    }
}

- (void) tableView: (NSTableView *)aTableView 
    setObjectValue: (id)anObject 
    forTableColumn: (NSTableColumn *)aTableColumn
               row: (int)rowIndex
{
  if ([[aTableColumn identifier] isEqualToString: @"Name"])
    {
      NSString * newName = anObject;
      NSString * oldName = [sortedNames objectAtIndex: rowIndex];

      [environment setObject: [environment objectForKey: oldName]
                      forKey: newName];
      [environment removeObjectForKey: oldName];

      ASSIGN(sortedNames, [[environment allKeys] sortedArrayUsingSelector:
        @selector(caseInsensitiveCompare:)]);

      [table reloadData];
    }
  else
    {
      [environment setObject: anObject
                      forKey: [sortedNames objectAtIndex: rowIndex]];
    }
}

@end
