/*
    DebuggerProtocol.h

    Declaration of the Debugger protocol for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSView, NSString, ProjectDocument;

@protocol Debugger

+ (NSString *) debuggerTypeID;

- initWithOwner: (ProjectDocument *) aDocument;

/**
 * Message sent when the debugger is to activate itself. This means
 * when the user switched to the `Debug' tab in the project where
 * this specific debugger is used. Some debuggers can simply perform
 * nothing in this method, but most debuggers have additional panels
 * which they should now order front.
 */
- (void) activate: sender;

/**
 * Message sent the debugger is to deactivate itself (order it's panels
 * out).
 *
 * @see -activate.
 */
- (void) deactivate: sender;

/**
 * Should return the debugger's view which will be put into the
 * project's window.
 */
- (NSView *) view;

@end
