/*
    ArgumentsInspector.h

    Interface declaration of the ArgumentsInspector class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSMutableArray, NSString;
@class NSTableView, NSTableColumn;

@interface ArgumentsInspector : NSObject
{
  id panel;
  id project;
  id table;

  NSMutableArray * arguments;
}

+ shared;

- (void) activateWithProject: (NSString *) aProject
                   arguments: (NSMutableArray *) argumentList;

- (void) addArgument: (id)sender;
- (void) moveArgumentUp: (id)sender;
- (void) moveArgumentDown: (id)sender;
- (void) removeArgument: (id)sender;

- (int) numberOfRowsInTableView: (NSTableView *)aTableView;
- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex;
- (void) tableView: (NSTableView *)aTableView 
    setObjectValue: (id)anObject 
    forTableColumn: (NSTableColumn *)aTableColumn
               row: (int)rowIndex;

@end
