/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfDemarcationsDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfDemarcationsDAOSQLiteEntity::CPfDemarcationsDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfDemarcationsDAOSQLiteEntity::~CPfDemarcationsDAOSQLiteEntity()
{
}

void CPfDemarcationsDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfDemarcationsDAOSQLiteEntity::deleteReg(CPfDemarcations *reg)
{
    std::string sql("DELETE FROM PF_DEMARCATIONS WHERE X_DEMARCATION=");
    sql += "'"+reg->getXDemarcation_str()+"'";
    return exec(sql);
}

bool CPfDemarcationsDAOSQLiteEntity::insertReg(CPfDemarcations *reg)
{
    std::string sql("INSERT INTO PF_DEMARCATIONS (S_SHORT_NAME,S_NAME) VALUES (");
    sql += (reg->getSShortName_str()=="")?"NULL":"'"+reg->getSShortName_str()+"'";
    sql += (reg->getSName_str()=="")?",NULL":",'"+reg->getSName_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXDemarcation(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfDemarcationsDAOSQLiteEntity::updateReg(CPfDemarcations *reg)
{
    std::string sql("UPDATE PF_DEMARCATIONS SET ");
    sql += (reg->getSShortName_str()=="")?" S_SHORT_NAME=NULL":" S_SHORT_NAME='"+reg->getSShortName_str()+"'";
    sql += (reg->getXDemarcation_str()=="")?",X_DEMARCATION=NULL":",X_DEMARCATION='"+reg->getXDemarcation_str()+"'";
    sql += (reg->getSName_str()=="")?",S_NAME=NULL":",S_NAME='"+reg->getSName_str()+"'";
    sql += " WHERE X_DEMARCATION='"+reg->getXDemarcation_str()+"'";
    return exec(sql);
}

void CPfDemarcationsDAOSQLiteEntity::freeVector(std::vector<CPfDemarcations*>* vector )
{
    std::vector<CPfDemarcations*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfDemarcations* CPfDemarcationsDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfDemarcations *destiny = new CPfDemarcations();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfDemarcations*> * CPfDemarcationsDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfDemarcations*> *container = new std::vector<CPfDemarcations*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfDemarcationsDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfDemarcationsDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfDemarcations *destiny = (CPfDemarcations*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "S_SHORT_NAME")==0 ){
                destiny->setSShortName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_DEMARCATION")==0 ){
                destiny->setXDemarcation_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_NAME")==0 ){
                destiny->setSName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfDemarcationsDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfDemarcations*> *container = (std::vector<CPfDemarcations*> *)object;
        CPfDemarcations *destiny = new CPfDemarcations();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "S_SHORT_NAME")==0 ){
                destiny->setSShortName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_DEMARCATION")==0 ){
                destiny->setXDemarcation_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_NAME")==0 ){
                destiny->setSName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

