/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfCoachContractsDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfCoachContractsDAOSQLiteEntity::CPfCoachContractsDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfCoachContractsDAOSQLiteEntity::~CPfCoachContractsDAOSQLiteEntity()
{
}

void CPfCoachContractsDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfCoachContractsDAOSQLiteEntity::deleteReg(CPfCoachContracts *reg)
{
    std::string sql("DELETE FROM PF_COACH_CONTRACTS WHERE X_COACH_CONTRACT=");
    sql += "'"+reg->getXCoachContract_str()+"'";
    return exec(sql);
}

bool CPfCoachContractsDAOSQLiteEntity::insertReg(CPfCoachContracts *reg)
{
    std::string sql("INSERT INTO PF_COACH_CONTRACTS (D_BEGIN,D_END,X_FK_COACH,N_SALARY,X_FK_TEAM) VALUES (");
    sql += (reg->getDBegin_str()=="")?"NULL":"'"+reg->getDBegin_str()+"'";
    sql += (reg->getDEnd_str()=="")?",NULL":",'"+reg->getDEnd_str()+"'";
    sql += (reg->getXFkCoach_str()=="")?",NULL":",'"+reg->getXFkCoach_str()+"'";
    sql += (reg->getNSalary_str()=="")?",NULL":",'"+reg->getNSalary_str()+"'";
    sql += (reg->getXFkTeam_str()=="")?",NULL":",'"+reg->getXFkTeam_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXCoachContract(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfCoachContractsDAOSQLiteEntity::updateReg(CPfCoachContracts *reg)
{
    std::string sql("UPDATE PF_COACH_CONTRACTS SET ");
    sql += (reg->getDBegin_str()=="")?" D_BEGIN=NULL":" D_BEGIN='"+reg->getDBegin_str()+"'";
    sql += (reg->getXCoachContract_str()=="")?",X_COACH_CONTRACT=NULL":",X_COACH_CONTRACT='"+reg->getXCoachContract_str()+"'";
    sql += (reg->getDEnd_str()=="")?",D_END=NULL":",D_END='"+reg->getDEnd_str()+"'";
    sql += (reg->getXFkCoach_str()=="")?",X_FK_COACH=NULL":",X_FK_COACH='"+reg->getXFkCoach_str()+"'";
    sql += (reg->getNSalary_str()=="")?",N_SALARY=NULL":",N_SALARY='"+reg->getNSalary_str()+"'";
    sql += (reg->getXFkTeam_str()=="")?",X_FK_TEAM=NULL":",X_FK_TEAM='"+reg->getXFkTeam_str()+"'";
    sql += " WHERE X_COACH_CONTRACT='"+reg->getXCoachContract_str()+"'";
    return exec(sql);
}

void CPfCoachContractsDAOSQLiteEntity::freeVector(std::vector<CPfCoachContracts*>* vector )
{
    std::vector<CPfCoachContracts*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfCoachContracts* CPfCoachContractsDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfCoachContracts *destiny = new CPfCoachContracts();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfCoachContracts*> * CPfCoachContractsDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfCoachContracts*> *container = new std::vector<CPfCoachContracts*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfCoachContractsDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfCoachContractsDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfCoachContracts *destiny = (CPfCoachContracts*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "D_BEGIN")==0 ){
                destiny->setDBegin_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_COACH_CONTRACT")==0 ){
                destiny->setXCoachContract_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_END")==0 ){
                destiny->setDEnd_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_COACH")==0 ){
                destiny->setXFkCoach_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_SALARY")==0 ){
                destiny->setNSalary_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_TEAM")==0 ){
                destiny->setXFkTeam_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfCoachContractsDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfCoachContracts*> *container = (std::vector<CPfCoachContracts*> *)object;
        CPfCoachContracts *destiny = new CPfCoachContracts();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "D_BEGIN")==0 ){
                destiny->setDBegin_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_COACH_CONTRACT")==0 ){
                destiny->setXCoachContract_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_END")==0 ){
                destiny->setDEnd_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_COACH")==0 ){
                destiny->setXFkCoach_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_SALARY")==0 ){
                destiny->setNSalary_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_TEAM")==0 ){
                destiny->setXFkTeam_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

