/******************************************************************************
* Copyright (C) 2008 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.20                                                         *
******************************************************************************/

#include <iostream>
#include <sstream>

#include "CPfCompetitionsDAOSQLite.h"

CPfCompetitionsDAOSQLite::CPfCompetitionsDAOSQLite(sqlite3 *database)
  : CPfCompetitionsDAOSQLiteEntity(database)
{
}

CPfCompetitionsDAOSQLite::~CPfCompetitionsDAOSQLite()
{
}

std::vector<CPfCompetitions*>* CPfCompetitionsDAOSQLite::findCompetitions()
{
    return loadVector("SELECT * FROM PF_COMPETITIONS ORDER BY S_COMPETITION");
}

CPfCompetitions* CPfCompetitionsDAOSQLite::findByXCompetition(int XCompetition)
{
    std::ostringstream stream;
    stream << XCompetition;
    return findByXCompetition(stream.str());
}

CPfCompetitions* CPfCompetitionsDAOSQLite::findByXCompetition(const std::string &XCompetition)
{
    std::string sql(
    		"SELECT * "
    		"FROM PF_COMPETITIONS ");
    sql +=  "WHERE X_COMPETITION='"+XCompetition+"'";
    return loadRegister(sql);
}

std::vector<CPfCompetitions*>* CPfCompetitionsDAOSQLite::findByXFkCountryAndXFKSeason(int XFkCountry, int XFKseason)
{
    std::ostringstream strXFKCountry;
    strXFKCountry << XFkCountry;

    std::ostringstream strXFKSeason;
    strXFKSeason << XFKseason;
    return findByXFkCountryAndXFKSeason(strXFKCountry.str(), strXFKSeason.str());
}

std::vector<CPfCompetitions*>* CPfCompetitionsDAOSQLite::findByXFkCountryAndXFKSeason(const std::string &XFkCountry, const std::string &XFKSeason)
{
    std::string sql(
    		"SELECT CO.* "
    		"FROM PF_COMPETITIONS CO "
    		"  JOIN PF_COMPETITIONS_BY_SEASON CBS ON CBS.X_FK_COMPETITION=CO.X_COMPETITION ");
    sql +=  "WHERE CO.X_FK_COUNTRY='"+XFkCountry+"' AND CBS.X_FK_SEASON='"+XFKSeason+"' ";
    return loadVector(sql);
}

std::vector<CPfCompetitions*>* CPfCompetitionsDAOSQLite::findByXFkSeason(int XFKSeason)
{
    std::ostringstream stream;
    stream << XFKSeason;
    return findByXFkSeason(stream.str());
}

std::vector<CPfCompetitions*>* CPfCompetitionsDAOSQLite::findByXFkSeason(const std::string &XFKSeason)
{
	std::string sql(
			"SELECT CO.* "
			"FROM PF_COMPETITIONS CO "
			"  JOIN PF_COMPETITIONS_BY_SEASON CBS ON CBS.X_FK_COMPETITION=CO.X_COMPETITION ");
	sql +=  "WHERE CBS.X_FK_SEASON='"+XFKSeason+"'";
	return loadVector(sql);
}

