/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfGamesDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfGamesDAOSQLiteEntity::CPfGamesDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfGamesDAOSQLiteEntity::~CPfGamesDAOSQLiteEntity()
{
}

void CPfGamesDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfGamesDAOSQLiteEntity::deleteReg(CPfGames *reg)
{
    std::string sql("DELETE FROM PF_GAMES WHERE X_GAME=");
    sql += "'"+reg->getXGame_str()+"'";
    return exec(sql);
}

bool CPfGamesDAOSQLiteEntity::insertReg(CPfGames *reg)
{
    std::string sql("INSERT INTO PF_GAMES (X_FK_USER,S_GAME_NAME,S_CONNECTION_STRING,S_DRIVER_NAME,S_GAME_TYPE,D_LAST_SAVED) VALUES (");
    sql += (reg->getXFkUser_str()=="")?"NULL":"'"+reg->getXFkUser_str()+"'";
    sql += (reg->getSGameName_str()=="")?",NULL":",'"+reg->getSGameName_str()+"'";
    sql += (reg->getSConnectionString_str()=="")?",NULL":",'"+reg->getSConnectionString_str()+"'";
    sql += (reg->getSDriverName_str()=="")?",NULL":",'"+reg->getSDriverName_str()+"'";
    sql += (reg->getSGameType_str()=="")?",NULL":",'"+reg->getSGameType_str()+"'";
    sql += (reg->getDLastSaved_str()=="")?",NULL":",'"+reg->getDLastSaved_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXGame(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfGamesDAOSQLiteEntity::updateReg(CPfGames *reg)
{
    std::string sql("UPDATE PF_GAMES SET ");
    sql += (reg->getXFkUser_str()=="")?" X_FK_USER=NULL":" X_FK_USER='"+reg->getXFkUser_str()+"'";
    sql += (reg->getXGame_str()=="")?",X_GAME=NULL":",X_GAME='"+reg->getXGame_str()+"'";
    sql += (reg->getSGameName_str()=="")?",S_GAME_NAME=NULL":",S_GAME_NAME='"+reg->getSGameName_str()+"'";
    sql += (reg->getSConnectionString_str()=="")?",S_CONNECTION_STRING=NULL":",S_CONNECTION_STRING='"+reg->getSConnectionString_str()+"'";
    sql += (reg->getSDriverName_str()=="")?",S_DRIVER_NAME=NULL":",S_DRIVER_NAME='"+reg->getSDriverName_str()+"'";
    sql += (reg->getSGameType_str()=="")?",S_GAME_TYPE=NULL":",S_GAME_TYPE='"+reg->getSGameType_str()+"'";
    sql += (reg->getDLastSaved_str()=="")?",D_LAST_SAVED=NULL":",D_LAST_SAVED='"+reg->getDLastSaved_str()+"'";
    sql += " WHERE X_GAME='"+reg->getXGame_str()+"'";
    return exec(sql);
}

void CPfGamesDAOSQLiteEntity::freeVector(std::vector<CPfGames*>* vector )
{
    std::vector<CPfGames*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfGames* CPfGamesDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfGames *destiny = new CPfGames();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfGames*> * CPfGamesDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfGames*> *container = new std::vector<CPfGames*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfGamesDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfGamesDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfGames *destiny = (CPfGames*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_USER")==0 ){
                destiny->setXFkUser_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_GAME")==0 ){
                destiny->setXGame_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_GAME_NAME")==0 ){
                destiny->setSGameName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_CONNECTION_STRING")==0 ){
                destiny->setSConnectionString_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_DRIVER_NAME")==0 ){
                destiny->setSDriverName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_GAME_TYPE")==0 ){
                destiny->setSGameType_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_LAST_SAVED")==0 ){
                destiny->setDLastSaved_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfGamesDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfGames*> *container = (std::vector<CPfGames*> *)object;
        CPfGames *destiny = new CPfGames();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_USER")==0 ){
                destiny->setXFkUser_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_GAME")==0 ){
                destiny->setXGame_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_GAME_NAME")==0 ){
                destiny->setSGameName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_CONNECTION_STRING")==0 ){
                destiny->setSConnectionString_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_DRIVER_NAME")==0 ){
                destiny->setSDriverName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_GAME_TYPE")==0 ){
                destiny->setSGameType_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_LAST_SAVED")==0 ){
                destiny->setDLastSaved_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

