/***************************************************************************
                          ps_database.h  -  description
                             -------------------
    begin                : Sun Jun 30 2002
    copyright            : (C) 2002 by Jan Fernquist, Florian Boor
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PS_DATABASE_H
#define PS_DATABASE_H

/*
** Make sure we can call this stuff from C++.
*/
#ifdef __cplusplus
extern "C" {
#endif

#include <sqlite.h>
#include "prismstumbler.h"

#define DBVERSION 2

#ifndef FALSE
	#define FALSE 0
#endif

#ifndef TRUE
	#define TRUE 1
#endif

int init_db();
int create_table();
void close_db();
int getall_networks(sqlite_callback fCallback);
psnetinfo_t get_network(char* my_bssid);
int save_network(psnetinfo_t my_net);
int check_table();
int getnetworkpos(char* my_bssid,sqlite_callback fCallback);
int deletenetwork(char* my_bssid,int chan);

#ifdef __cplusplus
}  /* End of the 'extern "C"' block */
#endif
// PS_DATABASE_H
#endif
