/***************************************************************************
                          analyzer.h  -  description
                             -------------------
    begin                : Thu Sep 19 2002
    copyright            : (C) 2002 by Jan Fernquist, Florian Boor
    email                : boor@unix-ag.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PS_ANALYZER_H
#define PS_ANALYZER_H

#include <netdb.h>
#include <netinet/in.h>
#include <asm/types.h>
#include <linux/netlink.h>
#include <netinet/in.h>

#ifndef FALSE
        #define FALSE 0
#endif

#ifndef TRUE
        #define TRUE 1
#endif

// flags changes behaviour of analyzer
extern int LOG_PACKETS;
extern int FAKEAP_FILTER;

/*
 * Packet Types
 */
#define MGT_PROBE      		0x0040  	/* Client ProbeRequest    */
#define MGT_PROBE_RESP		0x0050 		/* AP ProbeReponse        */
#define MGT_ASSOC_REQ 		0x0000 		/* Client Assocrequest    */
#define MGT_ASSOC_RESP 		0x0010 		/* Assoc Response    */
#define MGT_BEACON  		0x0080 		/* Management - Beacon frame  */

#define DATA_PURE			0x0008		/* Data Packet */
#define CTRL_PURE			0x0004		/* Control Packet */

#define FLAG_TO_DS				0x01
#define FLAG_FROM_DS			0x02
#define FLAG_MORE_FRAGMENTS		0x04
#define FLAG_RETRY				0x08
#define FLAG_POWER_MGT			0x10
#define FLAG_MORE_DATA			0x20
#define FLAG_WEP				0x40
#define FLAG_ORDER				0x80

#define FLAG_WEP_REQUIRED		0x10
#define FLAG_CAP_ESS			0x01
#define FLAG_CAP_IBSS			0x02


#define COOK_FLAGS(x)          (((x) & 0xFF00) >> 8)
#define DATA_ADDR_T4         ((FLAG_TO_DS|FLAG_FROM_DS) << 8)
#define COOK_ADDR_SELECTOR(x) ((x) & 0x300)

#define DATA_SHORT_HDR_LEN     24
#define DATA_LONG_HDR_LEN      30
#define MGT_FRAME_HDR_LEN      24	/* Length of Managment frame-headers */

#define IP_PROTO_NONE		0		/* indicator for none */
#define IP_PROTO_UDP		17		/* user datagram protocol */
#define IP_PROTO_TCP		6		/* tcp */
#define IP_PROTO_ICMP		1		/* icmp */
#define IP_PROTO_ESP		50      /* encrypted security payload */
#define IP_PROTO_AH			51		/* authentication header */

#define IP_OFFSET_PROTO		9	/* location of prtocol id in ip header */
#define IP_OFFSET_FRAGMENT  6	/* first fragmentation byte */
#define IP_OFFSET_FRAGMENT2 7	/* second fragmentation byte */
#define IP_MASK_FRAGMENT	0x3F /* mask to remove other bits from first fragmentation byte */
#define IP_OFFSET_CHKSUM_16	5
#define IP_OFFSET_LENGTH_16 0
#define IP_MASK_HDRLENGTH	0x000F
#define IP_MASK_VERSION		0x00F0

#define IS_TO_DS(x)            ((x) & FLAG_TO_DS)
#define IS_FROM_DS(x)          ((x) & FLAG_FROM_DS)
#define IS_WEP(x)              ((x) & FLAG_WEP)
#define IS_WEP_REQUIRED(x)     ((x) & FLAG_WEP_REQUIRED)
#define IS_ESS(x)     ((x) & FLAG_CAP_ESS)
#define IS_IBSS(x)     ((x) & FLAG_CAP_IBSS)

#define AP_NONE 	0
#define AP_ONE		1
#define AP_MORE     2
#define AP_PROBE	3

static const uint8_t DHCPD_SIGNATURE[] = {0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x43, 0x00, 0x44};

#define  DHCPD_OFFSET 24


/* ************************************************************************* */
/*        Logical field codes (IEEE 802.11 encoding of tags)                 */
/* ************************************************************************* */
#define TAG_SSID           0x00
#define TAG_SUPP_RATES     0x01
#define TAG_FH_PARAMETER   0x02
#define TAG_DS_PARAMETER   0x03
#define TAG_CF_PARAMETER   0x04
#define TAG_TIM            0x05
#define TAG_IBSS_PARAMETER 0x06
#define TAG_CHALLENGE_TEXT 0x10

#define DEVNAME_LEN 16

extern int g_offset;

/*
 * The basic information types in the sniffed packed from prism
 */
typedef struct {
  __u32 did __attribute__ ((packed));
  __u16 status __attribute__ ((packed));
  __u16 len __attribute__ ((packed));
  __u32 data __attribute__ ((packed));
} p80211item_t;

/*
 * Just before the payload, the prismcard
 * puts in a lot of other info
 * like signal quality an stuff
 */
typedef struct {
  __u32 msgcode __attribute__ ((packed));
  __u32 msglen __attribute__ ((packed));
  __u8 devname[DEVNAME_LEN] __attribute__ ((packed));
  p80211item_t hosttime __attribute__ ((packed));
  p80211item_t mactime __attribute__ ((packed));
  p80211item_t channel __attribute__ ((packed));
  p80211item_t rssi __attribute__ ((packed));
  p80211item_t sq __attribute__ ((packed));
  p80211item_t signal __attribute__ ((packed));
  p80211item_t noise __attribute__ ((packed));
  p80211item_t rate __attribute__ ((packed));
  p80211item_t istx __attribute__ ((packed));
  p80211item_t frmlen __attribute__ ((packed));
} AdmInfo_t;

/*
 * Overlay to directly index varius types of data
 * in Mgmt Frames
 */
typedef struct {
	unsigned short frametype;
	unsigned short duration;
	unsigned char DestAddr[6];
	unsigned char SrcAddr[6];
	unsigned char BssId[6];
	unsigned short FragSeq;
    unsigned short TimeStamp[4];
	unsigned short BeaconInterval;
	unsigned short Capabilities;
}FixedMgmt_t;

typedef struct {
	unsigned short frametype;
	unsigned short duration;
	unsigned char DestAddr[6];
	unsigned char SrcAddr[6];
	unsigned char BssId[6];
	unsigned short FragSeq;
}ProbeFixedMgmt_t;


int processPacket(unsigned char *packet, int len,int RealChannel, int ps_socket);


#endif
