;;;; prime-enum-mode.el: Description about selection by typing of numbers.
;;;; $Id: prime-enum-mode.el,v 1.4 2005/02/15 23:09:51 komatsu Exp $
;;;;
;;;; Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;;
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(defcustom prime-enum-char-list '(?1 ?2 ?3 ?4 ?5 ?6 ?7 ?8 ?9 ?0)
  "prime-enum-mode $B;~$KA*BrMQ$H$7$F;HMQ$5$l$kJ8;z$N%j%9%H(B")
(defcustom prime-enum-mode-sensitive nil
  "prime-enum-mode $B$,M-8z$J>l9g(B, $B>o$KE,MQ$9$k$+$I$&$+(B
nil $B$N>l9g$O(B prime-enum-char-list $B$NCM$,B3$/8B$j(B, prime-enum-mode $B$OL5;k$9$k(B.")

(defvar prime-enum-mode-ignorep nil "enum-mode $B$rL5;k$9$k$+$N%U%i%0(B ($BFbItMQ(B)")
(make-variable-buffer-local 'prime-enum-mode-ignorep)


;;;; ------------------------------------------------------------
;;;; prime-enum-mode
;;;; ------------------------------------------------------------
(defun prime-enum-mode (&optional arg)
  (interactive)
  (setq prime-enum-mode 
	(if (null arg) (not prime-enum-mode)
	  (> (prefix-numeric-value arg) 0)))
  (cond
   (prime-enum-mode-ignorep
    (prime-enum-mode-on t))
   (prime-enum-mode ;; $BD>46$H$O5U$K$J$C$A$c$C$F$k$M(B.
    (prime-enum-mode-on t))
   (t
    (prime-enum-mode-off t)))
  (prime-enum-mode-reset)
  (prime-disp-conv)
  )

(defun prime-enum-mode-on (&optional forcep)
  (if (or forcep (not prime-enum-mode))
      (progn
	(setq prime-enum-mode t)
	)))

(defun prime-enum-mode-off (&optional forcep)
  (if (or forcep prime-enum-mode)
      (progn
	(setq prime-enum-mode nil)
	)))

(defun prime-enum-mode-reset ()
  (setq prime-enum-mode-ignorep nil)
  )
  
;;;; ------------------------------------------------------------
(defun prime-enum-keyin (char)
  (if (and prime-enum-mode
	   (not prime-enum-mode-ignorep)
	   (member char prime-enum-char-list))
      (cond
       (prime-fund-mode
	(setq prime-enum-mode-ignorep (not prime-enum-mode-sensitive))
	nil)
       (t
	(prime-fix
	 (prime-nth-candidate
	  (+ (if (eq prime-style-display-candidates 'compact)
		 (+ prime-nth-cand
		    (if prime-conv-mode 1 0)) ;; $B$3$3(B, $B$h$/$J$$$M(B.
	       0)
	     (mell-list-member-get-nth char prime-enum-char-list))))
	(prime-after-fix)
	t)
       )
    nil))

(provide 'prime-enum-mode)
