/* $Cambridge: hermes/src/prayer/session/options.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

struct options {
    BOOL save;
    struct prefs *prefs;        /* Live preferences              */
    struct prefs *prefs_save;   /* Preferences to be saved       */
    struct prefs *prefs_work;   /* Temporary copy while updating */
    struct abook *abook;        /* Address book */
    struct list *role_list;     /* Role list */
    struct dictionary *dictionary;      /* Dictionary */
    struct favourite_list *favourite_list;      /* favourite list */
};

struct options *options_create(struct config *config, struct pool *pool);

void options_free(struct options *options);

char *options_create_message(struct options *options,
                             struct config *config, struct pool *pool);

char *options_decode(char *string);

void options_print_token(struct buffer *b, char *s,
                         unsigned long *offsetp);

void options_print(struct buffer *b, char *key, char *s);

void options_print_bool(struct buffer *b, char *key, BOOL value);

void options_print_number(struct buffer *b, char *key,
                          unsigned long value);

BOOL options_parse_bool(char *value);

BOOL
options_parse(struct options *options, char *string,
              struct session *session);
