/* $Cambridge: hermes/src/prayer/session/ml.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* C-client interface */

#define ML_OPENTIMEOUT  (120L)   /* All in seconds */
#define ML_READTIMEOUT  (240L)
#define ML_WRITETIMEOUT (240L)

void ml_init(void);

BOOL ml_have_error(void);
void ml_clear_error(void);
void ml_set_error(void);
char *ml_errmsg(void);
BOOL ml_have_errmsg(void);
void ml_clear_errmsg(void);
void ml_set_errmsg(char *error);

BOOL ml_have_try_create(void);
void ml_clear_try_create(void);
void ml_set_try_create(void);

BOOL ml_have_close(void);
void ml_clear_have_close(void);
void ml_set_have_close(void);

BOOL ml_mailbox_update(void);
void ml_clear_mailbox_update(void);
void ml_set_mailbox_update(void);

void ml_set_errmsg(char *error);
void ml_errmsg_printf(char *fmt, ...);

/* ====================================================================== */

#define ml_fetchheader(session, stream,msgno) \
  ml_fetch_header (session, stream,msgno,NIL,NIL,NIL,FT_PEEK)
#define ml_fetchheader_full(session, stream,msgno,lines,len,flags) \
  ml_fetch_header (session, stream,msgno,NIL,lines,len,FT_PEEK | (flags))
#define ml_fetchtext(session, stream,msgno) \
  ml_fetch_text (session, stream,msgno,NIL,NIL,NIL)
#define ml_fetchtext_full(session, stream,msgno,length,flags) \
  ml_fetch_text (session, stream,msgno,NIL,length,flags)
#define ml_fetchbody(session, stream,msgno,section,length) \
  ml_fetch_body (session, stream,msgno,section,length,NIL)

#define ml_setflag(session, stream,sequence,flag) \
  ml_flag (session, stream,sequence,flag,ST_SET)
#define ml_setflag_full(session, stream,sequence,flag,flags) \
  ml_flag (session, stream,sequence,flag,ST_SET | (flags))
#define ml_clearflag(session, stream,sequence,flag) \
  ml_flag (session, stream,sequence,flag,NIL)
#define ml_clearflag_full ml_flag

#define ml_search(session, stream,criteria) \
  ml_search_full (session, stream,NIL,mail_criteria (criteria),SE_FREE);

/* ====================================================================== */

MESSAGECACHE *ml_elt(struct session *session, MAILSTREAM * stream,
                     unsigned long msgno);

unsigned long
ml_msgno(struct session *session, MAILSTREAM * stream, unsigned long uid);

unsigned long
ml_uid(struct session *session, MAILSTREAM * stream, unsigned long msgno);

BOOL
ml_fetch_fast(struct session *session, MAILSTREAM * stream,
              char *seq, unsigned long flags);

BOOL
ml_fetch_overview(struct session *session,
                  MAILSTREAM * stream, char *sequence, overview_t ofn);

ENVELOPE *ml_fetch_structure(struct session *session,
                             MAILSTREAM * stream, unsigned long msgno,
                             BODY ** body, long flags);

char *ml_fetch_message(struct session *session,
                       MAILSTREAM * stream, unsigned long msgno,
                       unsigned long *len, long flags);

char *ml_fetch_header(struct session *session,
                      MAILSTREAM * stream, unsigned long msgno,
                      char *section, STRINGLIST * lines,
                      unsigned long *len, long flags);

char *ml_fetch_text(struct session *session,
                    MAILSTREAM * stream, unsigned long msgno,
                    char *section, unsigned long *len, long flags);

char *ml_fetch_mime(struct session *session,
                    MAILSTREAM * stream, unsigned long msgno,
                    char *section, unsigned long *len, long flags);

char *ml_fetch_body(struct session *session,
                    MAILSTREAM * stream, unsigned long msgno,
                    char *section, unsigned long *len, long flags);

BODY *ml_body(struct session *session,
              MAILSTREAM * stream, unsigned long msgno, char *section);

BOOL ml_ping(struct session *session, MAILSTREAM * stream);

BOOL
ml_append(struct session *session,
          MAILSTREAM * stream, char *mailbox, STRING * message);

BOOL
ml_append_multiple(struct session *session,
                   MAILSTREAM * stream, char *mailbox,
                   append_t fn, void *ap);

BOOL
ml_copy(struct session *session,
        MAILSTREAM * stream, char *sequence, char *mailbox, long options);

BOOL ml_check(struct session *session, MAILSTREAM * stream);

void ml_close(struct session *session, MAILSTREAM * stream);

BOOL ml_create(struct session *session, MAILSTREAM * stream,
               char *mailbox);

BOOL ml_delete(struct session *session, MAILSTREAM * stream,
               char *mailbox);

BOOL ml_expunge(struct session *session, MAILSTREAM * stream);

BOOL
ml_flag(struct session *session,
        MAILSTREAM * stream, char *sequence, char *flag, long flags);

BOOL
ml_list(struct session *session, MAILSTREAM * stream, char *ref,
        char *pat);

void ml_status_callback(MAILSTATUS *status);

BOOL ml_status(struct session * session, MAILSTREAM * stream, char *mbx,
               int flags, MAILSTATUS *status);

MAILSTREAM *ml_open(struct session *session,
                    MAILSTREAM * oldstream, char *name, long options);

BOOL
ml_rename(struct session *session,
          MAILSTREAM * stream, char *oldname, char *newname);

BOOL
ml_search_full(struct session *session,
               MAILSTREAM * stream, char *charset, SEARCHPGM * pgm,
               long flags);
