#ifndef IO_H
#define IO_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <wchar.h>

/*
 * Colors
 */

#define COLOR_BLACK		0			/* Black */
#define COLOR_RED		1			/* Red */
#define COLOR_GREEN		2			/* Green */
#define COLOR_YELLOW	3			/* Yellow */
#define COLOR_BLUE		4			/* Blue */
#define COLOR_MAGENTA	5			/* Magenta */
#define COLOR_CYAN		6			/* Cyan */
#define COLOR_WHITE		7			/* White */

/*
 * Attributes
 */

#define ATTR_OFF		0			/* All attributes off */
#define ATTR_BOLD		1			/* Bold On */
#define ATTR_DIM		2			/* Dim (Is this really in the ANSI standard? */
#define ATTR_UNDERLINE	4			/* Underline (Monochrome Display Only */
#define ATTR_BLINK		5			/* Blink On */
#define ATTR_REVERSE	7			/* Reverse Video On */
#define ATTR_INVISIBLE	8			/* Concealed On */

/*
 * Keys
 */

#ifndef IO_C_DEF
#define KEY_F0				keytable[0]
#define KEY_KP_INSERT		keytable[1]
#define KEY_KP_DELETE		keytable[2]
#define KEY_KP_ENTER		keytable[3]
#define KEY_KP_PLUS			keytable[4]
#define KEY_KP_MINUS		keytable[5]
#define KEY_KP_MULTIPLY		keytable[6]
#define KEY_KP_DIVIDE		keytable[7]
#define KEY_KP_END			keytable[8]
#define KEY_KP_DOWN			keytable[9]
#define KEY_KP_PGDN			keytable[10]
#define KEY_KP_LEFT			keytable[11]
#define KEY_KP_CENTER		keytable[12]
#define KEY_KP_RIGHT		keytable[13]
#define KEY_KP_HOME			keytable[14]
#define KEY_KP_UP			keytable[15]
#define KEY_KP_PGUP			keytable[16]
#define KEY_INSERT			keytable[17]
#define KEY_HOME			keytable[18]
#define KEY_PGUP			keytable[19]
#define KEY_PGDN			keytable[20]
#define KEY_END				keytable[21]
#define KEY_DELETE			keytable[22]
#define KEY_UP				keytable[23]
#define KEY_DOWN			keytable[24]
#define KEY_LEFT			keytable[25]
#define KEY_RIGHT			keytable[26]
#define KEY_F(x)			(KEY_F0 + (x))
#define KEY_ALT(x)			(0x200 | (x))
#define KEY_CTRL(x)			((x) & 0x1f)
#endif	/* #ifndef IO_C_DEF */

struct line
{
   wchar_t tl;		/* Top Left         */
   wchar_t tr;		/* Top Right        */
   wchar_t bl;		/* Bottom Left      */
   wchar_t br;		/* Bottom Right     */
   wchar_t lt;		/* Left T           */
   wchar_t rt;		/* Right T          */
   wchar_t tt;		/* Top T            */
   wchar_t bt;		/* Bottom T         */
   wchar_t ct;		/* Center T         */
   wchar_t hl;		/* Horizontal Line  */
   wchar_t vl;		/* Vertical Line    */
};

/* line drawing characters */
extern const struct line line;

/* table with predefined keypresses */
extern const int keytable[];

/*
 * Init & Close
 */

/* Initialize screen */
extern void io_open (void);

/* Restore original screen state */
extern void io_close (void);

/*
 * Output
 */

/* Set color attributes */
extern void out_setattr (int attr);

/* Set color */
extern void out_setcolor (int fg,int bg);

/* Move cursor to position (x,y) on the screen. Upper corner of screen is (0,0) */
extern void out_gotoxy (int x,int y);

/* Put a character on the screen */
extern void out_putc (wchar_t c);

/* Put a string on the screen */
extern void out_puts (const char *s);

/* Write a string to the screen */
extern void out_printf (const char *format, ...)
  __attribute__ ((format (printf,1,2)));

/* Write updates to screen */
extern void out_flush (void);

/* Completely redraw screen on next flush */
extern void out_refresh (void);

/* Get the screen width */
extern int out_width (void);

/* Get the screen height */
extern int out_height (void);

/* Beep */
extern void out_beep (void);

/* Clear screen */
extern void out_clear (void);

/*
 * Input
 */

/* Read a character */
extern int in_getc (void);

/* Empty keyboard buffer */
extern void in_flush (void);

#endif	/* #ifndef IO_H */
