/*               
ClientFileBrowser.cc
*/

#include "ClientFileBrowser.h"
extern Language *L;

extern bool Inverse;
extern int FLSortToken;
extern StringList SLPapeleraCopy, SLPapeleraCut;
extern DiskList FLAllDisks; 

#define INFINITE_QUOTA (long) MAXLONG

ClientFileBrowser::ClientFileBrowser (int aCurrentDisk, 
                                      const char *aRestrictedPath, 
                                      long aDiskUsage, 
                                      long aQUOTA)
  {
  initStr (ErrorMsg);
  xstrncpy (RestrictedPath, CMAXBUFFER, aRestrictedPath); 
  if (LastChar (RestrictedPath) != '/') {addLastSlash (RestrictedPath);}
  xstrncpy (CurrentRelDir, CMAXBUFFER, "/");
  xstrncpy (CurrentFullDir, CMAXBUFFER, RestrictedPath); 
  CurrentDisk = aCurrentDisk;
  DiskUsage = aDiskUsage;
  if (aQUOTA == 0) QUOTA = MAXLONG; else QUOTA = aQUOTA;
  }  

ClientFileBrowser::~ClientFileBrowser ()
  {
  }

void ClientFileBrowser::init (int aCurrentDisk, 
                              const char *aRestrictedPath, 
                              long aDiskUsage, 
                              long aQUOTA)
  {
  initStr (ErrorMsg);
  xstrncpy (RestrictedPath, CMAXBUFFER, aRestrictedPath); 
  if (LastChar (RestrictedPath) != '/') {addLastSlash (RestrictedPath);}
  xstrncpy (CurrentRelDir, CMAXBUFFER, "/");
  xstrncpy (CurrentFullDir, CMAXBUFFER, RestrictedPath); 
  CurrentDisk = aCurrentDisk;
  DiskUsage = aDiskUsage;
  if (aQUOTA == 0) QUOTA = MAXLONG; else QUOTA = aQUOTA;
  }  

bool ClientFileBrowser::isCorrectFullDir (const char *apath)
  {
  char *pc;
  TBuffer adir;
  initStr (ErrorMsg);
  if (apath == NULL) 
    {
    LOG ("isCorrectFullDir -> %s: '%s'", L->get(ERR_FILE_INVALIDNAME), apath);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_INVALIDNAME)); 
    return false;
    }
  if ((strcmp (apath, "") == 0) || (strstr (apath, "..") != NULL) || (strstr (apath, "~") != NULL)) 
    {
    LOG ("isCorrectFullDir -> %s: '%s'", L->get(ERR_FILE_INVALIDNAME), apath);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_INVALIDNAME)); 
    return false;
    }    
  xstrncpy (adir, CMAXBUFFER, apath); addLastSlash (adir);
  pc = strstr (adir, RestrictedPath);
  if (pc == NULL) 
    {
    LOG ("isCorrectFullDir -> %s: '%s'", L->get(ERR_FILE_INVALIDNAME), apath);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_INVALIDNAME)); 
    return false;
    }
  if (adir - pc != 0)
    {
    LOG ("isCorrectFullDir -> %s: '%s'", L->get(ERR_FILE_INVALIDNAME), apath);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_INVALIDNAME));
    return false;
    }
  return true;
  }

const char *ClientFileBrowser::getErrorMsg (void)
  {
  return ErrorMsg;           
  }  

const char *ClientFileBrowser::getCurrentFullDir (void)
  {
  return CurrentFullDir;
  }  
  
const char *ClientFileBrowser::getCurrentRelDir (void)
  {
  return CurrentRelDir;
  }  

char *ClientFileBrowser::escape_input (const char *source, TBuffer dest)
  {
  unsigned int i, j = 0;
  
  for (i = 0; i < strlen(source); i++) 
    {
    if (!((((source[i] >= 'A') && (source[i] <= 'Z')) || ((source[i] >= 'a') && (source[i] <= 'z')) || ((source[i] >= '0') && (source[i] <= '9')))) 
         && (source[i] != '/'))
      {
      dest[j] = '\\';
      j++;
      dest[j] = source[i];
      j++;
      }
    else if (source[i] == '/')
      {
      dest[j] = ':'; j++; dest[j] = ':'; j++;
      }  
    else
      {  
      dest[j] = source[i];
      j++;
      }
    }
  dest[j] = '\0';
  return dest;
  }

char *ClientFileBrowser::unescape_input (const char *source, TBuffer dest)
  {
  XString XS;  
  XS = XString (source);
  XS.replace ("::", "/");
  xstrncpy (dest, CMAXBUFFER, XS.cstr());
  utils_unescape (dest);
  return dest;
  }

const char *ClientFileBrowser::obtainOldCurrentRelDir (void)
  {
  int pposant = 0, ppos = 0, numslash = 0;
  static TBuffer OldCurrentRelDir;

  if (strcmp (CurrentRelDir, "/") == 0) {xstrncpy (OldCurrentRelDir, CMAXBUFFER, ""); return OldCurrentRelDir;}
  xstrncpy (OldCurrentRelDir, CMAXBUFFER, CurrentRelDir);  
  addLastSlash (OldCurrentRelDir);
  if (strcmp (OldCurrentRelDir, "/") != 0) 
    {
    for (int i = 0; i < (signed) strlen(OldCurrentRelDir); ++i) 
      {
      if (OldCurrentRelDir[i] == '/') {++numslash; pposant = ppos; ppos = i;}
      }
    if (numslash <= 1)
      {
      xstrncpy (OldCurrentRelDir, CMAXBUFFER, "/");
      }  
    else if (numslash > 1) 
      {
      OldCurrentRelDir[pposant + 1] = '\0';
      }  
    }
  return OldCurrentRelDir;
  }
      
const char *ClientFileBrowser::obtainRelDir (const char *FullDir, TBuffer reldir)
  {
  char *pc;
  if (strcmp (FullDir, RestrictedPath) == 0) {xstrncpy (reldir, CMAXBUFFER, "/"); return reldir;}
  pc = strstr (FullDir, RestrictedPath);
  if (pc == NULL) {addLastSlash (reldir);}
  else
    {  
    XString axs;
    axs = XString (FullDir);
    axs.replace ("//", "/");
    xstrncpy (reldir, CMAXBUFFER, axs.substring (strlen(RestrictedPath) - 1, axs.length()).cstr());
    }
  return reldir;
  }  

const char *ClientFileBrowser::getExtension (const char *afile, TBuffer extension)
  {
  xstrncpy (extension, CMAXBUFFER, getExtensionFromFile (afile));
  return extension;
  }

bool ClientFileBrowser::obtainFullName (const char *relname, TBuffer fullfilename)
  {
  if (strcmp (relname, "") == 0) 
    {
    LOG ("obtainFullName -> %s: '%s'", L->get(ERR_FILE_INVALIDNAME), relname);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_INVALIDNAME)); 
    return false;
    }
  xstrncpy (fullfilename, CMAXBUFFER, CurrentFullDir);
  if (LastChar(fullfilename) != '/') {addLastSlash (fullfilename);}
  xstrncat (fullfilename, CMAXBUFFER, relname);  
  return isCorrectFullDir (fullfilename);
  }

bool ClientFileBrowser::isEditableFile (const char *afile)
  {
  TBuffer ext;
  getExtension (afile, ext);
  if (
      (strcasecmp (ext, "HTML") == 0) || (strcasecmp (ext, "TXT") == 0)      ||
      (strcasecmp (ext, "HTM") == 0)  || (strcasecmp (ext, "INI") == 0)      ||
      (strcasecmp (ext, "CC") == 0)   || (strcasecmp (ext, "C") == 0)        ||
      (strcasecmp (ext, "H") == 0)    || (strcasecmp (ext, "PAS") == 0)      ||
      (strcasecmp (ext, "BAS") == 0)  || (strcasecmp (ext, "PL") == 0)       ||
      (strcasecmp (ext, "CPP") == 0)  || (strcasecmp (ext, "HTACCESS") == 0)                              
     ) 
    {
    return true;
    }
  return false;  
  }

int ClientFileBrowser::getCurrentDisk (void)
  {
  return CurrentDisk;
  }

void ClientFileBrowser::setCurrentDisk (int aCurrentDisk)
  {
  CurrentDisk = aCurrentDisk;
  }

bool ClientFileBrowser::setCurrentRelDir (const char *aCurrentRelDir)
  {
  bool b;
  b = obtainFullName (aCurrentRelDir, CurrentFullDir);
  if (b == false) return false;
  xstrncpy (CurrentRelDir, CMAXBUFFER, aCurrentRelDir);
  return true;  
  }
  
bool ClientFileBrowser::deleteItems (StringList *SLMulti, int *itemsdeleted)
  {
  TBuffer fullfilename;
  bool b;
  *itemsdeleted = 0;
  for (int i = 0; i < SLMulti->Count(); ++i)
    {
    if (isDirectory (SLMulti->getString(i).cstr()) == false)
      {
      b = obtainFullName (SLMulti->getString(i).cstr(), fullfilename);
      if (b == false) {return false;}
      long abytes = FileSize (fullfilename);
      b = DeleteFile (fullfilename); 
      if (b == false) 
        {
        LOG ("deleteItems -> %s: '%s'", L->get(ERR_FILE_DELETING), fullfilename);
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_DELETING)); 
        return false;
        }
      else
        {
        delDiskUsage (abytes);
        ++(*itemsdeleted);
        }                                
      }  
    else
      {  
      b = rmFullDir (SLMulti->getString(i).cstr(), itemsdeleted);
      if (b == false) 
        {
        LOG ("deleteItems -> %s: '%s'", L->get(ERR_FILE_DELETING), SLMulti->getString(i).cstr());
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_DELETING)); 
        return false;
        }        
      }
    }
  return true;  
  }
      
bool ClientFileBrowser::dumpFile (const char *afile, char *fullfilename, char *CT)
  {
  bool b;
  b = obtainFullName (afile, fullfilename);
  if (b == false) {return false;}  
  if (FileExists (fullfilename) == false)
    {
    LOG ("dumpFile -> %s: '%s'", L->get(ERR_FILE_NO_EXISTS), fullfilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_NO_EXISTS)); 
    return false;
    }  
  getMailcapTipoFromFilename (fullfilename, MAILCAP);
  xstrncpy (CT, CMAXBUFFER, getMailcapTipoFromFilename (fullfilename, MAILCAP));
  return true;
  }    

bool ClientFileBrowser::saveFile (const char *afilename, const char *filetext)
  {
  bool b;
  FILE *fw;
  if (getDiskUsage() + (signed)strlen(filetext) > QUOTA) 
    {
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_QUOTA_OVER)); 
    return false;
    }
  b = isCorrectFullDir (afilename);
  if (b == false) {return false;}  
  fw = fopen (afilename, "w");
  if (fw == NULL)
    {
    LOG ("saveFile -> %s: '%s'", L->get(ERR_FILE_CREATE), afilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_CREATE));
    return false;
    }  
  unsigned int res = fprintf (fw, "%s", filetext);
  fclose (fw);
  if (res != strlen(filetext)) 
    {
    LOG ("saveFile -> %s: '%s'", L->get(ERR_FILE_WRITING), afilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_WRITING));
    return false;
    }  
  return true;
  }  

bool ClientFileBrowser::makeDir (const char *adirname)
  {
  bool b;
  TBuffer fulldirname;
  initStr (ErrorMsg);
  b = obtainFullName (adirname, fulldirname);
  if (b == false) {return false;}  
  if (FileExists (fulldirname) == true) 
    {
    LOG ("makeDir -> %s: '%s'", L->get(ERR_DIR_EXISTS), adirname);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_DIR_EXISTS));
    return false;
    }  
  b = CreateDir (fulldirname, NEWDIRSMODE);
  if (b == false) 
    {
    LOG ("makeDir -> %s: '%s'", L->get(ERR_DIR_CREATE), adirname);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_DIR_CREATE)); 
    return false;
    }
  return true;
  }  

bool ClientFileBrowser::makeFile (const char *afilename)
  {
  bool b;
  int res;
  TBuffer fullfilename;
  initStr (ErrorMsg);
  b = obtainFullName (afilename, fullfilename);
  if (b == false) {return false;}
  if (FileExists (fullfilename) == true) 
    {
    LOG ("makeFile -> %s: '%s'", L->get(ERR_FILE_EXISTS), afilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_EXISTS));
    return false;
    }  
  res = Touch (fullfilename);
  if (res == false) 
    {
    LOG ("makeFile -> %s: '%s'", L->get(ERR_FILE_CREATE), afilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_CREATE));
    return false;
    }
  return true;
  }  

bool ClientFileBrowser::CwdUp (void)
  {
  bool b;
  TBuffer anewdir;
  int i, ppos = -1;
  xstrncpy (anewdir, CMAXBUFFER, CurrentFullDir);
  delLastSlash (anewdir);
  for (i = 0; (unsigned)i < strlen(anewdir); ++i) {if (anewdir[i] == '/') ppos=i;}
  if (ppos == 0) {anewdir[1] = '\0';}
  else if (ppos > 0) {anewdir[ppos] = '\0';}
  b = changeAbsDir (anewdir);
  if (b == true) 
    {
    xstrncpy (CurrentFullDir, CMAXBUFFER, anewdir);
    obtainRelDir (CurrentFullDir, CurrentRelDir);
    }
  return b;
  }    

bool ClientFileBrowser::Cwd (const char *anewdir)
  {
  bool b;
  TBuffer newdir;
  b = obtainFullName (anewdir, newdir);
  if (b == false) {return false;}    
  b = changeAbsDir (newdir);
  if (b == true) 
    {
    xstrncpy (CurrentFullDir, CMAXBUFFER, newdir);
    obtainRelDir (CurrentFullDir, CurrentRelDir);
    }
  return b;
  }    

bool ClientFileBrowser::sortName (void)
  {
  TBuffer anewdir;
  FLSortToken = 0;
  if (Inverse == true) Inverse = false; else Inverse = true;
  xstrncpy (anewdir, CMAXBUFFER, CurrentFullDir);
  delLastSlash (anewdir);
  return changeAbsDir (anewdir);
  }    

bool ClientFileBrowser::sortDate (void)
  {
  TBuffer anewdir;
  FLSortToken = 1;
  if (Inverse == true) Inverse = false; else Inverse = true;
  xstrncpy (anewdir, CMAXBUFFER, CurrentFullDir);
  delLastSlash (anewdir);
  return changeAbsDir (anewdir);
  } 

bool ClientFileBrowser::sortSize (void)
  {
  TBuffer anewdir;
  FLSortToken = 2;
  if (Inverse == true) Inverse = false; else Inverse = true;
  xstrncpy (anewdir, CMAXBUFFER, CurrentFullDir);
  delLastSlash (anewdir);
  return changeAbsDir (anewdir);
  }         

bool ClientFileBrowser::CwdNonRelative (const char *anewdir)
  {
  bool b;
  if (isCorrectFullDir (anewdir) == false) {return false;}
  b = changeAbsDir (anewdir);
  if (b == true) 
    {
    xstrncpy (CurrentFullDir, CMAXBUFFER, anewdir);
    }
  return b;  
  }    

bool ClientFileBrowser::changeRelDir (const char *anewdir)
  {
  TBuffer fulldirname;
  bool b;  
  //b = obtainFullName (anewdir, fulldirname);
  //if (b == false) {return false;}      
  //b = changeAbsDir (fulldirname);
  b = changeAbsDir (CurrentFullDir);
  if (b == true) 
    {
    xstrncpy (CurrentFullDir, CMAXBUFFER, fulldirname);
    xstrncpy (CurrentRelDir, CMAXBUFFER, anewdir);
    }
  return b;
  }
  
bool ClientFileBrowser::obtainFileList (void)
  {
  return changeAbsDir (CurrentFullDir);
  }  
  
bool ClientFileBrowser::changeAbsDir (const char *anewdir)
  {
  TBuffer buf;
  struct dirent *ent;
  struct stat statbuf;
  DIR *dirp;
  XFile xf;

  FLAllFiles.Clear();
                        
  if (isCorrectFullDir (anewdir) == false) {return false;}
  
  if ((dirp = opendir (anewdir)) == NULL) 
    {
    LOG ("changeAbsDir -> %s: '%s'", L->get(ERR_DIR_OPEN), anewdir);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_DIR_OPEN)); 
    return false;
    }  
  while ((ent = readdir(dirp)) != NULL)
    {
    if ((strcmp (ent->d_name, ".") != 0) && (strcmp (ent->d_name, "..") != 0))
      {
      xstrncpy (buf, CMAXBUFFER, anewdir);
      addLastSlash (buf);
      xstrncat (buf, CMAXBUFFER, ent->d_name);
      lstat (buf, &statbuf);      
      xstrncpy (xf.FileName, CMAXFILENAME, ent->d_name);
      xf.size     = statbuf.st_size;
      xf.stmtime  = statbuf.st_mtime;
      xf.type     = statbuf.st_mode & S_IFMT;      
      xf.Copiado  = false; 
      xf.Cortado  = false; 
      switch (xf.type) 
        {
        case S_IFDIR:  
          {
          //Check that the object is in the Cut or Copy Clipboard
               if (SLPapeleraCopy.indexOf (buf) >= 0) {xf.Copiado = true;}
          else if (SLPapeleraCut.indexOf (buf)  >= 0) {xf.Cortado = true;}
          FLAllFiles.Add (xf);  
          break;
          }
        case S_IFREG:  
          {
          //Check that the object is in the Cut or Copy Clipboard
               if (SLPapeleraCopy.indexOf (buf) >= 0) {xf.Copiado = true;}
          else if (SLPapeleraCut.indexOf (buf)  >= 0) {xf.Cortado = true;}
          FLAllFiles.Add (xf);  
          break;
          }
        case S_IFBLK:  /*NOTHING*/          break;
        case S_IFCHR:  /*NOTHING*/          break;
        case S_IFIFO:  /*NOTHING*/          break;
        case S_IFLNK:  /*NOTHING*/          break;
        case S_IFSOCK: /*NOTHING*/          break;
        default:       /*NOTHING*/          break;
        } 
      }
    }
  closedir(dirp);  
  xstrncpy (CurrentFullDir, CMAXBUFFER, anewdir);
  //SORT THE FILE LIST
  switch (FLSortToken)
    {
    case 1:  FLAllFiles.SORT (CFB_CompareEntriesByFileDate, CFB_FlipEntries); break;
    case 2:  FLAllFiles.SORT (CFB_CompareEntriesByFileSize, CFB_FlipEntries); break;
    default: FLAllFiles.SORT (CFB_CompareEntriesByFileName, CFB_FlipEntries); break;
    }    
    
  return true;
  }
  
bool ClientFileBrowser::isDirectory (const char *adirname)
  {
  TBuffer fulldirname;
  struct stat statbuf;
  bool b;
  b = obtainFullName (adirname, fulldirname);
  if (b == false) {return false;}      
  lstat (fulldirname, &statbuf);
  if ((statbuf.st_mode & S_IFMT) == S_IFDIR) return true; else return false;
  }
  
bool ClientFileBrowser::isFullDirectory (const char *adirname)
  {
  struct stat statbuf;
  lstat (adirname, &statbuf);
  if ((statbuf.st_mode & S_IFMT) == S_IFDIR) return true; else return false;
  }  
  
const char *ClientFileBrowser::getFileDate (time_t *tt, TBuffer abuf)
  {
  struct tm *atm;
  atm = localtime((time_t *)tt);
  sprintf (abuf, "%.2d/%.2d/%.4d %.2d:%.2d:%.2d", 
              atm->tm_mday, atm->tm_mon + 1, atm->tm_year + 1900, 
              atm->tm_hour, atm->tm_min, atm->tm_sec);
  return abuf;
  }  

bool ClientFileBrowser::listFullDir (const char *adirname, StringList *SLFileList)    
  {
  TBuffer buf, fulldirname, reldir;
  struct dirent *d;
  struct stat statbuf;
  DIR *myDir;
  bool b;

  if (FirstChar (adirname) != '/')
    {
    b = obtainFullName (adirname, fulldirname);
    if (b == false) {return false;}      
    }
  else
    {
    xstrncpy (fulldirname, CMAXBUFFER, adirname);
    }  
  myDir = opendir (fulldirname);
  if (myDir == 0) {return false;}                         
  while ((d = readdir (myDir)) != NULL)
    {
    if ((strcmp (d->d_name, ".") != 0) && (strcmp (d->d_name, "..") != 0))
      {
      if (LastChar(fulldirname) != '/') 
        xsnprintf (buf, CMAXBUFFER, "%s/%s", fulldirname, d->d_name);
      else
        xsnprintf (buf, CMAXBUFFER, "%s%s", fulldirname, d->d_name);
      lstat (buf, &statbuf);      
      if ((statbuf.st_mode & S_IFMT) == S_IFDIR) 
        {
        if (LastChar(reldir) != '/')
          xsnprintf (reldir, CMAXBUFFER, "%s/%s", adirname, d->d_name);
        else
          xsnprintf (reldir, CMAXBUFFER, "%s%s", adirname, d->d_name);
        b = listFullDir (reldir, SLFileList);
        if (b == false)
          {
          return false;
          }
        }
      else
        {
        SLFileList->Add (buf);
        }  
      }
    }
  closedir (myDir);
  addLastSlash (fulldirname);
  SLFileList->Add (fulldirname);
  return true;
  } 
  
//cp -R  
bool ClientFileBrowser::cpFullDir (const char *src_dirname, const char *dest_dirname)    
  {
  int ppos1 = -1, ppos2 = -1;
  XString XS;
  bool b;
  TBuffer xsrc_dirname, fn, dest, abuf;
  StringList SLOriFileList, SLDestFileList;
  
  xstrncpy (xsrc_dirname, CMAXBUFFER, src_dirname);
  addLastSlash (xsrc_dirname);
  listFullDir (xsrc_dirname, &SLOriFileList);
  SLOriFileList.SORT (CompareStringsCS, FlipStrings);
  ReverseSL (&SLOriFileList);
  for (int i = 0; i < (signed)strlen(xsrc_dirname); ++i) {if (xsrc_dirname[i] == '/') {ppos1 = ppos2; ppos2 = i;}}
  for (int k=0; k < SLOriFileList.Count(); ++k)
    {
    XS = XString (SLOriFileList.getString(k).cstr());
    if (LastChar (dest_dirname) == '/')
      xsnprintf (dest, CMAXBUFFER, "%s%s", dest_dirname, XS.substring(ppos1 + 1).cstr());
    else  
      xsnprintf (dest, CMAXBUFFER, "%s/%s", dest_dirname, XS.substring(ppos1 + 1).cstr());
    SLDestFileList.Add (dest);
    }
  //MAKE DIRS
  for (int k=0; k < SLOriFileList.Count(); ++k) 
    {
    xstrncpy (fn, CMAXBUFFER, SLDestFileList.getString(k).cstr());
    if (LastChar(fn) == '/') 
      {
      if (FileExists (fn) == true)
        {
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s: '%s'", L->get(ERR_DIR_CREATE), obtainRelDir(fn, abuf)); 
        return false;          
        }
      b = CreateDir (fn, NEWDIRSMODE);
      if (b == false) 
        {
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s: '%s'", L->get(ERR_DIR_CREATE), obtainRelDir(fn, abuf)); 
        return false;  
        }                  
      }
    }    
  //COPY FILES
  for (int k=0; k < SLOriFileList.Count(); ++k) 
    {
    xstrncpy (fn, CMAXBUFFER, SLOriFileList.getString(k).cstr());
    xstrncpy (dest, CMAXBUFFER, SLDestFileList.getString(k).cstr());
    if (LastChar(fn) != '/') 
      {
      long abytes = FileSize(fn);
      if (getDiskUsage() + abytes > QUOTA) 
        {
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_QUOTA_OVER)); 
        return false;
        }
      b = CopyFile (fn, dest);
      if (b == false) 
        {
        LOG ("cpFullDir -> %s: '%s'", L->get(ERR_FILE_COPYING), fn);
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_COPYING));
        return false;  
        }   
      addDiskUsage (abytes);                 
      }
    }        
  return true;
  }
  
bool ClientFileBrowser::rmFullDir (const char *adirname, int *itemsdeleted)    
  {
  TBuffer buf, fulldirname, reldir;
  struct dirent *d;
  struct stat statbuf;
  DIR *myDir;
  bool b;

  if (FirstChar (adirname) != '/')
    {
    b = obtainFullName (adirname, fulldirname);
    if (b == false) {return false;}      
    }
  else
    {
    xstrncpy (fulldirname, CMAXBUFFER, adirname);
    }  
  myDir = opendir (fulldirname);
  if (myDir == 0) {return false;}                         
  while ((d = readdir (myDir)) != NULL)
    {
    if ((strcmp (d->d_name, ".") != 0) && (strcmp (d->d_name, "..") != 0))
      {
      if (LastChar(fulldirname) != '/')
        xsnprintf (buf, CMAXBUFFER, "%s/%s", fulldirname, d->d_name);
      else
        xsnprintf (buf, CMAXBUFFER, "%s%s", fulldirname, d->d_name);
      lstat (buf, &statbuf);      
      if ((statbuf.st_mode & S_IFMT) == S_IFDIR) 
        {
        if (LastChar(adirname) != '/')
          xsnprintf (reldir, CMAXBUFFER, "%s/%s", adirname, d->d_name);
        else
          xsnprintf (reldir, CMAXBUFFER, "%s%s", adirname, d->d_name);
        b = rmFullDir (reldir, itemsdeleted);
        if (b == false)
          {
          return false;
          }
        }
      else
        {
        long abytes = FileSize(buf);
        b = DeleteFile (buf); 
        if (b == false) 
          {
          LOG ("rmFullDir -> %s: '%s'", L->get(ERR_FILE_DELETING), buf);
          xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_DELETING)); 
          return false;
          }
        else 
          {
          delDiskUsage (abytes);
          ++(*itemsdeleted);
          }
        }  
      }
    }
  closedir (myDir);
  if (rmdir (fulldirname) == 0)
    {
    ++(*itemsdeleted);
    return true;
    }
  else
    {
    return false;
    }   
  } 
  
const char *ClientFileBrowser::getFilenameFromFullFilename (const char *fullname, TBuffer filename)
  {
  int i, p = -1, cont;
  filename[0] = '\0';
  for (i = 0; (unsigned)i < strlen(fullname); ++i)
    {
    if (fullname[i] == '/') {p = i;}
    }
  if (p == -1) {return filename;}  
  cont = 0;  
  for (i = p + 1; (unsigned)i < strlen(fullname); ++i)
    {
    filename[cont] = fullname[i];
    filename[cont + 1] = '\0';
    ++cont;
    }  
  return filename;
  }                

bool ClientFileBrowser::pasteItems (StringList *SLPapeleraCopy, StringList *SLPapeleraCut)
  {
  TBuffer oldname, newname, fn;
  int i;
  bool b;  
  if (SLPapeleraCopy->Count() > 0)
    {
    for (i = 0; i < SLPapeleraCopy->Count(); ++i)
      {
      xstrncpy (oldname, CMAXBUFFER, SLPapeleraCopy->getString(i).cstr());
      getFilenameFromFullFilename (oldname, fn);
      if (LastChar (getCurrentFullDir()) == '/')
        xsnprintf (newname, CMAXBUFFER, "%s%s", getCurrentFullDir(), fn);
      else
        xsnprintf (newname, CMAXBUFFER, "%s/%s", getCurrentFullDir(), fn);      
      if (isFullDirectory (oldname) == true) 
        {
        b = cpFullDir (oldname, getCurrentFullDir());
        if (b == false) 
          {
          return false; 
          }         
        }
      else
        { 
        long abytes = FileSize (oldname);
        if (getDiskUsage() + abytes > QUOTA) 
          {
          xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_QUOTA_OVER)); 
          return false;
          }        
        b = CopyFileWin (oldname, newname);
        if (b == false) 
          {
          LOG ("pasteItems -> %s: '%s'", L->get(ERR_FILE_COPYING), fn);
          xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_COPYING)); 
          return false;  
          }
        addDiskUsage (abytes);  
        }
      }
    return true;
    }
  else if (SLPapeleraCut->Count() > 0)
    {                         
    for (i = 0; i < SLPapeleraCut->Count(); ++i)
      {
      xstrncpy (oldname, CMAXBUFFER, SLPapeleraCut->getString(i).cstr());
      getFilenameFromFullFilename (oldname, fn);
      if (LastChar (getCurrentFullDir()) == '/')
        xsnprintf (newname, CMAXBUFFER, "%s%s", getCurrentFullDir(), fn);
      else
        xsnprintf (newname, CMAXBUFFER, "%s/%s", getCurrentFullDir(), fn);      
      if (strcmp (oldname, newname) == 0) 
        {
        LOG ("pasteItems -> %s: '%s'", L->get(ERR_FILE_MOV_SAMESITE), fn);
        xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_MOV_SAMESITE));
        return false;
        }    
      if (isFullDirectory (oldname) == true) 
        {
        b = cpFullDir (oldname, getCurrentFullDir());
        if (b == false) 
          {
          return false; 
          }
        else
          {
          int itemsdeleted;
          b = rmFullDir (oldname, &itemsdeleted);
          if (b == false) 
            {
            LOG ("pasteItems -> %s: '%s'", L->get(ERR_FILE_COPYING), fn);
            xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_COPYING)); 
            return false;  
            }  
          }  
        }
      else
        {
        b = CopyFileWin (oldname, newname);
        if (b == false) 
          {
          LOG ("pasteItems -> %s: '%s'", L->get(ERR_FILE_COPYING), fn);
          xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_COPYING)); 
          return false;  
          }
        else
          {
          DeleteFile (oldname);
          }  
        }
      }
    return true;
    }
  else
    {
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_CLIPBOARD_EMPTY));
    return false;
    }    
  }
      
const char *ClientFileBrowser::FormatCountBytes (long count, TBuffer abuf)
  {
  TNumber anum;
  char stnum[30], stres[50], stres2[50];
  long L, j;
  xstrncpy (stnum, 30, xltoa (count, anum));
  L = strlen (stnum);
  if (L <= 3) {xstrncpy (stres, 50, "&#60;1 KB");}
  else if ((L > 3) && (L <= 6)) 
    {
    j = (long) ((long)count / (long)1024); if (j == 0) j = 1; 
    xstrncpy (stres, 50, xltoa(j, anum)); 
    xstrncat(stres, 30, " KB");
    }
  else if ((L > 6) && (L <= 9)) 
    {
    j = (long) ((long)count / (long)1048576); if (j == 0) j = 1; 
    xstrncpy (stres, 50, xltoa(j, anum)); 
    xstrncat(stres, 50, " MB");
    }
  else 
    {
    xstrncpy (stres, 50, stnum); 
    xstrncat(stres, 50, " B");
    }
  if (strlen (stres) == 2) 
    {
    xstrncpy (stres2, 50, "  "); 
    xstrncat (stres2, 50, stres); 
    xstrncpy (abuf, CMAXBUFFER, stres2); 
    return abuf;
    }
  else if (strlen (stres) == 3) 
    {
    xstrncpy (stres2, 50, " "); 
    xstrncat (stres2, 50, stres); 
    xstrncpy (abuf, CMAXBUFFER, stres2);
    return abuf;
    }
  xstrncpy (abuf, CMAXBUFFER, stres);  
  return abuf;
  }
      
void ClientFileBrowser::parseIncrementalPath (const char *adir, StringList *SL, StringList *SLInc)
  {
  char c, letra[2];
  TBuffer linea, word;
  int i;
  
  letra[1] = '\0';
  SL->Clear();
  SLInc->Clear();
  initStr(linea); 
  initStr(word);
  for (i = 0; i < (signed)strlen(adir); ++i)
    {
    c = adir[i];
    letra[0] = c;
    if (c == '/')
      {
      if (strcmp (linea, "") == 0)
        {
        SL->Add ("/");
        SLInc->Add ("/");
        xstrncat (linea, CMAXBUFFER, letra);
        }
      else
        { 
        SL->Add (word);       
        SLInc->Add (linea);
        xstrncat (linea, CMAXBUFFER, letra);
        initStr (word);
        }
      }
    else
      {
      xstrncat (linea, CMAXBUFFER, letra);
      xstrncat (word, CMAXBUFFER, letra);
      }      
    }     
  if (strcmp (word, "") != 0)
    {
    SL->Add (word);       
    SLInc->Add (linea);
    }
  }
  
bool ClientFileBrowser::renameItems (const char *oldfilename, const char *newfilename)
  {
  int res;
  bool b;
  TBuffer fulloldfilename, fullnewfilename;
  b = obtainFullName (oldfilename, fulloldfilename);
  if (b == false) {return false;}  
  b = obtainFullName (newfilename, fullnewfilename);
  if (b == false) {return false;}      
  if (FileExists (fulloldfilename) == false)
    {
    LOG ("renameItems -> %s: '%s'", L->get(ERR_FILE_NO_EXISTS), oldfilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_NO_EXISTS)); 
    return false;
    }  
  if (FileExists (fullnewfilename) == true)
    {
    LOG ("renameItems -> %s: '%s'", L->get(ERR_FILE_EXISTS), newfilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_EXISTS)); 
    return false;
    }  
  res = rename (fulloldfilename, fullnewfilename);
  if (res != 0) 
    {
    LOG ("renameItems -> %s: %s", L->get(ERR_FILE_RENAMING), oldfilename);
    xsnprintf (ErrorMsg, CMAXBUFFER, "%s", L->get(ERR_FILE_RENAMING));
    return false; 
    }
  return true;  
  }

void CFB_FlipEntries (const void *e1, const void *e2)
  {
  XFile temp;
  temp.FileName  = PXFile (e1)->FileName;
  temp.size      = PXFile (e1)->size;
  temp.stmtime  = PXFile (e1)->stmtime;
  temp.type      = PXFile (e1)->type;  
  temp.Copiado   = PXFile (e1)->Copiado;    
  temp.Cortado   = PXFile (e1)->Cortado;    
  PXFile (e1)->FileName  = PXFile (e2)->FileName;  PXFile (e2)->FileName  = temp.FileName;
  PXFile (e1)->size      = PXFile (e2)->size;      PXFile (e2)->size      = temp.size;  
  PXFile (e1)->stmtime  = PXFile (e2)->stmtime;  PXFile (e2)->stmtime  = temp.stmtime;  
  PXFile (e1)->type      = PXFile (e2)->type;      PXFile (e2)->type      = temp.type;  
  PXFile (e1)->Copiado   = PXFile (e2)->Copiado;   PXFile (e2)->Copiado   = temp.Copiado;  
  PXFile (e1)->Cortado   = PXFile (e2)->Cortado;   PXFile (e2)->Cortado   = temp.Cortado;  
  }
   
int CFB_CompareEntriesByFileName (const void *e1, const void *e2)
  {
  int res;
  res = strcasecmp (PXFile (e1)->FileName, PXFile(e2)->FileName);
  if (Inverse == true) {res = (-1) * res;}
  return res;  
  }
  
int CFB_CompareEntriesByFileNameCS (const void *e1, const void *e2)
  {
  int res;
  res = strcmp (PXFile (e1)->FileName, PXFile(e2)->FileName);
  return res;  
  }  

int CFB_CompareEntriesByFileSize  (const void *e1, const void *e2)
  {
  int res;
  res = PXFile (e1)->size - PXFile(e2)->size;
  if (Inverse == true) {res = (-1) * res;}
  return res;  
  }

int CFB_CompareEntriesByFileDate  (const void *e1, const void *e2)
  {
  int res;
  res = PXFile (e1)->stmtime - PXFile(e2)->stmtime;
  if (Inverse == true) {res = (-1) * res;}
  return res;  
  }

long ClientFileBrowser::getDiskUsage (void)
  {
  return DiskUsage;
  }
     
void ClientFileBrowser::addDiskUsage (long morebytes)
  {
  DiskUsage += morebytes;
  FLAllDisks.elementAt(CurrentDisk).diskusage = DiskUsage;
  }  
 
void ClientFileBrowser::delDiskUsage (long lessbytes)
  {
  DiskUsage -= lessbytes;
  if (DiskUsage < 0) DiskUsage = 0;
  FLAllDisks.elementAt(CurrentDisk).diskusage = DiskUsage;
  }   
 
//Return the porc of disk wasted
float ClientFileBrowser::getPercQuotaUsage (void)
  {
  if (QUOTA == INFINITE_QUOTA) {return 0.0;}
  return (((float)getDiskUsage() / (float)QUOTA) * 100.0);
  }  
  
long ClientFileBrowser::getQuota (void)
  {
  return QUOTA;
  }
        
