/*                               
Services.cc
*/

#include "Services.h"

//main         --> Service for display login page
//cclient      --> Service for imap
//nntp         --> Service for nntp (virtual, depends of cclient)
//poppass      --> Service for change password
//databases    --> Service for databases
//finger       --> Service for finger other hosts
//secvirtual   --> Service for students administrative questions (University of Valencia)
//filebrowser  --> Service for File Explorer (in server disk or samba mounted disk, by example)
//personaldata --> Service for retrieve Personal Data
//useraccounts --> Service for user account administration (University of Valencia)
//config       --> Service for handle Postman Configuration
//sieve        --> Service for mail: filters, vacation.
//calendar     --> Service for calendar

int TranslateService (const char *stservice)
  {
  if (IsEmpty(stservice))                         {return iSERVICE_MAIN;}
  TBuffer uplinea;
  xstrncpy (uplinea, CMAXBUFFER, stservice); xucase (uplinea);
  if (IsEmpty(uplinea) == true)                   {return iSERVICE_MAIN;}
  if (strcmp (uplinea, "MAIN")   == 0)            {return iSERVICE_MAIN;}  
  if (strcmp (uplinea, "CCLIENT")== 0)            {return iSERVICE_CCLIENT;}
  if (strcmp (uplinea, "POPPASS")== 0)            {return iSERVICE_POPPASS;}  
  if (strcmp (uplinea, "DATABASES")== 0)          {return iSERVICE_DATABASES;}    
  if (strcmp (uplinea, "FINGER")== 0)             {return iSERVICE_FINGER;}    
  if (strcmp (uplinea, "FILEBROWSER")== 0)        {return iSERVICE_FILEBROWSER;}    
  if (strcmp (uplinea, "FORWARDMAIL")== 0)        {return iSERVICE_FORWARDMAIL;}      
  if (strcmp (uplinea, "SECVIRTUAL")== 0)         {return iSERVICE_SECVIRTUAL;}        
  if (strcmp (uplinea, "PERSONALDATA")== 0)       {return iSERVICE_PERSONALDATA;}      
  if (strcmp (uplinea, "USERACCOUNTS")== 0)       {return iSERVICE_USERACCOUNTS;}              
  if (strcmp (uplinea, "CONFIG")== 0)             {return iSERVICE_CONFIG;}                
  if (strcmp (uplinea, "SIEVE")== 0)              {return iSERVICE_SIEVE;}                  
  if (strcmp (uplinea, "CALENDAR")== 0)           {return iSERVICE_CALENDAR;}                    
  return iSERVICE_INVALID;                
  }

const char *TranslateServiceR (int service)
  {
  switch (service)
    {
    case iSERVICE_MAIN:          return SERVICE_MAIN; break;
    case iSERVICE_CCLIENT:       return SERVICE_CCLIENT; break;
    case iSERVICE_POPPASS:       return SERVICE_POPPASS; break;    
    case iSERVICE_DATABASES:     return SERVICE_DATABASES; break;        
    case iSERVICE_FINGER:        return SERVICE_FINGER; break;        
    case iSERVICE_FILEBROWSER:   return SERVICE_FILEBROWSER; break; 
    case iSERVICE_FORWARDMAIL:   return SERVICE_FORWARDMAIL; break;            
    case iSERVICE_SECVIRTUAL:    return SERVICE_SECVIRTUAL; break; 
    case iSERVICE_PERSONALDATA:  return SERVICE_PERSONALDATA; break;     
    case iSERVICE_USERACCOUNTS:  return SERVICE_USERACCOUNTS; break;         
    case iSERVICE_CONFIG:        return SERVICE_CONFIG; break;             
    case iSERVICE_SIEVE:         return SERVICE_SIEVE; break;                 
    case iSERVICE_CALENDAR:      return SERVICE_CALENDAR; break;                     
    default:                     return SERVICE_MAIN; break;
    }
  }

int TranslateCmd (int service, const char *stcmd)
  {
  if ((service == iSERVICE_INVALID) || (IsEmpty(stcmd))) return CMD_SPECIAL_INVALID;
  TBuffer uplinea;
  xstrncpy (uplinea, CMAXBUFFER, stcmd); xucase (uplinea);

  if (IsEmpty(uplinea)                   == true) {return CMD_SPECIAL_INVALID;}
  if (strcmp (uplinea, "CHECK_COOKIE")   == 0)    {return CMD_SPECIAL_CHECK_COOKIE;}  
  if (strcmp (uplinea, "CONF_ACT")       == 0)    {return CMD_MAIN_CONF_ACT;}
  if (strcmp (uplinea, "HOME")           == 0)    {return CMD_MAIN_HOME;}  
  if (strcmp (uplinea, "ROOT")           == 0)    {return CMD_MAIN_ROOT;}  
  if (strcmp (uplinea, "LOGIN")          == 0)    {return CMD_MAIN_LOGIN;}
  if (strcmp (uplinea, "LOGOUT")         == 0)    {return CMD_MAIN_LOGOUT;}
  if (strcmp (uplinea, "HELP")           == 0)    {return CMD_MAIN_HELP;}
  if (strcmp (uplinea, "ABOUT")          == 0)    {return CMD_MAIN_ABOUT;}
  if (strcmp (uplinea, "RECONNECT")      == 0)    {return CMD_MAIN_RECONNECT;}
    
  switch (service)
    {
    case iSERVICE_CCLIENT:  
      if (strcmp (uplinea, "MG_DUMPFULLMSG") == 0)    {return CMD_CCLIENT_MG_DUMPFULLMSG;}
      if (strcmp (uplinea, "MG_DUMPFULLHEADER") == 0) {return CMD_CCLIENT_MG_DUMPFULLHEADER;} 
      if (strcmp (uplinea, "MG_DISPLAY")     == 0)    {return CMD_CCLIENT_MG_DISPLAY;}
      if (strcmp (uplinea, "MG_COPY")        == 0)    {return CMD_CCLIENT_MG_COPY;}
      if (strcmp (uplinea, "MG_MOVE")        == 0)    {return CMD_CCLIENT_MG_MOVE;}
      if (strcmp (uplinea, "MG_DELDISPLAY")  == 0)    {return CMD_CCLIENT_MG_DELDISPLAY;}
      if (strcmp (uplinea, "MG_UNDELDISPLAY")== 0)    {return CMD_CCLIENT_MG_UNDELDISPLAY;}  
      if (strcmp (uplinea, "MB_INDEX")       == 0)    {return CMD_CCLIENT_MB_INDEX;}
      if (strcmp (uplinea, "MB_SHOW")        == 0)    {return CMD_CCLIENT_MB_SHOW;}
      if (strcmp (uplinea, "MB_CHANGE")      == 0)    {return CMD_CCLIENT_MB_CHANGE;}
      if (strcmp (uplinea, "MB_CREATE")      == 0)    {return CMD_CCLIENT_MB_CREATE;}
      if (strcmp (uplinea, "MB_DELETE")      == 0)    {return CMD_CCLIENT_MB_DELETE;}
      if (strcmp (uplinea, "MB_RENAME")      == 0)    {return CMD_CCLIENT_MB_RENAME;}
      if (strcmp (uplinea, "MB_EXPUNGE")     == 0)    {return CMD_CCLIENT_MB_EXPUNGE;}
      if (strcmp (uplinea, "MB_DUMP")        == 0)    {return CMD_CCLIENT_MB_DUMP;}  
      if (strcmp (uplinea, "MB_SEARCH")      == 0)    {return CMD_CCLIENT_MB_SEARCH;}    
      if (strcmp (uplinea, "FG_DELETE")      == 0)    {return CMD_CCLIENT_FG_DELETE;}
      if (strcmp (uplinea, "FG_UNDELETE")    == 0)    {return CMD_CCLIENT_FG_UNDELETE;}
      if (strcmp (uplinea, "FG_ANSWERED")    == 0)    {return CMD_CCLIENT_FG_ANSWERED;}
      if (strcmp (uplinea, "FG_UNANSWERED")  == 0)    {return CMD_CCLIENT_FG_UNANSWERED;}
      if (strcmp (uplinea, "FG_FLAGGED")     == 0)    {return CMD_CCLIENT_FG_FLAGGED;}
      if (strcmp (uplinea, "FG_UNFLAGGED")   == 0)    {return CMD_CCLIENT_FG_UNFLAGGED;}
      if (strcmp (uplinea, "FG_SEEN")        == 0)    {return CMD_CCLIENT_FG_SEEN;}
      if (strcmp (uplinea, "FG_UNSEEN")      == 0)    {return CMD_CCLIENT_FG_UNSEEN;}
      if (strcmp (uplinea, "CM")             == 0)    {return CMD_CCLIENT_CM;}
      if (strcmp (uplinea, "CMNNTP")         == 0)    {return CMD_CCLIENT_CMNNTP;}  
      if (strcmp (uplinea, "CM_SEND")        == 0)    {return CMD_CCLIENT_CM_SEND;}
      if (strcmp (uplinea, "CM_SENDNNTP")    == 0)    {return CMD_CCLIENT_CM_SENDNNTP;}  
      if (strcmp (uplinea, "CM_CANCEL")      == 0)    {return CMD_CCLIENT_CM_CANCEL;}
      if (strcmp (uplinea, "CM_REPLY")       == 0)    {return CMD_CCLIENT_CM_REPLY;}
      if (strcmp (uplinea, "CM_REPLYALL")    == 0)    {return CMD_CCLIENT_CM_REPLYALL;}
      if (strcmp (uplinea, "CM_REPLYGROUP")  == 0)    {return CMD_CCLIENT_CM_REPLYGROUP;}  
      if (strcmp (uplinea, "CM_FORWARD")     == 0)    {return CMD_CCLIENT_CM_FORWARD;}
      if (strcmp (uplinea, "CM_CLEANALL")    == 0)    {return CMD_CCLIENT_CM_CLEANALL;}
      if (strcmp (uplinea, "CM_SAVE")        == 0)    {return CMD_CCLIENT_CM_SAVE;}  
      if (strcmp (uplinea, "AT_SHOW")        == 0)    {return CMD_CCLIENT_AT_SHOW;}
      if (strcmp (uplinea, "AT_DUMP")        == 0)    {return CMD_CCLIENT_AT_DUMP;}
      if (strcmp (uplinea, "AT_SAVE")        == 0)    {return CMD_CCLIENT_AT_SAVE;}  
      if (strcmp (uplinea, "AT_ERASE")       == 0)    {return CMD_CCLIENT_AT_ERASE;}
      if (strcmp (uplinea, "AB")             == 0)    {return CMD_CCLIENT_AB;}
      if (strcmp (uplinea, "AB_SHOWALL")     == 0)    {return CMD_CCLIENT_AB_SHOWALL;}
      if (strcmp (uplinea, "AB_SAVEENTRY")   == 0)    {return CMD_CCLIENT_AB_SAVEENTRY;}
      if (strcmp (uplinea, "AB_EDITENTRY")   == 0)    {return CMD_CCLIENT_AB_EDITENTRY;}
      if (strcmp (uplinea, "AB_DELEENTRIES") == 0)    {return CMD_CCLIENT_AB_DELEENTRIES;}
      if (strcmp (uplinea, "AB_NEWENTRY")    == 0)    {return CMD_CCLIENT_AB_NEWENTRY;}
      if (strcmp (uplinea, "AB_SORT")        == 0)    {return CMD_CCLIENT_AB_SORT;}
      if (strcmp (uplinea, "AB_FROM_CM")     == 0)    {return CMD_CCLIENT_AB_FROM_CM;}
      if (strcmp (uplinea, "AB_TAKEADDRESS") == 0)    {return CMD_CCLIENT_AB_TAKEADDRESS;}
      if (strcmp (uplinea, "AB_ADDFIELDS")   == 0)    {return CMD_CCLIENT_AB_ADDFIELDS;}  
      if (strcmp (uplinea, "AB_DUMP")        == 0)    {return CMD_CCLIENT_AB_DUMP;}  
      if (strcmp (uplinea, "NOOP")           == 0)    {return CMD_SPECIAL_NOOP;}    
      if (strcmp (uplinea, "DEBUG")          == 0)    {return CMD_SPECIAL_DEBUG;}      
      if (strcmp (uplinea, "MB_SORT")        == 0)    {return CMD_CCLIENT_MB_SORT;}        
      if (strcmp (uplinea, "MG_FG_DELETE")    == 0)   {return CMD_CCLIENT_MG_FG_DELETE;}        
      if (strcmp (uplinea, "MG_FG_UNDELETE")  == 0)   {return CMD_CCLIENT_MG_FG_UNDELETE;}        
      if (strcmp (uplinea, "MG_FG_ANSWERED")  == 0)   {return CMD_CCLIENT_MG_FG_ANSWERED;}        
      if (strcmp (uplinea, "MG_FG_UNANSWERED")== 0)   {return CMD_CCLIENT_MG_FG_UNANSWERED;}        
      if (strcmp (uplinea, "MG_FG_FLAGGED")   == 0)   {return CMD_CCLIENT_MG_FG_FLAGGED;}        
      if (strcmp (uplinea, "MG_FG_UNFLAGGED") == 0)   {return CMD_CCLIENT_MG_FG_UNFLAGGED;}        
      if (strcmp (uplinea, "MG_FG_SEEN")      == 0)   {return CMD_CCLIENT_MG_FG_SEEN;}        
      if (strcmp (uplinea, "MG_FG_UNSEEN")    == 0)   {return CMD_CCLIENT_MG_FG_UNSEEN;}        
      if (strcmp (uplinea, "MG_FG_SEARCHED")  == 0)   {return CMD_CCLIENT_MG_FG_SEARCHED;}        
      if (strcmp (uplinea, "MG_FG_UNSEARCHED")== 0)   {return CMD_CCLIENT_MG_FG_UNSEARCHED;}          
      if (strcmp (uplinea, "BD_UUDECODE")== 0)        {return CMD_CCLIENT_BD_UUDECODE;}        
      if (strcmp (uplinea, "NW_LIST_DUMP")== 0)       {return CMD_CCLIENT_NW_LIST_DUMP;}
      return CMD_SPECIAL_INVALID;
      break;
    case iSERVICE_POPPASS: 
      if (strcmp (uplinea, "DISPLAYPAGE")== 0)        {return CMD_POPPASS_DISPLAYPAGE;}
      if (strcmp (uplinea, "CHANGEPW")== 0)           {return CMD_POPPASS_CHANGEPW;}
      return CMD_SPECIAL_INVALID;
      break;
    case iSERVICE_DATABASES: 
      if (strcmp (uplinea, "DISPLAYPAGE")== 0)        {return CMD_DATABASES_DISPLAYPAGE;}
      if (strcmp (uplinea, "DISPLAYRECORD")== 0)      {return CMD_DATABASES_DISPLAYRECORD;}      
      if (strcmp (uplinea, "COPY")== 0)               {return CMD_DATABASES_COPY;}
      if (strcmp (uplinea, "DUPLICATE")== 0)          {return CMD_DATABASES_DUPLICATE;}      
      if (strcmp (uplinea, "CUT")== 0)                {return CMD_DATABASES_CUT;}      
      if (strcmp (uplinea, "PASTE")== 0)              {return CMD_DATABASES_PASTE;}
      if (strcmp (uplinea, "DELETE")== 0)             {return CMD_DATABASES_DELETE;}                                   
      if (strcmp (uplinea, "UNDELETE")== 0)           {return CMD_DATABASES_UNDELETE;} 
      if (strcmp (uplinea, "NEWRECORD")== 0)          {return CMD_DATABASES_NEWRECORD;}                             
      if (strcmp (uplinea, "EDIT")== 0)               {return CMD_DATABASES_EDIT;}                       
      if (strcmp (uplinea, "SYNC")== 0)               {return CMD_DATABASES_SYNC;}                             
      if (strcmp (uplinea, "EDITSAVE")== 0)           {return CMD_DATABASES_EDITSAVE;}                                   
      if (strcmp (uplinea, "EDITSHOW")== 0)           {return CMD_DATABASES_EDITSHOW;}                                         
      if (strcmp (uplinea, "SORT")== 0)               {return CMD_DATABASES_SORT;}                                               
      if (strcmp (uplinea, "SEARCH")== 0)             {return CMD_DATABASES_SEARCH;}                                  
      if (strcmp (uplinea, "DB_EXPUNGE")== 0)         {return CMD_DATABASES_DB_EXPUNGE;}
      if (strcmp (uplinea, "DB_OPEN")== 0)            {return CMD_DATABASES_DB_OPEN;}      
      if (strcmp (uplinea, "GO")== 0)                 {return CMD_DATABASES_GO;}
      if (strcmp (uplinea, "MAINPAGE")== 0)           {return CMD_DATABASES_MAINPAGE;}
      if (strcmp (uplinea, "DB_CREATE")== 0)          {return CMD_DATABASES_DB_CREATE;}
      if (strcmp (uplinea, "DB_RENAME")== 0)          {return CMD_DATABASES_DB_RENAME;}
      if (strcmp (uplinea, "DB_DELETE")== 0)          {return CMD_DATABASES_DB_DELETE;}
      if (strcmp (uplinea, "DB_CONFDELETE")== 0)      {return CMD_DATABASES_DB_CONFDELETE;}      
      if (strcmp (uplinea, "DB_DUMP")== 0)            {return CMD_DATABASES_DB_DUMP;}
      if (strcmp (uplinea, "DB_IMPORT")== 0)          {return CMD_DATABASES_DB_IMPORT;}
      if (strcmp (uplinea, "DB_EXPORT")== 0)          {return CMD_DATABASES_DB_EXPORT;}    
      if (strcmp (uplinea, "DB_DEFINE")== 0)          {return CMD_DATABASES_DB_DEFINE;}          
      if (strcmp (uplinea, "DELETESEARCH")== 0)       {return CMD_DATABASES_DELETESEARCH;}                
      return CMD_SPECIAL_INVALID;
      break;      
    case iSERVICE_FINGER: 
      if (strcmp (uplinea, "DISPLAYPAGE")== 0)        {return CMD_FINGER_DISPLAYPAGE;}
      if (strcmp (uplinea, "GO")== 0)                 {return CMD_FINGER_GO;}
      return CMD_SPECIAL_INVALID;
      break;            
    case iSERVICE_FILEBROWSER: 
      if (strcmp (uplinea, "DISPLAYPAGE")== 0)        {return CMD_FILEBROWSER_DISPLAYPAGE;}
      if (strcmp (uplinea, "CWDUP")== 0)              {return CMD_FILEBROWSER_CWDUP;}      
      if (strcmp (uplinea, "CWD")== 0)                {return CMD_FILEBROWSER_CWD;}            
      if (strcmp (uplinea, "DUMP")== 0)               {return CMD_FILEBROWSER_DUMP;}                  
      if (strcmp (uplinea, "EDITSHOW")== 0)           {return CMD_FILEBROWSER_EDITSHOW;}                       
      if (strcmp (uplinea, "EDITSAVE")== 0)           {return CMD_FILEBROWSER_EDITSAVE;}                             
      if (strcmp (uplinea, "EDITCANCEL")== 0)         {return CMD_FILEBROWSER_EDITCANCEL;}                             
      if (strcmp (uplinea, "CREATEITEM")== 0)         {return CMD_FILEBROWSER_CREATEITEM;}                             
      if (strcmp (uplinea, "DELETEITEM")== 0)         {return CMD_FILEBROWSER_DELETEITEM;}                                   
      if (strcmp (uplinea, "DELETEITEM_CONF")== 0)    {return CMD_FILEBROWSER_DELETEITEM_CONF;}                                   
      if (strcmp (uplinea, "LOADFILE")== 0)           {return CMD_FILEBROWSER_LOADFILE;}                                       
      if (strcmp (uplinea, "COPY")== 0)               {return CMD_FILEBROWSER_COPY;}
      if (strcmp (uplinea, "CUT")== 0)                {return CMD_FILEBROWSER_CUT;}    
      if (strcmp (uplinea, "PASTE")== 0)              {return CMD_FILEBROWSER_PASTE;}
      if (strcmp (uplinea, "RENAME")== 0)             {return CMD_FILEBROWSER_RENAME;}  
      if (strcmp (uplinea, "CWDF")== 0)               {return CMD_FILEBROWSER_CWDF;}     
      if (strcmp (uplinea, "RENAMEOK")== 0)           {return CMD_FILEBROWSER_RENAMEOK;}           
      if (strcmp (uplinea, "RENAMECANCEL")== 0)       {return CMD_FILEBROWSER_RENAMECANCEL;}        
      if (strcmp (uplinea, "SORTNAME")== 0)           {return CMD_FILEBROWSER_SORTNAME;}
      if (strcmp (uplinea, "SORTDATE")== 0)           {return CMD_FILEBROWSER_SORTDATE;}
      if (strcmp (uplinea, "SORTSIZE")== 0)           {return CMD_FILEBROWSER_SORTSIZE;}
      if (strcmp (uplinea, "CHANGEDISK")== 0)         {return CMD_FILEBROWSER_CHANGEDISK;}      
      return CMD_SPECIAL_INVALID;
      break;                  
    case iSERVICE_FORWARDMAIL: 
      if (strcmp (uplinea, "DISPLAYPAGE")== 0)        {return CMD_FORWARDMAIL_DISPLAYPAGE;}
      if (strcmp (uplinea, "ERASEALL")== 0)           {return CMD_FORWARDMAIL_ERASEALL;}
      if (strcmp (uplinea, "SET")== 0)                {return CMD_FORWARDMAIL_SET;}      
      return CMD_SPECIAL_INVALID;
      break;            
    case iSERVICE_SECVIRTUAL:
      if (strcmp (uplinea, "GOTO")== 0)               {return CMD_SECVIRTUAL_GOTO;}
      return CMD_SPECIAL_INVALID;
      break;                
    case iSERVICE_PERSONALDATA:
      return CMD_SPECIAL_INVALID;
      break;                
    case iSERVICE_USERACCOUNTS:
      if (strcmp (uplinea, "GOTO")== 0)               {return CMD_USERACCOUNTS_GOTO;}
      return CMD_SPECIAL_INVALID;
      break;                            
    case iSERVICE_CONFIG:
      if (strcmp (uplinea, "CONFIG")                  == 0) {return CMD_CONFIG;}
      if (strcmp (uplinea, "CONFIG_CANCEL")           == 0) {return CMD_CONFIG_CANCEL;}
      if (strcmp (uplinea, "CONFIG_CCLIENT")          == 0) {return CMD_CONFIG_CCLIENT;}      
      if (strcmp (uplinea, "CONFIG_CCLIENT_SAVE")     == 0) {return CMD_CONFIG_CCLIENT_SAVE;}
      if (strcmp (uplinea, "CONFIG_NNTP")             == 0) {return CMD_CONFIG_NNTP;}        
      if (strcmp (uplinea, "CONFIG_NNTP_SAVE")        == 0) {return CMD_CONFIG_NNTP_SAVE;}        
      if (strcmp (uplinea, "CONFIG_NNTP_SEARCH")      == 0) {return CMD_CONFIG_NNTP_SEARCH;}        
      if (strcmp (uplinea, "CONFIG_NNTP_ADDSELECTED") == 0) {return CMD_CONFIG_NNTP_ADDSELECTED;}        
      if (strcmp (uplinea, "CONFIG_APPEARANCE")       == 0) {return CMD_CONFIG_APPEARANCE;}      
      if (strcmp (uplinea, "CONFIG_APPEARANCE_SAVE")  == 0) {return CMD_CONFIG_APPEARANCE_SAVE;}
      return CMD_SPECIAL_INVALID;
      break;
    case iSERVICE_SIEVE: 
      if (strcmp (uplinea, "FILTERS_SHOW")== 0)             {return CMD_SIEVE_FILTERS_SHOW;}
      if (strcmp (uplinea, "FILTERS_EDIT")== 0)             {return CMD_SIEVE_FILTERS_EDIT;}
      if (strcmp (uplinea, "FILTERS_CREATE")== 0)           {return CMD_SIEVE_FILTERS_CREATE;}
      if (strcmp (uplinea, "FILTERS_DO")== 0)               {return CMD_SIEVE_FILTERS_DO;}
      if (strcmp (uplinea, "FILTERS_DELETE")== 0)           {return CMD_SIEVE_FILTERS_DELETE;}
      if (strcmp (uplinea, "FILTERS_SAVE")== 0)             {return CMD_SIEVE_FILTERS_SAVE;}
      if (strcmp (uplinea, "FILTERS_CANCEL")== 0)           {return CMD_SIEVE_FILTERS_CANCEL;}            
      if (strcmp (uplinea, "FILTERS_UP")== 0)               {return CMD_SIEVE_FILTERS_UP;}            
      if (strcmp (uplinea, "FILTERS_DOWN")== 0)             {return CMD_SIEVE_FILTERS_DOWN;}            
      if (strcmp (uplinea, "FILTERS_CONFDELETE")== 0)       {return CMD_SIEVE_FILTERS_CONFDELETE;}                  
      if (strcmp (uplinea, "FILTERS_PREDEFSPAM")== 0)       {return CMD_SIEVE_FILTERS_PREDEFSPAM;}                        
      if (strcmp (uplinea, "VACATIONS_SHOW")== 0)           {return CMD_SIEVE_VACATIONS_SHOW;}            
      if (strcmp (uplinea, "VACATIONS_DO")== 0)             {return CMD_SIEVE_VACATIONS_DO;}            
      if (strcmp (uplinea, "VACATIONS_SAVE")== 0)           {return CMD_SIEVE_VACATIONS_SAVE;}            
      if (strcmp (uplinea, "VACATIONS_CANCEL")== 0)         {return CMD_SIEVE_VACATIONS_CANCEL;}            
      return CMD_SPECIAL_INVALID;
      break;
    case iSERVICE_CALENDAR:      
      if (strcmp (uplinea, "YEAR_SHOW")== 0)                {return CMD_CALENDAR_YEAR_SHOW;}    
      if (strcmp (uplinea, "MONTH_SHOW")== 0)               {return CMD_CALENDAR_MONTH_SHOW;}
      if (strcmp (uplinea, "WEEK_SHOW")== 0)                {return CMD_CALENDAR_WEEK_SHOW;}
      if (strcmp (uplinea, "DAY_SHOW")== 0)                 {return CMD_CALENDAR_DAY_SHOW;}
      if (strcmp (uplinea, "EVENTS_SHOW")== 0)              {return CMD_CALENDAR_EVENTS_SHOW;}
      return CMD_SPECIAL_INVALID;
      break;      
    default:
      return CMD_SPECIAL_INVALID;
      break;
    }
  return CMD_SPECIAL_INVALID;                
  }
  
bool is_CMD_ALLOWED_ACTION (int ACTION, int service, int cmd)
  {
  switch (ACTION)
    {
    case ACTION_RECONNECT:
      {
      switch (service)
        {
        case iSERVICE_CCLIENT:
          {
          switch (cmd)
            {                             
            case CMD_CCLIENT_MG_DISPLAY: case CMD_CCLIENT_MB_INDEX: case CMD_CCLIENT_MB_CHANGE: case CMD_CCLIENT_CM:
                     {return true; break;}
            default: {return false; break;}
            }
          break;
          }
        case iSERVICE_FILEBROWSER: 
          {
          switch (cmd)
            {
            case CMD_FILEBROWSER_DISPLAYPAGE: case CMD_FILEBROWSER_CWD:                
                     {return true; break;}
            default: {return false; break;}            
            }
          break; 
          }
        case iSERVICE_USERACCOUNTS:   {return true; break;}  
        case iSERVICE_SECVIRTUAL:     {return false; break;}
        case iSERVICE_MAIN:           {return false; break;}
        case iSERVICE_POPPASS:        {return false; break;}    
        case iSERVICE_DATABASES:      {return false; break;}       
        case iSERVICE_PERSONALDATA:   {return false; break;}               
        case iSERVICE_FINGER:         {return false; break;}     
        case iSERVICE_FORWARDMAIL:    {return false; break;}
        case iSERVICE_CONFIG:         {return false; break;}        
        case iSERVICE_SIEVE:          {return false; break;}                
        case iSERVICE_CALENDAR:       {return false; break;}                        
        default:                      {return false; break;}                  
        }
      break;
      }
    default:
      {
      return false;
      break;  
      }
    }
  return false;
  }
  
int getiServiceFromCmd (int cmd)
  {  
  switch (cmd)
    {
    case CMD_MAIN_CONF_ACT:
    case CMD_MAIN_HOME:
    case CMD_MAIN_ROOT:
    case CMD_MAIN_LOGIN:
    case CMD_MAIN_LOGOUT:
    case CMD_MAIN_HELP:
    case CMD_MAIN_ABOUT:
    case CMD_MAIN_RECONNECT:
      {
      return iSERVICE_MAIN;
      break;
      }
    case CMD_CCLIENT_MG_DUMPFULLMSG:
    case CMD_CCLIENT_MG_DUMPFULLHEADER: 
    case CMD_CCLIENT_MG_DISPLAY:
    case CMD_CCLIENT_MG_COPY:
    case CMD_CCLIENT_MG_MOVE:
    case CMD_CCLIENT_MG_DELDISPLAY:
    case CMD_CCLIENT_MG_UNDELDISPLAY:  
    case CMD_CCLIENT_MB_INDEX:
    case CMD_CCLIENT_MB_SHOW:
    case CMD_CCLIENT_MB_CHANGE:
    case CMD_CCLIENT_MB_CREATE:
    case CMD_CCLIENT_MB_DELETE:
    case CMD_CCLIENT_MB_RENAME:
    case CMD_CCLIENT_MB_EXPUNGE:
    case CMD_CCLIENT_MB_DUMP:  
    case CMD_CCLIENT_MB_SEARCH:    
    case CMD_CCLIENT_FG_DELETE:
    case CMD_CCLIENT_FG_UNDELETE:
    case CMD_CCLIENT_FG_ANSWERED:
    case CMD_CCLIENT_FG_UNANSWERED:
    case CMD_CCLIENT_FG_FLAGGED:
    case CMD_CCLIENT_FG_UNFLAGGED:
    case CMD_CCLIENT_FG_SEEN:
    case CMD_CCLIENT_FG_UNSEEN:
    case CMD_CCLIENT_CM:
    case CMD_CCLIENT_CMNNTP:  
    case CMD_CCLIENT_CM_SEND:
    case CMD_CCLIENT_CM_SENDNNTP:  
    case CMD_CCLIENT_CM_CANCEL:
    case CMD_CCLIENT_CM_REPLY:
    case CMD_CCLIENT_CM_REPLYALL:
    case CMD_CCLIENT_CM_REPLYGROUP:  
    case CMD_CCLIENT_CM_FORWARD:
    case CMD_CCLIENT_CM_CLEANALL:
    case CMD_CCLIENT_CM_SAVE:  
    case CMD_CCLIENT_AT_SHOW:
    case CMD_CCLIENT_AT_DUMP:
    case CMD_CCLIENT_AT_SAVE:  
    case CMD_CCLIENT_AT_ERASE:
    case CMD_CCLIENT_AB:
    case CMD_CCLIENT_AB_SHOWALL:
    case CMD_CCLIENT_AB_SAVEENTRY:
    case CMD_CCLIENT_AB_EDITENTRY:
    case CMD_CCLIENT_AB_DELEENTRIES:
    case CMD_CCLIENT_AB_NEWENTRY:
    case CMD_CCLIENT_AB_SORT:
    case CMD_CCLIENT_AB_FROM_CM:
    case CMD_CCLIENT_AB_TAKEADDRESS:
    case CMD_CCLIENT_AB_ADDFIELDS:  
    case CMD_CCLIENT_AB_DUMP:  
    case CMD_SPECIAL_NOOP:    
    case CMD_SPECIAL_DEBUG:      
    case CMD_CCLIENT_MB_SORT:        
    case CMD_CCLIENT_MG_FG_DELETE:        
    case CMD_CCLIENT_MG_FG_UNDELETE:        
    case CMD_CCLIENT_MG_FG_ANSWERED:        
    case CMD_CCLIENT_MG_FG_UNANSWERED:        
    case CMD_CCLIENT_MG_FG_FLAGGED:        
    case CMD_CCLIENT_MG_FG_UNFLAGGED:        
    case CMD_CCLIENT_MG_FG_SEEN:        
    case CMD_CCLIENT_MG_FG_UNSEEN:        
    case CMD_CCLIENT_MG_FG_SEARCHED:        
    case CMD_CCLIENT_MG_FG_UNSEARCHED:          
    case CMD_CCLIENT_BD_UUDECODE:        
    case CMD_CCLIENT_NW_LIST_DUMP:
      {
      return iSERVICE_CCLIENT;
      break;
      }
    case CMD_POPPASS_DISPLAYPAGE:
    case CMD_POPPASS_CHANGEPW:
      {
      return iSERVICE_POPPASS;
      break;
      }
    case CMD_DATABASES_DISPLAYPAGE:
    case CMD_DATABASES_DISPLAYRECORD:      
    case CMD_DATABASES_COPY:
    case CMD_DATABASES_DUPLICATE:      
    case CMD_DATABASES_CUT:      
    case CMD_DATABASES_PASTE:
    case CMD_DATABASES_DELETE:                                   
    case CMD_DATABASES_UNDELETE: 
    case CMD_DATABASES_NEWRECORD:                             
    case CMD_DATABASES_EDIT:                       
    case CMD_DATABASES_SYNC:                             
    case CMD_DATABASES_EDITSAVE:                                   
    case CMD_DATABASES_EDITSHOW:                                         
    case CMD_DATABASES_SORT:                                               
    case CMD_DATABASES_SEARCH:                                  
    case CMD_DATABASES_DB_EXPUNGE:
    case CMD_DATABASES_DB_OPEN:      
    case CMD_DATABASES_GO:
    case CMD_DATABASES_MAINPAGE:
    case CMD_DATABASES_DB_CREATE:
    case CMD_DATABASES_DB_RENAME:
    case CMD_DATABASES_DB_DELETE:
    case CMD_DATABASES_DB_CONFDELETE:      
    case CMD_DATABASES_DB_DUMP:
    case CMD_DATABASES_DB_IMPORT:
    case CMD_DATABASES_DB_EXPORT:    
    case CMD_DATABASES_DB_DEFINE:          
    case CMD_DATABASES_DELETESEARCH:                
      {
      return iSERVICE_DATABASES;
      break;      
      }
    case CMD_FINGER_DISPLAYPAGE:
    case CMD_FINGER_GO:
      {
      return iSERVICE_FINGER;
      break;     
      }       
    case CMD_FILEBROWSER_DISPLAYPAGE:
    case CMD_FILEBROWSER_CWDUP:      
    case CMD_FILEBROWSER_CWD:            
    case CMD_FILEBROWSER_DUMP:                  
    case CMD_FILEBROWSER_EDITSHOW:                       
    case CMD_FILEBROWSER_EDITSAVE:                             
    case CMD_FILEBROWSER_EDITCANCEL:                             
    case CMD_FILEBROWSER_CREATEITEM:                             
    case CMD_FILEBROWSER_DELETEITEM:                                   
    case CMD_FILEBROWSER_DELETEITEM_CONF:                                   
    case CMD_FILEBROWSER_LOADFILE:                                       
    case CMD_FILEBROWSER_COPY:
    case CMD_FILEBROWSER_CUT:    
    case CMD_FILEBROWSER_PASTE:
    case CMD_FILEBROWSER_RENAME:  
    case CMD_FILEBROWSER_CWDF:     
    case CMD_FILEBROWSER_RENAMEOK:           
    case CMD_FILEBROWSER_RENAMECANCEL:        
    case CMD_FILEBROWSER_SORTNAME:
    case CMD_FILEBROWSER_SORTDATE:
    case CMD_FILEBROWSER_SORTSIZE:
    case CMD_FILEBROWSER_CHANGEDISK:      
      {
      return iSERVICE_FILEBROWSER;
      break; 
      }                 
    case CMD_FORWARDMAIL_DISPLAYPAGE:
    case CMD_FORWARDMAIL_ERASEALL:
    case CMD_FORWARDMAIL_SET:      
      {
      return iSERVICE_FORWARDMAIL;
      break;            
      }
    case CMD_SECVIRTUAL_GOTO:
      {
      return iSERVICE_SECVIRTUAL;
      break; 
      }               
    case CMD_USERACCOUNTS_GOTO:
      {
      return iSERVICE_USERACCOUNTS;
      break;                            
      }
    case CMD_CONFIG:
    case CMD_CONFIG_CANCEL:
    case CMD_CONFIG_CCLIENT:      
    case CMD_CONFIG_CCLIENT_SAVE:
    case CMD_CONFIG_NNTP:        
    case CMD_CONFIG_NNTP_SAVE:        
    case CMD_CONFIG_NNTP_SEARCH:        
    case CMD_CONFIG_NNTP_ADDSELECTED:        
    case CMD_CONFIG_APPEARANCE:      
    case CMD_CONFIG_APPEARANCE_SAVE:
      {
      return iSERVICE_CONFIG;
      break;
      }
    case CMD_SIEVE_FILTERS_SHOW:
    case CMD_SIEVE_FILTERS_EDIT:
    case CMD_SIEVE_FILTERS_CREATE:
    case CMD_SIEVE_FILTERS_DO:
    case CMD_SIEVE_FILTERS_DELETE:
    case CMD_SIEVE_FILTERS_SAVE:
    case CMD_SIEVE_FILTERS_CANCEL:    
    case CMD_SIEVE_FILTERS_UP:    
    case CMD_SIEVE_FILTERS_DOWN:    
    case CMD_SIEVE_FILTERS_CONFDELETE:
    case CMD_SIEVE_FILTERS_PREDEFSPAM:
    case CMD_SIEVE_VACATIONS_SHOW:
    case CMD_SIEVE_VACATIONS_DO:            
    case CMD_SIEVE_VACATIONS_SAVE:  
    case CMD_SIEVE_VACATIONS_CANCEL:            
      {
      return iSERVICE_SIEVE;
      break;
      }      
    case CMD_CALENDAR_YEAR_SHOW:                  
    case CMD_CALENDAR_MONTH_SHOW:            
    case CMD_CALENDAR_WEEK_SHOW:                
    case CMD_CALENDAR_DAY_SHOW:            
    case CMD_CALENDAR_EVENTS_SHOW:            
      {
      return iSERVICE_CALENDAR;
      break;
      }            
    case CMD_SPECIAL_INVALID: 
    case CMD_SPECIAL_CHECK_COOKIE:
    default:
      {
      return iSERVICE_INVALID;
      break;
      }
    }
  return iSERVICE_INVALID;
  }
  
